/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.TransformationStage;
import org.apache.kafka.connect.runtime.errors.ToleranceType;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;
import org.apache.kafka.connect.util.ConcreteSubClassValidator;
import org.apache.kafka.connect.util.InstantiableClassValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(ConnectorConfig.class);
    protected static final String COMMON_GROUP = "Common";
    protected static final String TRANSFORMS_GROUP = "Transforms";
    protected static final String PREDICATES_GROUP = "Predicates";
    protected static final String ERROR_GROUP = "Error Handling";
    public static final String NAME_CONFIG = "name";
    private static final String NAME_DOC = "Globally unique name to use for this connector.";
    private static final String NAME_DISPLAY = "Connector name";
    public static final String CONNECTOR_CLASS_CONFIG = "connector.class";
    private static final String CONNECTOR_CLASS_DOC = "Name or alias of the class for this connector. Must be a subclass of org.apache.kafka.connect.connector.Connector. If the connector is org.apache.kafka.connect.file.FileStreamSinkConnector, you can either specify this full name,  or use \"FileStreamSink\" or \"FileStreamSinkConnector\" to make the configuration a bit shorter";
    private static final String CONNECTOR_CLASS_DISPLAY = "Connector class";
    public static final String KEY_CONVERTER_CLASS_CONFIG = "key.converter";
    public static final String KEY_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the keys in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String KEY_CONVERTER_CLASS_DISPLAY = "Key converter class";
    private static final ConfigDef.Validator KEY_CONVERTER_CLASS_VALIDATOR = ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{ConcreteSubClassValidator.forSuperClass(Converter.class), new InstantiableClassValidator()});
    public static final String VALUE_CONVERTER_CLASS_CONFIG = "value.converter";
    public static final String VALUE_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String VALUE_CONVERTER_CLASS_DISPLAY = "Value converter class";
    private static final ConfigDef.Validator VALUE_CONVERTER_CLASS_VALIDATOR = ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{ConcreteSubClassValidator.forSuperClass(Converter.class), new InstantiableClassValidator()});
    public static final String HEADER_CONVERTER_CLASS_CONFIG = "header.converter";
    public static final String HEADER_CONVERTER_CLASS_DOC = "HeaderConverter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the header values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro. By default, the SimpleHeaderConverter is used to serialize header values to strings and deserialize them by inferring the schemas.";
    public static final String HEADER_CONVERTER_CLASS_DISPLAY = "Header converter class";
    public static final String HEADER_CONVERTER_CLASS_DEFAULT = null;
    private static final ConfigDef.Validator HEADER_CONVERTER_CLASS_VALIDATOR = ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{ConcreteSubClassValidator.forSuperClass(HeaderConverter.class), new InstantiableClassValidator()});
    public static final String TASKS_MAX_CONFIG = "tasks.max";
    private static final String TASKS_MAX_DOC = "Maximum number of tasks to use for this connector.";
    public static final int TASKS_MAX_DEFAULT = 1;
    private static final int TASKS_MIN_CONFIG = 1;
    private static final String TASK_MAX_DISPLAY = "Tasks max";
    public static final String TRANSFORMS_CONFIG = "transforms";
    private static final String TRANSFORMS_DOC = "Aliases for the transformations to be applied to records.";
    private static final String TRANSFORMS_DISPLAY = "Transforms";
    public static final String PREDICATES_CONFIG = "predicates";
    private static final String PREDICATES_DOC = "Aliases for the predicates used by transformations.";
    private static final String PREDICATES_DISPLAY = "Predicates";
    public static final String CONFIG_RELOAD_ACTION_CONFIG = "config.action.reload";
    private static final String CONFIG_RELOAD_ACTION_DOC = "The action that Connect should take on the connector when changes in external configuration providers result in a change in the connector's configuration properties. A value of 'none' indicates that Connect will do nothing. A value of 'restart' indicates that Connect should restart/reload the connector with the updated configuration properties.The restart may actually be scheduled in the future if the external configuration provider indicates that a configuration value will expire in the future.";
    private static final String CONFIG_RELOAD_ACTION_DISPLAY = "Reload Action";
    public static final String CONFIG_RELOAD_ACTION_NONE = Herder.ConfigReloadAction.NONE.name().toLowerCase(Locale.ROOT);
    public static final String CONFIG_RELOAD_ACTION_RESTART = Herder.ConfigReloadAction.RESTART.name().toLowerCase(Locale.ROOT);
    public static final String ERRORS_RETRY_TIMEOUT_CONFIG = "errors.retry.timeout";
    public static final String ERRORS_RETRY_TIMEOUT_DISPLAY = "Retry Timeout for Errors";
    public static final int ERRORS_RETRY_TIMEOUT_DEFAULT = 0;
    public static final String ERRORS_RETRY_TIMEOUT_DOC = "The maximum duration in milliseconds that a failed operation will be reattempted. The default is 0, which means no retries will be attempted. Use -1 for infinite retries.";
    public static final String ERRORS_RETRY_MAX_DELAY_CONFIG = "errors.retry.delay.max.ms";
    public static final String ERRORS_RETRY_MAX_DELAY_DISPLAY = "Maximum Delay Between Retries for Errors";
    public static final int ERRORS_RETRY_MAX_DELAY_DEFAULT = 60000;
    public static final String ERRORS_RETRY_MAX_DELAY_DOC = "The maximum duration in milliseconds between consecutive retry attempts. Jitter will be added to the delay once this limit is reached to prevent thundering herd issues.";
    public static final String ERRORS_TOLERANCE_CONFIG = "errors.tolerance";
    public static final String ERRORS_TOLERANCE_DISPLAY = "Error Tolerance";
    public static final ToleranceType ERRORS_TOLERANCE_DEFAULT = ToleranceType.NONE;
    public static final String ERRORS_TOLERANCE_DOC = "Behavior for tolerating errors during connector operation. 'none' is the default value and signals that any error will result in an immediate connector task failure; 'all' changes the behavior to skip over problematic records.";
    public static final String ERRORS_LOG_ENABLE_CONFIG = "errors.log.enable";
    public static final String ERRORS_LOG_ENABLE_DISPLAY = "Log Errors";
    public static final boolean ERRORS_LOG_ENABLE_DEFAULT = false;
    public static final String ERRORS_LOG_ENABLE_DOC = "If true, write each error and the details of the failed operation and problematic record to the Connect application log. This is 'false' by default, so that only errors that are not tolerated are reported.";
    public static final String ERRORS_LOG_INCLUDE_MESSAGES_CONFIG = "errors.log.include.messages";
    public static final String ERRORS_LOG_INCLUDE_MESSAGES_DISPLAY = "Log Error Details";
    public static final boolean ERRORS_LOG_INCLUDE_MESSAGES_DEFAULT = false;
    public static final String ERRORS_LOG_INCLUDE_MESSAGES_DOC = "Whether to include in the log the Connect record that resulted in a failure. For sink records, the topic, partition, offset, and timestamp will be logged. For source records, the key and value (and their schemas), all headers, and the timestamp, Kafka topic, Kafka partition, source partition, and source offset will be logged. This is 'false' by default, which will prevent record keys, values, and headers from being written to log files.";
    public static final String CONNECTOR_CLIENT_PRODUCER_OVERRIDES_PREFIX = "producer.override.";
    public static final String CONNECTOR_CLIENT_CONSUMER_OVERRIDES_PREFIX = "consumer.override.";
    public static final String CONNECTOR_CLIENT_ADMIN_OVERRIDES_PREFIX = "admin.override.";
    public static final String PREDICATES_PREFIX = "predicates.";
    public static final String CONNECTOR_ENDPOINT_CONFIG = "connector.endpoint";
    public static final String CONNECTOR_ENDPOINT_DOC = "An internal configuration that represents the endpoint hostname / URL of the end system that the connector is connecting to. This is used to determine the networking type of the connector (Public, Peering, PrivateLink)";
    public static final String CONNECTOR_TARGET_REGION_CONFIG = "connector.target.region";
    public static final String CONNECTOR_TARGET_REGION_DOC = "An internal configuration that represents region/cloud of the end system that the connector is connecting to. This is used to determine the regional connectivity type of the connector (Default, Cross_Cloud, Cross_Region)";
    public static final String MASKED_SECRET_VALUE = "\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022";
    private final EnrichedConnectorConfig enrichedConfig;

    public static ConfigDef configDef() {
        int orderInGroup = 0;
        int orderInErrorGroup = 0;
        return new ConfigDef().define(NAME_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.NonEmptyStringWithoutControlChars.nonEmptyStringWithoutControlChars(), ConfigDef.Importance.HIGH, NAME_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.MEDIUM, NAME_DISPLAY).define(CONNECTOR_CLASS_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, CONNECTOR_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.LONG, CONNECTOR_CLASS_DISPLAY).define(TASKS_MAX_CONFIG, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, TASKS_MAX_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, TASK_MAX_DISPLAY).define(KEY_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, null, KEY_CONVERTER_CLASS_VALIDATOR, ConfigDef.Importance.LOW, KEY_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, KEY_CONVERTER_CLASS_DISPLAY).define(VALUE_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, null, VALUE_CONVERTER_CLASS_VALIDATOR, ConfigDef.Importance.LOW, VALUE_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, VALUE_CONVERTER_CLASS_DISPLAY).define(HEADER_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)HEADER_CONVERTER_CLASS_DEFAULT, HEADER_CONVERTER_CLASS_VALIDATOR, ConfigDef.Importance.LOW, HEADER_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, HEADER_CONVERTER_CLASS_DISPLAY).define(TRANSFORMS_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)ConnectorConfig.aliasValidator("transformation"), ConfigDef.Importance.LOW, TRANSFORMS_DOC, "Transforms", ++orderInGroup, ConfigDef.Width.LONG, "Transforms").define(PREDICATES_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)ConnectorConfig.aliasValidator("predicate"), ConfigDef.Importance.LOW, PREDICATES_DOC, "Predicates", ++orderInGroup, ConfigDef.Width.LONG, "Predicates").define(CONFIG_RELOAD_ACTION_CONFIG, ConfigDef.Type.STRING, (Object)CONFIG_RELOAD_ACTION_RESTART, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{CONFIG_RELOAD_ACTION_NONE, CONFIG_RELOAD_ACTION_RESTART}), ConfigDef.Importance.LOW, CONFIG_RELOAD_ACTION_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.MEDIUM, CONFIG_RELOAD_ACTION_DISPLAY).define(ERRORS_RETRY_TIMEOUT_CONFIG, ConfigDef.Type.LONG, (Object)0, ConfigDef.Importance.MEDIUM, ERRORS_RETRY_TIMEOUT_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.MEDIUM, ERRORS_RETRY_TIMEOUT_DISPLAY).define(ERRORS_RETRY_MAX_DELAY_CONFIG, ConfigDef.Type.LONG, (Object)60000, ConfigDef.Importance.MEDIUM, ERRORS_RETRY_MAX_DELAY_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.MEDIUM, ERRORS_RETRY_MAX_DELAY_DISPLAY).define(ERRORS_TOLERANCE_CONFIG, ConfigDef.Type.STRING, (Object)ERRORS_TOLERANCE_DEFAULT.value(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{ToleranceType.NONE.value(), ToleranceType.ALL.value()}), ConfigDef.Importance.MEDIUM, ERRORS_TOLERANCE_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.SHORT, ERRORS_TOLERANCE_DISPLAY).define(ERRORS_LOG_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, ERRORS_LOG_ENABLE_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.SHORT, ERRORS_LOG_ENABLE_DISPLAY).define(ERRORS_LOG_INCLUDE_MESSAGES_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, ERRORS_LOG_INCLUDE_MESSAGES_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.SHORT, ERRORS_LOG_INCLUDE_MESSAGES_DISPLAY);
    }

    private static ConfigDef.CompositeValidator aliasValidator(final String kind) {
        return ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{new ConfigDef.NonNullValidator(), new ConfigDef.Validator(){

            public void ensureValid(String name, Object value) {
                List aliases = (List)value;
                if (aliases.size() > new HashSet(aliases).size()) {
                    throw new ConfigException(name, value, "Duplicate alias provided.");
                }
            }

            public String toString() {
                return "unique " + kind + " aliases";
            }
        }});
    }

    public ConnectorConfig(Plugins plugins) {
        this(plugins, Collections.emptyMap());
    }

    public ConnectorConfig(Plugins plugins, Map<String, String> props) {
        this(plugins, ConnectorConfig.configDef(), props);
    }

    public ConnectorConfig(Plugins plugins, ConfigDef configDef, Map<String, String> props) {
        super(configDef, props);
        this.enrichedConfig = new EnrichedConnectorConfig(ConnectorConfig.enrich(plugins, configDef, props, true), props);
    }

    public Object get(String key) {
        return this.enrichedConfig.get(key);
    }

    public long errorRetryTimeout() {
        return this.getLong(ERRORS_RETRY_TIMEOUT_CONFIG);
    }

    public long errorMaxDelayInMillis() {
        return this.getLong(ERRORS_RETRY_MAX_DELAY_CONFIG);
    }

    public ToleranceType errorToleranceType() {
        String tolerance = this.getString(ERRORS_TOLERANCE_CONFIG);
        for (ToleranceType type : ToleranceType.values()) {
            if (!type.name().equalsIgnoreCase(tolerance)) continue;
            return type;
        }
        return ERRORS_TOLERANCE_DEFAULT;
    }

    public boolean enableErrorLog() {
        return this.getBoolean(ERRORS_LOG_ENABLE_CONFIG);
    }

    public boolean includeRecordDetailsInErrorLog() {
        return this.getBoolean(ERRORS_LOG_INCLUDE_MESSAGES_CONFIG);
    }

    public <R extends ConnectRecord<R>> List<TransformationStage<R>> transformationStages() {
        List transformAliases = this.getList(TRANSFORMS_CONFIG);
        ArrayList<TransformationStage<R>> transformations = new ArrayList<TransformationStage<R>>(transformAliases.size());
        for (String alias : transformAliases) {
            String prefix = "transforms." + alias + ".";
            try {
                Transformation transformation = (Transformation)Utils.newInstance((Class)this.getClass(prefix + "type"), Transformation.class);
                Map configs = this.originalsWithPrefix(prefix);
                Object predicateAlias = configs.remove("predicate");
                Object negate = configs.remove("negate");
                transformation.configure(configs);
                if (predicateAlias != null) {
                    Predicate predicate = null;
                    try {
                        String predicatePrefix = PREDICATES_PREFIX + predicateAlias + ".";
                        predicate = (Predicate)Utils.newInstance((Class)this.getClass(predicatePrefix + "type"), Predicate.class);
                        predicate.configure(this.originalsWithPrefix(predicatePrefix));
                    }
                    catch (Throwable t) {
                        Utils.closeQuietly((AutoCloseable)transformation, (String)("transform " + alias + " for connector " + this.getString(NAME_CONFIG)));
                        Utils.closeQuietly((AutoCloseable)predicate, (String)("predicate " + predicateAlias + " for connector " + this.getString(NAME_CONFIG)));
                        throw t;
                    }
                    transformations.add(new TransformationStage(predicate, negate == null ? false : Boolean.parseBoolean(negate.toString()), transformation));
                    continue;
                }
                transformations.add(new TransformationStage(transformation));
            }
            catch (Throwable t) {
                transformations.forEach(transform -> Utils.closeQuietly((AutoCloseable)transform, (String)("transform " + transform + " for connector " + this.getString(NAME_CONFIG))));
                throw new ConnectException(t);
            }
        }
        return transformations;
    }

    public static ConfigDef enrich(final Plugins plugins, ConfigDef baseConfigDef, final Map<String, String> props, boolean requireFullConfig) {
        ConfigDef newDef = new ConfigDef(baseConfigDef);
        new EnrichablePlugin<Transformation<?>>("Transformation", TRANSFORMS_CONFIG, "Transforms", Transformation.class, props, requireFullConfig){

            @Override
            protected Set<PluginDesc<Transformation<?>>> plugins() {
                return plugins.transformations();
            }

            @Override
            protected ConfigDef initialConfigDef() {
                return super.initialConfigDef().define("predicate", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The alias of a predicate used to determine whether to apply this transformation.").define("negate", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Whether the configured predicate should be negated.");
            }

            @Override
            protected Stream<Map.Entry<String, ConfigDef.ConfigKey>> configDefsForClass(String typeConfig) {
                return super.configDefsForClass(typeConfig).filter(entry -> {
                    if ("predicate".equals(entry.getKey()) || "negate".equals(entry.getKey())) {
                        log.warn("Transformer config {} is masked by implicit config of that name", entry.getKey());
                        return false;
                    }
                    return true;
                });
            }

            @Override
            protected ConfigDef config(Transformation<?> transformation) {
                return transformation.config();
            }

            @Override
            protected void validateProps(String prefix) {
                String prefixedNegate = prefix + "negate";
                String prefixedPredicate = prefix + "predicate";
                if (props.containsKey(prefixedNegate) && !props.containsKey(prefixedPredicate)) {
                    throw new ConfigException("Config '" + prefixedNegate + "' was provided but there is no config '" + prefixedPredicate + "' defining a predicate to be negated.");
                }
            }
        }.enrich(newDef);
        new EnrichablePlugin<Predicate<?>>("Predicate", PREDICATES_CONFIG, "Predicates", Predicate.class, props, requireFullConfig){

            @Override
            protected Set<PluginDesc<Predicate<?>>> plugins() {
                return plugins.predicates();
            }

            @Override
            protected ConfigDef config(Predicate<?> predicate) {
                return predicate.config();
            }
        }.enrich(newDef);
        return newDef;
    }

    static abstract class EnrichablePlugin<T> {
        private final String aliasKind;
        private final String aliasConfig;
        private final String aliasGroup;
        private final Class<T> baseClass;
        private final Map<String, String> props;
        private final boolean requireFullConfig;

        public EnrichablePlugin(String aliasKind, String aliasConfig, String aliasGroup, Class<T> baseClass, Map<String, String> props, boolean requireFullConfig) {
            this.aliasKind = aliasKind;
            this.aliasConfig = aliasConfig;
            this.aliasGroup = aliasGroup;
            this.baseClass = baseClass;
            this.props = props;
            this.requireFullConfig = requireFullConfig;
        }

        void enrich(ConfigDef newDef) {
            Object aliases = ConfigDef.parseType((String)this.aliasConfig, (Object)this.props.get(this.aliasConfig), (ConfigDef.Type)ConfigDef.Type.LIST);
            if (!(aliases instanceof List)) {
                return;
            }
            LinkedHashSet uniqueAliases = new LinkedHashSet((List)aliases);
            for (Object o : uniqueAliases) {
                if (!(o instanceof String)) {
                    throw new ConfigException("Item in " + this.aliasConfig + " property is not of type String");
                }
                String alias = (String)o;
                String prefix = this.aliasConfig + "." + alias + ".";
                String group = this.aliasGroup + ": " + alias;
                int orderInGroup = 0;
                String typeConfig = prefix + "type";
                ConfigDef.LambdaValidator typeValidator = ConfigDef.LambdaValidator.with((name, value) -> {
                    this.validateProps(prefix);
                    if (value != null) {
                        this.getConfigDefFromConfigProvidingClass(typeConfig, (Class)value);
                    }
                }, () -> "valid configs for " + alias + " " + this.aliasKind.toLowerCase(Locale.ENGLISH));
                newDef.define(typeConfig, ConfigDef.Type.CLASS, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)typeValidator, ConfigDef.Importance.HIGH, "Class for the '" + alias + "' " + this.aliasKind.toLowerCase(Locale.ENGLISH) + ".", group, orderInGroup++, ConfigDef.Width.LONG, this.baseClass.getSimpleName() + " type for " + alias, Collections.emptyList(), (ConfigDef.Recommender)new ClassRecommender());
                ConfigDef configDef = this.populateConfigDef(typeConfig);
                if (configDef == null) continue;
                newDef.embed(prefix, group, orderInGroup, configDef);
            }
        }

        protected void validateProps(String prefix) {
        }

        protected ConfigDef populateConfigDef(String typeConfig) {
            ConfigDef configDef = this.initialConfigDef();
            try {
                this.configDefsForClass(typeConfig).forEach(entry -> configDef.define((ConfigDef.ConfigKey)entry.getValue()));
            }
            catch (ConfigException e) {
                if (this.requireFullConfig) {
                    throw e;
                }
                return null;
            }
            return configDef;
        }

        protected Stream<Map.Entry<String, ConfigDef.ConfigKey>> configDefsForClass(String typeConfig) {
            Class cls = (Class)ConfigDef.parseType((String)typeConfig, (Object)this.props.get(typeConfig), (ConfigDef.Type)ConfigDef.Type.CLASS);
            return this.getConfigDefFromConfigProvidingClass(typeConfig, cls).configKeys().entrySet().stream();
        }

        protected ConfigDef initialConfigDef() {
            return new ConfigDef();
        }

        ConfigDef getConfigDefFromConfigProvidingClass(String key, Class<?> cls) {
            Object transformation;
            if (cls == null) {
                throw new ConfigException(key, null, "Not a " + this.baseClass.getSimpleName());
            }
            Utils.ensureConcreteSubclass(this.baseClass, cls);
            try {
                transformation = Utils.newInstance(cls, this.baseClass);
            }
            catch (Exception e) {
                log.error("Failed to instantiate {} '{}'", new Object[]{this.baseClass.getSimpleName(), cls, e});
                throw new ConfigException(key, (Object)String.valueOf(cls), "Error instantiating " + this.baseClass.getSimpleName() + ": " + e.getMessage());
            }
            ConfigDef configDef = this.config(transformation);
            if (null == configDef) {
                throw new ConnectException(String.format("%s.config() must return a ConfigDef that is not null.", cls.getName()));
            }
            return configDef;
        }

        protected abstract ConfigDef config(T var1);

        protected abstract Set<PluginDesc<T>> plugins();

        final class ClassRecommender
        implements ConfigDef.Recommender {
            ClassRecommender() {
            }

            public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
                ArrayList result = new ArrayList();
                for (PluginDesc plugin : EnrichablePlugin.this.plugins()) {
                    result.add(plugin.pluginClass());
                }
                return Collections.unmodifiableList(result);
            }

            public boolean visible(String name, Map<String, Object> parsedConfig) {
                return true;
            }
        }
    }

    private static class EnrichedConnectorConfig
    extends AbstractConfig {
        EnrichedConnectorConfig(ConfigDef configDef, Map<String, String> props) {
            super(configDef, props);
        }

        public Object get(String key) {
            return super.get(key);
        }
    }
}

