/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.runtime.LoggerContext;
import org.apache.kafka.connect.runtime.rest.entities.LoggerLevel;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loggers {
    private static final Logger log = LoggerFactory.getLogger(Loggers.class);
    private static final String ROOT_LOGGER_NAME = "root";
    private final Time time;
    private final Map<String, LoggerContext> loggerContextMap;
    private static final String SHUTDOWN_HOOK_LOG_AUTORESET_SERVICE = "shutdownLogAutoResetService";
    private static final String LOG_AUTO_RESET_SERVICE_THREAD_PATTERN = "LogAutoResetService-%d";
    private ScheduledExecutorService logAutoResetService = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"LogAutoResetService-%d", (boolean)false));

    public Loggers(Time time) {
        this.time = time;
        this.loggerContextMap = new HashMap<String, LoggerContext>();
        Exit.addShutdownHook((String)SHUTDOWN_HOOK_LOG_AUTORESET_SERVICE, () -> this.logAutoResetService.shutdownNow());
    }

    public synchronized LoggerLevel level(String logger) {
        Objects.requireNonNull(logger, "Logger may not be null");
        org.apache.log4j.Logger foundLogger = null;
        if (ROOT_LOGGER_NAME.equalsIgnoreCase(logger)) {
            foundLogger = this.rootLogger();
        } else {
            Enumeration<org.apache.log4j.Logger> en = this.currentLoggers();
            while (en.hasMoreElements()) {
                org.apache.log4j.Logger l = en.nextElement();
                if (!logger.equals(l.getName())) continue;
                foundLogger = l;
                break;
            }
        }
        if (foundLogger == null) {
            log.warn("Unable to find level for logger {}", (Object)logger);
            return null;
        }
        return this.loggerLevel(foundLogger);
    }

    public synchronized Map<String, LoggerLevel> allLevels() {
        TreeMap<String, LoggerLevel> result = new TreeMap<String, LoggerLevel>();
        Enumeration<org.apache.log4j.Logger> enumeration = this.currentLoggers();
        Collections.list(enumeration).stream().filter(logger -> logger.getLevel() != null).forEach(logger -> result.put(logger.getName(), this.loggerLevel((org.apache.log4j.Logger)logger)));
        org.apache.log4j.Logger root = this.rootLogger();
        if (root.getLevel() != null) {
            result.put(ROOT_LOGGER_NAME, this.loggerLevel(root));
        }
        return result;
    }

    public synchronized Map<String, Map<String, String>> allLevelsWithTimeouts() {
        TreeMap<String, Map<String, String>> result = new TreeMap<String, Map<String, String>>();
        Enumeration<org.apache.log4j.Logger> enumeration = this.currentLoggers();
        Collections.list(enumeration).stream().filter(logger -> logger.getLevel() != null).forEach(logger -> result.put(logger.getName(), this.levelAndTimeoutToMap((org.apache.log4j.Logger)logger)));
        org.apache.log4j.Logger root = this.rootLogger();
        if (root.getLevel() != null) {
            result.put(ROOT_LOGGER_NAME, Collections.singletonMap("level", String.valueOf(root.getLevel())));
        }
        return result;
    }

    public synchronized List<String> setLevel(String namespace, Level level) {
        Objects.requireNonNull(namespace, "Logging namespace may not be null");
        Objects.requireNonNull(level, "Level may not be null");
        log.info("Setting level of namespace {} and children to {}", (Object)namespace, (Object)level);
        List<org.apache.log4j.Logger> childLoggers = this.loggers(namespace);
        ArrayList<String> result = new ArrayList<String>();
        for (org.apache.log4j.Logger logger : childLoggers) {
            LoggerContext logContext;
            if (this.loggerContextMap.containsKey(logger.getName()) && (logContext = this.loggerContextMap.get(logger.getName())).getLoggerContextAutoReset() != null) {
                logContext.getLoggerContextAutoReset().getAutoResetFuture().cancel(false);
                logContext.setLoggerContextAutoReset(null);
            }
            this.setLevel(logger, level);
            result.add(logger.getName());
        }
        Collections.sort(result);
        return result;
    }

    public synchronized Map<String, Long> setLevelWithTimeout(String namespace, Level level, Long timeout) {
        Objects.requireNonNull(namespace, "Logging namespace may not be null");
        Objects.requireNonNull(level, "Level may not be null");
        Objects.requireNonNull(timeout, "Timeout may not be null");
        log.info("Setting level of namespace {} and children to {} with a timeout {} on this worker", new Object[]{namespace, level, timeout});
        List<org.apache.log4j.Logger> childLoggers = this.loggers(namespace);
        TreeMap<String, Long> result = new TreeMap<String, Long>();
        for (org.apache.log4j.Logger logger : childLoggers) {
            Optional<LoggerContext> loggerContextOptional = Optional.ofNullable(this.loggerContextMap.get(logger.getName()));
            Optional<LoggerContext.LoggerContextAutoReset> loggerContextAutoResetOptional = loggerContextOptional.map(LoggerContext::getLoggerContextAutoReset);
            Level oldLogLevel = loggerContextAutoResetOptional.map(LoggerContext.LoggerContextAutoReset::getLevel).orElse(logger.getLevel());
            result.put(logger.getName(), timeout);
            logger.setLevel(level);
            ScheduledFuture<?> autoResetFuture = this.logAutoResetService.schedule(() -> {
                Loggers loggers = this;
                synchronized (loggers) {
                    logger.setLevel(oldLogLevel);
                    LoggerContext loggerContext = this.loggerContextMap.get(logger.getName());
                    if (loggerContext != null) {
                        loggerContext.setLoggerContextAutoReset(null);
                    }
                }
            }, (long)timeout, TimeUnit.MILLISECONDS);
            this.loggerContextMap.putIfAbsent(logger.getName(), new LoggerContext());
            this.loggerContextMap.get(logger.getName()).setLoggerContextAutoReset(new LoggerContext.LoggerContextAutoReset(oldLogLevel, timeout, autoResetFuture));
        }
        return result;
    }

    private synchronized List<org.apache.log4j.Logger> loggers(String namespace) {
        Objects.requireNonNull(namespace, "Logging namespace may not be null");
        if (ROOT_LOGGER_NAME.equalsIgnoreCase(namespace)) {
            ArrayList<org.apache.log4j.Logger> result = Collections.list(this.currentLoggers());
            result.add(this.rootLogger());
            return result;
        }
        ArrayList<org.apache.log4j.Logger> result = new ArrayList<org.apache.log4j.Logger>();
        org.apache.log4j.Logger ancestorLogger = this.lookupLogger(namespace);
        Enumeration<org.apache.log4j.Logger> en = this.currentLoggers();
        boolean present = false;
        while (en.hasMoreElements()) {
            org.apache.log4j.Logger current = en.nextElement();
            if (current.getName().startsWith(namespace)) {
                result.add(current);
            }
            if (!namespace.equals(current.getName())) continue;
            present = true;
        }
        if (!present) {
            result.add(ancestorLogger);
        }
        return result;
    }

    private Map<String, String> levelAndTimeoutToMap(org.apache.log4j.Logger logger) {
        HashMap<String, String> levelAndTimeoutMap = new HashMap<String, String>();
        levelAndTimeoutMap.put("level", String.valueOf(logger.getLevel()));
        Optional<Long> timeoutOptional = Optional.ofNullable(this.loggerContextMap.get(logger.getName())).map(LoggerContext::getLoggerContextAutoReset).map(LoggerContext.LoggerContextAutoReset::getDelay);
        timeoutOptional.ifPresent(timeout -> levelAndTimeoutMap.put("timeout", String.valueOf(timeout)));
        return levelAndTimeoutMap;
    }

    org.apache.log4j.Logger lookupLogger(String logger) {
        return LogManager.getLogger((String)logger);
    }

    Enumeration<org.apache.log4j.Logger> currentLoggers() {
        return LogManager.getCurrentLoggers();
    }

    org.apache.log4j.Logger rootLogger() {
        return LogManager.getRootLogger();
    }

    Map<String, LoggerContext> loggerContextMap() {
        return this.loggerContextMap;
    }

    void setLogAutoResetService(ScheduledExecutorService scheduledExecutorService) {
        this.logAutoResetService = scheduledExecutorService;
    }

    private void setLevel(org.apache.log4j.Logger logger, Level level) {
        Level currentLevel = logger.getLevel();
        if (currentLevel == null) {
            currentLevel = logger.getEffectiveLevel();
        }
        if (level.equals((Object)currentLevel)) {
            log.debug("Skipping update for logger {} since its level is already {}", (Object)logger.getName(), (Object)level);
            return;
        }
        log.debug("Setting level of logger {} (excluding children) to {}", (Object)logger.getName(), (Object)level);
        logger.setLevel(level);
        this.loggerContextMap.put(logger.getName(), new LoggerContext(this.time.milliseconds()));
    }

    private LoggerLevel loggerLevel(org.apache.log4j.Logger logger) {
        Level level = logger.getLevel();
        if (level == null) {
            level = logger.getEffectiveLevel();
        }
        Long lastModified = Optional.ofNullable(this.loggerContextMap.get(logger.getName())).map(LoggerContext::getLastModifiedTime).orElse(null);
        return new LoggerLevel(Objects.toString(level), lastModified);
    }
}

