/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoader;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoaderFactory;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginSource;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUtils {
    private static final Logger log = LoggerFactory.getLogger(PluginUtils.class);
    private static final Pattern EXCLUDE = Pattern.compile("^(?:java|javax\\.accessibility|javax\\.activation|javax\\.activity|javax\\.annotation|javax\\.batch\\.api|javax\\.batch\\.operations|javax\\.batch\\.runtime|javax\\.crypto|javax\\.decorator|javax\\.ejb|javax\\.el|javax\\.enterprise\\.concurrent|javax\\.enterprise\\.context|javax\\.enterprise\\.context\\.spi|javax\\.enterprise\\.deploy\\.model|javax\\.enterprise\\.deploy\\.shared|javax\\.enterprise\\.deploy\\.spi|javax\\.enterprise\\.event|javax\\.enterprise\\.inject|javax\\.enterprise\\.inject\\.spi|javax\\.enterprise\\.util|javax\\.faces|javax\\.imageio|javax\\.inject|javax\\.interceptor|javax\\.jms|javax\\.json|javax\\.jws|javax\\.lang\\.model|javax\\.mail|javax\\.management|javax\\.management\\.j2ee|javax\\.naming|javax\\.net|javax\\.persistence|javax\\.print|javax\\.resource|javax\\.rmi|javax\\.script|javax\\.security\\.auth|javax\\.security\\.auth\\.message|javax\\.security\\.cert|javax\\.security\\.jacc|javax\\.security\\.sasl|javax\\.servlet|javax\\.sound\\.midi|javax\\.sound\\.sampled|javax\\.sql|javax\\.swing|javax\\.tools|javax\\.transaction|javax\\.validation|javax\\.websocket|javax\\.ws\\.rs|javax\\.xml|javax\\.xml\\.bind|javax\\.xml\\.registry|javax\\.xml\\.rpc|javax\\.xml\\.soap|javax\\.xml\\.ws|org\\.ietf\\.jgss|org\\.omg\\.CORBA|org\\.omg\\.CosNaming|org\\.omg\\.Dynamic|org\\.omg\\.DynamicAny|org\\.omg\\.IOP|org\\.omg\\.Messaging|org\\.omg\\.PortableInterceptor|org\\.omg\\.PortableServer|org\\.omg\\.SendingContext|org\\.omg\\.stub\\.java\\.rmi|org\\.w3c\\.dom|org\\.xml\\.sax|org\\.apache\\.kafka|org\\.slf4j|io\\.confluent\\.license|io\\.confluent\\.command)\\..*$");
    private static final Pattern INCLUDE = Pattern.compile("^org\\.apache\\.kafka\\.(?:connect\\.(?:transforms\\.(?!Transformation|predicates\\.Predicate$).*|json\\..*|file\\..*|mirror\\..*|mirror-client\\..*|converters\\..*|storage\\.StringConverter|storage\\.SimpleHeaderConverter|rest\\.basic\\.auth\\.extension\\.BasicAuthSecurityRestExtension|connector\\.policy\\.(?!ConnectorClientConfig(?:OverridePolicy|Request(?:\\$ClientType)?)$).*)|common\\.config\\.provider\\.(?!ConfigProvider$).*)$");
    private static final Pattern COMMA_WITH_WHITESPACE = Pattern.compile("\\s*,\\s*");
    private static final DirectoryStream.Filter<Path> PLUGIN_PATH_FILTER = path -> Files.isDirectory(path, new LinkOption[0]) || PluginUtils.isArchive(path) || PluginUtils.isClassFile(path);

    public static boolean shouldLoadInIsolation(String name) {
        return !EXCLUDE.matcher(name).matches() || INCLUDE.matcher(name).matches();
    }

    public static boolean isConcrete(Class<?> klass) {
        int mod = klass.getModifiers();
        return !Modifier.isAbstract(mod) && !Modifier.isInterface(mod);
    }

    public static boolean isArchive(Path path) {
        String archivePath = path.toString().toLowerCase(Locale.ROOT);
        return archivePath.endsWith(".jar") || archivePath.endsWith(".zip");
    }

    public static boolean isClassFile(Path path) {
        return path.toString().toLowerCase(Locale.ROOT).endsWith(".class");
    }

    public static Set<Path> pluginLocations(String pluginPath, boolean failFast, boolean lazyLoadEnabled) {
        if (pluginPath == null || lazyLoadEnabled) {
            return Collections.emptySet();
        }
        String[] pluginPathElements = COMMA_WITH_WHITESPACE.split(pluginPath.trim(), -1);
        LinkedHashSet<Path> pluginLocations = new LinkedHashSet<Path>();
        for (String path : pluginPathElements) {
            try {
                Path pluginPathElement = Paths.get(path, new String[0]).toAbsolutePath();
                if (pluginPath.isEmpty()) {
                    log.warn("Plugin path element is empty, evaluating to {}.", (Object)pluginPathElement);
                }
                if (!Files.exists(pluginPathElement, new LinkOption[0])) {
                    throw new FileNotFoundException(pluginPathElement.toString());
                }
                if (Files.isDirectory(pluginPathElement, new LinkOption[0])) {
                    pluginLocations.addAll(PluginUtils.pluginLocations(pluginPathElement));
                    continue;
                }
                if (!PluginUtils.isArchive(pluginPathElement)) continue;
                pluginLocations.add(pluginPathElement);
            }
            catch (IOException | InvalidPathException e) {
                if (failFast) {
                    throw new RuntimeException(e);
                }
                log.error("Could not get listing for plugin path: {}. Ignoring.", (Object)path, (Object)e);
            }
        }
        return pluginLocations;
    }

    private static List<Path> pluginLocations(Path pluginPathElement) throws IOException {
        ArrayList<Path> locations = new ArrayList<Path>();
        try (DirectoryStream<Path> listing = Files.newDirectoryStream(pluginPathElement, PLUGIN_PATH_FILTER);){
            for (Path dir : listing) {
                locations.add(dir);
            }
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Path> pluginUrls(Path topPath) throws IOException {
        boolean containsClassFiles = false;
        TreeSet<Path> archives = new TreeSet<Path>();
        LinkedList<DirectoryEntry> dfs = new LinkedList<DirectoryEntry>();
        HashSet<Path> visited = new HashSet<Path>();
        if (PluginUtils.isArchive(topPath)) {
            return Collections.singletonList(topPath);
        }
        DirectoryStream<Path> topListing = Files.newDirectoryStream(topPath, PLUGIN_PATH_FILTER);
        dfs.push(new DirectoryEntry(topListing));
        visited.add(topPath);
        try {
            while (!dfs.isEmpty()) {
                Iterator<Path> neighbors = ((DirectoryEntry)dfs.peek()).iterator;
                if (!neighbors.hasNext()) {
                    ((DirectoryEntry)dfs.pop()).stream.close();
                    continue;
                }
                Path adjacent = neighbors.next();
                if (Files.isSymbolicLink(adjacent)) {
                    try {
                        Path absolute;
                        Path symlink = Files.readSymbolicLink(adjacent);
                        Path parent = adjacent.getParent();
                        if (parent == null || !Files.exists(absolute = parent.resolve(symlink).toRealPath(new LinkOption[0]), new LinkOption[0])) continue;
                        adjacent = absolute;
                    }
                    catch (IOException e) {
                        log.warn("Resolving symbolic link '{}' failed. Ignoring this path.", (Object)adjacent, (Object)e);
                        continue;
                    }
                }
                if (visited.contains(adjacent)) continue;
                visited.add(adjacent);
                if (PluginUtils.isArchive(adjacent)) {
                    archives.add(adjacent);
                    continue;
                }
                if (PluginUtils.isClassFile(adjacent)) {
                    containsClassFiles = true;
                    continue;
                }
                DirectoryStream<Path> listing = Files.newDirectoryStream(adjacent, PLUGIN_PATH_FILTER);
                dfs.push(new DirectoryEntry(listing));
            }
        }
        finally {
            while (!dfs.isEmpty()) {
                ((DirectoryEntry)dfs.pop()).stream.close();
            }
        }
        if (containsClassFiles) {
            if (archives.isEmpty()) {
                return Collections.singletonList(topPath);
            }
            log.warn("Plugin path contains both java archives and class files. Returning only the archives");
        }
        return Arrays.asList(archives.toArray(new Path[0]));
    }

    public static Set<PluginSource> pluginSources(Set<Path> pluginLocations, ClassLoader classLoader, PluginClassLoaderFactory factory) {
        LinkedHashSet<PluginSource> pluginSources = new LinkedHashSet<PluginSource>();
        for (Path pluginLocation : pluginLocations) {
            try {
                pluginSources.add(PluginUtils.isolatedPluginSource(pluginLocation, classLoader, factory));
            }
            catch (MalformedURLException | InvalidPathException e) {
                log.error("Invalid path in plugin path: {}. Ignoring.", (Object)pluginLocation, (Object)e);
            }
            catch (IOException e) {
                log.error("Could not get listing for plugin path: {}. Ignoring.", (Object)pluginLocation, (Object)e);
            }
        }
        pluginSources.add(PluginUtils.classpathPluginSource(classLoader.getParent()));
        return pluginSources;
    }

    public static PluginSource isolatedPluginSource(Path pluginLocation, ClassLoader parent, PluginClassLoaderFactory factory) throws IOException {
        ArrayList<URL> pluginUrls = new ArrayList<URL>();
        List<Path> paths = PluginUtils.pluginUrls(pluginLocation);
        PluginSource.Type type = paths.size() == 1 && paths.get(0) == pluginLocation ? (PluginUtils.isArchive(pluginLocation) ? PluginSource.Type.SINGLE_JAR : PluginSource.Type.CLASS_HIERARCHY) : PluginSource.Type.MULTI_JAR;
        for (Path path : paths) {
            pluginUrls.add(path.toUri().toURL());
        }
        URL[] urls = pluginUrls.toArray(new URL[0]);
        PluginClassLoader loader = factory.newPluginClassLoader(pluginLocation.toUri().toURL(), urls, parent);
        return new PluginSource(pluginLocation, type, loader, urls);
    }

    public static PluginSource classpathPluginSource(ClassLoader classLoader) {
        ArrayList parentUrls = new ArrayList();
        parentUrls.addAll(ClasspathHelper.forJavaClassPath());
        parentUrls.addAll(ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{classLoader}));
        return new PluginSource(null, PluginSource.Type.CLASSPATH, classLoader, parentUrls.toArray(new URL[0]));
    }

    public static String simpleName(PluginDesc<?> plugin) {
        return plugin.pluginClass().getSimpleName();
    }

    public static String prunedName(PluginDesc<?> plugin) {
        switch (plugin.type()) {
            case SOURCE: 
            case SINK: {
                return PluginUtils.prunePluginName(plugin, "Connector");
            }
        }
        return PluginUtils.prunePluginName(plugin, plugin.type().simpleName());
    }

    private static String prunePluginName(PluginDesc<?> plugin, String suffix) {
        String simple = plugin.pluginClass().getSimpleName();
        int pos = simple.lastIndexOf(suffix);
        if (pos > 0) {
            return simple.substring(0, pos);
        }
        return simple;
    }

    public static Map<String, String> computeAliases(PluginScanResult scanResult) {
        HashMap aliasCollisions = new HashMap();
        scanResult.forEach(pluginDesc -> {
            aliasCollisions.computeIfAbsent(PluginUtils.simpleName(pluginDesc), ignored -> new HashSet()).add(pluginDesc.className());
            aliasCollisions.computeIfAbsent(PluginUtils.prunedName(pluginDesc), ignored -> new HashSet()).add(pluginDesc.className());
        });
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (Map.Entry entry : aliasCollisions.entrySet()) {
            String alias = (String)entry.getKey();
            Set classNames = (Set)entry.getValue();
            if (classNames.size() == 1) {
                aliases.put(alias, (String)classNames.stream().findAny().get());
                continue;
            }
            log.debug("Ignoring ambiguous alias '{}' since it refers to multiple distinct plugins {}", (Object)alias, (Object)classNames);
        }
        return aliases;
    }

    private static class DirectoryEntry {
        final DirectoryStream<Path> stream;
        final Iterator<Path> iterator;

        DirectoryEntry(DirectoryStream<Path> stream) {
            this.stream = stream;
            this.iterator = stream.iterator();
        }
    }
}

