/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.tracing;

import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.runtime.errors.Stage;
import org.apache.kafka.connect.runtime.tracing.ConnectorTracingException;
import org.apache.kafka.connect.runtime.tracing.TraceRecord;
import org.apache.kafka.connect.runtime.tracing.TraceRecordBuilder;
import org.apache.kafka.connect.runtime.tracing.TracerConfig;
import org.apache.kafka.connect.runtime.tracing.TracingContext;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.source.SourceRecord;

@Confluent
public class TraceRecordBuilderImpl
implements TraceRecordBuilder {
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String HEADERS = "headers";
    public static final String SOURCE_PARTITION = "source_partition";
    public static final String SOURCE_OFFSET = "source_offset";
    public static final String TYPE = "type";
    public static final String OFFSET = "offset";
    public static final String TOPIC = "topic";
    public static final String PARTITION = "partition";
    public static final String CONNECTOR = "connector";
    public static final String CORRELATION_ID = "correlation_id";
    public static final String CURRENT_STEP = "current_step";
    public static final String TOTAL_STEP = "total_step";
    public static final String TRANSFORMATION_NAME = "transformation_name";
    public static final String TRANSFORMATION_TYPE = "transformation_type";
    public static final String RECORD = "record";
    public static final String METADATA = "metadata";
    public static final String ERROR = "error";
    public static final String ERROR_MESSAGE = "error_message";
    public static final String ERROR_TRACE = "error_trace";
    public static final String ADDITIONAL_ERROR_INFO = "error_info";
    public static final String SOURCE_TYPE = "SOURCE";
    public static final String SINK_TYPE = "SINK";
    private final List<TraceRecord> records = new ArrayList<TraceRecord>();
    private final TracingContext context;
    private final TracerConfig tracerConfig;
    private final Map<String, Integer> recordStepCount;
    private static final String TRACE_METADATA_SCHEMA_NAME = "TRACE_METADATA";
    private static final String RECORD_SCHEMA_NAME = "TRANSFORMED_RECORD";
    private static final String TRACE_SCHEMA_NAME = "TRACE_SCHEMA";
    private static final String TRACE_ERROR_SCHEMA_NAME = "TRACE_ERROR";
    private static final String ERROR_TYPE = "Type";
    private static final String SINK_RECORD_ERROR = "SinkRecord error";
    private static final String CONVERSION_ERROR = "Conversion Error";
    private static final String CONVERSION_TYPE = "Conversion Type";
    private static final String TASK_ERROR = "Task error";
    private static final String TRACING_ERROR = "Tracing error";
    private static final String FAILED_RECORD = "Failed Record";
    private static final String EXECUTING_CLASS = "Executing Class";
    private static final String ERROR_STAGE = "Stage";
    private static final String DATA_ERROR = "Data error";
    private static final String DATA_ERROR_INFO = "Info";
    public static final Schema METADATA_SCHEMA = SchemaBuilder.struct().name("TRACE_METADATA").field("source_partition", SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).optional().build()).field("source_offset", SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).optional().build()).field("topic", SchemaBuilder.OPTIONAL_STRING_SCHEMA).field("partition", SchemaBuilder.OPTIONAL_INT32_SCHEMA).field("offset", SchemaBuilder.OPTIONAL_INT64_SCHEMA).field("connector", Schema.STRING_SCHEMA).field("correlation_id", SchemaBuilder.OPTIONAL_STRING_SCHEMA).field("current_step", Schema.OPTIONAL_INT32_SCHEMA).field("total_step", Schema.OPTIONAL_INT32_SCHEMA).field("type", SchemaBuilder.OPTIONAL_STRING_SCHEMA).field("transformation_name", SchemaBuilder.OPTIONAL_STRING_SCHEMA).field("transformation_type", SchemaBuilder.OPTIONAL_STRING_SCHEMA).build();
    public static final Schema ERROR_SCHEMA;
    public static final Schema ERROR_SCHEMA_WITH_TRACE;

    public TraceRecordBuilderImpl(TracerConfig tracerConfig, TracingContext context) {
        this.context = context;
        this.tracerConfig = tracerConfig;
        this.recordStepCount = new HashMap<String, Integer>();
    }

    private static Map<String, String> stringMap(Map<String, ?> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString()));
    }

    private String stackTraceError(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private void correlateAndIncrementStep(Struct metadataValue) {
        String correlationId = Arrays.asList(this.context.traceID().toString(), this.context.connectorTaskId().toString(), this.context.processedRecordCount().toString()).stream().collect(Collectors.joining("-"));
        metadataValue.put(CORRELATION_ID, (Object)correlationId);
        Integer stepCount = this.recordStepCount.getOrDefault(correlationId, 0) + 1;
        metadataValue.put(CURRENT_STEP, (Object)stepCount);
        metadataValue.put(TOTAL_STEP, (Object)-1);
        this.recordStepCount.put(correlationId, stepCount);
    }

    private Struct createErrorObject(SchemaBuilder recordSchemaBuilder, Throwable error, Optional<Map<String, String>> errorInfo, boolean writeErrorTrace) {
        Schema errorSchema = writeErrorTrace ? ERROR_SCHEMA_WITH_TRACE : ERROR_SCHEMA;
        recordSchemaBuilder.field(ERROR, errorSchema);
        Struct errorValue = new Struct(errorSchema);
        errorValue.put(ERROR_MESSAGE, (Object)error.getMessage());
        if (writeErrorTrace) {
            errorValue.put(ERROR_TRACE, (Object)this.stackTraceError(error));
        }
        errorInfo.ifPresent(ef -> errorValue.put(ADDITIONAL_ERROR_INFO, ef));
        return errorValue;
    }

    private Object actualOrNull(Schema schema, Object value) {
        if (schema != null || value == null) {
            return value;
        }
        return value.toString();
    }

    private <R extends ConnectRecord<R>> SchemaAndValue createSchemaAndValue(TraceMetadata traceMetadata, Optional<R> record, Optional<String> transformationName, Optional<String> transformationType, Optional<Throwable> error, Optional<Map<String, String>> errorInfo, boolean correlate, boolean writeNullRecord, boolean writeErrorTrace) {
        Optional<Object> recordObject;
        Struct metadataValue = new Struct(METADATA_SCHEMA);
        traceMetadata.sourcePartition().ifPresent(x -> metadataValue.put(SOURCE_PARTITION, x));
        traceMetadata.sourceOffset().ifPresent(x -> metadataValue.put(SOURCE_OFFSET, x));
        traceMetadata.type().ifPresent(x -> metadataValue.put(TYPE, x));
        traceMetadata.offset().ifPresent(x -> metadataValue.put(OFFSET, x));
        traceMetadata.topic().ifPresent(x -> metadataValue.put(TOPIC, x));
        metadataValue.put(CONNECTOR, (Object)this.context.connectorTaskId().connector());
        traceMetadata.kafkaPartition().ifPresent(x -> metadataValue.put(PARTITION, x));
        transformationName.ifPresent(name -> metadataValue.put(TRANSFORMATION_NAME, name));
        transformationType.ifPresent(type -> metadataValue.put(TRANSFORMATION_TYPE, type));
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(TRACE_SCHEMA_NAME).field(METADATA, METADATA_SCHEMA);
        Optional errorObject = error.flatMap(throwable -> Optional.of(this.createErrorObject(schemaBuilder, (Throwable)throwable, errorInfo, writeErrorTrace)));
        if (record.isPresent() || writeNullRecord) {
            Schema embeddedRecordSchema = record.map(r -> SchemaBuilder.struct().name(RECORD_SCHEMA_NAME).field(KEY, r.keySchema() != null ? r.keySchema() : Schema.OPTIONAL_STRING_SCHEMA).field(VALUE, r.valueSchema() != null ? r.valueSchema() : Schema.OPTIONAL_STRING_SCHEMA).field(HEADERS, SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build()).optional().build()).orElse(Schema.OPTIONAL_STRING_SCHEMA);
            schemaBuilder.field(RECORD, embeddedRecordSchema);
            Object finalValue = record.map(r -> {
                Struct embeddedRecordValue = new Struct(embeddedRecordSchema);
                embeddedRecordValue.put(KEY, this.actualOrNull(r.keySchema(), r.key()));
                embeddedRecordValue.put(VALUE, this.actualOrNull(r.valueSchema(), r.value()));
                embeddedRecordValue.put(HEADERS, this.convertHeaders(r.headers()));
                return embeddedRecordValue;
            }).orElse(null);
            recordObject = Optional.ofNullable(finalValue);
        } else {
            recordObject = Optional.empty();
        }
        Schema schema = schemaBuilder.build();
        Struct value = new Struct(schema);
        value.put(METADATA, (Object)metadataValue);
        errorObject.ifPresent(e -> value.put(ERROR, e));
        if (record.isPresent() || writeNullRecord) {
            value.put(RECORD, recordObject.orElse(null));
        }
        if (correlate) {
            this.correlateAndIncrementStep(metadataValue);
        }
        return new SchemaAndValue(schema, (Object)value);
    }

    private <R extends ConnectRecord<R>> SchemaAndValue createSchemaAndValue(TraceMetadata traceMetadata, Optional<R> transformedRecord, Optional<String> transformationName, Optional<String> transformationType, Optional<Throwable> error, Optional<Map<String, String>> errorInfo) {
        return this.createSchemaAndValue(traceMetadata, transformedRecord, transformationName, transformationType, error, errorInfo, true, false, true);
    }

    private Object convertHeaders(Headers headers) {
        if (headers == null) {
            return null;
        }
        return StreamSupport.stream(headers.spliterator(), false).collect(Collectors.toMap(Header::key, header -> header.value() != null ? header.value().toString() : null));
    }

    private void updateStepCountWithTotalSteps(TraceRecord record) {
        Struct metadataStruct = (Struct)((Struct)record.value()).get(METADATA);
        String correlationId = metadataStruct.getString(CORRELATION_ID);
        Integer totalStepCount = this.recordStepCount.get(correlationId);
        metadataStruct.put(TOTAL_STEP, (Object)totalStepCount);
    }

    private <R extends ConnectRecord<R>> TraceRecord dataExceptionRecord(R failedRecord, TraceMetadata metadata, DataException e, String additionalInfo) {
        try {
            ImmutableMap errorInfo = ImmutableMap.of((Object)ERROR_TYPE, (Object)DATA_ERROR, (Object)DATA_ERROR_INFO, (Object)additionalInfo, (Object)FAILED_RECORD, (Object)failedRecord.toString());
            return this.createTraceRecord(this.createSchemaAndValue(metadata, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(e), Optional.of(errorInfo), true, false, false));
        }
        catch (Exception exception) {
            throw new ConnectorTracingException("Failed to create trace record for a data exception, Context " + this.context, exception);
        }
    }

    @Override
    public <R extends ConnectRecord<R>> TraceRecordBuilder appendRecord(R record) {
        TraceMetadata traceMetadata = TraceMetadata.extractFromConnectRecord(record);
        try {
            Optional<R> optionalRecord = Optional.ofNullable(record);
            SchemaAndValue schemaAndValue = this.createSchemaAndValue(traceMetadata, optionalRecord, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            TraceRecord traceRecord = this.createTraceRecord(schemaAndValue);
            this.records.add(traceRecord);
            return this;
        }
        catch (Exception e) {
            if (e instanceof DataException) {
                this.records.add(this.dataExceptionRecord(record, traceMetadata, (DataException)e, "Invalid Record"));
            }
            throw new ConnectorTracingException("Failed to append connect record, Context" + this.context, e);
        }
    }

    @Override
    public <R extends ConnectRecord<R>> TraceRecordBuilder appendTransformedRecord(String transformationName, Class<?> transformationClass, R record, R previousRecord) {
        TraceMetadata traceMetadata = TraceMetadata.extractFromConnectRecord(record == null ? previousRecord : record);
        try {
            Optional<R> optionalRecord = Optional.ofNullable(record);
            SchemaAndValue schemaAndValue = this.createSchemaAndValue(traceMetadata, optionalRecord, Optional.of(transformationName), Optional.of(transformationClass.getName()), Optional.empty(), Optional.empty(), true, true, false);
            TraceRecord traceRecord = this.createTraceRecord(schemaAndValue);
            this.records.add(traceRecord);
            return this;
        }
        catch (Exception e) {
            if (e instanceof DataException) {
                this.records.add(this.dataExceptionRecord(record, traceMetadata, (DataException)e, "Invalid Transformed Record"));
            }
            throw new ConnectorTracingException("Failed to append transformed record for transformation " + transformationName + ", Context " + this.context, e);
        }
    }

    @Override
    public TraceRecordBuilder appendTransformationError(String transformationName, Class<?> transformationClass, Throwable error) {
        try {
            TraceMetadata traceMetadata = TraceMetadata.EMPTY;
            SchemaAndValue schemaAndValue = this.createSchemaAndValue(traceMetadata, Optional.empty(), Optional.of(transformationName), Optional.of(transformationClass.getName()), Optional.of(error), Optional.empty());
            TraceRecord traceRecord = this.createTraceRecord(schemaAndValue);
            this.records.add(traceRecord);
            return this;
        }
        catch (Exception e) {
            throw new ConnectorTracingException("Failed to append transformation error due to failed transformation " + transformationName + " caused by: " + error.getMessage() + ", Context " + this.context, e);
        }
    }

    @Override
    public TraceRecordBuilder appendSourceConversionError(Stage conversionType, SourceRecord sourceRecord, Throwable error) {
        try {
            TraceMetadata traceMetadata = TraceMetadata.extractFromConnectRecord((ConnectRecord)sourceRecord);
            ImmutableMap errorInfo = ImmutableMap.of((Object)ERROR_TYPE, (Object)CONVERSION_ERROR, (Object)CONVERSION_TYPE, (Object)conversionType.toString());
            SchemaAndValue schemaAndValue = this.createSchemaAndValue(traceMetadata, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(error), Optional.of(errorInfo));
            TraceRecord traceRecord = this.createTraceRecord(schemaAndValue);
            this.records.add(traceRecord);
            return this;
        }
        catch (Exception e) {
            throw new ConnectorTracingException("Failed to append source conversion error caused by " + error.getMessage() + ", Context" + this.context, e);
        }
    }

    public TraceRecordBuilder appendSinkConversionError(Stage conversionType, ConsumerRecord consumerRecord, Throwable error) {
        try {
            TraceMetadata traceMetadata = TraceMetadata.extractFromConsumerRecord(consumerRecord);
            ImmutableMap errorInfo = ImmutableMap.of((Object)ERROR_TYPE, (Object)CONVERSION_ERROR, (Object)CONVERSION_TYPE, (Object)conversionType.toString());
            SchemaAndValue schemaAndValue = this.createSchemaAndValue(traceMetadata, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(error), Optional.of(errorInfo));
            TraceRecord traceRecord = this.createTraceRecord(schemaAndValue);
            this.records.add(traceRecord);
            return this;
        }
        catch (Exception e) {
            throw new ConnectorTracingException("Failed to append sink conversion error  caused by: " + error.getMessage() + ", Context " + this.context, e);
        }
    }

    @Override
    public TraceRecord createSinkRecordError(SinkRecord sinkRecord, Throwable error) {
        TraceMetadata traceMetadata = TraceMetadata.extractFromConnectRecord((ConnectRecord)sinkRecord);
        try {
            ImmutableMap errorInfo = ImmutableMap.of((Object)ERROR_TYPE, (Object)SINK_RECORD_ERROR);
            SchemaAndValue schemaAndValue = this.createSchemaAndValue(traceMetadata, Optional.of(sinkRecord), Optional.empty(), Optional.empty(), Optional.of(error), Optional.of(errorInfo), false, true, true);
            return this.createTraceRecord(schemaAndValue);
        }
        catch (Exception e) {
            if (e instanceof DataException) {
                this.records.add(this.dataExceptionRecord(sinkRecord, traceMetadata, (DataException)e, "Invalid Sink Record"));
            }
            throw new ConnectorTracingException("Failed to create sink record error for record:  caused by " + error.getMessage() + ", Context" + this.context, e);
        }
    }

    @Override
    public TraceRecordBuilder appendError(String stage, Class<?> executingClass, Throwable error) {
        try {
            TraceMetadata traceMetadata = TraceMetadata.EMPTY;
            ImmutableMap errorInfo = ImmutableMap.of((Object)ERROR_TYPE, (Object)TASK_ERROR, (Object)EXECUTING_CLASS, (Object)executingClass.getName(), (Object)ERROR_STAGE, (Object)stage);
            SchemaAndValue schemaAndValue = this.createSchemaAndValue(traceMetadata, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(error), Optional.of(errorInfo));
            TraceRecord traceRecord = this.createTraceRecord(schemaAndValue);
            this.records.add(traceRecord);
            return this;
        }
        catch (Exception e) {
            throw new ConnectorTracingException("Failed to append error on stage: " + stage + " caused by: " + error.getMessage() + ", Context" + this.context, e);
        }
    }

    @Override
    public TraceRecord createTracingError(TraceRecord failedTraceRecord, Throwable error) {
        try {
            TraceMetadata traceMetadata = TraceMetadata.EMPTY;
            ImmutableMap errorInfo = ImmutableMap.of((Object)ERROR_TYPE, (Object)TRACING_ERROR, (Object)FAILED_RECORD, (Object)failedTraceRecord.toString());
            SchemaAndValue schemaAndValue = this.createSchemaAndValue(traceMetadata, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(error), Optional.of(errorInfo), false, false, false);
            return this.createTraceRecord(schemaAndValue);
        }
        catch (Exception e) {
            throw new ConnectorTracingException("Failed to create error for trace record:  caused by " + error.getMessage() + ", Context" + this.context, e);
        }
    }

    @Override
    public List<TraceRecord> build() {
        try {
            this.records.forEach(this::updateStepCountWithTotalSteps);
            return this.records;
        }
        catch (Exception e) {
            throw new ConnectorTracingException("Failed to build list of trace record, Context " + this.context, e);
        }
    }

    private <R extends ConnectRecord<R>> TraceRecord createTraceRecord(SchemaAndValue schemaAndValue) {
        return new TraceRecord(this.tracerConfig.traceTopic(), null, Schema.STRING_SCHEMA, this.context.connectorTaskId().toString(), schemaAndValue.schema(), schemaAndValue.value(), null, null);
    }

    static {
        SchemaBuilder errorSchemaBuilder = SchemaBuilder.struct().optional().name(TRACE_ERROR_SCHEMA_NAME).field(ERROR_MESSAGE, Schema.STRING_SCHEMA).field(ADDITIONAL_ERROR_INFO, (Schema)SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).optional());
        ERROR_SCHEMA = errorSchemaBuilder.build();
        ERROR_SCHEMA_WITH_TRACE = errorSchemaBuilder.field(ERROR_TRACE, Schema.STRING_SCHEMA).build();
    }

    private static class TraceMetadata {
        private final Optional<Map<String, String>> sourcePartition;
        private final Optional<Map<String, String>> sourceOffset;
        private final Optional<String> type;
        private final Optional<Long> offset;
        private final Optional<String> topic;
        private final Optional<Integer> kafkaPartition;
        private final Optional<Long> timestamp;
        private static final TraceMetadata EMPTY = new TraceMetadata(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());

        private TraceMetadata(Optional<Map<String, String>> sourcePartition, Optional<Map<String, String>> sourceOffset, Optional<String> type, Optional<Long> offset, Optional<String> topic, Optional<Integer> kafkaPartition, Optional<Long> timestamp) {
            this.sourcePartition = sourcePartition;
            this.sourceOffset = sourceOffset;
            this.type = type;
            this.offset = offset;
            this.topic = topic;
            this.kafkaPartition = kafkaPartition;
            this.timestamp = timestamp;
        }

        public static TraceMetadata extractFromConnectRecord(ConnectRecord connectRecord) {
            if (connectRecord == null) {
                return EMPTY;
            }
            Optional<Map<String, String>> sourcePartition = Optional.empty();
            Optional<Map<String, String>> sourceOffset = Optional.empty();
            Optional<String> type = Optional.empty();
            Optional<Long> offset = Optional.empty();
            if (connectRecord instanceof SourceRecord) {
                sourcePartition = Optional.ofNullable(TraceRecordBuilderImpl.stringMap(((SourceRecord)connectRecord).sourcePartition()));
                sourceOffset = Optional.ofNullable(TraceRecordBuilderImpl.stringMap(((SourceRecord)connectRecord).sourceOffset()));
                type = Optional.of(TraceRecordBuilderImpl.SOURCE_TYPE);
            } else if (connectRecord instanceof SinkRecord) {
                offset = Optional.of(((SinkRecord)connectRecord).kafkaOffset());
                type = Optional.of(TraceRecordBuilderImpl.SINK_TYPE);
            }
            return new TraceMetadata(sourcePartition, sourceOffset, type, offset, Optional.ofNullable(connectRecord.topic()), Optional.ofNullable(connectRecord.kafkaPartition()), Optional.ofNullable(connectRecord.timestamp()));
        }

        public static TraceMetadata extractFromConsumerRecord(ConsumerRecord<?, ?> consumerRecord) {
            if (consumerRecord == null) {
                return EMPTY;
            }
            return new TraceMetadata(Optional.empty(), Optional.empty(), Optional.of(TraceRecordBuilderImpl.SINK_TYPE), Optional.of(consumerRecord.offset()), Optional.of(consumerRecord.topic()), Optional.of(consumerRecord.partition()), Optional.of(consumerRecord.timestamp()));
        }

        public Optional<Integer> kafkaPartition() {
            return this.kafkaPartition;
        }

        public Optional<String> topic() {
            return this.topic;
        }

        public Optional<Long> offset() {
            return this.offset;
        }

        public Optional<String> type() {
            return this.type;
        }

        public Optional<Map<String, String>> sourceOffset() {
            return this.sourceOffset;
        }

        public Optional<Map<String, String>> sourcePartition() {
            return this.sourcePartition;
        }

        public Optional<Long> timestamp() {
            return this.timestamp;
        }
    }
}

