/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link.integration;

import io.confluent.kafka.link.integration.ClusterLinkTestUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.link.ClusterLinkControlPlaneLinkResourceIntegrationTest;
import kafka.server.link.ClusterLinkConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Option;
import scala.collection.Map;
import scala.collection.Seq;

@Tag(value="integration")
public class ClusterLinkPrefixControlPlaneLinkResourceIntegrationTest
extends ClusterLinkControlPlaneLinkResourceIntegrationTest {
    public ClusterLinkPrefixControlPlaneLinkResourceIntegrationTest() {
        this.clusterLinkPrefix_$eq("src_");
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testCreateAndDeleteAndRecreateLink(String quorum, boolean coordinator) {
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDeleteClusterLinkCleanup(String quorum, boolean useLinkCoordinator) {
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testInvalidClusterLinkPrefixActions(String quorum, boolean coordinator) {
        String clusterLinkPrefixTwo = "src_2_";
        Properties linkProps = this.destLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()));
        linkProps.setProperty(ClusterLinkConfig.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        linkProps.setProperty(ClusterLinkConfig.ConsumerGroupPrefixEnableProp(), "false");
        this.createClusterLink(this.linkName(), linkProps, this.sourceLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap())), false, true);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.destCluster().linkTopic(this.topic(), this.topic(), this.replicationFactor(), this.linkName(), ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()), Option.empty()), (String)("Mirror topic name should start with cluster link prefix " + this.clusterLinkPrefix()));
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.destCluster().linkTopic(this.clusterLinkPrefix() + this.topic().substring(1), this.topic(), this.replicationFactor(), this.linkName(), ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()), Option.empty()), (String)"Topic renaming for mirroring not yet supported.");
        HashMap<String, String> updatedConfigs = new HashMap<String, String>();
        updatedConfigs.put(ClusterLinkConfig.ClusterLinkPrefixProp(), clusterLinkPrefixTwo);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.destCluster().alterClusterLink(this.linkName(), ClusterLinkTestUtils.convertMapToScalaMap(Collections.singletonMap(ClusterLinkConfig.ClusterLinkPrefixProp(), clusterLinkPrefixTwo)), (Seq)this.destCluster().brokers().toSeq(), ClusterLinkTestUtils.convertSetToScalaSet(Collections.EMPTY_SET), true));
        HashMap<String, String> updatedConfigsTwo = new HashMap<String, String>();
        updatedConfigsTwo.put(ClusterLinkConfig.ConsumerGroupPrefixEnableProp(), "true");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.destCluster().alterClusterLink(this.linkName(), ClusterLinkTestUtils.convertMapToScalaMap(updatedConfigsTwo), (Seq)this.destCluster().brokers().toSeq(), ClusterLinkTestUtils.convertSetToScalaSet(Collections.EMPTY_SET), true));
        String linkNameTwo = this.linkName() + "-2";
        Properties linkPropsTwo = this.destLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()));
        linkPropsTwo.setProperty(ClusterLinkConfig.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkNameTwo, linkPropsTwo, this.sourceLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap())), false, true));
        linkPropsTwo.setProperty(ClusterLinkConfig.ClusterLinkPrefixProp(), "1243.ABCD-876");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkNameTwo, linkPropsTwo, this.sourceLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap())), false, true));
        linkPropsTwo.setProperty(ClusterLinkConfig.ClusterLinkPrefixProp(), clusterLinkPrefixTwo);
        this.createClusterLink(linkNameTwo, linkPropsTwo, this.sourceLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap())), false, true);
        this.verifyLinkWithClusterLinkPrefixCountMetric(2, this.linkName(), Option.apply((Object)linkNameTwo));
        this.destCluster().deleteClusterLink(this.linkName(), false, (Seq)this.destCluster().brokers().toSeq());
        this.destCluster().deleteClusterLink(linkNameTwo, false, (Seq)this.destCluster().brokers().toSeq());
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testMirroringAfterIdleClientsClosed(String quorum, boolean useLinkCoordinator) {
    }
}

