/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.authorizer;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.authorizer.TenantAclProvider;
import io.confluent.kafka.security.authorizer.acl.AclMapper;
import io.confluent.kafka.security.authorizer.acl.ExtendedAccessRuleProvider;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.AclAccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.PermissionType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TenantAclProviderTest {
    TenantAclProviderTest() {
    }

    @Test
    public void testStandardAuthorizerInitialization() {
        TenantAclProvider provider = new TenantAclProvider();
        provider.configure(this.sampleKRaftBrokerConfig());
        Assertions.assertTrue((boolean)provider.asAuthorizer().isPresent());
    }

    @Test
    public void testMatchTenantWildcardPrincipal() {
        ExtendedAccessRuleProvider underlyingProvider = (ExtendedAccessRuleProvider)Mockito.mock(ExtendedAccessRuleProvider.class);
        TenantAclProvider tenantAclProvider = new TenantAclProvider(underlyingProvider);
        tenantAclProvider.configure(this.sampleKRaftBrokerConfig());
        String logicalClusterId = "lkc-12345";
        String username = "foo";
        String host = "127.0.0.1";
        ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, "bar", PatternType.LITERAL);
        TenantMetadata tenantMetadata = new TenantMetadata.Builder(logicalClusterId, "u-15").build();
        MultiTenantPrincipal tenantPrincipal = new MultiTenantPrincipal(username, tenantMetadata);
        KafkaPrincipal wildcardTenantPrincipal = new KafkaPrincipal("TenantUser*", logicalClusterId + "_");
        KafkaPrincipal userResourceIdTenantPrincipal = new KafkaPrincipal("TenantUser", logicalClusterId + "_u-15");
        Action action = new Action(Scope.ROOT_SCOPE, AclMapper.resourceType((ResourceType)topicResource.resourceType()), topicResource.name(), AclMapper.operation((AclOperation)AclOperation.READ));
        AccessControlEntry accessControlEntry = new AccessControlEntry(wildcardTenantPrincipal.toString(), "*", AclOperation.READ, AclPermissionType.DENY);
        AuthorizeRule expected = new AuthorizeRule();
        expected.addRuleIfNotExist((AccessRule)new AclAccessRule(AclMapper.resourcePattern((ResourcePattern)topicResource), (KafkaPrincipal)tenantPrincipal, PermissionType.DENY, host, AclMapper.operation((AclOperation)AclOperation.READ), AuthorizePolicy.PolicyType.DENY_ACL, new AclBinding(topicResource, accessControlEntry)));
        Mockito.when((Object)underlyingProvider.findRule(Utils.mkSet((Object[])new KafkaPrincipal[]{AccessRule.asBaseKafkaPrincipal((KafkaPrincipal)tenantPrincipal), userResourceIdTenantPrincipal, wildcardTenantPrincipal}), host, action)).thenReturn((Object)expected);
        AuthorizeRule actual = tenantAclProvider.findRule((KafkaPrincipal)tenantPrincipal, Collections.emptySet(), host, action);
        Assertions.assertSame((Object)expected, (Object)actual);
    }

    private Map<String, Object> sampleKRaftBrokerConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(KafkaConfig.ControllerListenerNamesProp(), "CONTROLLER");
        configs.put(KafkaConfig.ProcessRolesProp(), "broker");
        configs.put(KafkaConfig.QuorumVotersProp(), "10@localhost:8092");
        configs.put(KafkaConfig.NodeIdProp(), "0");
        configs.put(KafkaConfig.ListenersProp(), "PLAINTEXT://localhost:9092");
        configs.put(KafkaConfig.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        configs.put("confluent.multitenant.listener.names", "EXTERNAL");
        configs.put("confluent.authorizer.access.rule.providers", ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name());
        return configs;
    }
}

