/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.BasePhysicalClusterMetadata;
import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.TopicBasedPhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig$;
import kafka.test.JarResourceLoader;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;

@Tag(value="integration")
public abstract class AbstractTopicBasedPlainSaslAuthIntegrationTest {
    protected final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    protected final String serviceUserAPIkey = "APIKEY1";
    protected final String serviceUserAPIkeyPassword = "pwd1";
    protected IntegrationTestHarness testHarness;
    protected PhysicalCluster physicalCluster;
    protected int numBrokers = 3;
    protected final String apiKeysTopic = "_confluent-apikey";
    protected final String lkcMetadataTopic = "_confluent-logical_clusters";
    protected final String testTopic = "abcd";
    protected List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));
    protected long baseSequenceId = 1000L;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testHarness = new IntegrationTestHarness(testInfo, this.numBrokers);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
    }

    protected void startWithTopic() throws Exception {
        this.startWithTopic(Optional.empty());
    }

    protected void startWithTopic(Optional<Time> time) throws Exception {
        long topicCreateTimeout = 15000L;
        long topicLoadTimeoutMs = topicCreateTimeout + TimeUnit.SECONDS.toMillis(3L);
        this.physicalCluster = this.testHarness.startWithTopic(this.getInitialTopics(), 1, 1, topicCreateTimeout, this.brokerProps(topicLoadTimeoutMs, true), this.nodeProps(topicLoadTimeoutMs), time);
        int serviceUserId = 1;
        LogicalCluster logicalCluster = this.physicalCluster.createLogicalCluster(this.logicalClusterId, 100, serviceUserId);
        LogicalClusterUser serviceUser = logicalCluster.user(serviceUserId);
        this.testHarness.newAclCommand().addTopicAclArgs(serviceUser.prefixedKafkaPrincipal(), serviceUser.withPrefix("abcd"), AclOperation.ALL, PatternType.LITERAL).execute();
    }

    protected List<String> getInitialTopics() {
        return Arrays.asList("_confluent-apikey", "_confluent-logical_clusters");
    }

    protected Properties brokerProps(long topicLoadTimeoutMs, boolean enableLKCMetadata) throws IOException, InterruptedException {
        Properties props = new Properties();
        props.put("listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("advertised.listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT, EXTERNAL:SASL_PLAINTEXT");
        props.put("inter.broker.listener.name", "INTERNAL");
        props.putAll((Map<?, ?>)this.nodeProps(topicLoadTimeoutMs));
        if (enableLKCMetadata) {
            this.setupClusterMetadata(props);
        }
        return props;
    }

    protected Properties nodeProps(long topicLoadTimeoutMs) throws IOException {
        Properties props = new Properties();
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", "true");
        props.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule required;");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        props.put("confluent.cdc.api.keys.topic", "_confluent-apikey");
        props.put("confluent.cdc.api.keys.topic.load.timeout.ms", String.valueOf(topicLoadTimeoutMs));
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.close.connections.on.credential.delete", "true");
        props.put("sasl.server.max.receive.size", "1024");
        return props;
    }

    private void setupClusterMetadata(Properties brokerProps) {
        brokerProps.put("confluent.cdc.lkc.metadata.topic", "_confluent-logical_clusters");
        brokerProps.put("confluent.cdc.api.keys.topic.load.timeout.ms", (Object)(15000L + TimeUnit.SECONDS.toMillis(3L)));
        brokerProps.put("multitenant.metadata.class", TopicBasedPhysicalClusterMetadata.class.getName());
    }

    protected void loadApiKeys() throws Exception {
        BufferedInputStream path;
        try {
            path = (BufferedInputStream)JarResourceLoader.loadFileFromResource(FileBasedPlainSaslAuthenticatorTest.class, (String)"/file_auth_test_apikeys.json").toURI().toURL().getContent();
        }
        catch (IOException e) {
            throw new Exception("Couldn't read apikeys content");
        }
        String apiKeys = org.apache.kafka.common.utils.Utils.readFullyToString((InputStream)path);
        this.physicalCluster.kafkaCluster().produceApiKeysData("_confluent-apikey", "APIKEY1", apiKeys, true);
    }

    protected void loadLKCMetadata() throws InterruptedException {
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkcId = Utils.LC_META_ABC.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", this.baseSequenceId + 1L, lkcId, Utils.LC_META_ABC);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkcId) != null), (String)"Expected metadata to get consumed");
    }

    protected ConfluentAuthenticationEvent getLastAuthenticationEvent() throws Exception {
        TestUtils.waitForCondition(() -> this.getLastAuthenticationEventOrNull() != null, (String)"Couldn't find the last authentication event");
        return this.getLastAuthenticationEventOrNull();
    }

    private ConfluentAuthenticationEvent getLastAuthenticationEventOrNull() {
        for (int i = 0; i < this.numBrokers; ++i) {
            String brokerUuid = this.getBrokerSessionUuid(i);
            MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(brokerUuid);
            try {
                ConfluentAuthenticationEvent event = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
                if (event == null) continue;
                return event;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String getBrokerSessionUuid(int i) {
        return this.physicalCluster.kafkaCluster().kafkaBrokers().get(i).config().brokerSessionUuid();
    }

    protected void resetAuditEvents() {
        for (int i = 0; i < this.numBrokers; ++i) {
            String brokerUuid = this.getBrokerSessionUuid(i);
            MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(brokerUuid);
            auditLogProvider.resetEvents();
        }
    }
}

