/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class DisableIntegerIdAuthorizationIntegrationTest {
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private final String adminUserAPIkey = "APIKEY1";
    private final String adminUserAPIkeyPassword = "pwd1";
    private final String serviceUserAPIkey2 = "APIKEY2";
    private final String serviceUserAPIkeyPassword2 = "pwd2";
    private IntegrationTestHarness testHarness;
    private PhysicalCluster physicalCluster;
    private final String apiKeysTopic = "_confluent-apikey";

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        int numBrokers = 3;
        this.testHarness = new IntegrationTestHarness(testInfo, numBrokers);
        long topicCreateTimeout = 15000L;
        long topicLoadTimeoutMs = topicCreateTimeout + TimeUnit.SECONDS.toMillis(3L);
        this.physicalCluster = this.testHarness.startWithTopic(Arrays.asList("_confluent-apikey"), 1, 1, topicCreateTimeout, this.brokerProps(topicLoadTimeoutMs, "0"), this.controllerProps(topicLoadTimeoutMs, "0"), Optional.empty());
        int adminUserId = 1;
        int serviceUserId = 2;
        this.physicalCluster.createLogicalCluster(this.logicalClusterId, 100, adminUserId, serviceUserId);
        this.loadApiKeys(this.physicalCluster, "/file_auth_test_apikeys.json", "APIKEY1");
        this.loadApiKeys(this.physicalCluster, "/service_account_apikey_2.json", "APIKEY2");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.physicalCluster.shutdown();
        TestUtils.verifyNoUnexpectedThreads();
    }

    private Properties brokerProps(long topicLoadTimeoutMs, String brokerId) throws IOException {
        Properties props = new Properties();
        props.put("listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("advertised.listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT, EXTERNAL:SASL_PLAINTEXT");
        props.put("broker.id", brokerId);
        props.putAll((Map<?, ?>)this.commonProps(topicLoadTimeoutMs));
        return props;
    }

    private Properties controllerProps(long topicLoadTimeoutMs, String nodeId) throws IOException {
        Properties props = new Properties();
        props.put("node.id", nodeId);
        props.putAll((Map<?, ?>)this.commonProps(topicLoadTimeoutMs));
        return props;
    }

    private Properties commonProps(long topicLoadTimeoutMs) throws IOException {
        Properties props = new Properties();
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", "true");
        props.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule required;");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        props.put("confluent.cdc.api.keys.topic", "_confluent-apikey");
        props.put("confluent.cdc.api.keys.topic.load.timeout.ms", String.valueOf(topicLoadTimeoutMs));
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.close.connections.on.credential.delete", "true");
        return props;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUserV2AclFilter(String quorum) throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            AclBinding acl1 = this.topicAcl("u-2", "topic1");
            AclBinding acl2 = this.topicAcl("3", "topic1");
            AclBinding acl3 = this.topicAcl("u-3", "topic1");
            adminClient.createAcls(Arrays.asList(acl1, acl2, acl3)).all().get();
            try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));){
                TestUtils.retryOnExceptionWithTimeout(() -> {
                    Void cfr_ignored_0 = (Void)client.createTopics(this.topicsList("topic1")).all().get();
                });
                List expectedTopics = this.topicsList("topic1").stream().map(NewTopic::name).collect(Collectors.toList());
                TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
            }
            Collection result = (Collection)adminClient.describeAcls(this.filter("*", "UserV2")).values().get();
            Assertions.assertTrue((boolean)result.containsAll(Arrays.asList(acl1, acl2, acl3)));
            result = (Collection)adminClient.describeAcls(AclBindingFilter.ANY).values().get();
            Assertions.assertTrue((boolean)result.containsAll(Arrays.asList(acl1, acl2, acl3)));
            result = (Collection)adminClient.deleteAcls(Arrays.asList(this.filter("*", "UserV2"))).all().get();
            Assertions.assertTrue((boolean)result.containsAll(Arrays.asList(acl1, acl2, acl3)));
        }
    }

    private List<NewTopic> topicsList(String topicName) {
        return Collections.singletonList(new NewTopic(topicName, 3, 1));
    }

    private AclBindingFilter filter(String principalName, String principalType) {
        return new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(new KafkaPrincipal(principalType, principalName).toString(), null, AclOperation.ANY, AclPermissionType.ANY));
    }

    private AclBinding topicAcl(String principalName, String topicName) {
        return new AclBinding(new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.LITERAL), new AccessControlEntry(new KafkaPrincipal("User", principalName).toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW));
    }

    private void loadApiKeys(PhysicalCluster cluster, String fileName, String apiKey) throws Exception {
        BufferedInputStream path;
        try {
            path = new BufferedInputStream(FileBasedPlainSaslAuthenticatorTest.class.getResourceAsStream(fileName));
        }
        catch (Exception e) {
            throw new Exception("Couldn't read apikeys content");
        }
        String apiKeys = org.apache.kafka.common.utils.Utils.readFullyToString((InputStream)path);
        cluster.kafkaCluster().produceApiKeysData("_confluent-apikey", apiKey, apiKeys, true);
    }
}

