/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.quota.TenantQuotaCallback;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthBearerServerLoginCallbackHandler;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthBearerValidatorCallbackHandler;
import io.confluent.kafka.test.utils.AclCommandBuilder;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import kafka.admin.RackAwareMode;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.TestInfo;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class IntegrationTestHarness {
    private static final int DEFAULT_BROKERS_IN_PHYSICAL_CLUSTER = 1;
    private PhysicalCluster physicalCluster;
    private final TestInfo testInfo;
    private final List<KafkaProducer<?, ?>> producers = new ArrayList();
    private final List<KafkaConsumer<?, ?>> consumers = new ArrayList();
    private final List<AdminClient> adminClients = new ArrayList<AdminClient>();
    private final int brokersInPhysicalCluster;
    private final List<String> brokerRacks;
    private final List<String> brokerCells;

    public IntegrationTestHarness(TestInfo testInfo) {
        this(testInfo, 1);
    }

    public IntegrationTestHarness(TestInfo testInfo, int brokersInPhysicalCluster) {
        this(testInfo, brokersInPhysicalCluster, Collections.emptyList());
    }

    public IntegrationTestHarness(TestInfo testInfo, int brokersInPhysicalCluster, List<String> brokerRacks) {
        this(testInfo, brokersInPhysicalCluster, brokerRacks, Collections.emptyList());
    }

    public IntegrationTestHarness(TestInfo testInfo, int brokersInPhysicalCluster, List<String> brokerRacks, List<String> brokerCells) {
        this.testInfo = testInfo;
        if (!brokerRacks.isEmpty() && brokerRacks.size() != brokersInPhysicalCluster) {
            throw new IllegalArgumentException("Broker racks should be empty or should be same as number of brokers.");
        }
        if (!brokerCells.isEmpty() && brokerCells.size() != brokersInPhysicalCluster) {
            throw new IllegalArgumentException("Broker cells should be empty or should be same as number of brokers.");
        }
        this.brokersInPhysicalCluster = brokersInPhysicalCluster;
        this.brokerRacks = brokerRacks;
        this.brokerCells = brokerCells;
    }

    public PhysicalCluster start(Properties brokerOverrides) {
        return this.start(brokerOverrides, true, Optional.empty(), cluster -> {});
    }

    public PhysicalCluster start(Properties brokerOverrides, Properties controllerOverrides) {
        return this.start(brokerOverrides, controllerOverrides, true, Optional.empty(), cluster -> {});
    }

    public PhysicalCluster start(Properties brokerOverrides, Time time) {
        return this.start(brokerOverrides, true, Optional.of(time), cluster -> {});
    }

    public PhysicalCluster start(Properties brokerOverrides, boolean isBrokerSuperUser, Optional<Time> time, Consumer<PhysicalCluster> preStartCallback) {
        return this.start(brokerOverrides, new Properties(), isBrokerSuperUser, time, preStartCallback);
    }

    public PhysicalCluster start(Properties brokerOverrides, Properties controllerOverrides, boolean isBrokerSuperUser, Set<String> additionalSuperUsers, Optional<Time> time, Consumer<PhysicalCluster> preStartCallback) {
        this.physicalCluster = this.createCluster(time);
        if (!isBrokerSuperUser) {
            this.physicalCluster.disableBrokerSuperUser();
        }
        this.physicalCluster.startQuorum(controllerOverrides, additionalSuperUsers);
        preStartCallback.accept(this.physicalCluster);
        this.physicalCluster.startBrokers(brokerOverrides, additionalSuperUsers);
        this.physicalCluster.kafkaCluster().waitForQuorumStart();
        return this.physicalCluster;
    }

    public PhysicalCluster start(Properties brokerOverrides, Properties controllerOverrides, boolean isBrokerSuperUser, Optional<Time> time, Consumer<PhysicalCluster> preStartCallback) {
        return this.start(brokerOverrides, controllerOverrides, isBrokerSuperUser, Collections.emptySet(), time, preStartCallback);
    }

    public PhysicalCluster startWithTopic(String topicName, int partitions, int replicationFactor, long topicCreateTimeoutMs, Properties brokerOverrides, Properties controllerOverrides) throws ExecutionException, InterruptedException {
        return this.startWithTopic(topicName, partitions, replicationFactor, topicCreateTimeoutMs, brokerOverrides, controllerOverrides, Optional.empty());
    }

    public PhysicalCluster startWithTopic(String topicName, int partitions, int replicationFactor, long topicCreateTimeoutMs, Properties brokerOverrides, Properties controllerOverrides, Optional<Time> time) throws ExecutionException, InterruptedException {
        return this.startWithTopic(Collections.singletonList(topicName), partitions, replicationFactor, topicCreateTimeoutMs, brokerOverrides, controllerOverrides, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhysicalCluster startWithTopic(Collection<String> topics, int partitions, int replicationFactor, long topicCreateTimeoutMs, Properties brokerOverrides, Properties controllerOverrides, Optional<Time> time) throws ExecutionException, InterruptedException {
        this.physicalCluster = this.createCluster(time);
        this.physicalCluster.startQuorum(controllerOverrides);
        ExecutorService executorService = Executors.newFixedThreadPool(topics.size());
        try {
            ArrayList futures = new ArrayList(topics.size());
            for (String string : topics) {
                Future<?> fut = executorService.submit(() -> this.tryCreateEarlyTopic(topicName, partitions, replicationFactor, topicCreateTimeoutMs));
                futures.add(fut);
            }
            this.physicalCluster.startBrokers(brokerOverrides);
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executorService.shutdown();
        }
        this.physicalCluster.kafkaCluster().waitForQuorumStart();
        return this.physicalCluster;
    }

    public void shutdownBrokers() {
        if (this.physicalCluster != null) {
            this.physicalCluster.kafkaCluster().shutdownBrokers();
        }
    }

    public void startBrokers(Properties nodeProps, Properties controllerProps) {
        if (this.physicalCluster != null) {
            this.physicalCluster.startQuorum(controllerProps);
            this.physicalCluster.startBrokers(nodeProps);
            this.physicalCluster.kafkaCluster().waitForQuorumStart();
        }
    }

    public void shutdown() {
        this.producers.forEach(KafkaProducer::close);
        this.consumers.forEach(KafkaConsumer::close);
        this.adminClients.forEach(Admin::close);
        if (this.physicalCluster != null) {
            this.physicalCluster.shutdown();
        }
    }

    public boolean isKraft() {
        return this.physicalCluster.isKRaft();
    }

    public String zkConnect() {
        return this.physicalCluster.kafkaCluster().zkConnect();
    }

    public KafkaProducer<String, String> createProducer(LogicalClusterUser user, SecurityProtocol securityProtocol) {
        return this.createProducer(user, securityProtocol, Optional.empty());
    }

    public KafkaProducer<String, String> createProducer(LogicalClusterUser user, SecurityProtocol securityProtocol, Properties properties) {
        return this.createProducer(user, securityProtocol, Optional.empty(), properties);
    }

    public KafkaProducer<String, String> createProducer(LogicalClusterUser user, SecurityProtocol securityProtocol, Optional<String> listener) {
        return this.createProducer(user, securityProtocol, listener, new Properties());
    }

    public KafkaProducer<String, String> createProducer(LogicalClusterUser user, SecurityProtocol securityProtocol, Optional<String> listener, Properties properties) {
        String bootstrapServers = listener.isPresent() ? this.physicalCluster.bootstrapServers(listener.get()) : this.physicalCluster.bootstrapServers();
        KafkaProducer<String, String> producer = KafkaTestUtils.createProducer(bootstrapServers, securityProtocol, ScramMechanism.SCRAM_SHA_256.mechanismName(), user.saslJaasConfig(), properties);
        this.producers.add(producer);
        return producer;
    }

    public KafkaConsumer<String, String> createConsumer(LogicalClusterUser user, String consumerGroup, SecurityProtocol securityProtocol) {
        return this.createConsumer(user, consumerGroup, securityProtocol, Optional.empty(), new Properties());
    }

    public KafkaConsumer<String, String> createConsumer(LogicalClusterUser user, String consumerGroup, SecurityProtocol securityProtocol, Optional<String> listener, Properties additionalProps) {
        String bootstrapServers = listener.isPresent() ? this.physicalCluster.bootstrapServers(listener.get()) : this.physicalCluster.bootstrapServers();
        KafkaConsumer<String, String> consumer = KafkaTestUtils.createConsumer(bootstrapServers, securityProtocol, ScramMechanism.SCRAM_SHA_256.mechanismName(), user.saslJaasConfig(), consumerGroup, additionalProps);
        this.consumers.add(consumer);
        return consumer;
    }

    public AdminClient createAdminClient(LogicalClusterUser user) {
        AdminClient adminClient = KafkaTestUtils.createAdminClient(this.physicalCluster.bootstrapServers(), SecurityProtocol.SASL_PLAINTEXT, ScramMechanism.SCRAM_SHA_256.mechanismName(), user.saslJaasConfig());
        this.adminClients.add(adminClient);
        return adminClient;
    }

    public AdminClient createAdminClient(LogicalClusterUser user, String listener) {
        AdminClient adminClient = KafkaTestUtils.createAdminClient(this.physicalCluster.bootstrapServers(listener), SecurityProtocol.SASL_PLAINTEXT, ScramMechanism.SCRAM_SHA_256.mechanismName(), user.saslJaasConfig());
        this.adminClients.add(adminClient);
        return adminClient;
    }

    public AdminClient createAdminClient(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig, Properties clientProps) {
        AdminClient adminClient = KafkaTestUtils.createAdminClient(bootstrapServers, securityProtocol, saslMechanism, jaasConfig, clientProps);
        this.adminClients.add(adminClient);
        return adminClient;
    }

    public AdminClient createOAuthAdminClient(String jaasConfig, Properties properties) {
        return this.createOAuthAdminClient(jaasConfig, properties, null, null);
    }

    public AdminClient createOAuthAdminClient(String jaasConfig, Properties properties, RequestCallback requestCallback, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        AdminClient adminClient = KafkaTestUtils.createAdminClient(this.physicalCluster.bootstrapServers(), SecurityProtocol.SASL_PLAINTEXT, "OAUTHBEARER", jaasConfig, properties, requestCallback, proxyProtocolEngineFactory);
        this.adminClients.add(adminClient);
        return adminClient;
    }

    public KafkaProducer<String, String> createOAuthProducer(String jaasConfig, Properties properties) {
        KafkaProducer<String, String> producer = KafkaTestUtils.createProducer(this.physicalCluster.bootstrapServers(), SecurityProtocol.SASL_PLAINTEXT, "OAUTHBEARER", jaasConfig, properties);
        this.producers.add(producer);
        return producer;
    }

    public KafkaConsumer<String, String> createOAuthConsumer(String consumerGroup, String jaasConfig, Properties properties) {
        KafkaConsumer<String, String> consumer = KafkaTestUtils.createConsumer(this.physicalCluster.bootstrapServers(), SecurityProtocol.SASL_PLAINTEXT, "OAUTHBEARER", jaasConfig, consumerGroup, properties);
        this.consumers.add(consumer);
        return consumer;
    }

    public AdminClient createSSLOAuthAdminClient(String jaasConfig, Properties properties, Map<String, Object> certStore, String sslEngineFactoryPath) {
        if (certStore != null) {
            properties.putAll(certStore);
        }
        if (sslEngineFactoryPath != null) {
            properties.put("ssl.engine.factory.class", sslEngineFactoryPath);
        }
        AdminClient adminClient = KafkaTestUtils.createAdminClient(this.physicalCluster.bootstrapServers("EXTERNAL"), SecurityProtocol.SASL_SSL, "OAUTHBEARER", jaasConfig, properties);
        this.adminClients.add(adminClient);
        return adminClient;
    }

    public AdminClient createPlainAuthAdminClient(String jaasConfig) {
        return this.createPlainAuthAdminClient(jaasConfig, new Properties(), null, null);
    }

    public AdminClient createPlainAuthAdminClient(String jaasConfig, Properties props, RequestCallback requestCallback, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        AdminClient adminClient = KafkaTestUtils.createAdminClient(this.physicalCluster.bootstrapServers(), SecurityProtocol.SASL_PLAINTEXT, "PLAIN", jaasConfig, props, requestCallback, proxyProtocolEngineFactory);
        this.adminClients.add(adminClient);
        return adminClient;
    }

    public AdminClient createSSLAuthAdminClient(String jaasConfig, Map<String, Object> certStore) {
        return this.createSSLAuthAdminClient(jaasConfig, certStore, null, null, new Properties());
    }

    public AdminClient createSSLAuthAdminClient(String jaasConfig, Map<String, Object> certStore, Properties props) {
        return this.createSSLAuthAdminClient(jaasConfig, certStore, null, null, props);
    }

    public AdminClient createSSLAuthAdminClient(String jaasConfig, Map<String, Object> certStore, String sslEngineFactoryPath) {
        return this.createSSLAuthAdminClient(jaasConfig, certStore, sslEngineFactoryPath, null, new Properties());
    }

    public AdminClient createSSLAuthAdminClient(String jaasConfig, Map<String, Object> certStore, String sslEngineFactoryPath, Class<? extends HostResolver> hostResolverClass) {
        return this.createSSLAuthAdminClient(jaasConfig, certStore, sslEngineFactoryPath, hostResolverClass, new Properties());
    }

    public AdminClient createSSLAuthAdminClient(String jaasConfig, Map<String, Object> certStore, String sslEngineFactoryPath, Class<? extends HostResolver> hostResolverClass, Properties props) {
        props.put("ssl.truststore.location", certStore.get("ssl.truststore.location"));
        props.put("ssl.truststore.password", ((Password)certStore.get("ssl.truststore.password")).value());
        props.put("security.protocol", "SSL");
        if (sslEngineFactoryPath != null) {
            props.put("ssl.engine.factory.class", sslEngineFactoryPath);
        }
        if (hostResolverClass != null) {
            props.put("host.resolver.class", hostResolverClass.getName());
        }
        AdminClient adminClient = KafkaTestUtils.createAdminClient(this.physicalCluster.bootstrapServers("EXTERNAL"), SecurityProtocol.SASL_SSL, "PLAIN", jaasConfig, props);
        this.adminClients.add(adminClient);
        return adminClient;
    }

    public void produceConsume(LogicalClusterUser producerUser, LogicalClusterUser consumerUser, String topic, String consumerGroup, int firstMessageIndex, SecurityProtocol securityProtocol) throws Throwable {
        this.produceConsume(producerUser, consumerUser, Arrays.asList(topic), consumerGroup, firstMessageIndex, securityProtocol, true);
    }

    public void produceConsume(LogicalClusterUser producerUser, LogicalClusterUser consumerUser, List<String> topics, String consumerGroup, int firstMessageIndex, SecurityProtocol securityProtocol) throws Throwable {
        this.produceConsume(producerUser, consumerUser, topics, consumerGroup, firstMessageIndex, securityProtocol, true);
    }

    public void produceConsume(LogicalClusterUser producerUser, LogicalClusterUser consumerUser, List<String> topics, String consumerGroup, int firstMessageIndex, SecurityProtocol securityProtocol, boolean createTopic) throws Throwable {
        this.produceConsume(producerUser, consumerUser, topics, consumerGroup, firstMessageIndex, securityProtocol, createTopic, Optional.empty(), new Properties());
    }

    /*
     * Exception decompiling
     */
    public void produceConsume(LogicalClusterUser producerUser, LogicalClusterUser consumerUser, List<String> topics, String consumerGroup, int firstMessageIndex, SecurityProtocol securityProtocol, boolean createTopic, Optional<String> listener, Properties additionalProps) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void produceConsume(LogicalClusterUser producerUser, LogicalClusterUser consumerUser, String topic, String consumerGroup, int firstMessageIndex, boolean createTopic) throws Throwable {
        this.produceConsume(producerUser, consumerUser, Arrays.asList(topic), consumerGroup, firstMessageIndex, SecurityProtocol.SASL_PLAINTEXT, createTopic);
    }

    public void produceConsume(LogicalClusterUser producerUser, LogicalClusterUser consumerUser, List<String> topics, String consumerGroup, int firstMessageIndex, boolean createTopic) throws Throwable {
        this.produceConsume(producerUser, consumerUser, topics, consumerGroup, firstMessageIndex, SecurityProtocol.SASL_PLAINTEXT, createTopic);
    }

    public void produceConsume(LogicalClusterUser producerUser, LogicalClusterUser consumerUser, String topic, String consumerGroup, int firstMessageIndex) throws Throwable {
        this.produceConsume(producerUser, consumerUser, Arrays.asList(topic), consumerGroup, firstMessageIndex, SecurityProtocol.SASL_PLAINTEXT);
    }

    public void produceConsume(LogicalClusterUser producerUser, LogicalClusterUser consumerUser, List<String> topics, String consumerGroup, int firstMessageIndex) throws Throwable {
        this.produceConsume(producerUser, consumerUser, topics, consumerGroup, firstMessageIndex, SecurityProtocol.SASL_PLAINTEXT);
    }

    public AclCommandBuilder newAclCommand() {
        return this.physicalCluster.newAclCommand();
    }

    public static SSLEngine setSniHostName(SSLEngine sslEngine, String sniHostName) {
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        List<SNIServerName> sniServerNameList = Collections.singletonList(new SNIHostName(sniHostName));
        sslParameters.setServerNames(sniServerNameList);
        sslEngine.setSSLParameters(sslParameters);
        return sslEngine;
    }

    public static String clientPlainJaasConfig(String username, String password) {
        return "org.apache.kafka.common.security.plain.PlainLoginModule required  username=\"" + username + "\"  password=\"" + password + "\";";
    }

    public static String clientOAuthJaasConfig(String jwsToken, String allowedCluster) {
        return "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required token=\"" + jwsToken + "\" cluster=\"" + allowedCluster + "\";";
    }

    public static Properties defaultOAuthBrokerProps() {
        Properties props = new Properties();
        props.put("sasl.enabled.mechanisms", Collections.singletonList("OAUTHBEARER"));
        props.put(KafkaConfig.ClientQuotaCallbackClassProp(), TenantQuotaCallback.class.getName());
        props.put("confluent.security.event.logger.authentication.enable", "true");
        props.put(KafkaConfig.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("listener.name.external.oauthbearer.sasl.login.callback.handler.class", OAuthBearerServerLoginCallbackHandler.class.getName());
        props.put("listener.name.external.oauthbearer.sasl.server.callback.handler.class", OAuthBearerValidatorCallbackHandler.class.getName());
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        return props;
    }

    public void ensureKraftMetadataConsistent() {
        if (this.isKraft()) {
            kafka.utils.TestUtils.ensureConsistentKRaftMetadata((Seq)((Iterator)JavaConverters.asScalaIteratorConverter(this.physicalCluster.kafkaCluster().kafkaBrokers().iterator()).asScala()).toSeq(), (ControllerServer)this.physicalCluster.kafkaCluster().kraftController(), (String)"Timeout waiting for controller metadata propagating to brokers");
        }
    }

    public Admin controllerAdminClient(String clientId) {
        return this.physicalCluster.kafkaCluster().kraftController().internalAdminClientSupplier().apply(clientId);
    }

    private PhysicalCluster createCluster(Optional<Time> time) {
        return new PhysicalCluster(this.brokersInPhysicalCluster, this.brokerRacks, this.brokerCells, time, this.testInfo);
    }

    private void tryCreateEarlyTopic(String topicName, int partitions, int replicationFactor, long timeoutMs) {
        block17: {
            if (!this.isKraft()) {
                try (KafkaZkClient zkClient = this.physicalCluster.kafkaCluster().createZkClient();){
                    TestUtils.waitForCondition(() -> zkClient.getAllBrokersInCluster().size() == replicationFactor, (long)timeoutMs, (String)"Not enough brokers in ZooKeeper");
                    AdminZkClient adminZkClient = new AdminZkClient(zkClient, Option.empty());
                    adminZkClient.createTopic(topicName, partitions, replicationFactor, new Properties(), (RackAwareMode)RackAwareMode.Enforced$.MODULE$, false, false, Option.empty());
                    break block17;
                }
                catch (InterruptedException e) {
                    throw new TimeoutException();
                }
            }
            try {
                ListenerName internalListener = new ListenerName("INTERNAL");
                TestUtils.waitForCondition(() -> {
                    List<KafkaBroker> brokers = this.physicalCluster.kafkaCluster().kafkaBrokers();
                    return brokers.size() != 0 && brokers.stream().allMatch(broker -> {
                        try {
                            return broker.boundPort(internalListener) != 0;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    });
                }, (String)"Socket server is not open");
                this.physicalCluster.kafkaCluster().createTopic(topicName, partitions, replicationFactor);
            }
            catch (Exception e) {
                throw new TimeoutException();
            }
        }
    }
}

