/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.BasePhysicalClusterMetadata;
import io.confluent.kafka.multitenant.TopicBasedPhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.assignor.TenantPartitionAssignorBuilder;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.server.plugins.policy.AlterConfigPolicy;
import io.confluent.kafka.server.plugins.policy.CreateTopicPolicy;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Tuple2;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:size:medium")})
public class TopicBasedPhysicalClusterMetadataIntegrationTest {
    private final String topicName = "_confluent-logical_clusters";
    private final int brokerCount = 3;
    private IntegrationTestHarness testHarness;
    private PhysicalCluster physicalCluster;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        Map<String, Object> propsMap = Stream.of({KafkaConfig.ListenersProp(), "INTERNAL://localhost:0, EXTERNAL://localhost:0"}, {"advertised.listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0"}, {KafkaConfig.ListenerSecurityProtocolMapProp(), "INTERNAL:PLAINTEXT, EXTERNAL:SASL_PLAINTEXT"}, {"inter.broker.listener.name", "INTERNAL"}, {"confluent.multitenant.listener.names", "EXTERNAL"}).collect(Collectors.toMap(prop -> prop[0].toString(), prop -> prop[1]));
        Properties props = new Properties();
        props.putAll(propsMap);
        props.putAll(this.nodeProps());
        Properties controllerProps = new Properties();
        controllerProps.putAll(this.nodeProps());
        this.testHarness = new IntegrationTestHarness(testInfo, 3);
        this.physicalCluster = this.testHarness.startWithTopic("_confluent-logical_clusters", 1, 1, 15000L, props, controllerProps);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
    }

    public Map<String, Object> nodeProps() {
        return Stream.of({KafkaConfig.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName()}, {"confluent.topic.replica.assignor.builder.class", TenantPartitionAssignorBuilder.class.getName()}, {KafkaConfig.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class.getName()}, {AclAuthorizer.AllowEveryoneIfNoAclIsFoundProp(), "true"}, {KafkaConfig.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class.getName()}, {"confluent.plugins.topic.policy.replication.factor", "1"}, {KafkaConfig.AutoCreateTopicsEnableProp(), "false"}, {"confluent.cdc.lkc.metadata.topic", "_confluent-logical_clusters"}, {"confluent.cdc.api.keys.topic.load.timeout.ms", 15000L + TimeUnit.SECONDS.toMillis(3L)}, {"multitenant.metadata.class", TopicBasedPhysicalClusterMetadata.class.getName()}, {"multitenant.tenant.delete.delay", TimeUnit.SECONDS.toMillis(1L)}, {"multitenant.tenant.delete.check.ms", TimeUnit.SECONDS.toMillis(1L)}, {"confluent.cluster.link.request.quota.request.percentage.multiplier", 1}).collect(Collectors.toMap(prop -> prop[0].toString(), prop -> prop[1]));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAddTenant(String quorum) throws Exception {
        long baseSequenceId = 1000L;
        HashSet<String> lkcIds = new HashSet<String>();
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        Assertions.assertTrue((boolean)instances.stream().allMatch(i -> i.kafkaLogicalClusterIds().equals(lkcIds)));
        String lkcId = Utils.LC_META_ABC.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1L, lkcId, Utils.LC_META_ABC);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkcId) != null), (String)"Expected metadata to get consumed");
        lkcIds.add(lkcId);
        Assertions.assertTrue((boolean)instances.stream().allMatch(i -> i.kafkaLogicalClusterIds().equals(lkcIds)), (String)"Single Kafka tenant should be recorded");
        String xyzId = Utils.LC_META_XYZ.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1L, Utils.LC_META_XYZ.logicalClusterId(), Utils.LC_META_XYZ);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(xyzId) != null), (String)"Expected metadata to get consumed");
        lkcIds.add(xyzId);
        Assertions.assertTrue((boolean)instances.stream().allMatch(i -> i.kafkaLogicalClusterIds().equals(lkcIds)), (String)"Multiple Kafka tenants should be recorded");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDelTenant(String quorum) throws Exception {
        long baseSequenceId = 2000L;
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        Assertions.assertTrue((boolean)instances.stream().allMatch(i -> i.kafkaLogicalClusterIds().isEmpty()));
        String lkcId = Utils.LC_META_ABC.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1L, lkcId, Utils.LC_META_ABC);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkcId) != null), (String)"Expected metadata to get consumed");
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 2L, lkcId, null);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkcId) == null), (String)"lkc should be deleted");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeactivateTenant(String quorum) throws Exception {
        long baseSequenceId = 3000L;
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        Assertions.assertTrue((boolean)instances.stream().allMatch(i -> i.kafkaLogicalClusterIds().isEmpty()));
        String lkcId = Utils.LC_META_DED.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1L, lkcId, Utils.LC_META_DED);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkcId) == null), (String)"Shouldn't return deactivated tenants");
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> ((TopicBasedPhysicalClusterMetadata)i).tenantLifecycleManager.deletedClusters().contains(lkcId)), (String)"Expect to have the lkc actually marked for deletion");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testReconfigurable(String quorum) throws Exception {
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        instances.stream().forEach(i -> {
            double linkRequestPercentageMultipler = (Double)TestUtils.fieldValue((Object)i, BasePhysicalClusterMetadata.class, (String)"linkRequestPercentageMultipler");
            Assertions.assertEquals((double)linkRequestPercentageMultipler, (double)1.0);
        });
        this.setAndVerifyLinkRequestPercentageMultiplierConfig(instances, 2.0);
        this.setAndVerifyLinkRequestPercentageMultiplierConfig(instances, 0.01);
    }

    private void setAndVerifyLinkRequestPercentageMultiplierConfig(List<BasePhysicalClusterMetadata> instances, double expectedValue) throws InterruptedException, ExecutionException {
        this.physicalCluster.superAdminClient().incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry("confluent.cluster.link.request.quota.request.percentage.multiplier", String.valueOf(expectedValue)), AlterConfigOp.OpType.SET)))).all().get();
        instances.stream().forEach(i -> {
            Tuple2 result = kafka.utils.TestUtils.computeUntilTrue(() -> (Double)TestUtils.fieldValue((Object)i, BasePhysicalClusterMetadata.class, (String)"linkRequestPercentageMultipler"), (long)15000L, (long)1000L, value -> value == expectedValue);
            Assertions.assertEquals((Double)((Double)result._1()), (double)expectedValue, (String)("Expect to have instance-" + i + " with updated linkRequestPercentageMultipler"));
        });
    }
}

