/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.integration.test.AbstractTopicBasedPlainSaslAuthIntegrationTest;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.test.JarResourceLoader;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:size:medium")})
public class TopicBasedPlainSaslAuthIntegrationTest
extends AbstractTopicBasedPlainSaslAuthIntegrationTest {
    protected final String pbkdf2ServiceUserAPIkey = "APIKEY2";
    private static final String JSON_WITH_MULTIPLE_KEYS = String.join((CharSequence)"\n", "{", "  \"keys\": {", "    \"key1\": {", "      \"user_id\": \"user1\",", "      \"logical_cluster_id\": \"myCluster\",", "      \"sasl_mechanism\": \"PLAIN\",", "      \"hashed_secret\": \"no hash\",", "      \"hash_function\": \"none\"", "    },", "    \"key2\": {", "      \"user_id\": \"user2\",", "      \"logical_cluster_id\": \"myCluster2\",", "      \"sasl_mechanism\": \"SSL\",", "      \"hashed_secret\": \"no hash\",", "      \"hash_function\": \"none\"", "    }", "  }", "}");

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSuccessfulAuthentication(String quorum) throws Exception {
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            client.createTopics((Collection)this.sampleTopics).all().get();
            List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
        }
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        Assertions.assertTrue((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
        Assertions.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
        Assertions.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        Assertions.assertFalse((boolean)((KafkaPrincipal)authenticationEvent.principal().get()).toString().contains("tenantMetadata"));
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Assertions.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidPassword(String quorum) throws Exception {
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "WrongPassword"));){
            KafkaFuture future = client.createTopics((Collection)this.sampleTopics).all();
            TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
        }
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("organization=my-org2"));
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("environment=my-env2"));
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("cloud-cluster=lkc-abc"));
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        Assertions.assertEquals(authenticationEvent.data().get("principal-resource-id"), (Object)"u-1");
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((boolean)errorInfo.errorMessage().contains("Bad password for user APIKEY1"));
        Assertions.assertEquals((Object)"APIKEY1", (Object)errorInfo.identifier());
        Assertions.assertEquals((Object)"lkc-abc", (Object)errorInfo.clusterId());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSuccessfulAuthenticationPbkdf2(String quorum) throws Exception {
        this.startWithTopic();
        this.loadPbkdf2ApiKeys();
        this.loadLKCMetadata();
        try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "blah"));){
            client.createTopics((Collection)this.sampleTopics).all().get();
            List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
        }
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        Assertions.assertTrue((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
        Assertions.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
        Assertions.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        Assertions.assertFalse((boolean)((KafkaPrincipal)authenticationEvent.principal().get()).toString().contains("tenantMetadata"));
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Assertions.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidPbkdf2Password(String quorum) throws Exception {
        this.startWithTopic();
        this.loadPbkdf2ApiKeys();
        this.loadLKCMetadata();
        try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "WrongPassword"));){
            KafkaFuture future = client.createTopics((Collection)this.sampleTopics).all();
            TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
        }
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("organization=my-org2"));
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("environment=my-env2"));
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("cloud-cluster=lkc-abc"));
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        Assertions.assertEquals(authenticationEvent.data().get("principal-resource-id"), (Object)"u-1");
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((boolean)errorInfo.errorMessage().contains("Bad password for user APIKEY2"));
        Assertions.assertEquals((Object)"APIKEY2", (Object)errorInfo.identifier());
        Assertions.assertEquals((Object)"lkc-abc", (Object)errorInfo.clusterId());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUnknownUser(String quorum) throws Exception {
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("UnknownUser", "WrongPassword"));){
            KafkaFuture future = client.createTopics((Collection)this.sampleTopics).all();
            TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
        }
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNKNOWN_USER_DENIED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((boolean)errorInfo.errorMessage().contains("Unknown user UnknownUser"));
        Assertions.assertEquals((Object)"UnknownUser", (Object)errorInfo.identifier());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNoSecretsInTopic(String quorum) throws Exception {
        this.startWithTopic();
        this.loadLKCMetadata();
        try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            KafkaFuture future = client.createTopics((Collection)this.sampleTopics).all();
            TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
        }
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNKNOWN_USER_DENIED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        Assertions.assertTrue((boolean)authenticationException.errorInfo().errorMessage().contains("Unknown user"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailureToConnectWithNoTopic(String quorum) {
        long topicLoadTimeoutMs = 3000L;
        Exception e = (Exception)Assertions.assertThrows(RuntimeException.class, () -> this.testHarness.start(this.brokerProps(topicLoadTimeoutMs, false)), (String)"No topic should cause the broker to fail to start");
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Received a fatal error while waiting for all of the authorizer futures to be completed"), (String)("Unexpected error message " + e.getMessage()));
        String causeMessage = e.getCause() == null ? "(cause is null)" : Optional.ofNullable(e.getCause().getMessage()).orElse("(null)");
        Assertions.assertTrue((boolean)causeMessage.contains("Unable to start the consumer for MultiTenantSaslSecretsStore"), (String)("Unexpected value of exception cause message: " + causeMessage));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testApiKeyDelete(String quorum) throws Exception {
        this.startWithTopic();
        this.loadApiKeys();
        AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));
        client.createTopics((Collection)this.sampleTopics).all().get();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
        this.physicalCluster.kafkaCluster().produceApiKeysData("_confluent-apikey", "APIKEY1", null, true);
        TestUtils.waitForCondition(() -> {
            try {
                client.listTopics().listings().get(15L, TimeUnit.SECONDS);
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }, (String)"Connection for deleted API key not terminated");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidSecretsHandledGracefully(String quorum) throws Exception {
        this.startWithTopic();
        this.loadApiKeys();
        AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));
        client.createTopics((Collection)this.sampleTopics).all().get();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
        this.physicalCluster.kafkaCluster().produceApiKeysData("_confluent-apikey", "some_key", JSON_WITH_MULTIPLE_KEYS, false);
        this.physicalCluster.kafkaCluster().produceApiKeysData("_confluent-apikey", "some_other_key", "NOT A JSON MESSAGE", false);
        this.physicalCluster.kafkaCluster().produceApiKeysData("_confluent-apikey", "APIKEY1", null, true);
        TestUtils.waitForCondition(() -> {
            try {
                client.listTopics().listings().get(15L, TimeUnit.SECONDS);
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }, (String)"Connection for deleted API key not terminated");
    }

    protected void loadPbkdf2ApiKeys() throws Exception {
        BufferedInputStream path;
        try {
            path = (BufferedInputStream)JarResourceLoader.loadFileFromResource(FileBasedPlainSaslAuthenticatorTest.class, (String)"/pbkdf2_auth_keys.json").toURI().toURL().getContent();
        }
        catch (IOException e) {
            throw new Exception("Couldn't read apikeys content");
        }
        String apiKeys = Utils.readFullyToString((InputStream)path);
        this.physicalCluster.kafkaCluster().produceApiKeysData("_confluent-apikey", "APIKEY2", apiKeys, true);
    }
}

