/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import com.google.common.collect.Iterables;
import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import io.confluent.kafka.test.utils.AclCommandBuilder;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.test.JarResourceLoader;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:2")})
public class UserResourceIdAuthorizationIntegrationTest {
    static final String KEY2 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"u-2\",", "  \"OrgResourceId\": \"org1\",", "  \"PkcId\": \"pkc1\"", "}");
    static final String VALUE2 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"2\",", "  \"ActiveLkcIds\": [\"lkc1\", \"lkc2\"]", "}");
    static final String KEY4 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"u-4\",", "  \"OrgResourceId\": \"org1\"", "}");
    static final String VALUE4 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"4\",", "  \"ActiveLkcIds\": [\"lkc3\", \"lkc4\"]", "}");
    static final String KEY5 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"u-5\",", "  \"OrgResourceId\": \"org1\"", "}");
    static final String VALUE5 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"5\",", "  \"ActiveLkcIds\": [\"lkc3\", \"lkc4\"]", "}");
    static final String ANY_ACL_FILTER = "{ \"aclFilters\": [{ \"resourceFilter\": { \"resourceType\": \"any\", \"patternType\": \"any\" },\"accessFilter\": { \"operation\": \"any\", \"permissionType\": \"any\"}}]}";
    static final String ACL_FILTER_FOR_USER_2 = "{ \"aclFilters\": [{ \"resourceFilter\": { \"resourceType\": \"any\", \"patternType\": \"any\" },\"accessFilter\": { \"operation\": \"any\", \"principal\": \"User:2\", \"permissionType\": \"any\"}}]}";
    static final String ACL_FILTER_FOR_USER_4 = "{ \"aclFilters\": [{ \"resourceFilter\": { \"resourceType\": \"any\", \"patternType\": \"any\" },\"accessFilter\": { \"operation\": \"any\", \"principal\": \"User:4\", \"permissionType\": \"any\"}}]}";
    static final String ACL_FILTER_FOR_USER_U_4_AND_POOL_ID = "{ \"aclFilters\": [{ \"resourceFilter\": { \"resourceType\": \"any\", \"patternType\": \"any\" },\"accessFilter\": { \"operation\": \"any\", \"principal\": \"User:u-4\", \"permissionType\": \"any\"}}, { \"resourceFilter\": { \"resourceType\": \"any\", \"patternType\": \"any\" },\"accessFilter\": { \"operation\": \"any\", \"principal\": \"User:pool-1\", \"permissionType\": \"any\"}}]}";
    static final String ACL_FILTER_FOR_USER_V_2 = "{ \"aclFilters\": [{ \"resourceFilter\": { \"resourceType\": \"any\", \"patternType\": \"any\" },\"accessFilter\": { \"operation\": \"any\", \"principal\": \"UserV2:*\", \"permissionType\": \"any\"}}]}";
    static final String LINK_NAME_1 = "test-link1";
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private final String destLogicalClusterId = Utils.LC_META_DED.logicalClusterId();
    private final String adminUserAPIkey = "APIKEY1";
    private final String adminUserAPIkeyPassword = "pwd1";
    private final String serviceUserAPIkey2 = "APIKEY2";
    private final String serviceUserAPIkeyPassword2 = "pwd2";
    private final String serviceUserAPIkey3 = "APIKEY3";
    private final String serviceUserAPIkeyPassword3 = "pwd3";
    private IntegrationTestHarness testHarness;
    private IntegrationTestHarness destTestHarness;
    private PhysicalCluster physicalCluster;
    private PhysicalCluster destPhysicalCluster;
    private ConfluentAdmin destConfluentAdmin;
    private Uuid linkId;
    private int userMetadataSequenceId;
    private final String apiKeysTopic = "_confluent-apikey";
    private final String userMetaDataTopic = "_confluent-user_metadata";
    private final String testTopic1 = "abcd1";
    private final String testTopic2 = "abcd2";
    private final String testTopic3 = "abcd3";
    private final String userType = "User:";
    private final String userResourceId2 = "u-2";
    private final String userResourceId3 = "u-3";
    private final String userResourceId4 = "u-4";
    private final String userId2 = "2";
    private final String userId3 = "3";
    private final String userId4 = "4";
    private final List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd1", 3, 1));

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        int numBrokers = 3;
        this.testHarness = new IntegrationTestHarness(testInfo, numBrokers);
        this.destTestHarness = new IntegrationTestHarness(testInfo, numBrokers);
        long topicCreateTimeout = 15000L;
        long topicLoadTimeoutMs = topicCreateTimeout + TimeUnit.SECONDS.toMillis(3L);
        this.physicalCluster = this.testHarness.startWithTopic(Arrays.asList("_confluent-apikey", "_confluent-user_metadata"), 1, 1, topicCreateTimeout, this.brokerProps(topicLoadTimeoutMs, "0"), this.controllerProps(topicLoadTimeoutMs, "0"), Optional.empty());
        this.destPhysicalCluster = this.destTestHarness.startWithTopic(Arrays.asList("_confluent-apikey", "_confluent-user_metadata"), 1, 1, topicCreateTimeout, this.brokerProps(topicLoadTimeoutMs, "100"), this.controllerProps(topicLoadTimeoutMs, "100"), Optional.empty());
        int adminUserId = 1;
        int serviceUserId = 2;
        this.physicalCluster.createLogicalCluster(this.logicalClusterId, 100, adminUserId, serviceUserId);
        this.destPhysicalCluster.createLogicalCluster(this.destLogicalClusterId, 100, adminUserId, serviceUserId);
        this.loadApiKeys(this.physicalCluster, "/file_auth_test_apikeys.json", "APIKEY1");
        this.loadApiKeys(this.physicalCluster, "/service_account_apikey_2.json", "APIKEY2");
        this.loadApiKeys(this.physicalCluster, "/service_account_apikey_3.json", "APIKEY3");
        this.loadApiKeys(this.physicalCluster, "/service_account_apikey_4.json", "APIKEY4");
        this.loadApiKeys(this.destPhysicalCluster, "/admin_account_apikey_1.json", "APIKEY1");
        this.loadUserMetaData();
    }

    private void loadUserMetaData() {
        this.userMetadataSequenceId = 0;
        List<String> userMetaDataKeys = Arrays.asList(KEY2, KEY4, KEY5);
        List<String> userMetaDataValues = Arrays.asList(VALUE2, VALUE4, VALUE5);
        for (int i = 0; i < userMetaDataKeys.size(); ++i) {
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, userMetaDataKeys.get(i), userMetaDataValues.get(i));
            this.destPhysicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, userMetaDataKeys.get(i), userMetaDataValues.get(i));
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
        this.destTestHarness.shutdown();
    }

    private Properties brokerProps(long topicLoadTimeoutMs, String brokerId) throws IOException {
        Properties props = new Properties();
        props.put("listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("advertised.listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT, EXTERNAL:SASL_PLAINTEXT");
        props.put("broker.id", brokerId);
        props.putAll((Map<?, ?>)this.commonProps(topicLoadTimeoutMs));
        return props;
    }

    private Properties controllerProps(long topicLoadTimeoutMs, String nodeId) throws IOException {
        Properties props = new Properties();
        props.put("node.id", nodeId);
        props.putAll((Map<?, ?>)this.commonProps(topicLoadTimeoutMs));
        return props;
    }

    private Properties commonProps(long topicLoadTimeoutMs) throws IOException {
        Properties props = new Properties();
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", "true");
        props.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule required;");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        props.put("confluent.cdc.api.keys.topic", "_confluent-apikey");
        props.put("confluent.cdc.api.keys.topic.load.timeout.ms", String.valueOf(topicLoadTimeoutMs));
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.close.connections.on.credential.delete", "true");
        props.put("multitenant.authorizer.support.resource.ids", "true");
        props.put("confluent.cdc.user.metadata.enable", "true");
        props.put("confluent.cluster.link.enable", "true");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "link-secret");
        props.put("confluent.max.acls.per.tenant", "100");
        return props;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateAcls(String quorum) throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            Object future4;
            Object future22;
            Object future3;
            try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));){
                future3 = client.createTopics(this.topicsList("topic1")).all();
                TestUtils.assertFutureError((Future)future3, TopicAuthorizationException.class);
            }
            AclBinding acl1 = this.topicAcl("2", "topic1");
            adminClient.createAcls(Collections.singleton(acl1)).all().get();
            AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            future3 = null;
            try {
                TestUtils.retryOnExceptionWithTimeout(() -> {
                    Void cfr_ignored_0 = (Void)client.createTopics(this.topicsList("topic1")).all().get();
                });
                List expectedTopics = this.topicsList("topic1").stream().map(NewTopic::name).collect(Collectors.toList());
                TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
            }
            catch (Throwable expectedTopics) {
                future3 = expectedTopics;
                throw expectedTopics;
            }
            finally {
                if (client != null) {
                    if (future3 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable expectedTopics) {
                            ((Throwable)future3).addSuppressed(expectedTopics);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            future3 = null;
            try {
                future22 = client.createTopics(this.topicsList("topic2")).all();
                TestUtils.assertFutureError((Future)future22, TopicAuthorizationException.class);
            }
            catch (Throwable future22) {
                future3 = future22;
                throw future22;
            }
            finally {
                if (client != null) {
                    if (future3 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable future22) {
                            ((Throwable)future3).addSuppressed(future22);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            AclBinding acl2 = this.topicAcl("2", "topic2");
            adminClient.createAcls(Collections.singleton(acl2)).all().get();
            AdminClient client2 = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            future22 = null;
            try {
                TestUtils.retryOnExceptionWithTimeout(() -> {
                    Void cfr_ignored_0 = (Void)client2.createTopics(this.topicsList("topic2")).all().get();
                });
                List expectedTopics = this.topicsList("topic2").stream().map(NewTopic::name).collect(Collectors.toList());
                TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client2.listTopics().names().get()).containsAll(expectedTopics)));
            }
            catch (Throwable expectedTopics) {
                future22 = expectedTopics;
                throw expectedTopics;
            }
            finally {
                if (client2 != null) {
                    if (future22 != null) {
                        try {
                            client2.close();
                        }
                        catch (Throwable expectedTopics) {
                            ((Throwable)future22).addSuppressed(expectedTopics);
                        }
                    } else {
                        client2.close();
                    }
                }
            }
            client2 = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY3", "pwd3"));
            future22 = null;
            try {
                future4 = client2.createTopics(this.topicsList("topic3")).all();
                TestUtils.assertFutureError((Future)future4, TopicAuthorizationException.class);
            }
            catch (Throwable future4) {
                future22 = future4;
                throw future4;
            }
            finally {
                if (client2 != null) {
                    if (future22 != null) {
                        try {
                            client2.close();
                        }
                        catch (Throwable future4) {
                            ((Throwable)future22).addSuppressed(future4);
                        }
                    } else {
                        client2.close();
                    }
                }
            }
            AclBinding acl3 = this.topicAcl("3", "topic3");
            adminClient.createAcls(Collections.singleton(acl3)).all().get();
            AdminClient client3 = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY3", "pwd3"));
            future4 = null;
            try {
                TestUtils.retryOnExceptionWithTimeout(() -> {
                    Void cfr_ignored_0 = (Void)client3.createTopics(this.topicsList("topic3")).all().get();
                });
                List expectedTopics = this.topicsList("topic3").stream().map(NewTopic::name).collect(Collectors.toList());
                TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client3.listTopics().names().get()).containsAll(expectedTopics)));
            }
            catch (Throwable expectedTopics) {
                future4 = expectedTopics;
                throw expectedTopics;
            }
            finally {
                if (client3 != null) {
                    if (future4 != null) {
                        try {
                            client3.close();
                        }
                        catch (Throwable expectedTopics) {
                            ((Throwable)future4).addSuppressed(expectedTopics);
                        }
                    } else {
                        client3.close();
                    }
                }
            }
            client3 = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            future4 = null;
            try {
                KafkaFuture future5 = client3.createTopics(this.topicsList("topic4")).all();
                TestUtils.assertFutureError((Future)future5, TopicAuthorizationException.class);
            }
            catch (Throwable throwable) {
                future4 = throwable;
                throw throwable;
            }
            finally {
                if (client3 != null) {
                    if (future4 != null) {
                        try {
                            client3.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)future4).addSuppressed(throwable);
                        }
                    } else {
                        client3.close();
                    }
                }
            }
            AclBinding acl4 = this.topicAcl("*", "topic4");
            adminClient.createAcls(Collections.singleton(acl4)).all().get();
            try (AdminClient client4 = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));){
                TestUtils.retryOnExceptionWithTimeout(() -> {
                    Void cfr_ignored_0 = (Void)client4.createTopics(this.topicsList("topic4")).all().get();
                });
                List expectedTopics = this.topicsList("topic4").stream().map(NewTopic::name).collect(Collectors.toList());
                TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client4.listTopics().names().get()).containsAll(expectedTopics)));
            }
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWildCardAcls(String quorum) throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            AclBinding acl1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.PREFIXED), new AccessControlEntry(new KafkaPrincipal("User", "*").toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW));
            KafkaFuture future = adminClient.createAcls(Collections.singleton(acl1)).all();
            TestUtils.assertFutureError((Future)future, InvalidRequestException.class);
            AclBinding acl2 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry(new KafkaPrincipal("User", "4").toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW));
            adminClient.createAcls(Collections.singleton(acl2)).all().get();
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection result = (Collection)adminClient.describeAcls(this.topicFilter("4")).values().get();
                Assertions.assertEquals((Object)result, Collections.singletonList(acl2));
            });
            AclBinding acl3 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "..", PatternType.PREFIXED), new AccessControlEntry(new KafkaPrincipal("User", "4").toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW));
            adminClient.createAcls(Collections.singleton(acl3)).all().get();
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection result = (Collection)adminClient.describeAcls(this.topicFilter("4")).values().get();
                Assertions.assertTrue((boolean)result.containsAll(Arrays.asList(acl2, acl3)));
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeAcls(String quorum) throws Exception {
        AclBinding acl1 = this.topicAcl("2");
        AclBinding acl2 = this.topicAcl("3");
        AclBinding acl3 = this.topicAcl("*");
        ArrayList<AclBinding> aclsOldFormat = new ArrayList<AclBinding>(Arrays.asList(acl1, acl2, acl3));
        ArrayList<AclBinding> aclsNewFormat = new ArrayList<AclBinding>(Arrays.asList(this.topicAcl("u-2"), acl2, acl3));
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            adminClient.createAcls(new ArrayList<AclBinding>(Arrays.asList(acl1, acl2, acl3))).all().get();
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection aclsAnyFilter = (Collection)adminClient.describeAcls(AclBindingFilter.ANY).values().get();
                Assertions.assertEquals((int)aclsOldFormat.size(), (int)aclsAnyFilter.size());
                Assertions.assertTrue((boolean)aclsOldFormat.containsAll(aclsAnyFilter));
                AclBindingFilter resourceIdFilter = this.topicFilter("u-2");
                Assertions.assertEquals((Object)this.topicAcl("u-2"), (Object)Iterables.getOnlyElement((Iterable)((Iterable)adminClient.describeAcls(resourceIdFilter).values().get())));
                AclBindingFilter userIdFilter = this.topicFilter("2");
                Assertions.assertEquals((Object)acl1, (Object)Iterables.getOnlyElement((Iterable)((Iterable)adminClient.describeAcls(userIdFilter).values().get())));
                AclBindingFilter userV2Filter = this.topicFilter("*", "UserV2");
                Collection aclsV2Filter = (Collection)adminClient.describeAcls(userV2Filter).values().get();
                Assertions.assertEquals((int)aclsNewFormat.size(), (int)aclsV2Filter.size());
                Assertions.assertTrue((boolean)aclsNewFormat.containsAll(aclsV2Filter));
                Collection aclsForNullPrincipal = (Collection)adminClient.describeAcls(this.topicFilter(AclOperation.ALL)).values().get();
                Assertions.assertEquals((int)aclsOldFormat.size(), (int)aclsForNullPrincipal.size());
                Assertions.assertTrue((boolean)aclsOldFormat.containsAll(aclsForNullPrincipal));
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteAcls(String quorum) throws Exception {
        ArrayList<AclBinding> aclBindings = new ArrayList<AclBinding>();
        for (int i = 0; i < 5; ++i) {
            aclBindings.add(this.topicAcl("2", "abcd1" + i));
            aclBindings.add(this.topicAcl("u-2", "abcd2" + i));
            aclBindings.add(this.topicAcl("3", "abcd1" + i));
            aclBindings.add(this.topicAcl("4", "abcd1" + i));
            aclBindings.add(this.topicAcl("u-4", "abcd2" + i));
        }
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            List<AclBindingFilter> aclBindingFilters = Arrays.asList(this.topicFilter("2"), this.topicFilter("u-2"), this.topicFilter("u-3"), this.topicFilter("4"));
            adminClient.createAcls(aclBindings).all().get();
            Map aclBindingFilterKafkaFutureMap = adminClient.deleteAcls(aclBindingFilters).values();
            this.testHarness.ensureKraftMetadataConsistent();
            block16: for (int i = 0; i < 4; ++i) {
                DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)((KafkaFuture)aclBindingFilterKafkaFutureMap.get(aclBindingFilters.get(i))).get();
                Set principals = filterResults.values().stream().map(filterResult -> filterResult.binding().entry().principal()).collect(Collectors.toSet());
                Assertions.assertTrue((principals.size() == (i == 2 ? 0 : 1) ? 1 : 0) != 0);
                switch (i + 1) {
                    case 1: {
                        Assertions.assertTrue((filterResults.values().size() == 5 && principals.contains(this.principal("2")) ? 1 : 0) != 0);
                        continue block16;
                    }
                    case 2: {
                        Assertions.assertTrue((filterResults.values().size() == 5 && principals.contains(this.principal("u-2")) ? 1 : 0) != 0);
                        continue block16;
                    }
                    case 3: {
                        Assertions.assertTrue((filterResults.values().size() == 0 ? 1 : 0) != 0);
                        continue block16;
                    }
                    case 4: {
                        Assertions.assertTrue((filterResults.values().size() == 10 && principals.contains(this.principal("4")) ? 1 : 0) != 0);
                    }
                }
            }
            adminClient.createAcls(aclBindings).all().get();
            Collection resultAclBindings = (Collection)adminClient.deleteAcls(Arrays.asList(AclBindingFilter.ANY)).all().get();
            Set principals = resultAclBindings.stream().map(aclBinding -> aclBinding.entry().principal()).collect(Collectors.toSet());
            Assertions.assertTrue((resultAclBindings.size() == 25 && principals.size() == 3 && principals.containsAll(Arrays.asList(this.principal("2"), this.principal("3"), this.principal("4"))) ? 1 : 0) != 0);
            adminClient.createAcls(aclBindings).all().get();
            resultAclBindings = (Collection)adminClient.deleteAcls(Arrays.asList(this.topicFilter("*", "UserV2"))).all().get();
            principals = resultAclBindings.stream().map(aclBinding -> aclBinding.entry().principal()).collect(Collectors.toSet());
            Assertions.assertTrue((resultAclBindings.size() == 25 && principals.size() == 3 && principals.containsAll(Arrays.asList(this.principal("u-2"), this.principal("3"), this.principal("u-4"))) ? 1 : 0) != 0);
        }
    }

    private String principal(String user) {
        return "User:" + user;
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUserResourceIdWithAdminClient(String quorum) throws Exception {
        AclBinding topicAcl = this.topicAcl("u-2");
        AclBindingFilter topicFilter = this.topicFilter("u-2");
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            KafkaFuture future;
            Collection acls = (Collection)adminClient.describeAcls(topicFilter).values().get();
            Assertions.assertTrue((boolean)acls.isEmpty());
            try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));){
                future = client.createTopics(this.sampleTopics).all();
                TestUtils.assertFutureError((Future)future, TopicAuthorizationException.class);
            }
            adminClient.createAcls(Collections.singleton(topicAcl)).all().get();
            acls = (Collection)adminClient.describeAcls(topicFilter).values().get();
            Assertions.assertEquals((int)1, (int)acls.size());
            client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            var8_10 = null;
            try {
                client.createTopics(this.sampleTopics).all().get();
                List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
                Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics));
            }
            catch (Throwable expectedTopics) {
                var8_10 = expectedTopics;
                throw expectedTopics;
            }
            finally {
                if (client != null) {
                    if (var8_10 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable expectedTopics) {
                            var8_10.addSuppressed(expectedTopics);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            adminClient.deleteAcls(Collections.singleton(topicFilter)).all().get();
            acls = (Collection)adminClient.describeAcls(topicFilter).values().get();
            Assertions.assertTrue((boolean)acls.isEmpty());
            client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            var8_10 = null;
            try {
                future = client.describeTopics(Collections.singletonList("abcd1")).allTopicNames();
                TestUtils.assertFutureError((Future)future, TopicAuthorizationException.class);
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (var8_10 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            var8_10.addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
    }

    @Test
    public void testDynamicConfig() throws ExecutionException, InterruptedException {
        ArrayList<AclBinding> aclBindings = new ArrayList<AclBinding>();
        aclBindings.add(this.topicAcl("2", "abcd1"));
        aclBindings.add(this.topicAcl("u-2", "abcd2"));
        aclBindings.add(this.topicAcl("u-2", "abcd3"));
        aclBindings.add(this.topicAcl("3", "abcd1"));
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            adminClient.createAcls(aclBindings).all().get();
            AclBindingFilter userIdFilter2 = this.topicFilter("2");
            AclBindingFilter userIdFilter3 = this.topicFilter("3");
            Assertions.assertTrue((((Collection)adminClient.describeAcls(userIdFilter2).values().get()).size() == 3 && ((Collection)adminClient.describeAcls(userIdFilter3).values().get()).size() == 1 ? 1 : 0) != 0);
            this.updateResourceIdInAclConfig(adminClient, "false");
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((((Collection)adminClient.describeAcls(userIdFilter2).values().get()).size() == 1 && ((Collection)adminClient.describeAcls(userIdFilter3).values().get()).size() == 1 ? 1 : 0) != 0));
            this.updateResourceIdInAclConfig(adminClient, "true");
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((((Collection)adminClient.describeAcls(userIdFilter2).values().get()).size() == 3 && ((Collection)adminClient.describeAcls(userIdFilter3).values().get()).size() == 1 ? 1 : 0) != 0));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testResourceIdSupportInKafkaCli(String quorum) throws Exception {
        String jaasConfig = IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1");
        this.topicAclCommandBuilder("2", "abcd1", jaasConfig).execute();
        this.topicAclCommandBuilder("u-2", "abcd2", jaasConfig).execute();
        this.topicAclCommandBuilder("u-2", "abcd3", jaasConfig).execute();
        this.topicAclCommandBuilder("4", "abcd1", jaasConfig).execute();
        TestUtils.retryOnExceptionWithTimeout(() -> {
            String aclOutput = this.physicalCluster.newAclCommandWithExternalListener(jaasConfig).customCommand(Arrays.asList("--add", "--resource-pattern-type=" + PatternType.LITERAL.name(), "--topic=abcd1", "--operation=" + SecurityUtils.operationName((AclOperation)AclOperation.READ), "--allow-principal=" + new KafkaPrincipal("User", "3"), "--resource-id")).executeAndGrabOutput();
            Assertions.assertTrue((aclOutput.split("User:u-2", -1).length == 2 && aclOutput.split("User:u-4", -1).length == 2 && aclOutput.split("User:3", -1).length == 3 ? 1 : 0) != 0);
            aclOutput = this.physicalCluster.newAclCommandWithExternalListener(jaasConfig).customCommand(Arrays.asList("--list", "--resource-id")).executeAndGrabOutput();
            Assertions.assertTrue((aclOutput.split("User:u-2", -1).length == 4 && aclOutput.split("User:3", -1).length == 2 ? 1 : 0) != 0);
            aclOutput = this.physicalCluster.newAclCommandWithExternalListener(jaasConfig).customCommand(Arrays.asList("--list", "--principal=User:u-2", "--resource-id")).executeAndGrabOutput();
            Assertions.assertTrue((aclOutput.split("User:u-2", -1).length == 5 && aclOutput.split("User:3", -1).length == 1 ? 1 : 0) != 0);
            aclOutput = this.physicalCluster.newAclCommandWithExternalListener(jaasConfig).customCommand(Arrays.asList("--list", "--principal=User:3", "--resource-id")).executeAndGrabOutput();
            Assertions.assertTrue((aclOutput.split("User:u-2", -1).length == 1 && aclOutput.split("User:3", -1).length == 3 ? 1 : 0) != 0);
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateSameAclWithDifferentId(String quorum) throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            ArrayList<AclBinding> resourceIdAclBindings = new ArrayList<AclBinding>(Arrays.asList(this.topicAcl("u-2"), this.topicAcl("u-4"), this.topicAcl("pool-1")));
            adminClient.createAcls(Arrays.asList(this.topicAcl("2"), this.topicAcl("u-4"), this.topicAcl("pool-1"))).all().get();
            TestUtils.waitForCondition(() -> ((Collection)adminClient.describeAcls(AclBindingFilter.ANY).values().get()).size() == 3, (String)"ACL size should be equal to 3");
            adminClient.createAcls(Arrays.asList(this.topicAcl("u-2"), this.topicAcl("4"))).all().get();
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY2, null);
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY4, null);
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection aclBindings = (Collection)adminClient.describeAcls(AclBindingFilter.ANY).values().get();
                Assertions.assertTrue((boolean)aclBindings.containsAll(resourceIdAclBindings));
                Assertions.assertTrue((aclBindings.size() == resourceIdAclBindings.size() ? 1 : 0) != 0);
            });
            int i = 0;
            while (resourceIdAclBindings.size() < 100) {
                resourceIdAclBindings.add(this.topicAcl("u-2", "abcd1" + i));
                ++i;
            }
            adminClient.createAcls(resourceIdAclBindings).all().get();
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY2, VALUE2);
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", ++this.userMetadataSequenceId, KEY4, VALUE4);
            TestUtils.retryOnExceptionWithTimeout(() -> adminClient.createAcls(Arrays.asList(this.topicAcl("2"))).all().get());
            adminClient.createAcls(Arrays.asList(this.topicAcl("pool-1"))).all().get();
            adminClient.deleteAcls(Arrays.asList(this.topicAcl("u-4").toFilter())).all().get();
            adminClient.createAcls(Arrays.asList(this.topicAcl("4"))).all().get();
            TestUtils.assertFutureThrows((Future)adminClient.createAcls(Arrays.asList(this.topicAcl("4", "abcd2"))).all(), InvalidRequestException.class);
            adminClient.createAcls(Arrays.asList(this.topicAcl("u-4"))).all().get();
            Assertions.assertTrue((((Collection)adminClient.describeAcls(AclBindingFilter.ANY).values().get()).size() == 100 ? 1 : 0) != 0);
        }
    }

    @ValueSource(strings={"zk"})
    public void testAclsWithMultipleClusterLinkIds(String quorum) throws Exception {
        AclBinding aclWithUserId4 = this.topicAcl("4", "abcd1");
        AclBinding aclWithUserResourceId4 = this.topicAcl("u-4", "abcd1");
        try (AdminClient srcAdminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));
             AdminClient destAdminClient = this.destTestHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            this.destConfluentAdmin = (ConfluentAdmin)destAdminClient;
            this.linkId = this.createClusterLink(LINK_NAME_1, ACL_FILTER_FOR_USER_V_2);
            srcAdminClient.createAcls(Arrays.asList(aclWithUserId4)).all().get();
            this.destConfluentAdmin.createAcls(Arrays.asList(aclWithUserId4)).all().get();
            this.waitForDestAcls(Arrays.asList(this.addLinkId(aclWithUserId4, this.linkId, Uuid.ZERO_UUID)));
            srcAdminClient.deleteAcls(Arrays.asList(aclWithUserResourceId4.toFilter())).all().get();
            this.waitForDestAcls(Arrays.asList(aclWithUserId4));
            this.destConfluentAdmin.deleteAcls(Arrays.asList(aclWithUserId4.toFilter())).all().get();
            srcAdminClient.createAcls(Arrays.asList(aclWithUserId4)).all().get();
            this.waitForDestAcls(Arrays.asList(this.addLinkId(aclWithUserId4, this.linkId)));
            this.destConfluentAdmin.deleteClusterLinks(Arrays.asList(LINK_NAME_1), new DeleteClusterLinksOptions()).all().get();
            this.waitForDestAcls(Arrays.asList(aclWithUserId4));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testAclSyncWithResourceId(String quorum) throws Exception {
        ArrayList<AclBinding> aclBindings = new ArrayList<AclBinding>();
        aclBindings.add(this.topicAcl("2", "abcd1"));
        aclBindings.add(this.topicAcl("2", "abcd2"));
        aclBindings.add(this.topicAcl("pool-1", "abcd1"));
        aclBindings.add(this.topicAcl("pool-1", "abcd3"));
        aclBindings.add(this.topicAcl("4", "abcd3"));
        aclBindings.add(this.topicAcl("4", "abcd2"));
        try (AdminClient srcAdminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));
             AdminClient destAdminClient = this.destTestHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            this.destConfluentAdmin = (ConfluentAdmin)destAdminClient;
            this.linkId = this.createClusterLink(LINK_NAME_1, ANY_ACL_FILTER);
            srcAdminClient.createAcls(aclBindings).all().get();
            this.waitForDestAcls(aclBindings.stream().map(aclBinding -> this.addLinkId((AclBinding)aclBinding, this.linkId)).collect(Collectors.toSet()));
            this.updateAclFilterForClusterLink(ACL_FILTER_FOR_USER_2, LINK_NAME_1);
            this.waitForDestAcls(aclBindings.stream().map(aclBinding -> {
                if (aclBinding.entry().principal().equals("User:2")) {
                    return this.addLinkId((AclBinding)aclBinding, this.linkId);
                }
                return aclBinding;
            }).collect(Collectors.toSet()));
            srcAdminClient.deleteAcls(Collections.singleton(AclBindingFilter.ANY)).all().get();
            this.waitForDestAcls(aclBindings.subList(2, aclBindings.size()).stream().collect(Collectors.toSet()));
            this.destConfluentAdmin.deleteAcls(Collections.singleton(AclBindingFilter.ANY)).all().get();
            this.testAclSyncWithResourceIdFlagEnabledOnSrcAndDest(srcAdminClient, aclBindings);
        }
    }

    private void testAclSyncWithResourceIdFlagEnabledOnSrcAndDest(AdminClient srcAdminClient, List<AclBinding> aclBindings) throws Exception {
        srcAdminClient.createAcls(aclBindings).all().get();
        this.updateAclFilterForClusterLink(ANY_ACL_FILTER, LINK_NAME_1);
        this.waitForDestAcls(aclBindings.stream().map(aclBinding -> this.addLinkId((AclBinding)aclBinding, this.linkId)).collect(Collectors.toSet()));
        this.updateAclFilterForClusterLink(ACL_FILTER_FOR_USER_V_2, LINK_NAME_1);
        this.waitForDestAcls(aclBindings.stream().map(aclBinding -> this.addLinkId((AclBinding)aclBinding, this.linkId)).collect(Collectors.toSet()));
        this.updateAclFilterForClusterLink(ACL_FILTER_FOR_USER_U_4_AND_POOL_ID, LINK_NAME_1);
        this.waitForDestAcls(aclBindings.stream().map(aclBinding -> {
            if (aclBinding.entry().principal().equals("User:2")) {
                return aclBinding;
            }
            return this.addLinkId((AclBinding)aclBinding, this.linkId);
        }).collect(Collectors.toSet()));
        this.updateAclFilterForClusterLink(ACL_FILTER_FOR_USER_4, LINK_NAME_1);
        this.waitForDestAcls(aclBindings.stream().map(aclBinding -> {
            if (aclBinding.entry().principal().equals("User:2") || aclBinding.entry().principal().equals("User:pool-1")) {
                return aclBinding;
            }
            return this.addLinkId((AclBinding)aclBinding, this.linkId);
        }).collect(Collectors.toSet()));
        srcAdminClient.deleteAcls(Collections.singleton(AclBindingFilter.ANY)).all().get();
        this.waitForDestAcls(aclBindings.subList(0, 4).stream().collect(Collectors.toSet()));
        this.destConfluentAdmin.deleteAcls(Collections.singleton(AclBindingFilter.ANY)).all().get();
    }

    private void updateAclFilterForClusterLink(String aclFilter, String linkName) throws Exception {
        this.destConfluentAdmin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName), Collections.singleton(new AlterConfigOp(new ConfigEntry(ClusterLinkConfig.AclFiltersProp(), aclFilter), AlterConfigOp.OpType.SET)))).all().get(15L, TimeUnit.SECONDS);
    }

    private void waitForDestAcls(Collection<AclBinding> expectedAclBindings) throws Exception {
        TestUtils.waitForCondition(() -> this.equalAclBindings(this.describeAcls(this.destConfluentAdmin, AclBindingFilter.ANY), expectedAclBindings), () -> "expected acls " + expectedAclBindings + " got " + this.describeAcls(this.destConfluentAdmin, AclBindingFilter.ANY));
    }

    private Boolean equalAclBindings(Collection<AclBinding> aclBindings, Collection<AclBinding> expectedAclBindings) {
        return aclBindings.size() == expectedAclBindings.size() && aclBindings.containsAll(expectedAclBindings);
    }

    private Collection<AclBinding> describeAcls(ConfluentAdmin confluentAdmin, AclBindingFilter aclBindingFilter) {
        try {
            return (Collection)confluentAdmin.describeAcls(aclBindingFilter).values().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Uuid createClusterLink(String linkName, String aclFilter) throws ExecutionException, InterruptedException, TimeoutException {
        HashMap<String, String> linkConfigs = new HashMap<String, String>();
        Properties sourceClientProps = KafkaTestUtils.securityProps(this.physicalCluster.bootstrapServers(), SecurityProtocol.SASL_PLAINTEXT, "PLAIN", IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));
        sourceClientProps.stringPropertyNames().forEach(name -> linkConfigs.put((String)name, sourceClientProps.getProperty((String)name)));
        linkConfigs.put("request.timeout.ms", "10000");
        linkConfigs.put("metadata.max.age.ms", "1000");
        linkConfigs.put(ClusterLinkConfig$.MODULE$.AclFiltersProp(), aclFilter);
        linkConfigs.put(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "true");
        linkConfigs.put(ClusterLinkConfig$.MODULE$.AclSyncMsProp(), "100");
        NewClusterLink newClusterLink = new NewClusterLink(linkName, Utils.LC_META_ABC.logicalClusterId(), linkConfigs);
        CreateClusterLinksOptions options = new CreateClusterLinksOptions().validateOnly(false).validateLink(true);
        this.destConfluentAdmin.createClusterLinks(Collections.singleton(newClusterLink), options).all().get();
        return ((ClusterLinkListing)((Collection)this.destConfluentAdmin.listClusterLinks(new ListClusterLinksOptions()).result().get(15L, TimeUnit.SECONDS)).stream().filter(link -> link.linkName().equals(linkName)).iterator().next()).clusterLinkId();
    }

    private AclBinding addLinkId(AclBinding aclBinding, Uuid ... linkIds) {
        ArrayList<Uuid> existingLinkIds = new ArrayList<Uuid>(aclBinding.entry().clusterLinkIds());
        existingLinkIds.addAll(Arrays.asList(linkIds));
        return new AclBinding(aclBinding.pattern(), new AccessControlEntry(aclBinding.entry().principal(), aclBinding.entry().host(), aclBinding.entry().operation(), aclBinding.entry().permissionType(), existingLinkIds));
    }

    private void updateResourceIdInAclConfig(AdminClient adminClient, String value) throws InterruptedException, ExecutionException {
        ConfigResource broker = new ConfigResource(ConfigResource.Type.BROKER, "");
        ConfigEntry entry = new ConfigEntry("multitenant.authorizer.support.resource.ids", value);
        Set<AlterConfigOp> configs = Collections.singleton(new AlterConfigOp(entry, AlterConfigOp.OpType.SET));
        adminClient.createAcls(Collections.singleton(this.topicAcl("u-5"))).all().get();
        adminClient.incrementalAlterConfigs(Collections.singletonMap(broker, configs)).all().get();
        TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((((Collection)adminClient.describeAcls(this.topicFilter("5")).values().get()).size() == (value.equals("true") ? 1 : 0) ? 1 : 0) != 0));
        adminClient.deleteAcls(Collections.singleton(this.topicFilter("u-5"))).all().get();
    }

    private AclCommandBuilder topicAclCommandBuilder(String userId, String topic, String jaasConfig) {
        return this.physicalCluster.newAclCommandWithExternalListener(jaasConfig).addTopicAclArgs(new KafkaPrincipal("User", userId), topic, AclOperation.READ, PatternType.LITERAL);
    }

    private AclBinding topicAcl(String principalName) {
        return this.topicAcl(principalName, "abcd1");
    }

    private AclBinding topicAcl(String principalName, String topicName) {
        return new AclBinding(new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.LITERAL), new AccessControlEntry(new KafkaPrincipal("User", principalName).toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW));
    }

    private AclBindingFilter topicFilter(String principalName) {
        return this.topicFilter(principalName, "User");
    }

    private AclBindingFilter topicFilter(String principalName, String principalType) {
        return new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(new KafkaPrincipal(principalType, principalName).toString(), null, AclOperation.ANY, AclPermissionType.ANY));
    }

    private AclBindingFilter topicFilter(AclOperation aclOperation) {
        return new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(null, null, aclOperation, AclPermissionType.ANY));
    }

    private List<NewTopic> topicsList(String topicName) {
        return Collections.singletonList(new NewTopic(topicName, 3, 1));
    }

    private void loadApiKeys(PhysicalCluster cluster, String fileName, String apiKey) throws Exception {
        BufferedInputStream path;
        try {
            path = (BufferedInputStream)JarResourceLoader.loadFileFromResource(FileBasedPlainSaslAuthenticatorTest.class, (String)fileName).toURI().toURL().getContent();
        }
        catch (IOException e) {
            throw new Exception("Couldn't read apikeys content");
        }
        String apiKeys = org.apache.kafka.common.utils.Utils.readFullyToString((InputStream)path);
        cluster.kafkaCluster().produceApiKeysData("_confluent-apikey", apiKey, apiKeys, true);
    }
}

