/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.server.metrics.ApiSensorBuilder;
import org.apache.kafka.server.metrics.ApiSensors;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TenantMetricsTest {
    private Metrics metrics;

    @BeforeEach
    public void setUp() {
        this.metrics = new Metrics();
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testApiSensorsReinitialized() {
        TenantMetrics tenantMetrics = new TenantMetrics();
        MockTime time = new MockTime();
        MultiTenantPrincipal principal = new MultiTenantPrincipal("user", new TenantMetadata("tenant", "cluster-1"));
        String clientId = "client";
        ApiKeys apiKey = ApiKeys.API_VERSIONS;
        TenantMetrics.MetricsRequestContext ctx = new TenantMetrics.MetricsRequestContext(principal, clientId, apiKey);
        tenantMetrics.recordResponse(this.metrics, ctx, 100L, time.nanoseconds(), Collections.emptyMap(), time.milliseconds());
        Map<Errors, Integer> errors = Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1);
        tenantMetrics.recordResponse(this.metrics, ctx, 100L, time.nanoseconds(), errors, time.milliseconds());
        ApiSensors apiSensors = (ApiSensors)tenantMetrics.apiSensors.get(apiKey);
        Assertions.assertEquals(Collections.emptySet(), (Object)apiSensors.errorsWithoutSensors(this.metrics, errors.keySet()));
        Map responseSensors = new ApiSensorBuilder(this.metrics, (MetricsBuilderContext)ctx, apiKey).getOrCreateSuffixedSensors();
        Map errorSensors = new ApiSensorBuilder(this.metrics, (MetricsBuilderContext)ctx, apiKey).getOrCreateErrorSensors(errors.keySet());
        Assertions.assertFalse((boolean)apiSensors.requestSensorsExpired(this.metrics));
        errorSensors.values().forEach(sensor -> this.metrics.removeSensor(sensor.name()));
        Assertions.assertEquals(errors.keySet(), (Object)((ApiSensors)tenantMetrics.apiSensors.get(apiKey)).errorsWithoutSensors(this.metrics, errors.keySet()));
        responseSensors.values().forEach(sensor -> this.metrics.removeSensor(sensor.name()));
        Assertions.assertTrue((boolean)apiSensors.requestSensorsExpired(this.metrics));
        Assertions.assertTrue((boolean)apiSensors.responseSensorsExpired(this.metrics));
        tenantMetrics.recordResponse(this.metrics, ctx, 100L, time.nanoseconds(), Collections.emptyMap(), time.milliseconds());
        ApiSensors newSensors = (ApiSensors)tenantMetrics.apiSensors.get(apiKey);
        Assertions.assertNotEquals((Object)apiSensors, (Object)newSensors);
        Assertions.assertFalse((boolean)newSensors.requestSensorsExpired(this.metrics));
        Assertions.assertFalse((boolean)newSensors.responseSensorsExpired(this.metrics));
    }
}

