/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.serde;

import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.LogicalClusterMetadata;
import io.confluent.kafka.multitenant.serde.EventsMetadataHeader;
import io.confluent.kafka.multitenant.serde.LogicalClusterMetadataRecord;
import io.confluent.kafka.multitenant.serde.LogicalClusterMetadataRecordDeserializer;
import io.confluent.protobuf.cloud.events.v1.EventsMetadata;
import io.confluent.protobuf.cloud.events.v1.LogicalCluster;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogicalClusterMetadataRecordDeserializerTest {
    private static LogicalClusterMetadataRecordDeserializer deserializer = new LogicalClusterMetadataRecordDeserializer();

    @Test
    public void testDeserialize() throws Exception {
        EventsMetadata em = EventsMetadata.newBuilder().setAppName("foobar").setSequenceId(123456789L).build();
        LogicalCluster lc = LogicalCluster.newBuilder().setAccountId("foo").setLogicalClusterId("lkc-foo").setConfig("blah").setLogicalClusterType("kafka").build();
        Assertions.assertEquals((Object)new LogicalClusterMetadataRecord(EventsMetadataHeader.fromProtobuf((EventsMetadata)em), (LogicalClusterMetadata)KafkaLogicalClusterMetadata.fromProtobuf((LogicalCluster)lc)).toString(), (Object)deserializer.deserialize("foo", (Headers)new RecordHeaders((Header[])new RecordHeader[]{new RecordHeader("eventsmetadata", em.toByteArray())}), lc.toByteArray()).toString());
    }
}

