/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer;

import io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import java.util.Collections;
import java.util.Properties;
import kafka.api.SaslEndToEndAuthorizationTest;
import kafka.server.KafkaConfig$;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestInfoUtils;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;

@Tag(value="bazel:shard_count:4")
public class AclEndToEndAuthorizationTest
extends SaslEndToEndAuthorizationTest {
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Properties serverConfig = this.serverConfig();
        serverConfig.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), ConfluentServerAuthorizer.class.getName());
        if (TestInfoUtils.isKRaft((TestInfo)testInfo)) {
            serverConfig.put("confluent.authorizer.access.rule.providers", ConfluentBuiltInProviders.AccessRuleProviders.KRAFT_ACL.name());
        }
        super.setUp(testInfo);
        this.createScramCredentialsViaPrivilegedAdminClient(JaasTestUtils.KafkaScramUser(), JaasTestUtils.KafkaScramPassword());
        this.createScramCredentialsViaPrivilegedAdminClient(JaasTestUtils.KafkaScramUser2(), JaasTestUtils.KafkaScramPassword2());
    }

    public String kafkaClientSaslMechanism() {
        return "SCRAM-SHA-256";
    }

    public Option<ArrayBuffer<ApiMessageAndVersion>> optionalMetadataRecords() {
        return this.optionalScramMetadataRecords();
    }

    public Admin createPrivilegedAdminClient() {
        return this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.kafkaPrincipal().getName(), JaasTestUtils.KafkaScramAdminPassword());
    }

    public List<String> kafkaServerSaslMechanisms() {
        return JavaConverters.asScalaBuffer(Collections.singletonList("SCRAM-SHA-256")).toList();
    }

    public KafkaPrincipal clientPrincipal() {
        return new KafkaPrincipal("User", JaasTestUtils.KafkaScramUser());
    }

    public KafkaPrincipal kafkaPrincipal() {
        return new KafkaPrincipal("User", JaasTestUtils.KafkaScramAdmin());
    }

    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
        super.configureSecurityBeforeServersStart(testInfo);
        if (!TestInfoUtils.isKRaft((TestInfo)testInfo)) {
            this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
            this.createScramCredentials(this.zkConnect(), this.kafkaPrincipal().getName(), JaasTestUtils.KafkaScramAdminPassword());
        }
    }
}

