/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.token;

import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import io.confluent.kafka.server.plugins.auth.token.TokenBearerServerLoginCallbackHandler;
import io.confluent.kafka.test.utils.TokenTestUtils;
import io.confluent.security.auth.client.rest.RestClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.security.auth.callback.Callback;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TokenBearerServerLoginCallbackHandlerTest {
    private TokenBearerServerLoginCallbackHandler callbackHandler;
    private OAuthBearerToken token;
    private TokenTestUtils.JwsContainer jwsContainer;

    @BeforeEach
    public void setUp() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, "user", "password");
        this.token = new OAuthBearerJwsToken("Token", Collections.emptySet(), -1L, "", Long.valueOf(-1L));
        Function restClientCreator = (Function)Mockito.mock(Function.class);
        RestClient restClient = (RestClient)Mockito.mock(RestClient.class);
        Mockito.when((Object)restClient.login()).thenReturn((Object)this.token);
        Mockito.when(restClientCreator.apply(ArgumentMatchers.any())).thenReturn((Object)restClient);
        this.callbackHandler = new TokenBearerServerLoginCallbackHandler(restClientCreator);
    }

    @Test
    public void testHandleRaisesExceptionIfNotConfigured() throws Exception {
        Assertions.assertThrows(IllegalStateException.class, () -> this.callbackHandler.handle(new Callback[]{new SaslExtensionsCallback()}));
    }

    @Test
    public void testAttachesAuthTokenToCallback() throws Exception {
        OAuthBearerTokenCallback tokenCallback = new OAuthBearerTokenCallback();
        Map<String, Object> jaasConfig = this.buildClientJassConfigText("user", "password", "http://url1.com");
        this.callbackHandler.configure(jaasConfig, "OAUTHBEARER", JaasContext.loadClientContext(jaasConfig).configurationEntries());
        this.callbackHandler.handle(new Callback[]{tokenCallback});
        Assertions.assertEquals((Object)"Token", (Object)tokenCallback.token().value());
    }

    @Test
    public void testNullTokenCallback() throws Exception {
        OAuthBearerTokenCallback tokenCallback = new OAuthBearerTokenCallback();
        Map<String, Object> jaasConfig = this.buildClientJassConfigText(null, null, null);
        this.callbackHandler.configure(jaasConfig, "OAUTHBEARER", JaasContext.loadClientContext(jaasConfig).configurationEntries());
        this.callbackHandler.handle(new Callback[]{tokenCallback});
        Assertions.assertNull((Object)tokenCallback.token());
    }

    private Map<String, Object> buildClientJassConfigText(String user, String pass, String authServer) {
        String jaasConfigText = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required";
        jaasConfigText = jaasConfigText + " publicKeyPath=\"" + this.jwsContainer.getPublicKeyFile().getAbsolutePath() + "\"";
        if (user != null && !user.isEmpty()) {
            jaasConfigText = jaasConfigText + " username=\"" + this.token + "\"";
        }
        if (pass != null && !pass.isEmpty()) {
            jaasConfigText = jaasConfigText + " password=\"" + this.token + "\"";
        }
        if (authServer != null && !authServer.isEmpty()) {
            jaasConfigText = jaasConfigText + " metadataServerUrls=\"" + authServer + '\"';
        }
        jaasConfigText = jaasConfigText + ";";
        HashMap<String, Password> tmp = new HashMap<String, Password>();
        tmp.put("sasl.jaas.config", new Password(jaasConfigText));
        return Collections.unmodifiableMap(tmp);
    }
}

