/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.provider.oauth;

import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import io.confluent.kafka.multitenant.TopicBasedPhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import io.confluent.kafka.server.plugins.auth.oauth.JwtAuthenticatorConfig;
import io.confluent.kafka.server.plugins.auth.oauth.MockBasicAuthStore;
import io.confluent.kafka.server.plugins.auth.oauth.MockTrustCache;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthUtils;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.kafka.util.ClientContext;
import io.confluent.security.auth.provider.oauth.EnhancedOAuthBearerValidatorCallbackHandler;
import io.confluent.security.authentication.AuthenticationException;
import io.confluent.security.authentication.credential.BearerCredential;
import io.confluent.security.authentication.oauthbearer.MockJwtSource;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.config.ConfigurationException;
import io.confluent.security.store.KeyValueStore;
import io.confluent.security.test.utils.JwtTestUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import kafka.server.KafkaConfig;
import kafka.test.JarResourceLoader;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.test.TestUtils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class EnhancedOAuthBearerValidatorCallbackHandlerTest {
    private final Scope orgA = new Scope.Builder(new String[]{"org=OrgA"}).build();
    private final String jwtIssuerA = "https://test-issuer-a.com";
    private final String jwksEndpointA = "https://test-issuer-a.com/json.jwks";
    private final String httpsIssuer = "https://vault.cireops.gcp.internal.confluent.cloud/v1/identity/oidc";
    private static final List<String> ALLOWED_LOGICAL_CLUSTERS = Collections.singletonList(Utils.LC_META_ABC.logicalClusterId());
    private static final String ORG_RESOURCE_ID = Utils.LC_META_ABC.organizationId();
    private static final OAuthBearerJwsToken TOKEN_MOCK = new OAuthBearerJwsToken("", new HashSet<String>(ALLOWED_LOGICAL_CLUSTERS), 0L, "", Long.valueOf(0L), Collections.singletonMap("orgResourceId", ORG_RESOURCE_ID), "Confluent");
    private static final OAuthBearerJwsToken INVALID_ORG_TOKEN_MOCK = new OAuthBearerJwsToken("", new HashSet<String>(ALLOWED_LOGICAL_CLUSTERS), 0L, "", Long.valueOf(0L), Collections.singletonMap("orgResourceId", "org_1"), "Confluent");
    private static final OAuthBearerJwsToken NON_CONFLUENT_TOKEN_MOCK = new OAuthBearerJwsToken("", new HashSet<String>(ALLOWED_LOGICAL_CLUSTERS), 0L, "", Long.valueOf(0L), Collections.singletonMap("orgResourceId", ORG_RESOURCE_ID), "SomeoneElse");
    private JsonWebKeySet jwks = new JsonWebKeySet(new JsonWebKey[0]);
    private static final String DEFAULT_ISSUER = "Confluent";
    private static final String DEFAULT_SUBJECT = "Customer";
    private static final String SPIRE_SUBJECT_1 = "spiffe://" + MockJwtSource.SPIRE_TRUST_DOMAIN_1 + "/test-workload";
    private MockBasicAuthStore authStore;
    private MockTrustCache authCache;
    private Map<String, Object> configs;
    private String brokerUUID;
    private OAuthUtils.JwsContainer jwsContainer;
    private TopicBasedPhysicalClusterMetadata metadata;

    private static JwtClaims mockJwtClaims(String issuer) {
        JwtClaims jwtClaims = new JwtClaims();
        jwtClaims.setIssuer(issuer);
        jwtClaims.setIssuedAt(NumericDate.fromMilliseconds((long)0L));
        jwtClaims.setExpirationTime(NumericDate.fromMilliseconds((long)0L));
        return jwtClaims;
    }

    private static JwtClaims mockAuthServiceJwtClaims(List<String> clusters) {
        JwtClaims jwtClaims = EnhancedOAuthBearerValidatorCallbackHandlerTest.mockJwtClaims(DEFAULT_ISSUER);
        jwtClaims.setClaim("clusters", clusters);
        return jwtClaims;
    }

    @BeforeEach
    public void setUp() throws Exception {
        KafkaTestUtils.verifyThreadCleanup();
        this.createAuthStore();
        this.brokerUUID = "uuid";
        this.configs = new HashMap<String, Object>();
        this.configs.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        this.initiateTopicBasedPhysicalClusterMetadata(this.configs);
    }

    private void initiateTopicBasedPhysicalClusterMetadata(Map<String, Object> configs) {
        this.metadata = (TopicBasedPhysicalClusterMetadata)Mockito.mock(TopicBasedPhysicalClusterMetadata.class);
        ((TopicBasedPhysicalClusterMetadata)Mockito.doCallRealMethod().when((Object)this.metadata)).configure((Map)ArgumentMatchers.any(Map.class));
        ((TopicBasedPhysicalClusterMetadata)Mockito.doCallRealMethod().when((Object)this.metadata)).getSessionUuid((Map)ArgumentMatchers.any(Map.class));
        ((TopicBasedPhysicalClusterMetadata)Mockito.doCallRealMethod().when((Object)this.metadata)).close((String)ArgumentMatchers.any(String.class));
        try {
            this.metadata.configure(configs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Mockito.when((Object)this.metadata.metadata(Utils.LC_META_ABC.logicalClusterId())).thenReturn((Object)Utils.LC_META_ABC);
    }

    @AfterEach
    public void tearDown() {
        this.metadata.close(this.brokerUUID);
        if (this.authStore != null) {
            this.authStore.close();
        }
        KafkaTestUtils.verifyThreadCleanup();
    }

    @Test
    public void testAttachJwsWithPropertyConfig() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, "https://test-issuer-a.com", DEFAULT_SUBJECT, ORG_RESOURCE_ID).withKid(true).build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("");
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        RsaJsonWebKey key = new RsaJsonWebKey((RSAPublicKey)this.jwsContainer.verificationKey());
        key.setKeyId(this.jwsContainer.getKid());
        this.jwks.addJsonWebKey((JsonWebKey)key);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"", (JsonWebKeySet)this.jwks);
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.token());
        Assertions.assertEquals((Object)this.jwsContainer.getJwsToken(), (Object)callback.token().value());
        Assertions.assertNull((Object)callback.errorStatus());
    }

    @Test
    public void testAttachJwsWithJwksEndpointWithPropertyConfig() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, "https://test-issuer-a.com", DEFAULT_SUBJECT, ORG_RESOURCE_ID).withKid(true).build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("");
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        callback.context().add("jwksEndpoint", (Object)"https://test-issuer-a.com/json.jwks");
        RsaJsonWebKey key = new RsaJsonWebKey((RSAPublicKey)this.jwsContainer.verificationKey());
        key.setKeyId(this.jwsContainer.getKid());
        this.jwks.addJsonWebKey((JsonWebKey)key);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)this.jwks);
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.token());
        Assertions.assertEquals((Object)this.jwsContainer.getJwsToken(), (Object)callback.token().value());
        Assertions.assertNull((Object)callback.errorStatus());
    }

    @Test
    public void testAttachJws() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, "https://test-issuer-a.com", DEFAULT_SUBJECT, ORG_RESOURCE_ID).withKid(true).build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        RsaJsonWebKey key = new RsaJsonWebKey((RSAPublicKey)this.jwsContainer.verificationKey());
        key.setKeyId(this.jwsContainer.getKid());
        this.jwks.addJsonWebKey((JsonWebKey)key);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"", (JsonWebKeySet)this.jwks);
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.token());
        Assertions.assertEquals((Object)this.jwsContainer.getJwsToken(), (Object)callback.token().value());
        Assertions.assertNull((Object)callback.errorStatus());
    }

    @Test
    public void testPopulatesInvalidExtensionsWhenNoLogicalClusterMetadata() throws Exception {
        this.deleteLogicalClusterMetadata();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", Utils.LC_META_ABC.logicalClusterId());
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToLogicalClusterNotMatched(callback);
    }

    @Test
    public void testLogicalClusterExtensionsValidatedWhenTheyMatchTokensLogicalClusterAndIsHostedOnBroker() throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifySuccessfulAuthentication(callback);
    }

    @Test
    public void testLogicalClusterExtensionsValidatedWhenTheyStartWithPkcLegacySniValidationMode() throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml", SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", "pkc-wrong-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifySuccessfulAuthentication(callback);
    }

    @Test
    public void testLogicalClusterExtensionsValidatedWhenTheyMatchTokensLogicalClusterLegacySniValidationMode() throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml", SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", Utils.LC_META_ABC.logicalClusterId() + "-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifySuccessfulAuthentication(callback);
    }

    @Test
    public void testLogicalClusterNoBelongToOrg() throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml", SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", Utils.LC_META_ABC.logicalClusterId() + "-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)INVALID_ORG_TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToLogicalClusterNotMatched(callback);
    }

    @Test
    public void testLogicalClusterExtensionsFailedWhenNotProvidedLegacySniValidationMode() throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml", SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", null);
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToSniHostNameNotMatched(callback);
    }

    @Test
    public void testLogicalClusterExtensionsFailedWhenTheyNotMatchTokensLogicalClusterLegacySniValidationModeConfluentIssuer() throws Exception {
        this.testLogicalClusterExtensionsFailedWhenTheyNotMatchTokensLogicalClusterLegacySniValidationMode(TOKEN_MOCK);
    }

    @Test
    public void testLogicalClusterExtensionsFailedWhenTheyNotMatchTokensLogicalClusterLegacySniValidationModeNonConfluentIssuer() throws Exception {
        this.testLogicalClusterExtensionsFailedWhenTheyNotMatchTokensLogicalClusterLegacySniValidationMode(NON_CONFLUENT_TOKEN_MOCK);
    }

    private void testLogicalClusterExtensionsFailedWhenTheyNotMatchTokensLogicalClusterLegacySniValidationMode(OAuthBearerJwsToken token) throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml", SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", "lkc-wrong-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)token, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToSniHostNameNotMatched(callback);
    }

    @Test
    public void testLogicalClusterExtensionsValidatedWhenTheyMatchTokensLogicalClusterStrictSniValidationMode() throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml", SniValidationMode.STRICT);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", Utils.LC_META_ABC.logicalClusterId() + "-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifySuccessfulAuthentication(callback);
    }

    @Test
    public void testLogicalClusterExtensionsValidatedWhenMissingSubjectWithNoConfluentIssuer() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, "https://test-issuer-a.com", null, ORG_RESOURCE_ID).withKid(true).build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        RsaJsonWebKey key = new RsaJsonWebKey((RSAPublicKey)this.jwsContainer.verificationKey());
        key.setKeyId(this.jwsContainer.getKid());
        this.jwks.addJsonWebKey((JsonWebKey)key);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)this.jwks);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifySuccessfulAuthentication(callback);
    }

    @Test
    public void testLogicalClusterExtensionsFailedWhenSNIHostNameNotMatchingStrictSniValidationModeConfluentIssuer() throws Exception {
        this.testLogicalClusterExtensionsFailedWhenSNIHostNameNotMatchingStrictSniValidationMode(TOKEN_MOCK);
    }

    @Test
    public void testLogicalClusterExtensionsFailedWhenSNIHostNameNotMatchingStrictSniValidationModeNonConfluentIssuer() throws Exception {
        this.testLogicalClusterExtensionsFailedWhenSNIHostNameNotMatchingStrictSniValidationMode(NON_CONFLUENT_TOKEN_MOCK);
    }

    private void testLogicalClusterExtensionsFailedWhenSNIHostNameNotMatchingStrictSniValidationMode(OAuthBearerJwsToken token) throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml", SniValidationMode.STRICT);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", "lkc-wrong-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)token, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToSniHostNameNotMatched(callback);
    }

    @Test
    public void testRaisesJwtExceptionIfMissingSubjectForConfluentIssuer() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, DEFAULT_ISSUER, null, ORG_RESOURCE_ID).withKid(true).build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        RsaJsonWebKey key = new RsaJsonWebKey((RSAPublicKey)this.jwsContainer.verificationKey());
        key.setKeyId(this.jwsContainer.getKid());
        this.jwks.addJsonWebKey((JsonWebKey)key);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)this.jwks);
        Exception exception = (Exception)Assertions.assertThrows(AuthenticationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken(), new ClientContext()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("InvalidJwtException"));
    }

    @Test
    public void testLogicalClusterExtensionsFailedWhenSNIHostNameIsNotSuppliedStrictSniValidationModeConfluentIssuer() throws Exception {
        this.testLogicalClusterExtensionsFailedWhenSNIHostNameIsNotSuppliedStrictSniValidationMode(TOKEN_MOCK);
    }

    @Test
    public void testLogicalClusterExtensionsFailedWhenSNIHostNameIsNotSuppliedStrictSniValidationModeNonConfluentIssuer() throws Exception {
        this.testLogicalClusterExtensionsFailedWhenSNIHostNameIsNotSuppliedStrictSniValidationMode(NON_CONFLUENT_TOKEN_MOCK);
    }

    private void testLogicalClusterExtensionsFailedWhenSNIHostNameIsNotSuppliedStrictSniValidationMode(OAuthBearerJwsToken token) throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml", SniValidationMode.STRICT);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", null);
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)token, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToSniHostNameNotMatched(callback);
    }

    @Test
    public void testPopulatesInvalidExtensionsWhenLogicalClusterIsNotHostedOnBroker() throws Exception {
        List<String> allowedLogicalClusters = Collections.singletonList("cp12");
        OAuthBearerJwsToken tokenMock = new OAuthBearerJwsToken("", new HashSet<String>(allowedLogicalClusters), 0L, "", Long.valueOf(0L));
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", allowedLogicalClusters.get(0));
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)tokenMock, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToLogicalClusterNotMatched(callback);
    }

    @Test
    public void testConfigureRaisesExceptionWhenInvalidPhysicalMetadataInstance() throws Exception {
        this.configs.put("broker.session.uuid", "made-up");
        Assertions.assertThrows(ConfigurationException.class, () -> this.createCallbackHandler("AuthConfig.yaml"));
    }

    @Test
    public void testRaisesJwtExceptionWhenInvalidJws() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, "https://test-issuer-a.com", DEFAULT_SUBJECT, ORG_RESOURCE_ID).withKid(true).build();
        RsaJsonWebKey key = new RsaJsonWebKey((RSAPublicKey)this.jwsContainer.verificationKey());
        key.setKeyId(this.jwsContainer.getKid());
        this.jwks.addJsonWebKey((JsonWebKey)key);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)this.jwks);
        this.jwsContainer = new OAuthUtils.Builder(36000, "https://test-issuer-a.com", DEFAULT_SUBJECT, ORG_RESOURCE_ID).withKid(true).build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        Exception exception = (Exception)Assertions.assertThrows(AuthenticationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken(), new ClientContext()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("UnresolvableKeyException"));
    }

    @Test
    public void testRaisesJwtExceptionWhenExpiredJws() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(50, "https://test-issuer-a.com", DEFAULT_SUBJECT, ORG_RESOURCE_ID).withKid(true).build();
        Thread.sleep(100L);
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        RsaJsonWebKey key = new RsaJsonWebKey((RSAPublicKey)this.jwsContainer.verificationKey());
        key.setKeyId(this.jwsContainer.getKid());
        this.jwks.addJsonWebKey((JsonWebKey)key);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)this.jwks);
        Exception exception = (Exception)Assertions.assertThrows(AuthenticationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken(), new ClientContext()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("InvalidJwtException"));
    }

    @Test
    public void testRaisesJwtExceptionIfNoExpirationTime() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(null, "https://test-issuer-a.com", DEFAULT_SUBJECT, ORG_RESOURCE_ID).withKid(true).build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        RsaJsonWebKey key = new RsaJsonWebKey((RSAPublicKey)this.jwsContainer.verificationKey());
        key.setKeyId(this.jwsContainer.getKid());
        this.jwks.addJsonWebKey((JsonWebKey)key);
        JwtTestUtils.updateJwks((KeyValueStore)this.authCache, (String)"https://test-issuer-a.com", (String)"https://test-issuer-a.com/json.jwks", (JsonWebKeySet)this.jwks);
        Exception exception = (Exception)Assertions.assertThrows(AuthenticationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken(), new ClientContext()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("InvalidJwtException"));
    }

    @Test
    public void testKeyResolverHttps() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(3600, "https://vault.cireops.gcp.internal.confluent.cloud/v1/identity/oidc", DEFAULT_SUBJECT, ORG_RESOURCE_ID).withKid(true).build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        Exception exception = (Exception)Assertions.assertThrows(AuthenticationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken(), new ClientContext()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("UnresolvableKeyException"));
    }

    @Test
    public void testKeyResolverHttpsNoJwksUri() throws Exception {
        Exception exception = (Exception)Assertions.assertThrows(ConfigurationException.class, () -> this.createCallbackHandler("AuthConfig1.yaml"));
        Assertions.assertTrue((boolean)exception.getCause().getMessage().contains("jwksUri must not be null"));
    }

    @Test
    public void testKeyResolverJku() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(3600, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).withKid(true).build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        Exception exception = (Exception)Assertions.assertThrows(AuthenticationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken(), new ClientContext()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("KeyConstraintException"));
    }

    @Test
    public void testNullSpireAgentEndpoint() {
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> this.createCallbackHandler("AuthConfigSpireInvalid.yaml"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("spireAgentSocketEndpoint must be non null"));
    }

    @Test
    public void testKeyResolverSpireFailure() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(3600, "test.prefix.spire.internal.confluent.cloud", SPIRE_SUBJECT_1, ORG_RESOURCE_ID).withKid(true).build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("");
        Exception exception = (Exception)Assertions.assertThrows(AuthenticationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken(), new ClientContext()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("UnresolvableKeyException"));
    }

    @Test
    public void testKeyResolverSpireSuccess() throws Exception {
        JwtClaims claims = new JwtClaims();
        claims.setIssuer("test.prefix.spire.internal.confluent.cloud");
        claims.setAudience(MockJwtSource.VALID_AUD);
        claims.setSubject("spiffe://" + MockJwtSource.SPIRE_TRUST_DOMAIN_1 + "/test-workload-client");
        claims.setExpirationTimeMinutesInTheFuture(60.0f);
        claims.setIssuedAt(NumericDate.now());
        BearerCredential bearerCredential = MockJwtSource.createEncodedJws((MockJwtSource.Kid)MockJwtSource.Kid.RSA_SPIRE_1, (JwtClaims)claims);
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("");
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(bearerCredential.bearerToken());
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertEquals((Object)bearerCredential.bearerToken(), (Object)callback.token().value());
        Assertions.assertNotNull((Object)callback.token());
        Assertions.assertNull((Object)callback.errorStatus());
    }

    @Test
    public void testKeyResolverJkuNoWhiteList() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(3600, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).withKid(true).jku(DEFAULT_ISSUER).build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        Exception exception = (Exception)Assertions.assertThrows(AuthenticationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken(), new ClientContext()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("KeyConstraintException"));
    }

    @Test
    public void testKeyResolverJkuEmptyWhiteList() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(3600, "Confluent1", DEFAULT_SUBJECT, ORG_RESOURCE_ID).withKid(true).jku("Confluent1").build();
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        Exception exception = (Exception)Assertions.assertThrows(AuthenticationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken(), new ClientContext()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("KeyConstraintException"));
    }

    @Test
    public void testIdentityPoolExtensionValidation() throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("identityPoolId", "identity_pool_1");
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("iss", "Google");
        claims.put("sub", "User-1");
        OAuthBearerJwsToken token = new OAuthBearerJwsToken("", new HashSet<String>(ALLOWED_LOGICAL_CLUSTERS), 0L, "", Long.valueOf(0L), claims, "Google");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)token, new SaslExtensions(extensions));
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)"identity_pool_1", (int)1, (String)"Google", (String)"google.com/jwks.json", (String)"sub", (String)"serviceAccount-1", (String)"claims.iss == \"Google\"", (String)"my-org2");
        callbackHandler.handle(new Callback[]{callback});
        this.verifySuccessfulExtensionAuthorization(callback, "serviceAccount-1", "User-1");
    }

    @Test
    public void testIdentityPoolExtensionValidationSubjectAsList() throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("identityPoolId", "identity_pool_1");
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("iss", "Google");
        claims.put("sub", Arrays.asList("a", "b"));
        OAuthBearerJwsToken token = new OAuthBearerJwsToken("", new HashSet<String>(ALLOWED_LOGICAL_CLUSTERS), 0L, "", Long.valueOf(0L), claims, "Google");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)token, new SaslExtensions(extensions));
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)"identity_pool_1", (int)1, (String)"Google", (String)"google.com/jwks.json", (String)"sub", (String)"serviceAccount-1", (String)"claims.sub==[\"a\", \"b\"]", (String)"my-org2");
        callbackHandler.handle(new Callback[]{callback});
        this.verifySuccessfulExtensionAuthorization(callback, "serviceAccount-1", "[a, b]");
    }

    @Test
    public void testIdentityPoolExtensionValidationIssClaimFailure() throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("identityPoolId", "identity_pool_1");
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("iss", "Google");
        OAuthBearerJwsToken token = new OAuthBearerJwsToken("", new HashSet<String>(ALLOWED_LOGICAL_CLUSTERS), 0L, "", Long.valueOf(0L), claims, "Google");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)token, new SaslExtensions(extensions));
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)"identity_pool_1", (int)1, (String)"Google", (String)"google.com/jwks.json", (String)"sub", (String)"serviceAccount-1", (String)"claims.iss == \"Amazon\"", (String)"my-org2");
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedExtensionAuthorization(callback);
    }

    @Test
    public void testIdentityPoolExtensionValidationOrgIdFailure() throws Exception {
        EnhancedOAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler("AuthConfig.yaml");
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("identityPoolId", "identity_pool_1");
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("iss", "Google");
        OAuthBearerJwsToken token = new OAuthBearerJwsToken("", new HashSet<String>(ALLOWED_LOGICAL_CLUSTERS), 0L, "", Long.valueOf(0L), claims, "Google");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)token, new SaslExtensions(extensions));
        JwtTestUtils.updateIdentityPool((KeyValueStore)this.authCache, (String)"identity_pool_1", (int)1, (String)"Google", (String)"google.com/jwks.json", (String)"User-1", (String)"serviceAccount-1", (String)"claims.iss == \"Google\"", (String)"my-org3");
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedExtensionAuthorization(callback);
    }

    private void deleteLogicalClusterMetadata() {
        Mockito.when((Object)this.metadata.metadata(Utils.LC_META_ABC.logicalClusterId())).thenReturn(null);
    }

    private void verifySuccessfulAuthentication(OAuthBearerExtensionsValidatorCallback callback) {
        Assertions.assertTrue((boolean)callback.invalidExtensions().isEmpty());
        Assertions.assertTrue((boolean)callback.errorMessage().isEmpty());
    }

    private void verifyFailedAuthenticationDueToSniHostNameNotMatched(OAuthBearerExtensionsValidatorCallback callback) {
        Assertions.assertFalse((boolean)callback.invalidExtensions().isEmpty());
        Assertions.assertNotNull(callback.invalidExtensions().get("__confluent_sni_broker_host_name"));
        Assertions.assertFalse((boolean)callback.errorMessage().isEmpty());
    }

    private void verifyFailedAuthenticationDueToLogicalClusterNotMatched(OAuthBearerExtensionsValidatorCallback callback) {
        Assertions.assertFalse((boolean)callback.invalidExtensions().isEmpty());
        Assertions.assertNotNull(callback.invalidExtensions().get("logicalCluster"));
        Assertions.assertFalse((boolean)callback.errorMessage().isEmpty());
    }

    private void verifySuccessfulExtensionAuthorization(OAuthBearerExtensionsValidatorCallback callback, String expectedSub, String expectedAzp) {
        Assertions.assertTrue((boolean)callback.invalidExtensions().isEmpty());
        Assertions.assertEquals((Object)expectedSub, callback.validatedExtensions().get("identityPoolId-sub"));
        Assertions.assertEquals((Object)expectedAzp, callback.validatedExtensions().get("identityPoolId-azp"));
        Assertions.assertTrue((boolean)callback.errorMessage().isEmpty());
    }

    private void verifyFailedExtensionAuthorization(OAuthBearerExtensionsValidatorCallback callback) {
        Assertions.assertFalse((boolean)callback.invalidExtensions().isEmpty());
        Assertions.assertTrue((boolean)callback.errorMessage().contains("do not match Identity Pool"));
    }

    private void createAuthStore() throws Exception {
        this.authStore = MockBasicAuthStore.create();
        this.authCache = (MockTrustCache)this.authStore.trustCache();
    }

    private EnhancedOAuthBearerValidatorCallbackHandler createCallbackHandler(String configureUrl) {
        return this.createCallbackHandler(configureUrl, SniValidationMode.OPTIONAL_VALIDATION);
    }

    private EnhancedOAuthBearerValidatorCallbackHandler createCallbackHandler(String configureUrl, SniValidationMode mode) {
        return this.createCallbackHandler(new EnhancedOAuthBearerValidatorCallbackHandler(), configureUrl, mode);
    }

    private <T extends AuthenticateCallbackHandler> T createCallbackHandler(T callbackHandler, String configureUrl, SniValidationMode mode) {
        TestJaasConfig config = new TestJaasConfig();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("sni_host_name_validation_mode", mode.getText());
        if (configureUrl.isEmpty()) {
            options.put("authenticator.jwt.kind", "jwt");
            options.put("authenticator.jwt.algorithmWhitelist.1", "RS256");
            options.put("authenticator.jwt.spireAgentSocketEndpoint", "tcp://0.0.0.0:31523");
            options.put("authenticator.jwt.issuers.1.name", "*");
            options.put("authenticator.jwt.issuers.1.verifier", "io.confluent.security.auth.dataplane.JwtIssuerAuthCache");
            options.put("authenticator.jwt.issuers.2.name", DEFAULT_ISSUER);
            options.put("authenticator.jwt.issuers.2.verifier", "io.confluent.security.authentication.oauthbearer.JwtIssuerJku");
            options.put("authenticator.jwt.issuers.3.name", "Confluent1");
            options.put("authenticator.jwt.issuers.3.verifier", "io.confluent.security.authentication.oauthbearer.JwtIssuerJku");
            options.put("authenticator.jwt.issuers.4.name", "https://vault.cireops.gcp.internal.confluent.cloud/v1/identity/oidc");
            options.put("authenticator.jwt.issuers.4.verifier", "io.confluent.security.authentication.oauthbearer.JwtIssuerJwks");
            options.put("authenticator.jwt.issuers.4.jwksUri", "https://vault.cireops.gcp.internal.confluent.cloud/v1/identity/oidc/.well-known/keys");
            options.put("authenticator.jwt.issuers.4.audience.1", "C82RLLokthIFn4v4sDYKpJbksC");
            options.put("authenticator.jwt.issuers.4.audience.2", "z2OPfk0pavN7Xj0UElTUaR1Xqt");
            options.put("authenticator.jwt.issuers.5.name", "test.prefix.spire.internal.confluent.cloud");
            options.put("authenticator.jwt.issuers.5.verifier", "io.confluent.security.authentication.oauthbearer.MockJwtIssuerSpire");
        } else {
            File configFile = null;
            try {
                URL configResource = Objects.requireNonNull(JarResourceLoader.loadFileFromResourceWithClassLoader(EnhancedOAuthBearerValidatorCallbackHandlerTest.class, (String)configureUrl).toURI().toURL());
                configFile = TestUtils.tempFile();
                Files.copy(configResource.openStream(), Paths.get(configFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            options.put(JwtAuthenticatorConfig.JWT_AUTHENTICATOR_CONFIG_URL, configFile.getAbsolutePath());
        }
        config.createOrUpdateEntry("Kafka", OAuthBearerLoginModule.class.getCanonicalName(), options);
        callbackHandler.configure(this.configs, "OAUTHBEARER", Collections.singletonList(config.getAppConfigurationEntry("Kafka")[0]));
        return callbackHandler;
    }
}

