/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push.metrics;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.replication.push.PushSessionEndReason;
import io.confluent.kafka.replication.push.metrics.ReplicationQuotaRecorder;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.AppendRecordsRequestData;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;

public class PushReplicationManagerMetrics
implements AutoCloseable {
    public static final String METRIC_GROUP_NAME = "io.confluent.kafka.replication";
    public static final String METRIC_TYPE_NAME = "PushReplication";
    public static final String EVENT_PROCESSING_FAILURE = "EventProcessingFailure";
    public static final String EVENT_QUEUE_PROCESSING_TIME_MS = "EventQueueProcessingTimeMs";
    public static final String PUSH_MANAGER_MEMORY_BYTES_USED = "PushManagerMemoryBytesUsed";
    public static final String PUSH_SESSION_END_COUNT = "PushSessionEndCount";
    public static final String STOPPING_PUSH_SESSIONS = "StoppingPushSessions";
    private static final KafkaMetricsGroup METRIC_GROUP = new KafkaMetricsGroup(PushReplicationManagerMetrics.class){

        public MetricName metricName(String name, Map<String, String> tags) {
            return KafkaMetricsGroup.explicitMetricName((String)PushReplicationManagerMetrics.METRIC_GROUP_NAME, (String)PushReplicationManagerMetrics.METRIC_TYPE_NAME, (String)name, tags);
        }
    };
    private final Meter replicationBytesOutMeter;
    private final ReplicationQuotaRecorder replicationQuotaRecorder;
    private final Counter eventProcessingFailure;
    private final Histogram eventQueueProcessingTime;
    private final Map<PushSessionEndReason, Counter> pushSessionEndReasonMeterMap;
    private final Set<Supplier<Integer>> stoppingPushSessionsSupplier;

    public PushReplicationManagerMetrics(Meter replicationBytesOutMeter, ReplicationQuotaRecorder replicationQuotaRecorder) {
        this.replicationBytesOutMeter = replicationBytesOutMeter;
        this.replicationQuotaRecorder = replicationQuotaRecorder;
        this.eventProcessingFailure = METRIC_GROUP.newCounter(EVENT_PROCESSING_FAILURE);
        this.eventQueueProcessingTime = METRIC_GROUP.newHistogram(EVENT_QUEUE_PROCESSING_TIME_MS);
        this.pushSessionEndReasonMeterMap = new EnumMap<PushSessionEndReason, Counter>(PushSessionEndReason.class);
        for (PushSessionEndReason pushSessionEndReason : PushSessionEndReason.values()) {
            this.pushSessionEndReasonMeterMap.put(pushSessionEndReason, METRIC_GROUP.newCounter(PUSH_SESSION_END_COUNT, Collections.singletonMap("reason", pushSessionEndReason.name())));
        }
        this.stoppingPushSessionsSupplier = ConcurrentHashMap.newKeySet();
        METRIC_GROUP.newGauge(STOPPING_PUSH_SESSIONS, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return PushReplicationManagerMetrics.this.stoppingPushSessionsSupplier.stream().mapToInt(Supplier::get).sum();
            }
        });
    }

    public void recordAppendRecordsRequest(AppendRecordsRequestData requestData) {
        long totalRecordBytes = 0L;
        for (AppendRecordsRequestData.TopicData topicData : requestData.topics()) {
            Uuid topicId = topicData.topicId();
            for (AppendRecordsRequestData.PartitionData partitionData : topicData.partitions()) {
                long recordSize = partitionData.records().sizeInBytes();
                if (recordSize <= 0L) continue;
                totalRecordBytes += recordSize;
                this.replicationQuotaRecorder.recordPartitionBytesOut(topicId, partitionData.partitionIndex(), recordSize);
            }
        }
        this.replicationBytesOutMeter.mark(totalRecordBytes);
    }

    public void updateEventQueueProcessingTime(long queueTimeMs) {
        this.eventQueueProcessingTime.update(queueTimeMs);
    }

    public void incrementPushSessionEndCount(PushSessionEndReason pushSessionEndReason) {
        this.pushSessionEndReasonMeterMap.get((Object)pushSessionEndReason).inc();
    }

    public void incrementEventProcessingFailureCount() {
        this.eventProcessingFailure.inc();
    }

    public void registerMemoryBytesUsedGauge(Gauge<Long> memoryBytesUsedGauge) {
        METRIC_GROUP.newGauge(PUSH_MANAGER_MEMORY_BYTES_USED, memoryBytesUsedGauge);
    }

    public void registerStoppingPushSessionSupplier(Supplier<Integer> supplier) {
        this.stoppingPushSessionsSupplier.add(supplier);
    }

    @Override
    public void close() {
        METRIC_GROUP.removeMetric(EVENT_PROCESSING_FAILURE);
        METRIC_GROUP.removeMetric(EVENT_QUEUE_PROCESSING_TIME_MS);
        METRIC_GROUP.removeMetric(PUSH_MANAGER_MEMORY_BYTES_USED);
        this.pushSessionEndReasonMeterMap.forEach((pushSessionEndReason, counter) -> METRIC_GROUP.removeMetric(PUSH_SESSION_END_COUNT, Collections.singletonMap("reason", pushSessionEndReason.name())));
        METRIC_GROUP.removeMetric(STOPPING_PUSH_SESSIONS);
    }
}

