/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java;

import com.api.jsonata4java.JSONataUtils;
import com.api.jsonata4java.expressions.EvaluateException;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.Expressions;
import com.api.jsonata4java.expressions.ParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class TesterTimeBox
implements Serializable {
    private static final long serialVersionUID = -6162778154105939338L;
    static String json = "{\n  \"Account\": {\n    \"Account Name\": \"Firefly\",\n    \"Order\": [\n      {\n        \"OrderID\": \"order103\",\n        \"Product\": [\n          {\n            \"Product Name\": \"Bowler Hat\",\n            \"ProductID\": 858383,\n            \"SKU\": \"0406654608\",\n            \"Description\": {\n              \"Colour\": \"Purple\",\n              \"Width\": 300,\n              \"Height\": 200,\n              \"Depth\": 210,\n              \"Weight\": 0.75\n            },\n            \"Price\": 34.45,\n            \"Quantity\": 2\n          },\n          {\n            \"Product Name\": \"Trilby hat\",\n            \"ProductID\": 858236,\n            \"SKU\": \"0406634348\",\n            \"Description\": {\n              \"Colour\": \"Orange\",\n              \"Width\": 300,\n              \"Height\": 200,\n              \"Depth\": 210,\n              \"Weight\": 0.6\n            },\n            \"Price\": 21.67,\n            \"Quantity\": 1\n          }\n        ]\n      },\n      {\n        \"OrderID\": \"order104\",\n        \"Product\": [\n          {\n            \"Product Name\": \"Bowler Hat\",\n            \"ProductID\": 858383,\n            \"SKU\": \"040657863\",\n            \"Description\": {\n              \"Colour\": \"Purple\",\n              \"Width\": 300,\n              \"Height\": 200,\n              \"Depth\": 210,\n              \"Weight\": 0.75\n            },\n            \"Price\": 34.45,\n            \"Quantity\": 4\n          },\n          {\n            \"ProductID\": 345664,\n            \"SKU\": \"0406654603\",\n            \"Product Name\": \"Cloak\",\n            \"Description\": {\n              \"Colour\": \"Black\",\n              \"Width\": 30,\n              \"Height\": 20,\n              \"Depth\": 210,\n              \"Weight\": 2\n            },\n            \"Price\": 107.99,\n            \"Quantity\": 1\n          }\n        ]\n      }\n    ]\n  }\n}\n";

    public static void main(String[] args) {
        String expression;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonObj = null;
        try {
            jsonObj = mapper.readTree(json);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (args.length > 0) {
            File file = new File(args[0]);
            System.out.println("Attempting to load JSON from file: " + args[0]);
            try {
                jsonObj = mapper.readTree(file);
            }
            catch (JsonProcessingException e) {
                System.err.println(e.getLocalizedMessage());
            }
            catch (IOException e) {
                System.err.println(e.getLocalizedMessage());
            }
        }
        try {
            System.out.println("Using json:\n" + mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObj));
        }
        catch (JsonProcessingException e1) {
            e1.printStackTrace();
        }
        int maxDepth = 100;
        long timeoutMS = 5000L;
        boolean checkRuntime = false;
        String test = JSONataUtils.prompt("Do you wish to timebox your expressions? (Y/n):");
        if (test.toUpperCase().startsWith("Y")) {
            checkRuntime = true;
        }
        if (checkRuntime) {
            while (true) {
                test = JSONataUtils.prompt("Enter the maximum call depth (" + maxDepth + "):");
                try {
                    int val = Integer.parseInt(test);
                    if (val > 0) {
                        maxDepth = val;
                        break;
                    }
                    System.out.println("Maximum call depth must be a positive integer. Try again.");
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Maximum call depth must be a positive integer. Try again.");
                }
            }
            while (true) {
                test = JSONataUtils.prompt("Enter the maximum milliseconds to allow to run (" + timeoutMS + "):");
                try {
                    long val = Long.parseLong(test);
                    if (val > 0L) {
                        timeoutMS = val;
                        break;
                    }
                    System.out.println("Maximum milliseconds must be a positive number. Try again.");
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Maximum milliseconds must be a positive number. Try again.");
                }
            }
        }
        while ((expression = JSONataUtils.prompt("Enter jsonata expression (or q to quit):")).length() != 0 && !"q".equalsIgnoreCase(expression)) {
            Expressions expr = null;
            try {
                expr = Expressions.parse(expression);
            }
            catch (ParseException e) {
                System.err.println(e.getLocalizedMessage());
                continue;
            }
            catch (EvaluateRuntimeException ere) {
                System.err.println(ere.getLocalizedMessage());
                continue;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getLocalizedMessage());
            }
            try {
                JsonNode result = null;
                result = checkRuntime ? expr.evaluate(jsonObj, timeoutMS, maxDepth) : expr.evaluate(jsonObj);
                if (result == null) {
                    System.out.println("** no match **");
                    continue;
                }
                System.out.println("" + mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)result));
            }
            catch (EvaluateException | JsonProcessingException e) {
                System.err.println(e.getLocalizedMessage());
            }
        }
        System.out.println("Goodbye");
    }
}

