/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.testerui;

import com.api.jsonata4java.testerui.TesterUI;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public enum TesterUIJsonataExample {
    NONE("-"),
    INVOICE("Invoice"),
    ADDRESS("Address"),
    SCHEMA("Schema"),
    XMLADDRESS("XML Address");

    private final String uiName;
    private static final String PATH_EXAMPLES = "src/test/resources/exerciser";

    private TesterUIJsonataExample(String uiName) {
        this.uiName = uiName;
    }

    public String toString() {
        return this.uiName;
    }

    public Path getPathInput() {
        File jsonFile = new File(PATH_EXAMPLES, this.uiName.toLowerCase() + ".json");
        if (jsonFile.exists()) {
            return jsonFile.toPath();
        }
        return new File(PATH_EXAMPLES, this.name().toLowerCase() + ".xml").toPath();
    }

    public Path getPathJsonata() {
        return new File(PATH_EXAMPLES, this.name().toLowerCase() + ".jsonata").toPath();
    }

    public static TesterUIJsonataExample fromContent(String input, String jsonata) throws IOException {
        for (TesterUIJsonataExample example : TesterUIJsonataExample.values()) {
            if (example == NONE || !TesterUI.readFile(example.getPathInput()).trim().equals(input.trim()) || !TesterUI.readFile(example.getPathJsonata()).trim().equals(jsonata.trim())) continue;
            return example;
        }
        return NONE;
    }
}

