/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.protobuf;

import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaProtobufSerde<T extends Message>
implements Serde<T> {
    private Class<T> specificProtobufClass;
    private final Serde<T> inner;

    public KafkaProtobufSerde() {
        this.inner = Serdes.serdeFrom((Serializer)new KafkaProtobufSerializer(), (Deserializer)new KafkaProtobufDeserializer());
    }

    public KafkaProtobufSerde(Class<T> specificProtobufClass) {
        this.specificProtobufClass = specificProtobufClass;
        this.inner = Serdes.serdeFrom((Serializer)new KafkaProtobufSerializer(), (Deserializer)new KafkaProtobufDeserializer());
    }

    public KafkaProtobufSerde(SchemaRegistryClient client) {
        this(client, null);
    }

    public KafkaProtobufSerde(SchemaRegistryClient client, Class<T> specificClass) {
        if (client == null) {
            throw new IllegalArgumentException("schema registry client must not be null");
        }
        this.specificProtobufClass = specificClass;
        this.inner = Serdes.serdeFrom((Serializer)new KafkaProtobufSerializer(client), (Deserializer)new KafkaProtobufDeserializer(client));
    }

    public Serializer<T> serializer() {
        return this.inner.serializer();
    }

    public Deserializer<T> deserializer() {
        return this.inner.deserializer();
    }

    public void configure(Map<String, ?> serdeConfig, boolean isSerdeForRecordKeys) {
        this.inner.serializer().configure(serdeConfig, isSerdeForRecordKeys);
        this.inner.deserializer().configure(this.withSpecificClass(serdeConfig, isSerdeForRecordKeys), isSerdeForRecordKeys);
    }

    public void close() {
        this.inner.serializer().close();
        this.inner.deserializer().close();
    }

    private Map<String, Object> withSpecificClass(Map<String, ?> config, boolean isKey) {
        HashMap<String, Object> newConfig;
        if (this.specificProtobufClass == null) {
            return config;
        }
        HashMap<String, Object> hashMap = newConfig = config == null ? new HashMap<String, Object>() : new HashMap<String, Object>(config);
        if (isKey) {
            newConfig.put("specific.protobuf.key.type", this.specificProtobufClass);
        } else {
            newConfig.put("specific.protobuf.value.type", this.specificProtobufClass);
        }
        return newConfig;
    }
}

