/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;

public class DirectoryId {
    public static final Uuid MIGRATING = new Uuid(0L, 0L);
    public static final Uuid UNASSIGNED = new Uuid(0L, 1L);
    public static final Uuid LOST = new Uuid(0L, 2L);

    public static Uuid random() {
        Uuid uuid;
        while (DirectoryId.reserved(uuid = Uuid.randomUuid())) {
        }
        return uuid;
    }

    public static boolean reserved(Uuid uuid) {
        return uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() < 100L;
    }

    public static List<Uuid> createDirectoriesFrom(int[] currentReplicas, Uuid[] currentDirectories, List<Integer> newReplicas) {
        if (currentReplicas == null) {
            currentReplicas = new int[]{};
        }
        if (currentDirectories == null) {
            currentDirectories = new Uuid[]{};
        }
        Map<Integer, Uuid> assignments = DirectoryId.createAssignmentMap(currentReplicas, currentDirectories);
        ArrayList<Uuid> consolidated = new ArrayList<Uuid>(newReplicas.size());
        for (int newReplica : newReplicas) {
            Uuid newDirectory = assignments.getOrDefault(newReplica, MIGRATING);
            consolidated.add(newDirectory);
        }
        return consolidated;
    }

    public static Map<Integer, Uuid> createAssignmentMap(int[] replicas, Uuid[] directories) {
        if (replicas.length != directories.length) {
            throw new IllegalArgumentException("The lengths for replicas and directories do not match.");
        }
        HashMap<Integer, Uuid> assignments = new HashMap<Integer, Uuid>();
        for (int i = 0; i < replicas.length; ++i) {
            int brokerId = replicas[i];
            Uuid directory = directories[i];
            if (assignments.put(brokerId, directory) == null) continue;
            throw new IllegalArgumentException("Duplicate broker ID in assignment");
        }
        return assignments;
    }

    public static Uuid[] unassignedArray(int length) {
        return DirectoryId.array(length, UNASSIGNED);
    }

    public static Uuid[] migratingArray(int length) {
        return DirectoryId.array(length, MIGRATING);
    }

    private static Uuid[] array(int length, Uuid value) {
        Object[] array = new Uuid[length];
        Arrays.fill(array, value);
        return array;
    }

    public static boolean isOnline(Uuid dir, List<Uuid> sortedOnlineDirs) {
        if (UNASSIGNED.equals((Object)dir) || MIGRATING.equals((Object)dir)) {
            return true;
        }
        if (LOST.equals((Object)dir)) {
            return false;
        }
        if (sortedOnlineDirs.isEmpty()) {
            return true;
        }
        return Collections.binarySearch(sortedOnlineDirs, dir) >= 0;
    }
}

