/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Utils;

public class MultiTenantConfigRestrictions {
    public static final String EXTERNAL_LISTENER_PREFIX = new ListenerName("external").configPrefix();
    private static final Map<String, String> UPDATABLE_LISTENER_TO_EXTERNAL_LISTENER_CONFIGS = Stream.of(KafkaConfig.SslCipherSuitesProp()).collect(Collectors.toMap(Function.identity(), configName -> EXTERNAL_LISTENER_PREFIX + configName));
    private static final Map<String, String> UPDATABLE_EXTERNAL_LISTENER_TO_LISTENER_CONFIGS = UPDATABLE_LISTENER_TO_EXTERNAL_LISTENER_CONFIGS.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getValue(), e -> (String)e.getKey()));
    public static final Set<String> UPDATABLE_BROKER_CONFIGS = Stream.concat(UPDATABLE_EXTERNAL_LISTENER_TO_LISTENER_CONFIGS.keySet().stream(), Stream.of(KafkaConfig.AutoCreateTopicsEnableProp(), KafkaConfig.NumPartitionsProp(), KafkaConfig.LogRetentionTimeMillisProp(), KafkaConfig.LogCleanerMaxCompactionLagMsProp())).collect(Collectors.toSet());
    public static final Set<String> VISIBLE_BROKER_CONFIGS = Stream.concat(UPDATABLE_BROKER_CONFIGS.stream(), Stream.of("confluent.schema.registry.url", KafkaConfig.DefaultReplicationFactorProp(), KafkaConfig.LogCleanupPolicyProp(), KafkaConfig.MessageMaxBytesProp(), KafkaConfig.LogMessageTimestampDifferenceMaxMsProp(), KafkaConfig.LogMessageTimestampBeforeMaxMsProp(), KafkaConfig.LogMessageTimestampAfterMaxMsProp(), KafkaConfig.LogMessageTimestampTypeProp(), KafkaConfig.LogCleanerMinCompactionLagMsProp(), KafkaConfig.LogRetentionBytesProp(), KafkaConfig.LogCleanerDeleteRetentionMsProp(), KafkaConfig.LogSegmentBytesProp())).collect(Collectors.toSet());
    private static final Set<String> UPDATABLE_TOPIC_CONFIGS = Utils.mkSet((Object[])new String[]{"cleanup.policy", "max.message.bytes", "message.timestamp.difference.max.ms", "message.timestamp.before.max.ms", "message.timestamp.after.max.ms", "message.timestamp.type", "min.compaction.lag.ms", "max.compaction.lag.ms", "retention.bytes", "retention.ms", "min.insync.replicas", "delete.retention.ms", "segment.bytes", "segment.ms"});
    private static final Set<String> SCHEMA_VALIDATION_TOPIC_CONFIGS = Utils.mkSet((Object[])new String[]{"confluent.key.schema.validation", "confluent.key.subject.name.strategy", "confluent.value.schema.validation", "confluent.value.subject.name.strategy"});
    private static final Set<String> UPDATABLE_CLUSTER_LINK_CLIENT_CONFIGS = Utils.mkSet((Object[])new String[]{"bootstrap.servers", "client.dns.lookup", "security.protocol", "sasl.jaas.config", "sasl.mechanism", "sasl.login.callback.handler.class", "sasl.oauthbearer.token.endpoint.url", "sasl.oauthbearer.scope.claim.name", "sasl.oauthbearer.sub.claim.name", "ssl.cipher.suites", "ssl.enabled.protocols", "ssl.endpoint.identification.algorithm", "ssl.protocol", "ssl.truststore.type", "ssl.truststore.certificates", "ssl.keystore.type", "ssl.keystore.certificate.chain", "ssl.keystore.key", "ssl.key.password"});
    public static final Set<String> UPDATABLE_CLUSTER_LINK_CONFIGS = Stream.of(UPDATABLE_CLUSTER_LINK_CLIENT_CONFIGS.stream(), UPDATABLE_CLUSTER_LINK_CLIENT_CONFIGS.stream().map(n -> ClusterLinkConfig.LocalPrefix() + n), Utils.mkSet((Object[])new String[]{ClusterLinkConfig.LinkModeProp(), ClusterLinkConfig.ConnectionModeProp(), ClusterLinkConfig.AclFiltersProp(), ClusterLinkConfig.AclSyncEnableProp(), ClusterLinkConfig.AclSyncMsProp(), ClusterLinkConfig.ConsumerOffsetGroupFiltersProp(), ClusterLinkConfig.ConsumerOffsetSyncEnableProp(), ClusterLinkConfig.ConsumerOffsetSyncMsProp(), ClusterLinkConfig.TopicConfigSyncMsProp(), ClusterLinkConfig.TopicConfigSyncIncludeProp(), ClusterLinkConfig.AutoMirroringEnableProp(), ClusterLinkConfig.TopicFiltersProp(), ClusterLinkConfig.ClusterLinkPrefixProp(), ClusterLinkConfig.ConsumerGroupPrefixEnableProp(), ClusterLinkConfig.MirrorStartOffsetSpecProp(), KafkaConfig.ReplicaSocketReceiveBufferBytesProp()}).stream()).flatMap(Function.identity()).collect(Collectors.toSet());
    public static final Set<String> VISIBLE_CLUSTER_LINK_CONFIGS = Stream.concat(UPDATABLE_CLUSTER_LINK_CONFIGS.stream(), Stream.of(ClusterLinkConfig.RetryTimeoutMsProp(), ClusterLinkConfig.NumClusterLinkFetchersProp(), "connections.max.idle.ms", "metadata.max.age.ms", "request.timeout.ms", "retry.backoff.ms", "socket.connection.setup.timeout.ms", "socket.connection.setup.timeout.max.ms", KafkaConfig.ReplicaFetchBackoffMsProp(), KafkaConfig.ReplicaFetchMaxBytesProp(), KafkaConfig.ReplicaFetchMinBytesProp(), KafkaConfig.ReplicaFetchResponseMaxBytesProp(), KafkaConfig.ReplicaFetchWaitMaxMsProp(), KafkaConfig.ReplicaSocketTimeoutMsProp())).collect(Collectors.toSet());

    public static boolean updatableTopicConfig(String configName, boolean schemaValidationEnabled) {
        return UPDATABLE_TOPIC_CONFIGS.contains(configName) || schemaValidationEnabled && SCHEMA_VALIDATION_TOPIC_CONFIGS.contains(configName);
    }

    public static boolean visibleTopicConfig(String configName, boolean schemaValidationEnabled) {
        return !configName.startsWith("confluent.") || schemaValidationEnabled && SCHEMA_VALIDATION_TOPIC_CONFIGS.contains(configName);
    }

    public static Optional<String> prependExternalListenerToConfigName(String configName) {
        return Optional.ofNullable(UPDATABLE_LISTENER_TO_EXTERNAL_LISTENER_CONFIGS.get(configName));
    }

    public static Optional<String> stripExternalListenerPrefixFromConfigName(String configName) {
        return Optional.ofNullable(UPDATABLE_EXTERNAL_LISTENER_TO_LISTENER_CONFIGS.get(configName));
    }
}

