/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.schema;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import kafka.security.authorizer.AclEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;

public class TenantContext
implements MessageContext {
    public static final String DELIMITER = "_";
    public final MultiTenantPrincipal principal;
    public final String prefix;
    protected final int prefixSizeInBytes;

    public static boolean isTenantPrefixed(String prefixedName) {
        return prefixedName != null && !prefixedName.startsWith(DELIMITER) && prefixedName.contains(DELIMITER);
    }

    public static String extractTenantPrefix(String prefixedName) {
        if (!TenantContext.isTenantPrefixed(prefixedName)) {
            throw new IllegalArgumentException("Name is not tenant-prefixed: " + prefixedName);
        }
        return prefixedName.substring(0, prefixedName.indexOf(DELIMITER) + 1);
    }

    public static String extractTenant(String prefixedName) {
        if (!TenantContext.isTenantPrefixed(prefixedName)) {
            throw new IllegalArgumentException("Name is not tenant-prefixed: " + prefixedName);
        }
        return prefixedName.substring(0, prefixedName.indexOf(DELIMITER));
    }

    public TenantContext(MultiTenantPrincipal principal) {
        String tenantName = principal.tenantMetadata().tenantName;
        TenantContext.ensureValidTenantName(tenantName);
        this.principal = principal;
        this.prefix = tenantName + DELIMITER;
        this.prefixSizeInBytes = Utils.utf8Length((CharSequence)this.prefix);
    }

    private static void ensureValidTenantName(String tenantName) {
        if (tenantName.contains(DELIMITER)) {
            throw new IllegalArgumentException("Tenant name includes illegal `_` character: " + tenantName);
        }
        try {
            Topic.validate((String)tenantName);
        }
        catch (InvalidTopicException e) {
            throw new IllegalArgumentException("Tenant name " + tenantName + " must be a valid topic prefix");
        }
    }

    public static String addTenantPrefix(String prefix, String value) {
        return prefix + value;
    }

    public String addTenantPrefix(String value) {
        return this.prefix + value;
    }

    private String addTenantPrefixNullable(String value) {
        return TenantContext.addTenantPrefixNullable(this.prefix, value);
    }

    public static String addTenantPrefixNullable(String prefix, String value) {
        if (value == null) {
            return null;
        }
        return prefix + value;
    }

    public String prefix() {
        return this.prefix;
    }

    public int prefixSizeInBytes() {
        return this.prefixSizeInBytes;
    }

    public TopicPartition removeTenantPrefix(TopicPartition tp) {
        return new TopicPartition(this.removeTenantPrefix(tp.topic()), tp.partition());
    }

    public static String removePrefix(String value) {
        String prefix = TenantContext.extractTenantPrefix(value);
        return value.substring(prefix.length());
    }

    public String removeTenantPrefix(String value) {
        return value.substring(this.prefix.length());
    }

    private String removeTenantPrefixNullable(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return value;
        }
        return value.substring(this.prefix.length());
    }

    public static boolean hasTenantPrefix(String prefix, String prefixedName) {
        return TenantContext.isTenantPrefixed(prefixedName) && prefixedName.startsWith(prefix);
    }

    public boolean hasTenantPrefix(String value) {
        return TenantContext.hasTenantPrefix(this.prefix, value);
    }

    public String removeAllTenantPrefixes(String message) {
        return message.replace(this.prefix, "");
    }

    private String removeAllTenantPrefixesNullable(String message) {
        if (message == null) {
            return null;
        }
        return message.replace(this.prefix, "");
    }

    public int sizeOfRemovedPrefixes(String message) {
        return message.length() - this.removeAllTenantPrefixes(message).length();
    }

    public String prefixedWildcard() {
        return this.prefix + "*";
    }

    public String write(EntityType entityType, String value) {
        switch (entityType) {
            case TOPIC_NAME: 
            case GROUP_ID: 
            case TRANSACTIONAL_ID: 
            case LINK_NAME: 
            case COORDINATOR_KEY: {
                return this.removeTenantPrefixNullable(value);
            }
            case ERROR_MESSAGE: {
                return this.removeAllTenantPrefixesNullable(value);
            }
            case CLUSTER_ID: {
                return this.principal.tenantMetadata().clusterId;
            }
            case ACL_PRINCIPAL: {
                return this.removeTenantPrefixFromPrincipal(value);
            }
        }
        return value;
    }

    public Message write(EntityType entityType, Message value) {
        Message duplicate = value.duplicate();
        switch (entityType) {
            case CONFIG_RESOURCE: {
                this.removeTenantPrefixFromConfigResource(duplicate);
                break;
            }
            case ACL_RESOURCE: {
                this.removeTenantPrefixFromAclResource(duplicate);
                break;
            }
        }
        return duplicate;
    }

    public String read(EntityType entityType, String value) {
        switch (entityType) {
            case TOPIC_NAME: 
            case GROUP_ID: 
            case TRANSACTIONAL_ID: 
            case LINK_NAME: 
            case COORDINATOR_KEY: {
                return this.addTenantPrefixNullable(value);
            }
            case ACL_PRINCIPAL: 
            case ACL_PRINCIPAL_FILTER: {
                return this.addTenantPrefixToPrincipal(value);
            }
        }
        return value;
    }

    public Message read(EntityType entityType, Message value) {
        switch (entityType) {
            case CONFIG_RESOURCE: {
                this.addTenantPrefixToConfigResource(value);
                break;
            }
            case ACL_RESOURCE: {
                this.addTenantPrefixToAclResource(value);
                break;
            }
            case ACL_RESOURCE_FILTER: {
                this.addTenantPrefixToAclResourceFilter(value);
                break;
            }
        }
        return value;
    }

    private void removeTenantPrefixFromConfigResource(Message value) {
        if (value instanceof AlterConfigsResponseData.AlterConfigsResourceResponse) {
            AlterConfigsResponseData.AlterConfigsResourceResponse resource = (AlterConfigsResponseData.AlterConfigsResourceResponse)value;
            if (this.isTransformRequired(ConfigResource.Type.forId((byte)resource.resourceType()))) {
                resource.setResourceName(this.removeTenantPrefixNullable(resource.resourceName()));
            }
        } else if (value instanceof IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse) {
            IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse resource = (IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse)value;
            if (this.isTransformRequired(ConfigResource.Type.forId((byte)resource.resourceType()))) {
                resource.setResourceName(this.removeTenantPrefixNullable(resource.resourceName()));
            }
        } else if (value instanceof DescribeConfigsResponseData.DescribeConfigsResult) {
            DescribeConfigsResponseData.DescribeConfigsResult resource = (DescribeConfigsResponseData.DescribeConfigsResult)value;
            if (this.isTransformRequired(ConfigResource.Type.forId((byte)resource.resourceType()))) {
                resource.setResourceName(this.removeTenantPrefixNullable(resource.resourceName()));
            }
        } else {
            throw new IllegalArgumentException("Unexpected config resource type " + value);
        }
    }

    private void removeTenantPrefixFromAclResource(Message value) {
        if (value instanceof DeleteAclsResponseData.DeleteAclsMatchingAcl) {
            DeleteAclsResponseData.DeleteAclsMatchingAcl resource = (DeleteAclsResponseData.DeleteAclsMatchingAcl)value;
            if (TenantContext.isTransformRequired(ResourceType.fromCode((byte)resource.resourceType()))) {
                resource.setResourceName(this.removeTenantPrefixNullable(resource.resourceName()));
            }
        } else if (value instanceof DescribeAclsResponseData.DescribeAclsResource) {
            DescribeAclsResponseData.DescribeAclsResource resource = (DescribeAclsResponseData.DescribeAclsResource)value;
            if (TenantContext.isTransformRequired(ResourceType.fromCode((byte)resource.resourceType()))) {
                resource.setResourceName(this.removeTenantPrefixNullable(resource.resourceName()));
            }
        } else {
            throw new IllegalArgumentException("Unexpected acl resource type " + value);
        }
    }

    private void addTenantPrefixToConfigResource(Message value) {
        if (value instanceof AlterConfigsRequestData.AlterConfigsResource) {
            AlterConfigsRequestData.AlterConfigsResource resource = (AlterConfigsRequestData.AlterConfigsResource)value;
            if (this.isTransformRequired(ConfigResource.Type.forId((byte)resource.resourceType()))) {
                resource.setResourceName(this.addTenantPrefixNullable(resource.resourceName()));
            }
        } else if (value instanceof IncrementalAlterConfigsRequestData.AlterConfigsResource) {
            IncrementalAlterConfigsRequestData.AlterConfigsResource resource = (IncrementalAlterConfigsRequestData.AlterConfigsResource)value;
            if (this.isTransformRequired(ConfigResource.Type.forId((byte)resource.resourceType()))) {
                resource.setResourceName(this.addTenantPrefixNullable(resource.resourceName()));
            }
        } else if (value instanceof DescribeConfigsRequestData.DescribeConfigsResource) {
            DescribeConfigsRequestData.DescribeConfigsResource resource = (DescribeConfigsRequestData.DescribeConfigsResource)value;
            if (this.isTransformRequired(ConfigResource.Type.forId((byte)resource.resourceType()))) {
                resource.setResourceName(this.addTenantPrefixNullable(resource.resourceName()));
            }
        } else {
            throw new IllegalArgumentException("Unexpected config resource type " + value);
        }
    }

    private void addTenantPrefixToAclResource(Message value) {
        if (value instanceof CreateAclsRequestData.AclCreation) {
            CreateAclsRequestData.AclCreation resource = (CreateAclsRequestData.AclCreation)value;
            if (TenantContext.isTransformRequired(ResourceType.fromCode((byte)resource.resourceType()))) {
                resource.setResourceName(this.addTenantPrefixNullable(resource.resourceName()));
            }
        } else {
            throw new IllegalArgumentException("Unexpected acl resource type " + value);
        }
    }

    private void addTenantPrefixToAclResourceFilter(Message value) {
        if (value instanceof DescribeAclsRequestData) {
            DescribeAclsRequestData request = (DescribeAclsRequestData)value;
            ResourceType resourceType = ResourceType.fromCode((byte)request.resourceTypeFilter());
            if (TenantContext.isTransformRequired(resourceType)) {
                request.setResourceNameFilter(this.addTenantPrefixNullable(request.resourceNameFilter()));
            }
        } else if (value instanceof DeleteAclsRequestData.DeleteAclsFilter) {
            DeleteAclsRequestData.DeleteAclsFilter filter = (DeleteAclsRequestData.DeleteAclsFilter)value;
            ResourceType resourceType = ResourceType.fromCode((byte)filter.resourceTypeFilter());
            if (TenantContext.isTransformRequired(resourceType)) {
                filter.setResourceNameFilter(this.addTenantPrefixNullable(filter.resourceNameFilter()));
            }
        } else {
            throw new IllegalArgumentException("Unexpected acl resource filter type " + value);
        }
    }

    public static String addTenantPrefixToPrincipal(String prefix, String principalString) {
        try {
            if (principalString == null) {
                return null;
            }
            KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)principalString);
            if (principal.equals((Object)MultiTenantPrincipal.WILDCARD_USERV2_PRINCIPAL)) {
                return "TenantUserV2*:" + prefix;
            }
            if (principal.equals((Object)AclEntry.WildcardPrincipal())) {
                return "TenantUser*:" + prefix;
            }
            return "TenantUser:" + TenantContext.addTenantPrefix(prefix, principal.getName());
        }
        catch (IllegalArgumentException e) {
            return principalString;
        }
    }

    private String addTenantPrefixToPrincipal(String principalString) {
        return TenantContext.addTenantPrefixToPrincipal(this.prefix, principalString);
    }

    private String removeTenantPrefixFromPrincipal(String principalString) {
        try {
            if (principalString == null) {
                return null;
            }
            KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)principalString);
            String user = principal.getName();
            boolean tenantWildcard = principal.getPrincipalType().equals("TenantUser*");
            if (user.equals("*")) {
                throw new IllegalStateException("Non-tenant ACLs have not been filtered out");
            }
            if (tenantWildcard) {
                if (!user.equals(this.prefix)) {
                    throw new IllegalStateException("Wildcard with different tenant not filtered out");
                }
                return AclEntry.WildcardPrincipalString();
            }
            String transformed = this.removeTenantPrefix(principal.getName());
            return "User:" + transformed;
        }
        catch (IllegalArgumentException e) {
            return principalString;
        }
    }

    public static boolean isTransformRequired(ResourceType resourceType) {
        switch (resourceType) {
            case TOPIC: 
            case GROUP: 
            case TRANSACTIONAL_ID: 
            case CLUSTER: 
            case ANY: {
                return true;
            }
        }
        return false;
    }

    protected boolean isTransformRequired(ConfigResource.Type resourceType) {
        return resourceType == ConfigResource.Type.TOPIC || resourceType == ConfigResource.Type.CLUSTER_LINK;
    }
}

