/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.utils;

import io.confluent.kafka.clients.CloudAdmin;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String SEQUENCE_ID_STRING_HEADER_KEY = "_sequence_id";
    public static final String EVENTS_METADATA_HEADER_KEY = "eventsmetadata";

    public static AdminClient createAdminClient(String endpoint) {
        Properties adminClientProps = new Properties();
        try {
            LOG.info("Using bootstrap server {}", (Object)endpoint);
            adminClientProps.put("bootstrap.servers", endpoint);
            return AdminClient.create((Properties)adminClientProps);
        }
        catch (Exception e) {
            LOG.error("Failed to create admin client for endpoint {} ", (Object)endpoint, (Object)e);
            return null;
        }
    }

    public static ConfluentAdmin createConfluentAdmin(Map<String, Object> interBrokerClientConfigs) {
        return Utils.createCloudAdmin(interBrokerClientConfigs);
    }

    public static CloudAdmin createCloudAdmin(Map<String, Object> interBrokerClientConfigs) {
        Object bootstrapServer = interBrokerClientConfigs.get("bootstrap.servers");
        try {
            LOG.info("Using bootstrap server {}", bootstrapServer);
            return CloudAdmin.create(interBrokerClientConfigs);
        }
        catch (Exception e) {
            LOG.error("Failed to create admin client for endpoint {} ", bootstrapServer, (Object)e);
            return null;
        }
    }
}

