/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer;

import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.security.authorizer.acl.AclMapper;
import io.confluent.security.authorizer.AclMigrationAware;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.EmbeddedAuthorizer;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AccessRuleProvider;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import io.confluent.security.authorizer.provider.Provider;
import io.confluent.security.authorizer.utils.AuthorizerUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.AuthorizerCompletableFuture;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;

public class ConfluentServerAuthorizer
extends EmbeddedAuthorizer
implements Authorizer,
Reconfigurable,
ClusterMetadataAuthorizer {
    private static final Set<String> UNSCOPED_PROVIDERS = Utils.mkSet((Object[])new String[]{ConfluentBuiltInProviders.AccessRuleProviders.ZK_ACL.name(), ConfluentBuiltInProviders.AccessRuleProviders.KRAFT_ACL.name(), ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name()});
    private AclUpdater aclUpdater;
    private List<String> multitenantListenerNames = Collections.emptyList();
    private Boolean waitForAuthorizer = true;
    private Boolean iskraft;
    private Boolean onlyCentralizedProvider = null;

    public void configure(Map<String, ?> configs) {
        List providerNames;
        this.multitenantListenerNames = ConfluentConfigs.multitenantListenerNames(configs, null);
        String role = (String)configs.get(KafkaConfig.ProcessRolesProp());
        this.iskraft = role != null && !role.isEmpty();
        HashMap authorizerConfigs = new HashMap(configs);
        String aclProviders = (String)authorizerConfigs.get("confluent.authorizer.access.rule.providers");
        if (aclProviders == null || aclProviders.isEmpty()) {
            if (this.iskraft.booleanValue()) {
                log.debug("KRaft mode detected, setting ACL provider as KRAFT_ACL.");
                authorizerConfigs.put("confluent.authorizer.access.rule.providers", ConfluentBuiltInProviders.AccessRuleProviders.KRAFT_ACL.name());
            } else {
                log.debug("Non-KRaft mode detected, setting ACL provider as ZK_ACL.");
                authorizerConfigs.put("confluent.authorizer.access.rule.providers", ConfluentBuiltInProviders.AccessRuleProviders.ZK_ACL.name());
            }
        }
        super.configure(authorizerConfigs);
        if (authorizerConfigs.containsKey("confluent.wait.for.authorizer.startup")) {
            this.waitForAuthorizer = Boolean.parseBoolean((String)authorizerConfigs.get("confluent.wait.for.authorizer.startup"));
        }
        if ((providerNames = this.authorizerConfig.authProviderNames()).contains(ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name()) && !(this instanceof MultiTenantAuthorizer)) {
            throw new ConfigException("The MULTI_TENANT provider can only be used with " + MultiTenantAuthorizer.class.getName());
        }
    }

    public Set<String> reconfigurableConfigs() {
        HashSet<String> result = new HashSet<String>();
        for (Provider provider : this.providersCreated) {
            if (!(provider instanceof Reconfigurable)) continue;
            result.addAll(((Reconfigurable)provider).reconfigurableConfigs());
        }
        return result;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        for (Provider provider : this.providersCreated) {
            if (!(provider instanceof Reconfigurable)) continue;
            ((Reconfigurable)provider).validateReconfiguration(configs);
        }
    }

    public void reconfigure(Map<String, ?> configs) {
        for (Provider provider : this.providersCreated) {
            if (!(provider instanceof Reconfigurable)) continue;
            ((Reconfigurable)provider).reconfigure(configs);
        }
    }

    public void configureServerInfo(ConfluentAuthorizerServerInfo serverInfo) {
        Set scopedProviders;
        super.configureServerInfo(serverInfo);
        this.initializeAclUpdater();
        if (this.scope().clusters().isEmpty() && !(scopedProviders = this.accessRuleProviders().stream().map(Provider::providerName).filter(a -> !UNSCOPED_PROVIDERS.contains(a)).collect(Collectors.toSet())).isEmpty()) {
            throw new ConfigException("Scope not provided for broker providers: " + scopedProviders);
        }
    }

    private void initializeAclUpdater() {
        AclAuthorizers authorizers = this.collectAuthorizers();
        Optional<Authorizer> kraftProvider = Optional.ofNullable(authorizers.kraftAuthorizer.get());
        Optional<Authorizer> zkAclProvider = Optional.ofNullable(authorizers.zkAuthorizer.get());
        Optional<Authorizer> centralizedAclProvider = Optional.ofNullable(authorizers.centralAuthorizer.get());
        if (this.authorizerConfig.migrateAclsFromCluster) {
            if (!zkAclProvider.isPresent() && !kraftProvider.isPresent()) {
                throw new IllegalArgumentException("Acl migration from ZK/KRAFT to metadata service is enabled, but AclProvider is not enabled.");
            }
            if (!centralizedAclProvider.isPresent()) {
                throw new IllegalArgumentException("Acl migration from ZK/KRAFT to metadata service is enabled, but centralized authorizer/RbacProvider is not enabled.");
            }
            if (!(centralizedAclProvider.get() instanceof AclMigrationAware)) {
                throw new IllegalArgumentException("Acl migration from ZK/KRAFT to metadata service is enabled, but centralized authorizer is not Acl migration aware");
            }
            this.aclUpdater = kraftProvider.isPresent() ? new AclUpdater(kraftProvider, centralizedAclProvider, true) : new AclUpdater(zkAclProvider, centralizedAclProvider, true);
        } else if (kraftProvider.isPresent()) {
            if (zkAclProvider.isPresent()) {
                throw new IllegalArgumentException("The ZK and KRaft rule providers must not both be configured");
            }
            this.aclUpdater = new AclUpdater(kraftProvider, centralizedAclProvider, false);
        } else {
            this.aclUpdater = new AclUpdater(zkAclProvider, centralizedAclProvider, false);
        }
    }

    private boolean onlyCentralizedAclProviderPresent() {
        if (this.onlyCentralizedProvider == null) {
            AclAuthorizers authorizers = AclAuthorizers.fromAclProviders(this.accessRuleProviders());
            Optional kraftProvider = Optional.ofNullable(authorizers.kraftAuthorizer.get());
            Optional centralizedAclProvider = Optional.ofNullable(authorizers.centralAuthorizer.get());
            this.onlyCentralizedProvider = centralizedAclProvider.isPresent() && !kraftProvider.isPresent();
        }
        return this.onlyCentralizedProvider;
    }

    protected AclAuthorizers collectAuthorizers() {
        return AclAuthorizers.fromAclProviders(this.accessRuleProviders());
    }

    public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
        ConfluentAuthorizerServerInfo confluentServerInfo = (ConfluentAuthorizerServerInfo)serverInfo;
        this.configureServerInfo(confluentServerInfo);
        Runnable migrationTask = this.createMigrationTask();
        CompletableFuture startFuture = super.start(confluentServerInfo, migrationTask);
        HashMap futures = new HashMap(serverInfo.endpoints().size());
        Optional<String> controlPlaneListener = Optional.ofNullable((String)this.authorizerConfig.originals().get(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp()));
        Collection earlyStartListenerNames = serverInfo.earlyStartListeners().stream().map(listenerName -> Optional.of(listenerName).map(ListenerName::normalised).map(ListenerName::value).orElse("")).collect(Collectors.toList());
        serverInfo.endpoints().forEach(arg_0 -> this.lambda$start$2(earlyStartListenerNames, futures, startFuture, serverInfo, controlPlaneListener, arg_0));
        return futures;
    }

    private Runnable createMigrationTask() {
        if (this.authorizerConfig.migrateAclsFromCluster) {
            return ((AclMigrationAware)this.aclUpdater.centralizedAclAuthorizer.get()).migrationTask((Authorizer)this.aclUpdater.clusterAclAuthorizer.get());
        }
        return () -> {};
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        List confluentActions = actions.stream().map(action -> this.buildAction((Action)action, action.resourcePattern(), requestContext.principal(), this.scope())).collect(Collectors.toList());
        List results = super.authorize(AuthorizerUtils.kafkaRequestContext((AuthorizableRequestContext)requestContext), confluentActions);
        return results.stream().map(result -> {
            if (result == AuthorizeResult.ALLOWED) {
                return AuthorizationResult.ALLOWED;
            }
            return AuthorizationResult.DENIED;
        }).collect(Collectors.toList());
    }

    public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        SecurityUtils.authorizeByResourceTypeCheckArgs((AclOperation)op, (ResourceType)resourceType);
        AuthorizeResult result = this.authorizeByResourceType(AuthorizerUtils.kafkaRequestContext((AuthorizableRequestContext)requestContext), AclMapper.operation(op), AclMapper.resourceType(resourceType));
        return result == AuthorizeResult.ALLOWED ? AuthorizationResult.ALLOWED : AuthorizationResult.DENIED;
    }

    private List<? extends CompletionStage<AclCreateResult>> createAclsInternal(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings, Optional<String> clusterId) {
        try {
            return this.aclUpdater.createAcls(requestContext, aclBindings, clusterId);
        }
        catch (Throwable t) {
            log.error("createAcls failed", t);
            throw t;
        }
    }

    public void setAclMutator(AclMutator aclMutator) {
        if (this.onlyCentralizedAclProviderPresent()) {
            log.warn("Only centralized authorizer found, skipping setting acl mutator.");
            return;
        }
        this.aclUpdater.kraftAuthorizerOrThrow().setAclMutator(aclMutator);
    }

    public AclMutator aclMutatorOrException() {
        return this.aclUpdater.kraftAuthorizerOrThrow().aclMutatorOrException();
    }

    public void completeInitialLoad() {
        this.aclUpdater.completeInitialLoad();
    }

    public void completeInitialLoad(Exception e) {
        this.aclUpdater.completeInitialLoad(e);
    }

    public void loadAclSnapshot(Map<Uuid, ConfluentStandardAcl> acls) {
        if (this.onlyCentralizedAclProviderPresent()) {
            log.warn("Only centralized authorizer found, skipping load snapshot.");
            return;
        }
        this.aclUpdater.kraftAuthorizerOrThrow().loadAclSnapshot(acls);
    }

    public void applyAclChanges(Map<Uuid, Optional<ConfluentStandardAcl>> aclChanges) {
        if (this.onlyCentralizedAclProviderPresent()) {
            log.warn("Only centralized authorizer found, skipping to apply acl changes.");
            return;
        }
        this.aclUpdater.kraftAuthorizerOrThrow().applyAclChanges(aclChanges);
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        return this.createAclsInternal(requestContext, aclBindings, Optional.empty());
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings, Optional<String> clusterId) {
        return this.createAclsInternal(requestContext, aclBindings, clusterId);
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        return this.deleteAcls(requestContext, aclBindingFilters, Optional.empty(), AclState.ANY);
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters, Optional<String> clusterId, AclState aclState) {
        try {
            return this.aclUpdater.deleteAcls(requestContext, aclBindingFilters, clusterId, aclState);
        }
        catch (Throwable t) {
            log.error("deleteAcls with AclState failed", t);
            throw t;
        }
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        return this.aclUpdater.acls(filter, AclState.ACTIVE);
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter, AclState aclState) {
        return this.aclUpdater.acls(filter, aclState);
    }

    public int aclCount() {
        return this.aclUpdater.aclCount();
    }

    public io.confluent.security.authorizer.Action buildAction(Action kafkaAction, ResourcePattern kafkaResourcePattern, KafkaPrincipal principal, Scope scope) {
        if (kafkaResourcePattern.patternType() != PatternType.LITERAL) {
            throw new IllegalArgumentException("Only literal resources are supported, got: " + kafkaResourcePattern.patternType());
        }
        io.confluent.security.authorizer.ResourcePattern resourcePattern = new io.confluent.security.authorizer.ResourcePattern(AclMapper.resourceType(kafkaResourcePattern.resourceType()), kafkaResourcePattern.name(), PatternType.LITERAL);
        return new io.confluent.security.authorizer.Action(scope, resourcePattern, AclMapper.operation(kafkaAction.operation()), kafkaAction.resourceReferenceCount(), kafkaAction.logIfAllowed(), kafkaAction.logIfDenied());
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$start$2(Collection earlyStartListenerNames, Map futures, CompletableFuture startFuture, AuthorizerServerInfo serverInfo, Optional controlPlaneListener, Endpoint endpoint) {
        block11: {
            block10: {
                normalisedListenerName = endpoint.listenerName().map((Function<String, ListenerName>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, normalised(java.lang.String ), (Ljava/lang/String;)Lorg/apache/kafka/common/network/ListenerName;)()).map((Function<ListenerName, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, value(), (Lorg/apache/kafka/common/network/ListenerName;)Ljava/lang/String;)());
                authorizerServerStartFuture = false;
                authorizerEnableEndpointsFuture = false;
                if (!this.multitenantListenerNames.isEmpty()) break block10;
                if (!this.iskraft.booleanValue()) ** GOTO lbl-1000
                if (normalisedListenerName.map((Function<String, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, contains(java.lang.Object ), (Ljava/lang/String;)Ljava/lang/Boolean;)((Collection)earlyStartListenerNames)).orElse(false).booleanValue()) {
                    futures.put(endpoint, new AuthorizerCompletableFuture(this.waitForAuthorizer != false ? startFuture : CompletableFuture.completedFuture(null), CompletableFuture.completedFuture(null)));
                    authorizerServerStartFuture = this.waitForAuthorizer;
                } else if (endpoint.equals((Object)serverInfo.interBrokerEndpoint()) || endpoint.listenerName().equals(controlPlaneListener)) {
                    futures.put(endpoint, new AuthorizerCompletableFuture(CompletableFuture.completedFuture(null)));
                } else {
                    futures.put(endpoint, new AuthorizerCompletableFuture((CompletableFuture)startFuture));
                    authorizerServerStartFuture = true;
                    authorizerEnableEndpointsFuture = true;
                }
                break block11;
            }
            if (!this.iskraft.booleanValue()) ** GOTO lbl-1000
            if (normalisedListenerName.map((Function<String, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, contains(java.lang.Object ), (Ljava/lang/String;)Ljava/lang/Boolean;)((Collection)earlyStartListenerNames)).orElse(false).booleanValue()) {
                futures.put(endpoint, new AuthorizerCompletableFuture(this.waitForAuthorizer != false ? startFuture : CompletableFuture.completedFuture(null), CompletableFuture.completedFuture(null)));
                authorizerServerStartFuture = this.waitForAuthorizer;
            } else if (normalisedListenerName.map((Function<String, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, contains(java.lang.Object ), (Ljava/lang/String;)Ljava/lang/Boolean;)(this.multitenantListenerNames)).orElse(false).booleanValue()) {
                futures.put(endpoint, new AuthorizerCompletableFuture((CompletableFuture)startFuture));
                authorizerServerStartFuture = true;
                authorizerEnableEndpointsFuture = true;
            } else {
                futures.put(endpoint, new AuthorizerCompletableFuture(CompletableFuture.completedFuture(null)));
            }
        }
        if (authorizerServerStartFuture.booleanValue() || authorizerEnableEndpointsFuture.booleanValue()) {
            ConfluentServerAuthorizer.log.info("Wait for {} {} futures to complete before enabling endpoint: {}", new Object[]{authorizerServerStartFuture != false ? "authorizerServerStartFuture" : "", authorizerEnableEndpointsFuture != false ? "authorizerEnableEndpointsFuture" : "", endpoint});
        } else {
            ConfluentServerAuthorizer.log.info("Immediately resolve Authorizer future for endpoint: {}", (Object)endpoint);
        }
    }

    protected static class AclAuthorizers {
        private final AtomicReference<Authorizer> zkAuthorizer = new AtomicReference();
        private final AtomicReference<Authorizer> kraftAuthorizer = new AtomicReference();
        private final AtomicReference<Authorizer> centralAuthorizer = new AtomicReference();

        protected AclAuthorizers() {
        }

        static AclAuthorizers fromAclProviders(List<AccessRuleProvider> aclProviders) {
            AclAuthorizers authorizers = new AclAuthorizers();
            for (AccessRuleProvider provider : aclProviders) {
                Optional authorizerOpt = provider.asAuthorizer();
                if (!authorizerOpt.isPresent()) continue;
                Authorizer authorizer = (Authorizer)authorizerOpt.get();
                if (authorizer instanceof AclAuthorizer) {
                    authorizers.setZkAuthorizer(authorizer);
                    continue;
                }
                if (authorizer instanceof StandardAuthorizer) {
                    authorizers.setKraftAuthorizer(authorizer);
                    continue;
                }
                authorizers.setCentralAuthorizer(authorizer);
            }
            return authorizers;
        }

        void setZkAuthorizer(Authorizer zkAuthorizer) {
            if (!this.zkAuthorizer.compareAndSet(null, zkAuthorizer)) {
                throw new IllegalStateException("Only one zk-based authorizer is permitted, but found both " + zkAuthorizer.getClass().getName() + " and " + this.zkAuthorizer.get().getClass().getName());
            }
        }

        void setKraftAuthorizer(Authorizer kraftAuthorizer) {
            if (!this.kraftAuthorizer.compareAndSet(null, kraftAuthorizer)) {
                throw new IllegalStateException("Only one kraft authorizer is permitted, but found both " + kraftAuthorizer.getClass().getName() + " and " + this.kraftAuthorizer.get().getClass().getName());
            }
        }

        void setCentralAuthorizer(Authorizer centralAuthorizer) {
            if (!this.centralAuthorizer.compareAndSet(null, centralAuthorizer)) {
                throw new IllegalStateException("Only one central authorizer is permitted, but found both " + centralAuthorizer.getClass().getName() + " and " + this.centralAuthorizer.get().getClass().getName());
            }
        }
    }

    private static class AclUpdater {
        private static final InvalidRequestException ACLS_DISABLED = new InvalidRequestException("ACL-based authorization is disabled");
        private static final InvalidRequestException CENTRALIZED_ACLS_DISABED = new InvalidRequestException("Centralized ACL-based authorization is disabled");
        private final Optional<Authorizer> clusterAclAuthorizer;
        private final Optional<Authorizer> centralizedAclAuthorizer;
        private final boolean migrateFromZk;

        AclUpdater(Optional<Authorizer> clusterAclAuthorizer, Optional<Authorizer> centralizedAclAuthorizer, boolean migrateFromZk) {
            this.clusterAclAuthorizer = clusterAclAuthorizer;
            this.centralizedAclAuthorizer = centralizedAclAuthorizer;
            this.migrateFromZk = migrateFromZk;
        }

        private StandardAuthorizer kraftAuthorizerOrThrow() {
            if (!this.clusterAclAuthorizer.isPresent()) {
                throw new IllegalStateException("KRaft authorizer is not configured, expected it to be present.");
            }
            Authorizer authorizer = this.clusterAclAuthorizer.get();
            if (!(authorizer instanceof StandardAuthorizer)) {
                throw new IllegalStateException("KRaft authorizer is not configured, expecting StandardAuthorizer got " + authorizer.getClass());
            }
            return (StandardAuthorizer)authorizer;
        }

        public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings, Optional<String> clusterId) {
            List createResults = null;
            this.ensureAclsEnabled(clusterId.isPresent());
            if (this.clusterAclAuthorizer.isPresent() && !clusterId.isPresent()) {
                createResults = this.clusterAclAuthorizer.get().createAcls(requestContext, aclBindings);
            }
            if (this.migrateFromZk || !this.clusterAclAuthorizer.isPresent() || clusterId.isPresent()) {
                if (createResults != null) {
                    try {
                        for (CompletionStage c : createResults) {
                            AclCreateResult createResult = (AclCreateResult)c.toCompletableFuture().get();
                            if (!createResult.exception().isPresent()) continue;
                            return createResults;
                        }
                    }
                    catch (Exception e) {
                        return createResults;
                    }
                }
                List centralizedResults = this.centralizedAclAuthorizer.get().createAcls(requestContext, aclBindings, clusterId);
                return createResults == null ? centralizedResults : createResults;
            }
            return createResults;
        }

        public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters, Optional<String> clusterId, AclState aclState) {
            List deleteResults = null;
            this.ensureAclsEnabled(clusterId.isPresent());
            if (this.clusterAclAuthorizer.isPresent() && !clusterId.isPresent()) {
                deleteResults = this.clusterAclAuthorizer.get().deleteAcls(requestContext, aclBindingFilters, Optional.empty(), aclState);
            }
            if (this.migrateFromZk || !this.clusterAclAuthorizer.isPresent() || clusterId.isPresent()) {
                if (deleteResults != null) {
                    try {
                        for (CompletionStage c : deleteResults) {
                            AclDeleteResult deleteResult = (AclDeleteResult)c.toCompletableFuture().get();
                            if (!deleteResult.exception().isPresent()) continue;
                            return deleteResults;
                        }
                    }
                    catch (Exception e) {
                        return deleteResults;
                    }
                }
                List centralizedResults = this.centralizedAclAuthorizer.get().deleteAcls(requestContext, aclBindingFilters, clusterId, AclState.ACTIVE);
                return deleteResults == null ? centralizedResults : deleteResults;
            }
            return deleteResults;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter, AclState aclState) {
            if (this.clusterAclAuthorizer.isPresent()) {
                return this.clusterAclAuthorizer.get().acls(filter, aclState);
            }
            if (this.centralizedAclAuthorizer.isPresent()) {
                return this.centralizedAclAuthorizer.get().acls(filter, aclState);
            }
            throw ACLS_DISABLED;
        }

        public int aclCount() {
            return this.clusterAclAuthorizer.map(Authorizer::aclCount).orElse(-1);
        }

        private void ensureAclsEnabled(boolean clusterIdProvided) {
            if (!this.clusterAclAuthorizer.isPresent() && !this.centralizedAclAuthorizer.isPresent()) {
                throw ACLS_DISABLED;
            }
            if (clusterIdProvided && !this.centralizedAclAuthorizer.isPresent()) {
                throw CENTRALIZED_ACLS_DISABED;
            }
        }

        void completeInitialLoad() {
            this.clusterAclAuthorizer.ifPresent(a -> this.maybeCompleteInitialLoad((Authorizer)a, null));
            this.centralizedAclAuthorizer.ifPresent(a -> this.maybeCompleteInitialLoad((Authorizer)a, null));
        }

        void completeInitialLoad(Exception e) {
            this.clusterAclAuthorizer.ifPresent(a -> this.maybeCompleteInitialLoad((Authorizer)a, e));
            this.centralizedAclAuthorizer.ifPresent(a -> this.maybeCompleteInitialLoad((Authorizer)a, e));
        }

        private void maybeCompleteInitialLoad(Authorizer authorizer, Exception e) {
            if (authorizer instanceof ClusterMetadataAuthorizer) {
                ClusterMetadataAuthorizer a = (ClusterMetadataAuthorizer)authorizer;
                if (e != null) {
                    a.completeInitialLoad(e);
                } else {
                    a.completeInitialLoad();
                }
            }
        }
    }
}

