/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.oauth;

import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.store.data.JwtIssuerKey;
import io.confluent.security.trustservice.store.TrustCache;
import io.confluent.security.util.SecurityContext;
import java.security.Key;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.utils.Utils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaVerificationKeyResolver
implements VerificationKeyResolver {
    private static final Logger log = LoggerFactory.getLogger(KafkaVerificationKeyResolver.class);
    private final String name;
    private final String sessionUuid;
    private TrustCache trustCache;
    private final SecurityContext context;

    public KafkaVerificationKeyResolver(String name, String sessionUuid, SecurityContext context) {
        this.name = name;
        this.sessionUuid = sessionUuid;
        this.trustCache = null;
        this.context = context;
    }

    private TrustCache resolveTrustCache() {
        AuthStore store = Objects.requireNonNull(AuthStore.getInstance((String)this.sessionUuid));
        return store.trustCache();
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        String key;
        JsonWebKeySet set;
        String kid;
        String issuer;
        try {
            issuer = JwtClaims.parse((String)jws.getUnverifiedPayload()).getIssuer();
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new UnresolvableKeyException("Cannot get issuer payload from jws with error ", e);
        }
        if (this.trustCache == null) {
            this.trustCache = this.resolveTrustCache();
        }
        if ((kid = jws.getHeaders().getStringHeaderValue("kid")) == null) {
            log.debug("Unable to find kid field in the token with header {}. Req id: {} " + jws.getHeaders().getFullHeaderAsJsonString(), (Object)this.getReqId());
            throw new UnresolvableKeyException("Cannot find kid field in the token with header " + jws.getHeaders().getFullHeaderAsJsonString());
        }
        String jwksEndpoint = Optional.ofNullable(this.context).map(ctx -> ctx.strVal("jwksEndpoint", null, true)).orElse("");
        if (issuer != null && !issuer.equals("Confluent") && Utils.isBlank((String)jwksEndpoint)) {
            log.warn("JwksEndpoint for issuer {} not found in context. Req id: {}", (Object)issuer, (Object)this.getReqId());
        }
        if ((set = this.trustCache.jsonWebKeySet(key = JwtIssuerKey.cacheKeyV2((String)issuer, (String)jwksEndpoint))) == null) {
            log.error("Unable to find key {} data entry in Auth Cache. Req id: {}", (Object)key, (Object)this.getReqId());
            throw new UnresolvableKeyException("Cannot find key " + key + " data in the system.");
        }
        JsonWebKey jwk = set.findJsonWebKey(kid, null, null, null);
        if (jwk == null) {
            log.error("Unable to find verification key with kid {} from key {} in Auth Cache. Req id: {}", new Object[]{kid, key, this.getReqId()});
            throw new UnresolvableKeyException("Unable to find a suitable verification key for JWS w/ header " + jws.getHeaders().getFullHeaderAsJsonString());
        }
        Key result = jwk.getKey();
        if (result == null) {
            log.error("Unable to retrieve public key from JsonWebKey: {}. Req id: {}", (Object)jwk, (Object)this.getReqId());
            throw new UnresolvableKeyException("Unable to find a suitable verification key for JWS w/ header " + jws.getHeaders().getFullHeaderAsJsonString());
        }
        return result;
    }

    private long getReqId() {
        if (this.context == null) {
            return -1L;
        }
        return this.context.getReqId();
    }
}

