/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.multitenant.BasePhysicalClusterMetadata;
import io.confluent.kafka.multitenant.LogicalClusterMetadata;
import io.confluent.kafka.multitenant.utils.AuthUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonTopicBasedPhysicalClusterMetadata<LCMType extends LogicalClusterMetadata>
extends BasePhysicalClusterMetadata<LCMType> {
    protected static final Logger LOG = LoggerFactory.getLogger(CommonTopicBasedPhysicalClusterMetadata.class);
    protected static final Long CLOSE_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(30L);
    protected Set<String> logicalClusterIds = new HashSet<String>();
    private static final String NUMBER_OF_TENANTS_GROUP_NAME = "confluent-number-of-tenants";
    public static final String NUMBER_OF_TENANTS_METRIC_NAME = "number-of-tenants";
    public static final String NUMBER_OF_NON_HC_TENANTS_METRIC_NAME = "number-of-non-hc-tenants";
    private final AtomicInteger numberOfTenantsValue = new AtomicInteger(0);
    private final Gauge<Integer> numberOfTenantsMetric = (config, now) -> this.numberOfTenantsValue.get();
    private final AtomicInteger numberOfNonHcTenantsValue = new AtomicInteger(0);
    private final Gauge<Integer> numberOfNonHcTenantsMetric = (config, now) -> this.numberOfNonHcTenantsValue.get();
    protected final Time time;
    protected final ScheduledExecutorService backgroundUpdatesExecutorService;
    protected List<String> multitenantListenerNames = Collections.emptyList();
    protected final Map<String, LCMPair> logicalClusterMap;
    protected final AtomicReference<State> logConsumerState;
    protected long maxPartitionRetryDelayMs;
    protected String topicName;
    private String topicClientId;
    private long topicLoadTimeoutMs;
    protected KafkaBasedLog<String, byte[]> lcLog;

    public CommonTopicBasedPhysicalClusterMetadata(Metrics metrics) {
        this(metrics, Time.SYSTEM);
    }

    public CommonTopicBasedPhysicalClusterMetadata(Metrics metrics, Time time) {
        MetricName numTenantsMetricName = metrics.metricName(NUMBER_OF_TENANTS_METRIC_NAME, NUMBER_OF_TENANTS_GROUP_NAME, "The number of tenants (i.e. logical clusters) in the physical cluster");
        MetricName numNonHcTenantsMetricName = metrics.metricName(NUMBER_OF_NON_HC_TENANTS_METRIC_NAME, NUMBER_OF_TENANTS_GROUP_NAME, "The number of non-healthcheck tenants (i.e. logical clusters) in the physical cluster");
        if (!metrics.metrics().containsKey(numTenantsMetricName)) {
            metrics.addMetric(numTenantsMetricName, this.numberOfTenantsMetric);
        }
        if (!metrics.metrics().containsKey(numNonHcTenantsMetricName)) {
            metrics.addMetric(numNonHcTenantsMetricName, this.numberOfNonHcTenantsMetric);
        }
        this.time = time;
        this.logConsumerState = new AtomicReference<State>(State.NOT_READY);
        this.logicalClusterMap = new ConcurrentHashMap<String, LCMPair>();
        this.backgroundUpdatesExecutorService = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "cluster-metadata-bg-updates");
            thread.setDaemon(true);
            return thread;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Map<String, ?> configs) {
        Map map = INSTANCES;
        synchronized (map) {
            BasePhysicalClusterMetadata instance = (BasePhysicalClusterMetadata)INSTANCES.get(this.getSessionUuid(configs));
            if (instance != null) {
                if (this != instance) {
                    throw new IllegalStateException("TopicBasedPhysicalClusterMetadata instance already exists for Authnz session " + this.getSessionUuid(configs));
                }
                LOG.info("Skipping configuring this instance (session {}): Already configured.", (Object)this.getSessionUuid(configs));
                return;
            }
            INSTANCES.put(this.getSessionUuid(configs), this);
        }
        this.setFieldsFromConfig(configs);
        LOG.warn("Configured and started instance for session {}", (Object)this.getSessionUuid(configs));
    }

    protected abstract String getSessionUuid(Map<String, ?> var1);

    protected abstract Sensor getStartSensor();

    protected abstract Sensor getEndToEndSensor();

    protected abstract String getTopicConfig();

    protected abstract String getTopicClientId(Map<String, ?> var1);

    private void setFieldsFromConfig(Map<String, ?> configs) {
        String topicConfig = this.getTopicConfig();
        this.topicName = (String)configs.get(topicConfig);
        if (this.topicName == null || this.topicName.isEmpty()) {
            throw new ConfigException("Config " + topicConfig + " can not be empty when using TopicBasedPhysicalClusterMetadata");
        }
        this.topicClientId = this.getTopicClientId(configs);
        Long timeoutValue = (Long)configs.get("confluent.cdc.api.keys.topic.load.timeout.ms");
        if (timeoutValue == null || timeoutValue <= 0L) {
            throw new ConfigException("Config confluent.cdc.api.keys.topic.load.timeout.ms must be positive integer when using TopicBasedPhysicalClusterMetadata");
        }
        this.topicLoadTimeoutMs = timeoutValue;
        Long reloadDelayValue = (Long)configs.get("multitenant.metadata.reload.delay.ms");
        this.maxPartitionRetryDelayMs = reloadDelayValue == null ? ConfluentConfigs.MULTITENANT_METADATA_RELOAD_DELAY_MS_DEFAULT.longValue() : reloadDelayValue.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String sessionUuid) {
        Map map = INSTANCES;
        synchronized (map) {
            BasePhysicalClusterMetadata instance = (BasePhysicalClusterMetadata)INSTANCES.get(sessionUuid);
            if (instance != null && instance == this) {
                INSTANCES.remove(sessionUuid);
                LOG.info("Removed instance for broker session {}", (Object)sessionUuid);
            } else if (instance != null) {
                LOG.info("Closing instance that doesn't match the instance in the static map with the same session {} will not remove that instance from the map.", (Object)sessionUuid);
            }
        }
        this.shutdown();
    }

    public CompletableFuture<Void> start(Map<String, Object> clientConfig) {
        CompletableFuture<Void> logStartedFuture;
        this.interBrokerClientConfig = new HashMap<String, Object>(clientConfig);
        if (this.logConsumerState.compareAndSet(State.NOT_READY, State.STARTING)) {
            this.lcLog = this.createKafkaBasedLog(clientConfig);
            try {
                logStartedFuture = CompletableFuture.runAsync(() -> this.startLog());
            }
            catch (Exception e) {
                this.logConsumerState.set(State.FAILED_TO_START);
                throw new IllegalStateException("Unable to create a future for startLog()", e);
            }
        } else {
            this.ensureNonTerminalState(this.logConsumerState.get());
            LOG.warn("Trying to start a consumer which was already started!");
            logStartedFuture = CompletableFuture.completedFuture(null);
        }
        return logStartedFuture;
    }

    protected abstract void startLog();

    protected abstract void shutdown();

    public boolean isUp() {
        return State.RUNNING.equals((Object)this.logConsumerState.get());
    }

    @Override
    public abstract Set<String> logicalClusterIds();

    @Override
    public Set<String> logicalClusterIdsIncludingStale() {
        this.ensureOpen();
        return ImmutableSet.copyOf(this.logicalClusterMap.keySet());
    }

    @Override
    public LCMType metadata(String logicalClusterId) {
        this.ensureOpen();
        LCMPair lcmPair = this.logicalClusterMap.get(logicalClusterId);
        if (lcmPair != null && lcmPair.isActiveCluster()) {
            return lcmPair.getLCM();
        }
        return null;
    }

    protected abstract LCMType parseLCM(ConsumerRecord<String, byte[]> var1);

    protected void updateNumberOfTenantsMetric() {
        List activeClusters = this.logicalClusterMap.values().stream().filter(LCMPair::exists).filter(LCMPair::isActiveCluster).collect(Collectors.toList());
        this.numberOfTenantsValue.set(activeClusters.size());
        this.numberOfNonHcTenantsValue.set((int)activeClusters.stream().filter(lcm -> !((LogicalClusterMetadata)lcm.getLCM()).isHealthcheckLogicalCluster()).count());
    }

    protected abstract void recordEndToEndSensor(LCMType var1);

    private void updateTenant(LCMType oldLcm, LCMType newLcm) {
        if (State.RUNNING.equals((Object)this.logConsumerState.get())) {
            if (newLcm != null) {
                LOG.info("Adding or updating lc metadata for cluster: ", (Object)((LogicalClusterMetadata)newLcm).logicalClusterId());
                this.recordEndToEndSensor(newLcm);
            } else {
                LOG.info("Deleting lc metadata for cluster: ", (Object)((LogicalClusterMetadata)oldLcm).logicalClusterId());
            }
            this.postUpdateBookkeeping();
        }
    }

    protected void postUpdateBookkeeping() {
        this.updateNumberOfTenantsMetric();
        this.updateLogicalClusterIds();
    }

    private void updateLogicalClusterIds() {
        this.logicalClusterIds = this.logicalClusterMap.values().stream().filter(LCMPair::exists).filter(e -> ((LogicalClusterMetadata)e.getLCM()).isValid()).map(e -> ((LogicalClusterMetadata)e.getLCM()).logicalClusterId()).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLogicalCluster(String clusterId, Long sequenceId, LCMType lcm) {
        if (!this.isStartingOrRunningState(this.logConsumerState.get())) {
            LOG.warn("Tried to add or update a logical cluster with a non running log (state = {})", (Object)this.logConsumerState.get());
        } else {
            Map<String, LCMPair> map = this.logicalClusterMap;
            synchronized (map) {
                LCMPair prevRecord = this.logicalClusterMap.get(clusterId);
                if (prevRecord == null || prevRecord.getSequenceId() < sequenceId) {
                    this.logicalClusterMap.put(clusterId, new LCMPair(this, sequenceId.longValue(), lcm));
                    LCMType prevLcm = null;
                    if (prevRecord != null) {
                        prevLcm = prevRecord.getLCM();
                    }
                    this.updateTenant(prevLcm, lcm);
                } else {
                    LOG.warn("Got asked to update a cluster {} which has a newer sequence id in map: {}", (Object)clusterId, (Object)prevRecord.getSequenceId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLogicalCluster(String clusterId, Long sequenceId) {
        if (!this.isStartingOrRunningState(this.logConsumerState.get())) {
            LOG.warn("Tried to add or update a logical cluster with a non running log (state = {})", (Object)this.logConsumerState.get());
        } else {
            Map<String, LCMPair> map = this.logicalClusterMap;
            synchronized (map) {
                LCMPair prevRecord = this.logicalClusterMap.get(clusterId);
                if (prevRecord == null) {
                    LOG.warn("Got asked to remove a cluster {} which isn't in the map", (Object)clusterId);
                } else if (prevRecord.getSequenceId() < sequenceId) {
                    this.logicalClusterMap.put(clusterId, new LCMPair(this, sequenceId.longValue(), null));
                    this.updateTenant(prevRecord.getLCM(), null);
                } else {
                    LOG.warn("Got asked to remove a cluster {} which has a newer sequence id in map: {}", (Object)clusterId, (Object)prevRecord.getSequenceId());
                }
            }
        }
    }

    public void consume(ConsumerRecord<String, byte[]> record) {
        String lcId = (String)record.key();
        if (lcId == null) {
            LOG.error("Missing key in LC metadata record! (partition = {}, offset = {}, timestamp = {}", new Object[]{record.partition(), record.offset(), record.timestamp()});
            return;
        }
        Long sequenceId = AuthUtils.tryParseEventsSequenceId(record);
        if (sequenceId == null) {
            LOG.error("Unable to decode sequence id for lc metadata message (key = {}, partition = {}, offset = {}, timestamp = {})", new Object[]{lcId, record.partition(), record.offset(), record.timestamp()});
            return;
        }
        if (record.value() == null) {
            LOG.info("seqId: {}. Removing Logical cluster metadata for {}", (Object)sequenceId, (Object)lcId);
            this.removeLogicalCluster(lcId, sequenceId);
        } else {
            try {
                LCMType lcm = this.parseLCM(record);
                if (((LogicalClusterMetadata)lcm).isValid()) {
                    if (!lcId.equals(((LogicalClusterMetadata)lcm).logicalClusterId())) {
                        LOG.error("seqId: {}. LKC id in key ({}) doesn't match one in message: {}. Skipping!", new Object[]{sequenceId, lcId, ((LogicalClusterMetadata)lcm).logicalClusterId()});
                    } else {
                        LOG.info("seqId: {}. Updating LogicalClusterMetadata for {}", (Object)sequenceId, (Object)lcId);
                        this.updateLogicalCluster(lcId, sequenceId, lcm);
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                LOG.error(String.format("seqId: %s. Unable to decode lkc metadata message for key %s", sequenceId, lcId), (Throwable)iae);
            }
        }
    }

    protected KafkaBasedLog<String, byte[]> createKafkaBasedLog(Map<String, ?> clientConfigs) {
        HashSet consumerConfigNames = new HashSet(ConsumerConfig.configNames());
        consumerConfigNames.remove("metric.reporters");
        HashMap consumerProps = new HashMap(clientConfigs);
        consumerProps.keySet().retainAll(consumerConfigNames);
        consumerProps.put("client.id", this.topicClientId);
        consumerProps.put("bootstrap.servers", clientConfigs.get("bootstrap.servers"));
        consumerProps.put("allow.auto.create.topics", false);
        consumerProps.put("key.deserializer", StringDeserializer.class.getName());
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("default.api.timeout.ms", (int)Math.min(this.topicLoadTimeoutMs, Integer.MAX_VALUE));
        return new KafkaBasedLog(this.topicName, null, consumerProps, (Callback)new ConsumeCallback(), this.time, null, this.topicLoadTimeoutMs);
    }

    protected abstract void ensureOpen();

    protected void ensureNonTerminalState(State state) {
        if (State.FAILED_TO_START.equals((Object)state) || State.CLOSED.equals((Object)state)) {
            throw new IllegalStateException("Unable to resume from state: " + state.toString());
        }
    }

    protected boolean isStartingOrRunningState(State state) {
        return State.STARTING.equals((Object)state) || State.RUNNING.equals((Object)state);
    }

    private class ConsumeCallback
    implements Callback<ConsumerRecord<String, byte[]>> {
        private ConsumeCallback() {
        }

        public void onCompletion(Throwable error, ConsumerRecord<String, byte[]> record) {
            if (error != null) {
                LOG.error("Unexpected error in ConsumeCallback for TopicBasedPhysicalClusterMetadata", error);
            } else {
                CommonTopicBasedPhysicalClusterMetadata.this.consume(record);
            }
        }
    }

    public static enum State {
        NOT_READY,
        STARTING,
        RUNNING,
        CLOSED,
        FAILED_TO_START;

    }

    protected class LCMPair {
        private final long sequenceId;
        private final LCMType lcm;
        final /* synthetic */ CommonTopicBasedPhysicalClusterMetadata this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        LCMPair(long lcm, LCMType LCMType) {
            void sequenceId;
            this.this$0 = (CommonTopicBasedPhysicalClusterMetadata)this$0;
            this.sequenceId = sequenceId;
            this.lcm = lcm;
        }

        long getSequenceId() {
            return this.sequenceId;
        }

        boolean exists() {
            return this.lcm != null;
        }

        boolean isActiveCluster() {
            return this.lcm != null && ((LogicalClusterMetadata)this.lcm).isActive();
        }

        LCMType getLCM() {
            return this.lcm;
        }
    }
}

