/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.network.PublicCredential;

public class MultiTenantSaslSecrets {
    private final Map<String, MultiTenantSaslConfigEntry> entries;

    @JsonCreator
    public MultiTenantSaslSecrets(@JsonProperty(value="keys", required=true) Map<String, MultiTenantSaslConfigEntry> entries) {
        this.entries = entries == null ? Collections.emptyMap() : Collections.unmodifiableMap(entries);
        for (Map.Entry<String, MultiTenantSaslConfigEntry> entry : this.entries.entrySet()) {
            if (entry.getKey() == null) {
                throw new RuntimeException("Invalid null key in map.");
            }
            if (entry.getValue() != null) continue;
            throw new RuntimeException("Invalid null value for " + entry.getKey() + " in map.");
        }
    }

    @JsonProperty(value="keys")
    public Map<String, MultiTenantSaslConfigEntry> entries() {
        return this.entries;
    }

    public Set<PublicCredential> deletedCredentials(MultiTenantSaslSecrets oldSecrets) {
        HashSet<PublicCredential> deleted = new HashSet<PublicCredential>();
        oldSecrets.entries().keySet().forEach(apiKey -> {
            if (!this.entries.containsKey(apiKey)) {
                deleted.add(PublicCredential.saslCredential((String)apiKey, (String)"PLAIN"));
            }
        });
        return deleted;
    }
}

