/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.base.CaseFormat;
import java.lang.reflect.Method;

public class PropertyNamingStrategyWrapper
extends PropertyNamingStrategy.PropertyNamingStrategyBase {
    private static final PropertyNamingStrategy.PropertyNamingStrategyBase SNAKE_TO_CAMEL = new SnakeToCamelNamingStrategy();
    private static final PropertyNamingStrategy.PropertyNamingStrategyBase NO_OP = new NoOpNamingStrategy();
    private final PropertyNamingStrategy.PropertyNamingStrategyBase delegate;

    public PropertyNamingStrategyWrapper(PropertyNamingStrategy delegate) {
        this.delegate = delegate instanceof PropertyNamingStrategy.PropertyNamingStrategyBase ? (PropertyNamingStrategy.PropertyNamingStrategyBase)delegate : (NamingBaseAdapter.extendsNamingBase(delegate) ? new NamingBaseAdapter(delegate) : (delegate == PropertyNamingStrategy.LOWER_CAMEL_CASE ? NO_OP : SNAKE_TO_CAMEL));
    }

    public String translate(String fieldName) {
        return this.delegate.translate(fieldName);
    }

    private static class NamingBaseAdapter
    extends PropertyNamingStrategy.PropertyNamingStrategyBase {
        private static final Class<?> NAMING_BASE = NamingBaseAdapter.tryToLoadNamingBase();
        private static final Method TRANSLATE_METHOD = NamingBaseAdapter.tryToLoadTranslateMethod(NAMING_BASE);
        private final PropertyNamingStrategy delegate;

        private NamingBaseAdapter(PropertyNamingStrategy delegate) {
            this.delegate = delegate;
        }

        public static boolean extendsNamingBase(PropertyNamingStrategy namingStrategy) {
            return NAMING_BASE != null && NAMING_BASE.isInstance(namingStrategy);
        }

        public String translate(String fieldName) {
            try {
                return (String)TRANSLATE_METHOD.invoke((Object)this.delegate, fieldName);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Unable to invoke translate method", e);
            }
        }

        private static Class<?> tryToLoadNamingBase() {
            try {
                return Class.forName("com.fasterxml.jackson.databind.PropertyNamingStrategies$NamingBase");
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private static Method tryToLoadTranslateMethod(Class<?> namingBase) {
            if (namingBase == null) {
                return null;
            }
            try {
                return namingBase.getMethod("translate", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Unable to find translate method on class: " + namingBase);
            }
        }
    }

    private static class NoOpNamingStrategy
    extends PropertyNamingStrategy.PropertyNamingStrategyBase {
        private NoOpNamingStrategy() {
        }

        public String translate(String fieldName) {
            return fieldName;
        }
    }

    private static class SnakeToCamelNamingStrategy
    extends PropertyNamingStrategy.PropertyNamingStrategyBase {
        private SnakeToCamelNamingStrategy() {
        }

        public String translate(String fieldName) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName);
        }
    }
}

