/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf.builtin.serializers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageOrBuilder;
import com.hubspot.jackson.datatype.protobuf.ExtensionRegistryWrapper;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.hubspot.jackson.datatype.protobuf.ProtobufSerializer;
import com.hubspot.jackson.datatype.protobuf.internal.PropertyNamingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class MessageSerializer
extends ProtobufSerializer<MessageOrBuilder> {
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final ProtobufJacksonConfig config;
    private final boolean unwrappingSerializer;
    private final Map<Descriptors.Descriptor, PropertyNamingCache> propertyNamingCache;

    @Deprecated
    public MessageSerializer(ExtensionRegistryWrapper extensionRegistry) {
        this(ProtobufJacksonConfig.builder().extensionRegistry(extensionRegistry).build());
    }

    public MessageSerializer(ProtobufJacksonConfig config) {
        this(config, false);
    }

    private MessageSerializer(ProtobufJacksonConfig config, boolean unwrappingSerializer) {
        super(MessageOrBuilder.class);
        this.config = config;
        this.unwrappingSerializer = unwrappingSerializer;
        this.propertyNamingCache = new ConcurrentHashMap<Descriptors.Descriptor, PropertyNamingCache>();
    }

    public void serialize(MessageOrBuilder message, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        if (!this.isUnwrappingSerializer()) {
            generator.writeStartObject();
        }
        boolean proto3 = message.getDescriptorForType().getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3;
        JsonInclude.Include include = serializerProvider.getConfig().getDefaultPropertyInclusion().getValueInclusion();
        boolean writeDefaultValues = proto3 && include != JsonInclude.Include.NON_DEFAULT;
        boolean writeEmptyCollections = include != JsonInclude.Include.NON_DEFAULT && include != JsonInclude.Include.NON_EMPTY;
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        Function<Descriptors.FieldDescriptor, String> propertyNaming = this.getPropertyNaming(descriptor, serializerProvider);
        ArrayList<Descriptors.FieldDescriptor> fields = descriptor.getFields();
        if (message instanceof GeneratedMessageV3.ExtendableMessageOrBuilder) {
            fields = new ArrayList<Descriptors.FieldDescriptor>(fields);
            for (ExtensionRegistry.ExtensionInfo extensionInfo : this.config.extensionRegistry().getExtensionsByDescriptor(descriptor)) {
                fields.add(extensionInfo.descriptor);
            }
        }
        for (Descriptors.FieldDescriptor field : fields) {
            String fieldName = propertyNaming.apply(field);
            if (field.isRepeated()) {
                List valueList = (List)message.getField(field);
                if (valueList.isEmpty() && !writeEmptyCollections) continue;
                if (field.isMapField()) {
                    generator.writeFieldName(fieldName);
                    this.writeMap(field, valueList, generator, serializerProvider);
                    continue;
                }
                if (valueList.size() == 1 && MessageSerializer.writeSingleElementArraysUnwrapped(serializerProvider)) {
                    generator.writeFieldName(fieldName);
                    this.writeValue(field, valueList.get(0), generator, serializerProvider);
                    continue;
                }
                generator.writeArrayFieldStart(fieldName);
                for (Object subValue : valueList) {
                    this.writeValue(field, subValue, generator, serializerProvider);
                }
                generator.writeEndArray();
                continue;
            }
            if (message.hasField(field) || writeDefaultValues && !MessageSerializer.supportsFieldPresence(field) && field.getContainingOneof() == null) {
                generator.writeFieldName(fieldName);
                this.writeValue(field, message.getField(field), generator, serializerProvider);
                continue;
            }
            if (include != JsonInclude.Include.ALWAYS || field.getContainingOneof() != null) continue;
            generator.writeFieldName(fieldName);
            generator.writeNull();
        }
        if (!this.isUnwrappingSerializer()) {
            generator.writeEndObject();
        }
    }

    public boolean isUnwrappingSerializer() {
        return this.unwrappingSerializer;
    }

    public MessageSerializer unwrappingSerializer(NameTransformer nameTransformer) {
        return new MessageSerializer(this.config, true);
    }

    private Function<Descriptors.FieldDescriptor, String> getPropertyNaming(Descriptors.Descriptor descriptor, SerializerProvider serializerProvider) {
        PropertyNamingCache cache = this.propertyNamingCache.get(descriptor);
        if (cache == null) {
            cache = this.propertyNamingCache.computeIfAbsent(descriptor, ignored -> PropertyNamingCache.forDescriptor(descriptor, this.config));
        }
        return cache.forSerialization(serializerProvider.getConfig().getPropertyNamingStrategy());
    }

    private static boolean supportsFieldPresence(Descriptors.FieldDescriptor field) {
        return field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE;
    }

    private static boolean writeSingleElementArraysUnwrapped(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
    }
}

