/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf.internal;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import com.hubspot.jackson.datatype.protobuf.PropertyNamingStrategyWrapper;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;

public class PropertyNamingCache {
    private final Descriptors.Descriptor descriptor;
    private final ProtobufJacksonConfig config;
    private final Map<PropertyNamingStrategy, Function<Descriptors.FieldDescriptor, String>> serializationCache;
    private final Map<PropertyNamingStrategy, Function<String, Descriptors.FieldDescriptor>> deserializationCache;

    private PropertyNamingCache(Descriptors.Descriptor descriptor, ProtobufJacksonConfig config) {
        this.descriptor = descriptor;
        this.config = config;
        this.serializationCache = Collections.synchronizedMap(new WeakHashMap());
        this.deserializationCache = Collections.synchronizedMap(new WeakHashMap());
    }

    public static PropertyNamingCache forDescriptor(Descriptors.Descriptor descriptor, ProtobufJacksonConfig config) {
        return new PropertyNamingCache(descriptor, config);
    }

    public Function<Descriptors.FieldDescriptor, String> forSerialization(PropertyNamingStrategy propertyNamingStrategy) {
        Function<Descriptors.FieldDescriptor, String> cached = this.serializationCache.get(propertyNamingStrategy);
        if (cached != null) {
            return cached;
        }
        Function<Descriptors.FieldDescriptor, String> function = this.buildSerializationFunction(this.descriptor, propertyNamingStrategy);
        this.serializationCache.put(propertyNamingStrategy, function);
        return function;
    }

    public Function<String, Descriptors.FieldDescriptor> forDeserialization(PropertyNamingStrategy propertyNamingStrategy) {
        Function<String, Descriptors.FieldDescriptor> cached = this.deserializationCache.get(propertyNamingStrategy);
        if (cached != null) {
            return cached;
        }
        Function<String, Descriptors.FieldDescriptor> function = this.buildDeserializationFunction(this.descriptor, propertyNamingStrategy);
        this.deserializationCache.put(propertyNamingStrategy, function);
        return function;
    }

    private Function<Descriptors.FieldDescriptor, String> buildSerializationFunction(Descriptors.Descriptor descriptor, PropertyNamingStrategy originalNamingStrategy) {
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(originalNamingStrategy);
        HashMap<Descriptors.FieldDescriptor, String> tempMap = new HashMap<Descriptors.FieldDescriptor, String>();
        for (Descriptors.FieldDescriptor field2 : descriptor.getFields()) {
            tempMap.put(field2, namingStrategy.translate(field2.getName()));
        }
        ImmutableMap fieldLookup = ImmutableMap.copyOf(tempMap);
        return field -> {
            String name = (String)fieldLookup.get(field);
            return name == null ? namingStrategy.translate(field.getName()) : name;
        };
    }

    private Function<String, Descriptors.FieldDescriptor> buildDeserializationFunction(Descriptors.Descriptor descriptor, PropertyNamingStrategy originalNamingStrategy) {
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(originalNamingStrategy);
        HashMap<String, Descriptors.FieldDescriptor> tempMap = new HashMap<String, Descriptors.FieldDescriptor>();
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            tempMap.put(namingStrategy.translate(field.getName()), field);
        }
        if (this.config.acceptLiteralFieldnames()) {
            for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
                if (tempMap.containsKey(field.getName())) continue;
                tempMap.put(field.getName(), field);
            }
        }
        ImmutableMap fieldLookup = ImmutableMap.copyOf(tempMap);
        return ((Map)fieldLookup)::get;
    }
}

