/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.disposables;

import io.confluent.shaded.io.reactivex.annotations.NonNull;
import io.confluent.shaded.io.reactivex.disposables.ActionDisposable;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.disposables.FutureDisposable;
import io.confluent.shaded.io.reactivex.disposables.RunnableDisposable;
import io.confluent.shaded.io.reactivex.disposables.SubscriptionDisposable;
import io.confluent.shaded.io.reactivex.functions.Action;
import io.confluent.shaded.io.reactivex.internal.disposables.EmptyDisposable;
import io.confluent.shaded.io.reactivex.internal.functions.Functions;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.org.reactivestreams.Subscription;
import java.util.concurrent.Future;

public final class Disposables {
    private Disposables() {
        throw new IllegalStateException("No instances!");
    }

    @NonNull
    public static Disposable fromRunnable(@NonNull Runnable run) {
        ObjectHelper.requireNonNull(run, "run is null");
        return new RunnableDisposable(run);
    }

    @NonNull
    public static Disposable fromAction(@NonNull Action run) {
        ObjectHelper.requireNonNull(run, "run is null");
        return new ActionDisposable(run);
    }

    @NonNull
    public static Disposable fromFuture(@NonNull Future<?> future) {
        ObjectHelper.requireNonNull(future, "future is null");
        return Disposables.fromFuture(future, true);
    }

    @NonNull
    public static Disposable fromFuture(@NonNull Future<?> future, boolean allowInterrupt) {
        ObjectHelper.requireNonNull(future, "future is null");
        return new FutureDisposable(future, allowInterrupt);
    }

    @NonNull
    public static Disposable fromSubscription(@NonNull Subscription subscription) {
        ObjectHelper.requireNonNull(subscription, "subscription is null");
        return new SubscriptionDisposable(subscription);
    }

    @NonNull
    public static Disposable empty() {
        return Disposables.fromRunnable(Functions.EMPTY_RUNNABLE);
    }

    @NonNull
    public static Disposable disposed() {
        return EmptyDisposable.INSTANCE;
    }
}

