/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.ObservableSource;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.confluent.shaded.io.reactivex.observers.DisposableObserver;
import io.confluent.shaded.io.reactivex.observers.SerializedObserver;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableDebounce<T, U>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super T, ? extends ObservableSource<U>> debounceSelector;

    public ObservableDebounce(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<U>> debounceSelector) {
        super(source);
        this.debounceSelector = debounceSelector;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new DebounceObserver(new SerializedObserver<T>(t), this.debounceSelector));
    }

    static final class DebounceObserver<T, U>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final Function<? super T, ? extends ObservableSource<U>> debounceSelector;
        Disposable upstream;
        final AtomicReference<Disposable> debouncer = new AtomicReference();
        volatile long index;
        boolean done;

        DebounceObserver(Observer<? super T> actual, Function<? super T, ? extends ObservableSource<U>> debounceSelector) {
            this.downstream = actual;
            this.debounceSelector = debounceSelector;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            ObservableSource<U> p;
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            Disposable d = this.debouncer.get();
            if (d != null) {
                d.dispose();
            }
            try {
                p = ObjectHelper.requireNonNull(this.debounceSelector.apply(t), "The ObservableSource supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.dispose();
                this.downstream.onError(e);
                return;
            }
            DebounceInnerObserver dis = new DebounceInnerObserver(this, idx, t);
            if (this.debouncer.compareAndSet(d, dis)) {
                p.subscribe(dis);
            }
        }

        @Override
        public void onError(Throwable t) {
            DisposableHelper.dispose(this.debouncer);
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Disposable d = this.debouncer.get();
            if (d != DisposableHelper.DISPOSED) {
                DebounceInnerObserver dis = (DebounceInnerObserver)d;
                if (dis != null) {
                    dis.emit();
                }
                DisposableHelper.dispose(this.debouncer);
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            DisposableHelper.dispose(this.debouncer);
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        void emit(long idx, T value) {
            if (idx == this.index) {
                this.downstream.onNext(value);
            }
        }

        static final class DebounceInnerObserver<T, U>
        extends DisposableObserver<U> {
            final DebounceObserver<T, U> parent;
            final long index;
            final T value;
            boolean done;
            final AtomicBoolean once = new AtomicBoolean();

            DebounceInnerObserver(DebounceObserver<T, U> parent, long index, T value) {
                this.parent = parent;
                this.index = index;
                this.value = value;
            }

            @Override
            public void onNext(U t) {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.dispose();
                this.emit();
            }

            void emit() {
                if (this.once.compareAndSet(false, true)) {
                    this.parent.emit(this.index, this.value);
                }
            }

            @Override
            public void onError(Throwable t) {
                if (this.done) {
                    RxJavaPlugins.onError(t);
                    return;
                }
                this.done = true;
                this.parent.onError(t);
            }

            @Override
            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.emit();
            }
        }
    }
}

