/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.netty.handler.intercept;

import io.confluent.shaded.org.asynchttpclient.AsyncHandler;
import io.confluent.shaded.org.asynchttpclient.AsyncHttpClientConfig;
import io.confluent.shaded.org.asynchttpclient.HttpResponseStatus;
import io.confluent.shaded.org.asynchttpclient.Realm;
import io.confluent.shaded.org.asynchttpclient.Request;
import io.confluent.shaded.org.asynchttpclient.cookie.CookieStore;
import io.confluent.shaded.org.asynchttpclient.netty.NettyResponseFuture;
import io.confluent.shaded.org.asynchttpclient.netty.channel.ChannelManager;
import io.confluent.shaded.org.asynchttpclient.netty.handler.intercept.ConnectSuccessInterceptor;
import io.confluent.shaded.org.asynchttpclient.netty.handler.intercept.Continue100Interceptor;
import io.confluent.shaded.org.asynchttpclient.netty.handler.intercept.ProxyUnauthorized407Interceptor;
import io.confluent.shaded.org.asynchttpclient.netty.handler.intercept.Redirect30xInterceptor;
import io.confluent.shaded.org.asynchttpclient.netty.handler.intercept.ResponseFiltersInterceptor;
import io.confluent.shaded.org.asynchttpclient.netty.handler.intercept.Unauthorized401Interceptor;
import io.confluent.shaded.org.asynchttpclient.netty.request.NettyRequestSender;
import io.confluent.shaded.org.asynchttpclient.proxy.ProxyServer;
import io.confluent.shaded.org.asynchttpclient.util.HttpConstants;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;

public class Interceptors {
    private final AsyncHttpClientConfig config;
    private final Unauthorized401Interceptor unauthorized401Interceptor;
    private final ProxyUnauthorized407Interceptor proxyUnauthorized407Interceptor;
    private final Continue100Interceptor continue100Interceptor;
    private final Redirect30xInterceptor redirect30xInterceptor;
    private final ConnectSuccessInterceptor connectSuccessInterceptor;
    private final ResponseFiltersInterceptor responseFiltersInterceptor;
    private final boolean hasResponseFilters;
    private final ClientCookieDecoder cookieDecoder;

    public Interceptors(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        this.config = config;
        this.unauthorized401Interceptor = new Unauthorized401Interceptor(channelManager, requestSender);
        this.proxyUnauthorized407Interceptor = new ProxyUnauthorized407Interceptor(channelManager, requestSender);
        this.continue100Interceptor = new Continue100Interceptor(requestSender);
        this.redirect30xInterceptor = new Redirect30xInterceptor(channelManager, config, requestSender);
        this.connectSuccessInterceptor = new ConnectSuccessInterceptor(channelManager, requestSender);
        this.responseFiltersInterceptor = new ResponseFiltersInterceptor(config, requestSender);
        this.hasResponseFilters = !config.getResponseFilters().isEmpty();
        this.cookieDecoder = config.isUseLaxCookieEncoder() ? ClientCookieDecoder.LAX : ClientCookieDecoder.STRICT;
    }

    public boolean exitAfterIntercept(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponse response, HttpResponseStatus status, HttpHeaders responseHeaders) throws Exception {
        HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
        ProxyServer proxyServer = future.getProxyServer();
        int statusCode = response.status().code();
        Request request = future.getCurrentRequest();
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        CookieStore cookieStore = this.config.getCookieStore();
        if (cookieStore != null) {
            for (String cookieStr : responseHeaders.getAll((CharSequence)HttpHeaderNames.SET_COOKIE)) {
                Cookie c = this.cookieDecoder.decode(cookieStr);
                if (c == null) continue;
                cookieStore.add(future.getCurrentRequest().getUri(), c);
            }
        }
        if (this.hasResponseFilters && this.responseFiltersInterceptor.exitAfterProcessingFilters(channel, future, handler, status, responseHeaders)) {
            return true;
        }
        if (statusCode == HttpConstants.ResponseStatusCodes.UNAUTHORIZED_401) {
            return this.unauthorized401Interceptor.exitAfterHandling401(channel, future, response, request, realm, httpRequest);
        }
        if (statusCode == HttpConstants.ResponseStatusCodes.PROXY_AUTHENTICATION_REQUIRED_407) {
            return this.proxyUnauthorized407Interceptor.exitAfterHandling407(channel, future, response, request, proxyServer, httpRequest);
        }
        if (statusCode == HttpConstants.ResponseStatusCodes.CONTINUE_100) {
            return this.continue100Interceptor.exitAfterHandling100(channel, future);
        }
        if (Redirect30xInterceptor.REDIRECT_STATUSES.contains(statusCode)) {
            return this.redirect30xInterceptor.exitAfterHandlingRedirect(channel, future, response, request, statusCode, realm);
        }
        if (httpRequest.method() == HttpMethod.CONNECT && statusCode == HttpConstants.ResponseStatusCodes.OK_200) {
            return this.connectSuccessInterceptor.exitAfterHandlingConnect(channel, future, request, proxyServer);
        }
        return false;
    }
}

