/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.netty.timeout;

import io.confluent.shaded.org.asynchttpclient.netty.NettyResponseFuture;
import io.confluent.shaded.org.asynchttpclient.netty.channel.Channels;
import io.confluent.shaded.org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import io.confluent.shaded.org.asynchttpclient.netty.request.NettyRequestSender;
import io.confluent.shaded.org.asynchttpclient.netty.timeout.TimeoutTimerTask;
import io.confluent.shaded.org.asynchttpclient.netty.timeout.TimeoutsHolder;
import io.confluent.shaded.org.asynchttpclient.util.DateUtils;
import io.confluent.shaded.org.asynchttpclient.util.StringBuilderPool;
import io.netty.util.Timeout;

public class ReadTimeoutTimerTask
extends TimeoutTimerTask {
    private final long readTimeout;

    ReadTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, int readTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.readTimeout = readTimeout;
    }

    public void run(Timeout timeout) {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        if (this.nettyResponseFuture.isDone()) {
            this.timeoutsHolder.cancel();
            return;
        }
        long now = DateUtils.unpreciseMillisTime();
        long currentReadTimeoutInstant = this.readTimeout + this.nettyResponseFuture.getLastTouch();
        long durationBeforeCurrentReadTimeout = currentReadTimeoutInstant - now;
        if (durationBeforeCurrentReadTimeout <= 0L && !this.isReactiveWithNoOutstandingRequest()) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder().append("Read timeout to ");
            this.appendRemoteAddress(sb);
            String message = sb.append(" after ").append(this.readTimeout).append(" ms").toString();
            long durationSinceLastTouch = now - this.nettyResponseFuture.getLastTouch();
            this.expire(message, durationSinceLastTouch);
            this.timeoutsHolder.cancel();
        } else {
            this.done.set(false);
            this.timeoutsHolder.startReadTimeout(this);
        }
    }

    private boolean isReactiveWithNoOutstandingRequest() {
        Object attribute = Channels.getAttribute(this.nettyResponseFuture.channel());
        return attribute instanceof StreamedResponsePublisher && !((StreamedResponsePublisher)attribute).hasOutstandingRequest();
    }
}

