/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.request.body.multipart.part;

import io.confluent.shaded.org.asynchttpclient.request.body.multipart.StringPart;
import io.confluent.shaded.org.asynchttpclient.request.body.multipart.part.MultipartPart;
import io.confluent.shaded.org.asynchttpclient.request.body.multipart.part.MultipartState;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

public class StringMultipartPart
extends MultipartPart<StringPart> {
    private final ByteBuf contentBuffer;

    public StringMultipartPart(StringPart part, byte[] boundary) {
        super(part, boundary);
        this.contentBuffer = Unpooled.wrappedBuffer((byte[])part.getValue().getBytes(part.getCharset()));
    }

    @Override
    protected long getContentLength() {
        return this.contentBuffer.capacity();
    }

    @Override
    protected long transferContentTo(ByteBuf target) {
        return this.transfer(this.contentBuffer, target, MultipartState.POST_CONTENT);
    }

    @Override
    protected long transferContentTo(WritableByteChannel target) throws IOException {
        return this.transfer(this.contentBuffer, target, MultipartState.POST_CONTENT);
    }

    @Override
    public void close() {
        super.close();
        this.contentBuffer.release();
    }
}

