/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.schema;

import io.confluent.kafka.schemaregistry.json.schema.SchemaTranslator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.TrueSchema;

public class SchemaUtils {
    private static volatile Method isSyntheticMethod;

    public static Schema.Builder<?> schemaToBuilder(Schema s) {
        if (s instanceof TrueSchema) {
            return SchemaUtils.toBuilder((TrueSchema)s);
        }
        if (s instanceof ArraySchema) {
            return SchemaUtils.toBuilder((ArraySchema)s);
        }
        if (s instanceof BooleanSchema) {
            return SchemaUtils.toBuilder((BooleanSchema)s);
        }
        if (s instanceof CombinedSchema) {
            return SchemaUtils.toBuilder((CombinedSchema)s);
        }
        if (s instanceof ConditionalSchema) {
            return SchemaUtils.toBuilder((ConditionalSchema)s);
        }
        if (s instanceof ConstSchema) {
            return SchemaUtils.toBuilder((ConstSchema)s);
        }
        if (s instanceof EmptySchema) {
            return SchemaUtils.toBuilder((EmptySchema)s);
        }
        if (s instanceof EnumSchema) {
            return SchemaUtils.toBuilder((EnumSchema)s);
        }
        if (s instanceof FalseSchema) {
            return SchemaUtils.toBuilder((FalseSchema)s);
        }
        if (s instanceof NotSchema) {
            return SchemaUtils.toBuilder((NotSchema)s);
        }
        if (s instanceof NullSchema) {
            return SchemaUtils.toBuilder((NullSchema)s);
        }
        if (s instanceof NumberSchema) {
            return SchemaUtils.toBuilder((NumberSchema)s);
        }
        if (s instanceof ObjectSchema) {
            return SchemaUtils.toBuilder((ObjectSchema)s);
        }
        if (s instanceof ReferenceSchema) {
            return SchemaUtils.toBuilder((ReferenceSchema)s);
        }
        if (s instanceof StringSchema) {
            return SchemaUtils.toBuilder((StringSchema)s);
        }
        throw new IllegalArgumentException();
    }

    public static ArraySchema.Builder toBuilder(ArraySchema s) {
        return SchemaUtils.merge(ArraySchema.builder().requiresArray(false), s);
    }

    public static BooleanSchema.Builder toBuilder(BooleanSchema s) {
        return SchemaUtils.merge(BooleanSchema.builder(), s);
    }

    public static CombinedSchema.Builder toBuilder(CombinedSchema s) {
        return SchemaUtils.merge(CombinedSchema.builder(), s);
    }

    public static ConditionalSchema.Builder toBuilder(ConditionalSchema s) {
        return SchemaUtils.merge(ConditionalSchema.builder(), s);
    }

    public static ConstSchema.ConstSchemaBuilder toBuilder(ConstSchema s) {
        return SchemaUtils.merge(ConstSchema.builder(), s);
    }

    public static EmptySchema.Builder toBuilder(EmptySchema s) {
        return SchemaUtils.merge(EmptySchema.builder(), s);
    }

    public static EnumSchema.Builder toBuilder(EnumSchema s) {
        return SchemaUtils.merge(EnumSchema.builder(), s);
    }

    public static FalseSchema.Builder toBuilder(FalseSchema s) {
        return SchemaUtils.merge(FalseSchema.builder(), s);
    }

    public static NotSchema.Builder toBuilder(NotSchema s) {
        return SchemaUtils.merge(NotSchema.builder(), s);
    }

    public static NullSchema.Builder toBuilder(NullSchema s) {
        return SchemaUtils.merge(NullSchema.builder(), s);
    }

    public static NumberSchema.Builder toBuilder(NumberSchema s) {
        return SchemaUtils.merge(NumberSchema.builder().requiresNumber(false), s);
    }

    public static ObjectSchema.Builder toBuilder(ObjectSchema s) {
        return SchemaUtils.merge(ObjectSchema.builder().requiresObject(false), s);
    }

    public static ReferenceSchema.Builder toBuilder(ReferenceSchema s) {
        return SchemaUtils.merge(ReferenceSchema.builder(), s);
    }

    public static StringSchema.Builder toBuilder(StringSchema s) {
        return SchemaUtils.merge(StringSchema.builder().requiresString(false), s);
    }

    public static TrueSchema.Builder toBuilder(TrueSchema s) {
        return SchemaUtils.merge(TrueSchema.builder(), s);
    }

    public static ArraySchema.Builder merge(ArraySchema.Builder builder, ArraySchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        if (s.requiresArray()) {
            builder.requiresArray(true);
        }
        if (s.getMinItems() != null) {
            builder.minItems(s.getMinItems());
        }
        if (s.getMaxItems() != null) {
            builder.maxItems(s.getMaxItems());
        }
        if (s.needsUniqueItems()) {
            builder.uniqueItems(true);
        }
        if (s.getAllItemSchema() != null) {
            builder.allItemSchema(s.getAllItemSchema());
        }
        if (s.getItemSchemas() != null) {
            for (Schema i : s.getItemSchemas()) {
                builder.addItemSchema(i);
            }
        }
        if (!s.permitsAdditionalItems()) {
            builder.additionalItems(false);
        }
        if (s.getSchemaOfAdditionalItems() != null) {
            builder.schemaOfAdditionalItems(s.getSchemaOfAdditionalItems());
        }
        if (s.getContainedItemSchema() != null) {
            builder.containsItemSchema(s.getContainedItemSchema());
        }
        return builder;
    }

    public static BooleanSchema.Builder merge(BooleanSchema.Builder builder, BooleanSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        return builder;
    }

    public static CombinedSchema.Builder merge(CombinedSchema.Builder builder, CombinedSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        builder.isSynthetic(SchemaUtils.isSynthetic(s));
        builder.criterion(s.getCriterion());
        builder.subschemas(s.getSubschemas());
        return builder;
    }

    public static ConditionalSchema.Builder merge(ConditionalSchema.Builder builder, ConditionalSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        if (s.getIfSchema().isPresent()) {
            builder.ifSchema((Schema)s.getIfSchema().get());
        }
        if (s.getThenSchema().isPresent()) {
            builder.thenSchema((Schema)s.getThenSchema().get());
        }
        if (s.getElseSchema().isPresent()) {
            builder.elseSchema((Schema)s.getElseSchema().get());
        }
        return builder;
    }

    public static ConstSchema.ConstSchemaBuilder merge(ConstSchema.ConstSchemaBuilder builder, ConstSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        if (s.getPermittedValue() != null) {
            builder.permittedValue(s.getPermittedValue());
        }
        return builder;
    }

    public static EmptySchema.Builder merge(EmptySchema.Builder builder, EmptySchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        return builder;
    }

    public static EnumSchema.Builder merge(EnumSchema.Builder builder, EnumSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        if (s.getPossibleValuesAsList() != null) {
            builder.possibleValues(s.getPossibleValuesAsList());
        }
        return builder;
    }

    public static FalseSchema.Builder merge(FalseSchema.Builder builder, FalseSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        return builder;
    }

    public static NotSchema.Builder merge(NotSchema.Builder builder, NotSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        if (s.getMustNotMatch() != null) {
            builder.mustNotMatch(s.getMustNotMatch());
        }
        return builder;
    }

    public static NullSchema.Builder merge(NullSchema.Builder builder, NullSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        return builder;
    }

    public static NumberSchema.Builder merge(NumberSchema.Builder builder, NumberSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        if (s.getMinimum() != null) {
            builder.minimum(s.getMinimum());
        }
        if (s.getMaximum() != null) {
            builder.maximum(s.getMaximum());
        }
        if (s.getExclusiveMinimumLimit() != null) {
            builder.exclusiveMinimum(s.getExclusiveMinimumLimit());
        }
        if (s.getExclusiveMaximumLimit() != null) {
            builder.exclusiveMaximum(s.getExclusiveMaximumLimit());
        }
        if (s.getMultipleOf() != null) {
            builder.multipleOf(s.getMultipleOf());
        }
        if (s.isRequiresNumber()) {
            builder.requiresNumber(true);
        }
        if (s.requiresInteger()) {
            builder.requiresInteger(true);
        }
        return builder;
    }

    public static ObjectSchema.Builder merge(ObjectSchema.Builder builder, ObjectSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        if (s.getPatternProperties() != null) {
            for (Map.Entry entry : s.getPatternProperties().entrySet()) {
                builder.patternProperty((Pattern)entry.getKey(), (Schema)entry.getValue());
            }
        }
        if (s.requiresObject()) {
            builder.requiresObject(true);
        }
        if (s.getPropertySchemas() != null) {
            for (Map.Entry entry : s.getPropertySchemas().entrySet()) {
                builder.addPropertySchema((String)entry.getKey(), (Schema)entry.getValue());
            }
        }
        if (!s.permitsAdditionalProperties()) {
            builder.additionalProperties(false);
        }
        if (s.getSchemaOfAdditionalProperties() != null) {
            builder.schemaOfAdditionalProperties(s.getSchemaOfAdditionalProperties());
        }
        if (s.getRequiredProperties() != null) {
            for (String p : s.getRequiredProperties()) {
                builder.addRequiredProperty(p);
            }
        }
        if (s.getMinProperties() != null) {
            builder.minProperties(s.getMinProperties());
        }
        if (s.getMaxProperties() != null) {
            builder.maxProperties(s.getMaxProperties());
        }
        if (s.getPropertyDependencies() != null) {
            for (Map.Entry entry : s.getPropertyDependencies().entrySet()) {
                for (String p : (Set)entry.getValue()) {
                    builder.propertyDependency((String)entry.getKey(), p);
                }
            }
        }
        if (s.getSchemaDependencies() != null) {
            for (Map.Entry entry : s.getSchemaDependencies().entrySet()) {
                builder.schemaDependency((String)entry.getKey(), (Schema)entry.getValue());
            }
        }
        if (s.getPropertyNameSchema() != null) {
            builder.propertyNameSchema(s.getPropertyNameSchema());
        }
        return builder;
    }

    public static ReferenceSchema.Builder merge(ReferenceSchema.Builder builder, ReferenceSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        if (s.getReferenceValue() != null) {
            builder.refValue(s.getReferenceValue());
        }
        return builder;
    }

    public static StringSchema.Builder merge(StringSchema.Builder builder, StringSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        if (s.getMinLength() != null) {
            builder.minLength(s.getMinLength());
        }
        if (s.getMaxLength() != null) {
            builder.maxLength(s.getMaxLength());
        }
        if (s.getPattern() != null) {
            builder.pattern(s.getPattern().pattern());
        }
        if (s.requireString()) {
            builder.requiresString(true);
        }
        if (s.getFormatValidator() != null) {
            builder.formatValidator(s.getFormatValidator());
        }
        return builder;
    }

    public static TrueSchema.Builder merge(TrueSchema.Builder builder, TrueSchema s) {
        SchemaUtils.copyGenericAttrs(builder, (Schema)s);
        return builder;
    }

    private static void copyGenericAttrs(Schema.Builder<?> builder, Schema s) {
        if (s.getTitle() != null) {
            builder.title(s.getTitle());
        }
        if (s.getDescription() != null) {
            builder.description(s.getDescription());
        }
        if (s.getId() != null) {
            builder.id(s.getId());
        }
        if (s.getDefaultValue() != null) {
            builder.defaultValue(s.getDefaultValue());
        }
        if (s.isNullable() != null) {
            builder.nullable(s.isNullable());
        }
        if (s.isReadOnly() != null) {
            builder.readOnly(s.isReadOnly());
        }
        if (s.isWriteOnly() != null) {
            builder.writeOnly(s.isWriteOnly());
        }
        if (s.getUnprocessedProperties() != null) {
            builder.unprocessedProperties(s.getUnprocessedProperties());
        }
    }

    protected static boolean containsType(CombinedSchema combinedSchema, Schema schema) {
        for (Schema subschema : combinedSchema.getSubschemas()) {
            if (!subschema.getClass().equals(schema.getClass())) continue;
            return true;
        }
        return false;
    }

    protected static boolean isSyntheticAll(Schema schema) {
        return schema instanceof CombinedSchema && SchemaUtils.isSyntheticCombined((CombinedSchema)schema, CombinedSchema.ALL_CRITERION);
    }

    protected static boolean isSyntheticAny(Schema schema) {
        return schema instanceof CombinedSchema && SchemaUtils.isSyntheticCombined((CombinedSchema)schema, CombinedSchema.ANY_CRITERION);
    }

    protected static boolean isSyntheticCombined(CombinedSchema schema, CombinedSchema.ValidationCriterion criterion) {
        return schema.getCriterion() == criterion && SchemaUtils.isSynthetic(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean isSynthetic(CombinedSchema schema) {
        try {
            if (isSyntheticMethod != null) return (Boolean)isSyntheticMethod.invoke((Object)schema, new Object[0]);
            Class<SchemaTranslator> clazz = SchemaTranslator.class;
            synchronized (SchemaTranslator.class) {
                if (isSyntheticMethod == null) {
                    isSyntheticMethod = CombinedSchema.class.getDeclaredMethod("isSynthetic", new Class[0]);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                isSyntheticMethod.setAccessible(true);
                return (Boolean)isSyntheticMethod.invoke((Object)schema, new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

