/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.confluent.security.authentication.oauthbearer.ConstrainedVerificationKeyResolver;
import io.confluent.security.authentication.oauthbearer.Constraint;
import io.confluent.security.authentication.oauthbearer.JwtIssuer;
import io.confluent.security.authentication.oauthbearer.MockJwtSource;
import io.confluent.security.authentication.oauthbearer.SpireVerificationKeyResolver;
import io.confluent.security.util.SecurityContext;
import io.spiffe.exception.JwtSourceException;
import io.spiffe.exception.SocketEndpointAddressException;
import io.spiffe.workloadapi.JwtSource;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
public class MockJwtIssuerSpire
extends JwtIssuer {
    private final String name;
    private String spireAgentSocketEndpoint;
    private final Set<String> audience;
    private JwtSource jwtSource;

    public MockJwtIssuerSpire(String name, Set<String> audience) {
        this.name = name;
        this.audience = audience;
        this.initializeJwtSource();
    }

    public void configureJwtSource(String spireAgentSocketEndpoint) {
        Objects.requireNonNull(spireAgentSocketEndpoint, "spireAgentSocketEndpoint must be non null");
        this.spireAgentSocketEndpoint = spireAgentSocketEndpoint;
        this.initializeJwtSource();
    }

    private void initializeJwtSource() {
        this.jwtSource = new MockJwtSource();
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="audience")
    public Set<String> audience() {
        return this.audience;
    }

    @JsonProperty(value="spireAgentSocketEndpoint")
    public String spireAgentSocketEndpoint() {
        return this.spireAgentSocketEndpoint;
    }

    @Override
    public ConstrainedVerificationKeyResolver keyResolver(Collection<Constraint> constraints, SecurityContext context) {
        return new ConstrainedVerificationKeyResolver(new SpireVerificationKeyResolver(this.jwtSource), constraints);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private Set<String> audience;

        private Builder() {
        }

        @JsonSetter(value="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonSetter(value="audience")
        public Builder audience(Set<String> audience) {
            this.audience = audience;
            return this;
        }

        public MockJwtIssuerSpire build() throws SocketEndpointAddressException, JwtSourceException {
            return new MockJwtIssuerSpire(this.name, this.audience == null ? Collections.emptySet() : this.audience);
        }
    }
}

