/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ConsumerGroupDescribeRequest;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.GroupCoordinatorShard;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.metrics.CoordinatorRuntimeMetrics;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetrics;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.group.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.group.runtime.CoordinatorRuntime;
import org.apache.kafka.coordinator.group.runtime.CoordinatorShardBuilderSupplier;
import org.apache.kafka.coordinator.group.runtime.MultiThreadedEventProcessor;
import org.apache.kafka.coordinator.group.runtime.PartitionWriter;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.FutureUtils;
import org.apache.kafka.server.util.timer.Timer;
import org.slf4j.Logger;

public class GroupCoordinatorService
implements GroupCoordinator {
    private final Logger log;
    private final GroupCoordinatorConfig config;
    private final CoordinatorRuntime<GroupCoordinatorShard, Record> runtime;
    private final GroupCoordinatorMetrics groupCoordinatorMetrics;
    private final AtomicBoolean isActive = new AtomicBoolean(false);
    private volatile int numPartitions = -1;

    GroupCoordinatorService(LogContext logContext, GroupCoordinatorConfig config, CoordinatorRuntime<GroupCoordinatorShard, Record> runtime, GroupCoordinatorMetrics groupCoordinatorMetrics) {
        this.log = logContext.logger(GroupCoordinatorService.class);
        this.config = config;
        this.runtime = runtime;
        this.groupCoordinatorMetrics = groupCoordinatorMetrics;
    }

    private void throwIfNotActive() {
        if (!this.isActive.get()) {
            throw Errors.COORDINATOR_NOT_AVAILABLE.exception();
        }
    }

    private TopicPartition topicPartitionFor(String groupId) {
        return new TopicPartition("__consumer_offsets", this.partitionFor(groupId));
    }

    @Override
    public int partitionFor(String groupId) {
        this.throwIfNotActive();
        return Utils.abs((int)groupId.hashCode()) % this.numPartitions;
    }

    @Override
    public CompletableFuture<ConsumerGroupHeartbeatResponseData> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        return this.runtime.scheduleWriteOperation("consumer-group-heartbeat", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.consumerGroupHeartbeat(context, request)).exceptionally(exception -> this.handleOperationException("consumer-group-heartbeat", (Object)request, (Throwable)exception, (error, message) -> new ConsumerGroupHeartbeatResponseData().setErrorCode(error.code()).setErrorMessage(message)));
    }

    @Override
    public CompletableFuture<JoinGroupResponseData> joinGroup(RequestContext context, JoinGroupRequestData request, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new JoinGroupResponseData().setMemberId(request.memberId()).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(new JoinGroupResponseData().setMemberId(request.memberId()).setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        CompletableFuture<JoinGroupResponseData> responseFuture = new CompletableFuture<JoinGroupResponseData>();
        this.runtime.scheduleWriteOperation("classic-group-join", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.classicGroupJoin(context, request, responseFuture)).exceptionally(exception -> {
            if (!responseFuture.isDone()) {
                responseFuture.complete(this.handleOperationException("classic-group-join", (Object)request, (Throwable)exception, (error, __) -> new JoinGroupResponseData().setErrorCode(error.code())));
            }
            return null;
        });
        return responseFuture;
    }

    @Override
    public CompletableFuture<SyncGroupResponseData> syncGroup(RequestContext context, SyncGroupRequestData request, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new SyncGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(new SyncGroupResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        CompletableFuture<SyncGroupResponseData> responseFuture = new CompletableFuture<SyncGroupResponseData>();
        this.runtime.scheduleWriteOperation("classic-group-sync", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.classicGroupSync(context, request, responseFuture)).exceptionally(exception -> {
            if (!responseFuture.isDone()) {
                responseFuture.complete(this.handleOperationException("classic-group-sync", (Object)request, (Throwable)exception, (error, __) -> new SyncGroupResponseData().setErrorCode(error.code())));
            }
            return null;
        });
        return responseFuture;
    }

    @Override
    public CompletableFuture<HeartbeatResponseData> heartbeat(RequestContext context, HeartbeatRequestData request) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new HeartbeatResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(new HeartbeatResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        return this.runtime.scheduleReadOperation("classic-group-heartbeat", this.topicPartitionFor(request.groupId()), (coordinator, __) -> coordinator.classicGroupHeartbeat(context, request)).exceptionally(exception -> this.handleOperationException("classic-group-heartbeat", (Object)request, (Throwable)exception, (error, __) -> {
            if (error == Errors.COORDINATOR_LOAD_IN_PROGRESS) {
                return new HeartbeatResponseData().setErrorCode(Errors.NONE.code());
            }
            return new HeartbeatResponseData().setErrorCode(error.code());
        }));
    }

    @Override
    public CompletableFuture<LeaveGroupResponseData> leaveGroup(RequestContext context, LeaveGroupRequestData request) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(new LeaveGroupResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        return this.runtime.scheduleWriteOperation("classic-group-leave", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.classicGroupLeave(context, request)).exceptionally(exception -> this.handleOperationException("classic-group-leave", (Object)request, (Throwable)exception, (error, __) -> {
            if (error == Errors.UNKNOWN_MEMBER_ID) {
                List memberResponses = request.members().stream().map(member -> new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code())).collect(Collectors.toList());
                return new LeaveGroupResponseData().setMembers(memberResponses);
            }
            return new LeaveGroupResponseData().setErrorCode(error.code());
        }));
    }

    @Override
    public CompletableFuture<ListGroupsResponseData> listGroups(RequestContext context, ListGroupsRequestData request) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        Set<TopicPartition> existingPartitionSet = this.runtime.partitions();
        if (existingPartitionSet.isEmpty()) {
            return CompletableFuture.completedFuture(new ListGroupsResponseData());
        }
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (TopicPartition tp : existingPartitionSet) {
            futures.add(this.runtime.scheduleReadOperation("list-groups", tp, (coordinator, lastCommittedOffset) -> coordinator.listGroups(request.statesFilter(), request.typesFilter(), lastCommittedOffset)).exceptionally(exception -> {
                if ((exception = Errors.maybeUnwrapException((Throwable)exception)) instanceof NotCoordinatorException) {
                    return Collections.emptyList();
                }
                throw new CompletionException((Throwable)exception);
            }));
        }
        return ((CompletableFuture)FutureUtils.combineFutures(futures, ArrayList::new, List::addAll).thenApply(groups -> new ListGroupsResponseData().setGroups(groups))).exceptionally(exception -> this.handleOperationException("list-groups", (Object)request, (Throwable)exception, (error, __) -> new ListGroupsResponseData().setErrorCode(error.code())));
    }

    @Override
    public CompletableFuture<List<ConsumerGroupDescribeResponseData.DescribedGroup>> consumerGroupDescribe(RequestContext context, List<String> groupIds) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(ConsumerGroupDescribeRequest.getErrorDescribedGroupList(groupIds, (Errors)Errors.COORDINATOR_NOT_AVAILABLE));
        }
        ArrayList futures = new ArrayList(groupIds.size());
        HashMap<TopicPartition, List> groupsByTopicPartition = new HashMap<TopicPartition, List>();
        groupIds.forEach(groupId -> {
            if (GroupCoordinatorService.isGroupIdNotEmpty(groupId)) {
                groupsByTopicPartition.computeIfAbsent(this.topicPartitionFor((String)groupId), __ -> new ArrayList()).add(groupId);
            } else {
                futures.add(CompletableFuture.completedFuture(Collections.singletonList(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(null).setErrorCode(Errors.INVALID_GROUP_ID.code()))));
            }
        });
        groupsByTopicPartition.forEach((topicPartition, groupList) -> {
            CompletionStage future = this.runtime.scheduleReadOperation("consumer-group-describe", (TopicPartition)topicPartition, (coordinator, lastCommittedOffset) -> coordinator.consumerGroupDescribe(groupIds, lastCommittedOffset)).exceptionally(exception -> this.handleOperationException("consumer-group-describe", (Object)groupList, (Throwable)exception, (error, __) -> ConsumerGroupDescribeRequest.getErrorDescribedGroupList((List)groupList, (Errors)error)));
            futures.add(future);
        });
        return FutureUtils.combineFutures(futures, ArrayList::new, List::addAll);
    }

    @Override
    public CompletableFuture<List<DescribeGroupsResponseData.DescribedGroup>> describeGroups(RequestContext context, List<String> groupIds) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(DescribeGroupsRequest.getErrorDescribedGroupList(groupIds, (Errors)Errors.COORDINATOR_NOT_AVAILABLE));
        }
        ArrayList futures = new ArrayList(groupIds.size());
        HashMap<TopicPartition, List> groupsByTopicPartition = new HashMap<TopicPartition, List>();
        groupIds.forEach(groupId -> {
            if (groupId == null) {
                futures.add(CompletableFuture.completedFuture(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId(null).setErrorCode(Errors.INVALID_GROUP_ID.code()))));
            } else {
                TopicPartition topicPartition = this.topicPartitionFor((String)groupId);
                groupsByTopicPartition.computeIfAbsent(topicPartition, __ -> new ArrayList()).add(groupId);
            }
        });
        groupsByTopicPartition.forEach((topicPartition, groupList) -> {
            CompletionStage future = this.runtime.scheduleReadOperation("describe-groups", (TopicPartition)topicPartition, (coordinator, lastCommittedOffset) -> coordinator.describeGroups(context, (List<String>)groupList, lastCommittedOffset)).exceptionally(exception -> this.handleOperationException("describe-groups", (Object)groupList, (Throwable)exception, (error, __) -> DescribeGroupsRequest.getErrorDescribedGroupList((List)groupList, (Errors)error)));
            futures.add(future);
        });
        return FutureUtils.combineFutures(futures, ArrayList::new, List::addAll);
    }

    @Override
    public CompletableFuture<DeleteGroupsResponseData.DeletableGroupResultCollection> deleteGroups(RequestContext context, List<String> groupIds, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(DeleteGroupsRequest.getErrorResultCollection(groupIds, (Errors)Errors.COORDINATOR_NOT_AVAILABLE));
        }
        ArrayList futures = new ArrayList(groupIds.size());
        HashMap<TopicPartition, List> groupsByTopicPartition = new HashMap<TopicPartition, List>();
        groupIds.forEach(groupId -> {
            if (groupId == null) {
                futures.add(CompletableFuture.completedFuture(DeleteGroupsRequest.getErrorResultCollection(Collections.singletonList(null), (Errors)Errors.INVALID_GROUP_ID)));
            } else {
                TopicPartition topicPartition = this.topicPartitionFor((String)groupId);
                groupsByTopicPartition.computeIfAbsent(topicPartition, __ -> new ArrayList()).add(groupId);
            }
        });
        groupsByTopicPartition.forEach((topicPartition, groupList) -> {
            CompletionStage future = this.runtime.scheduleWriteOperation("delete-groups", (TopicPartition)topicPartition, Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.deleteGroups(context, (List<String>)groupList)).exceptionally(exception -> this.handleOperationException("delete-groups", (Object)groupList, (Throwable)exception, (error, __) -> DeleteGroupsRequest.getErrorResultCollection((List)groupList, (Errors)error)));
            futures.add(future);
        });
        return FutureUtils.combineFutures(futures, DeleteGroupsResponseData.DeletableGroupResultCollection::new, (accumulator, newResults) -> newResults.forEach(result -> accumulator.add((ImplicitLinkedHashCollection.Element)result.duplicate())));
    }

    @Override
    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (request.groupId() == null) {
            return CompletableFuture.completedFuture(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        if (requireStable) {
            return this.runtime.scheduleWriteOperation("fetch-offsets", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> new CoordinatorResult(Collections.emptyList(), coordinator.fetchOffsets(request, Long.MAX_VALUE)));
        }
        return this.runtime.scheduleReadOperation("fetch-offsets", this.topicPartitionFor(request.groupId()), (coordinator, offset) -> coordinator.fetchOffsets(request, offset));
    }

    @Override
    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchAllOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (request.groupId() == null) {
            return CompletableFuture.completedFuture(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        if (requireStable) {
            return this.runtime.scheduleWriteOperation("fetch-all-offsets", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> new CoordinatorResult(Collections.emptyList(), coordinator.fetchAllOffsets(request, Long.MAX_VALUE)));
        }
        return this.runtime.scheduleReadOperation("fetch-all-offsets", this.topicPartitionFor(request.groupId()), (coordinator, offset) -> coordinator.fetchAllOffsets(request, offset));
    }

    @Override
    public CompletableFuture<OffsetCommitResponseData> commitOffsets(RequestContext context, OffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(OffsetCommitRequest.getErrorResponse((OffsetCommitRequestData)request, (Errors)Errors.COORDINATOR_NOT_AVAILABLE));
        }
        if (request.groupId() == null) {
            return CompletableFuture.completedFuture(OffsetCommitRequest.getErrorResponse((OffsetCommitRequestData)request, (Errors)Errors.INVALID_GROUP_ID));
        }
        return this.runtime.scheduleWriteOperation("commit-offset", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.commitOffset(context, request)).exceptionally(exception -> this.handleOperationException("commit-offset", (Object)request, (Throwable)exception, (error, __) -> OffsetCommitRequest.getErrorResponse((OffsetCommitRequestData)request, (Errors)error)));
    }

    @Override
    public CompletableFuture<TxnOffsetCommitResponseData> commitTransactionalOffsets(RequestContext context, TxnOffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(TxnOffsetCommitRequest.getErrorResponse((TxnOffsetCommitRequestData)request, (Errors)Errors.COORDINATOR_NOT_AVAILABLE));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(TxnOffsetCommitRequest.getErrorResponse((TxnOffsetCommitRequestData)request, (Errors)Errors.INVALID_GROUP_ID));
        }
        return this.runtime.scheduleTransactionalWriteOperation("txn-commit-offset", this.topicPartitionFor(request.groupId()), request.transactionalId(), request.producerId(), request.producerEpoch(), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.commitTransactionalOffset(context, request)).exceptionally(exception -> this.handleOperationException("txn-commit-offset", (Object)request, (Throwable)exception, (error, __) -> TxnOffsetCommitRequest.getErrorResponse((TxnOffsetCommitRequestData)request, (Errors)error)));
    }

    @Override
    public CompletableFuture<OffsetDeleteResponseData> deleteOffsets(RequestContext context, OffsetDeleteRequestData request, BufferSupplier bufferSupplier) {
        if (!this.isActive.get()) {
            return CompletableFuture.completedFuture(new OffsetDeleteResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        if (!GroupCoordinatorService.isGroupIdNotEmpty(request.groupId())) {
            return CompletableFuture.completedFuture(new OffsetDeleteResponseData().setErrorCode(Errors.INVALID_GROUP_ID.code()));
        }
        return this.runtime.scheduleWriteOperation("delete-offsets", this.topicPartitionFor(request.groupId()), Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.deleteOffsets(context, request)).exceptionally(exception -> this.handleOperationException("delete-offsets", (Object)request, (Throwable)exception, (error, __) -> new OffsetDeleteResponseData().setErrorCode(error.code())));
    }

    @Override
    public CompletableFuture<Void> completeTransaction(TopicPartition tp, long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result, Duration timeout) {
        if (!this.isActive.get()) {
            return FutureUtils.failedFuture((Throwable)Errors.COORDINATOR_NOT_AVAILABLE.exception());
        }
        if (!tp.topic().equals("__consumer_offsets")) {
            return FutureUtils.failedFuture((Throwable)new IllegalStateException("Completing a transaction for " + tp + " is not expected"));
        }
        return this.runtime.scheduleTransactionCompletion("write-txn-marker", tp, producerId, producerEpoch, coordinatorEpoch, result, timeout);
    }

    @Override
    public void onTransactionCompleted(long producerId, Iterable<TopicPartition> partitions, TransactionResult transactionResult) {
        this.throwIfNotActive();
        throw new IllegalStateException("onTransactionCompleted is not supported.");
    }

    @Override
    public void onPartitionsDeleted(List<TopicPartition> topicPartitions, BufferSupplier bufferSupplier) throws ExecutionException, InterruptedException {
        this.throwIfNotActive();
        Set<TopicPartition> existingPartitionSet = this.runtime.partitions();
        ArrayList futures = new ArrayList(existingPartitionSet.size());
        existingPartitionSet.forEach(partition -> futures.add(this.runtime.scheduleWriteOperation("on-partition-deleted", (TopicPartition)partition, Duration.ofMillis(this.config.offsetCommitTimeoutMs), coordinator -> coordinator.onPartitionsDeleted(topicPartitions)).exceptionally(exception -> {
            this.log.error("Could not delete offsets for deleted partitions {} in coordinator {} due to: {}.", new Object[]{partition, partition, exception.getMessage(), exception});
            return null;
        })));
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
    }

    @Override
    public void onElection(int groupMetadataPartitionIndex, int groupMetadataPartitionLeaderEpoch) {
        this.throwIfNotActive();
        this.runtime.scheduleLoadOperation(new TopicPartition("__consumer_offsets", groupMetadataPartitionIndex), groupMetadataPartitionLeaderEpoch);
    }

    @Override
    public void onResignation(int groupMetadataPartitionIndex, OptionalInt groupMetadataPartitionLeaderEpoch) {
        this.throwIfNotActive();
        this.runtime.scheduleUnloadOperation(new TopicPartition("__consumer_offsets", groupMetadataPartitionIndex), groupMetadataPartitionLeaderEpoch);
    }

    @Override
    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
        this.throwIfNotActive();
        this.runtime.onNewMetadataImage(newImage, delta);
    }

    @Override
    public Properties groupMetadataTopicConfigs() {
        Properties properties = new Properties();
        properties.put("cleanup.policy", "compact");
        properties.put("compression.type", BrokerCompressionType.PRODUCER.name);
        properties.put("segment.bytes", String.valueOf(this.config.offsetsTopicSegmentBytes));
        properties.put("delete.retention.ms", String.valueOf(this.config.offsetsLogCleanerDeleteRetentionMs));
        properties.put("min.cleanable.dirty.ratio", String.valueOf(this.config.offsetsLogCleanerMinCleanableDirtyRatio));
        properties.put("max.compaction.lag.ms", String.valueOf(this.config.offsetsLogCleanerMaxCompactionLagMs));
        return properties;
    }

    @Override
    public void startup(IntSupplier groupMetadataTopicPartitionCount) {
        if (!this.isActive.compareAndSet(false, true)) {
            this.log.warn("Group coordinator is already running.");
            return;
        }
        this.log.info("Starting up.");
        this.numPartitions = groupMetadataTopicPartitionCount.getAsInt();
        this.isActive.set(true);
        this.log.info("Startup complete.");
    }

    @Override
    public void shutdown() {
        if (!this.isActive.compareAndSet(true, false)) {
            this.log.warn("Group coordinator is already shutting down.");
            return;
        }
        this.log.info("Shutting down.");
        this.isActive.set(false);
        Utils.closeQuietly(this.runtime, (String)"coordinator runtime");
        Utils.closeQuietly((AutoCloseable)this.groupCoordinatorMetrics, (String)"group coordinator metrics");
        this.log.info("Shutdown complete.");
    }

    private static boolean isGroupIdNotEmpty(String groupId) {
        return groupId != null && !groupId.isEmpty();
    }

    private <IN, OUT> OUT handleOperationException(String operationName, IN operationInput, Throwable exception, BiFunction<Errors, String, OUT> handler) {
        ApiError apiError = ApiError.fromThrowable((Throwable)exception);
        switch (apiError.error()) {
            case UNKNOWN_SERVER_ERROR: {
                this.log.error("Operation {} with {} hit an unexpected exception: {}.", new Object[]{operationName, operationInput, exception.getMessage(), exception});
                return handler.apply(Errors.UNKNOWN_SERVER_ERROR, null);
            }
            case NETWORK_EXCEPTION: {
                return handler.apply(Errors.COORDINATOR_LOAD_IN_PROGRESS, null);
            }
            case UNKNOWN_TOPIC_OR_PARTITION: 
            case NOT_ENOUGH_REPLICAS: 
            case REQUEST_TIMED_OUT: {
                return handler.apply(Errors.COORDINATOR_NOT_AVAILABLE, null);
            }
            case NOT_LEADER_OR_FOLLOWER: 
            case KAFKA_STORAGE_ERROR: {
                return handler.apply(Errors.NOT_COORDINATOR, null);
            }
            case MESSAGE_TOO_LARGE: 
            case RECORD_LIST_TOO_LARGE: 
            case INVALID_FETCH_SIZE: {
                return handler.apply(Errors.UNKNOWN_SERVER_ERROR, null);
            }
        }
        return handler.apply(apiError.error(), apiError.message());
    }

    public static class Builder {
        private final int nodeId;
        private final GroupCoordinatorConfig config;
        private PartitionWriter<Record> writer;
        private CoordinatorLoader<Record> loader;
        private Time time;
        private Timer timer;
        private CoordinatorRuntimeMetrics coordinatorRuntimeMetrics;
        private GroupCoordinatorMetrics groupCoordinatorMetrics;

        public Builder(int nodeId, GroupCoordinatorConfig config) {
            this.nodeId = nodeId;
            this.config = config;
        }

        public Builder withWriter(PartitionWriter<Record> writer) {
            this.writer = writer;
            return this;
        }

        public Builder withLoader(CoordinatorLoader<Record> loader) {
            this.loader = loader;
            return this;
        }

        public Builder withTime(Time time) {
            this.time = time;
            return this;
        }

        public Builder withTimer(Timer timer) {
            this.timer = timer;
            return this;
        }

        public Builder withCoordinatorRuntimeMetrics(CoordinatorRuntimeMetrics coordinatorRuntimeMetrics) {
            this.coordinatorRuntimeMetrics = coordinatorRuntimeMetrics;
            return this;
        }

        public Builder withGroupCoordinatorMetrics(GroupCoordinatorMetrics groupCoordinatorMetrics) {
            this.groupCoordinatorMetrics = groupCoordinatorMetrics;
            return this;
        }

        public GroupCoordinatorService build() {
            if (this.config == null) {
                throw new IllegalArgumentException("Config must be set.");
            }
            if (this.writer == null) {
                throw new IllegalArgumentException("Writer must be set.");
            }
            if (this.loader == null) {
                throw new IllegalArgumentException("Loader must be set.");
            }
            if (this.time == null) {
                throw new IllegalArgumentException("Time must be set.");
            }
            if (this.timer == null) {
                throw new IllegalArgumentException("Timer must be set.");
            }
            if (this.coordinatorRuntimeMetrics == null) {
                throw new IllegalArgumentException("CoordinatorRuntimeMetrics must be set.");
            }
            if (this.groupCoordinatorMetrics == null) {
                throw new IllegalArgumentException("GroupCoordinatorMetrics must be set.");
            }
            String logPrefix = String.format("GroupCoordinator id=%d", this.nodeId);
            LogContext logContext = new LogContext(String.format("[%s] ", logPrefix));
            CoordinatorShardBuilderSupplier supplier = () -> new GroupCoordinatorShard.Builder(this.config);
            MultiThreadedEventProcessor processor = new MultiThreadedEventProcessor(logContext, "group-coordinator-event-processor-", this.config.numThreads, this.time, this.coordinatorRuntimeMetrics);
            CoordinatorRuntime<GroupCoordinatorShard, Record> runtime = new CoordinatorRuntime.Builder().withTime(this.time).withTimer(this.timer).withLogPrefix(logPrefix).withLogContext(logContext).withEventProcessor(processor).withPartitionWriter(this.writer).withLoader(this.loader).withCoordinatorShardBuilderSupplier(supplier).withTime(this.time).withDefaultWriteTimeOut(Duration.ofMillis(this.config.offsetCommitTimeoutMs)).withCoordinatorRuntimeMetrics(this.coordinatorRuntimeMetrics).withCoordinatorMetrics(this.groupCoordinatorMetrics).build();
            return new GroupCoordinatorService(logContext, this.config, runtime, this.groupCoordinatorMetrics);
        }
    }
}

