/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OwnerType {
    ORGANIZATION("Organization"),
    USER("User");

    private static final Map<String, OwnerType> TYPES_BY_NAME;
    private final String displayName;

    @JsonCreator
    public static OwnerType parse(String displayName) {
        if (displayName != null) {
            displayName = displayName.toLowerCase();
        }
        return TYPES_BY_NAME.get(displayName);
    }

    private OwnerType(String displayName) {
        this.displayName = displayName;
    }

    @JsonValue
    public String getDisplayName() {
        return this.displayName;
    }

    static {
        TYPES_BY_NAME = new HashMap<String, OwnerType>();
        for (OwnerType type : OwnerType.values()) {
            TYPES_BY_NAME.put(type.getDisplayName().toLowerCase(), type);
        }
    }
}

