/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.pluginregistry.util.JsonUtil;
import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.IOException;

@JsonPropertyOrder(value={"name", "url", "logo"})
public class PluginLicense
implements Comparable<PluginLicense> {
    @JsonProperty
    private String name;
    @JsonProperty
    private String url;
    @JsonProperty
    private String logo;

    public static PluginLicense fromJson(String json) throws IOException {
        return (PluginLicense)JsonUtil.newObjectMapper().readValue(json, PluginLicense.class);
    }

    public PluginLicense() {
    }

    public PluginLicense(String name, String url, String logo) {
        this.name = name;
        this.url = url;
        this.logo = logo;
    }

    public PluginLicense(PluginLicense original) {
        this.name = original.name;
        this.url = original.url;
        this.logo = original.logo;
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginLicense that = (PluginLicense)o;
        return ObjectUtil.equals(this.name, that.name) && ObjectUtil.equals(this.url, that.url);
    }

    @Override
    public int compareTo(PluginLicense that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        int diff = ObjectUtil.compareTo(this.name, that.name);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.url, that.url);
        return diff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{name=" + this.name + ",");
        sb.append("url=" + this.url + ",");
        sb.append("logo=" + this.logo + "}");
        return sb.toString();
    }
}

