/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.pluginregistry.util.JsonUtil;
import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class PluginSummary
implements Comparable<PluginSummary> {
    @JsonProperty
    private String name;
    @JsonProperty(value="plugin_resource_url")
    private String pluginResourceUrl;
    @JsonProperty
    private String description;

    public static PluginSummary fromJson(String json) throws IOException {
        return (PluginSummary)JsonUtil.newObjectMapper().readValue(json, PluginSummary.class);
    }

    public static PluginSummary fromJson(InputStream json) throws IOException {
        return (PluginSummary)JsonUtil.newObjectMapper().readValue(json, PluginSummary.class);
    }

    public PluginSummary() {
    }

    public PluginSummary(String name, String pluginResourceUrl, String description) {
        this.name = name;
        this.pluginResourceUrl = pluginResourceUrl;
        this.description = description;
    }

    public PluginSummary(PluginSummary original) {
        this.name = original.name;
        this.pluginResourceUrl = original.pluginResourceUrl;
        this.description = original.description;
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPluginResourceUrl() {
        return this.pluginResourceUrl;
    }

    public void setPluginResourceUrl(String pluginResourceUrl) {
        this.pluginResourceUrl = pluginResourceUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.pluginResourceUrl, this.description);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginSummary that = (PluginSummary)o;
        return ObjectUtil.equals(this.name, that.name) && ObjectUtil.equals(this.pluginResourceUrl, that.pluginResourceUrl) && ObjectUtil.equals(this.description, that.description);
    }

    @Override
    public int compareTo(PluginSummary that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        int diff = ObjectUtil.compareTo(this.name, that.name);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.pluginResourceUrl, that.pluginResourceUrl);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.description, that.description);
        return diff;
    }

    public String toString() {
        return String.format("{name=%s,description=%s,pluginResourceUrl=%s}", this.name, this.description, this.pluginResourceUrl);
    }
}

