/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.runtime.RestartRequest;
import org.apache.kafka.connect.runtime.SessionKey;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.WorkerConfigTransformer;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.storage.ClusterConfigState;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.KafkaTopicBasedBackingStore;
import org.apache.kafka.connect.storage.PrivilegedWriteException;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectUtils;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.apache.kafka.connect.util.SharedTopicAdmin;
import org.apache.kafka.connect.util.TopicAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfigBackingStore
extends KafkaTopicBasedBackingStore
implements ConfigBackingStore {
    private static final Logger log = LoggerFactory.getLogger(KafkaConfigBackingStore.class);
    public static final String TARGET_STATE_PREFIX = "target-state-";
    public static final String CONNECTOR_PREFIX = "connector-";
    public static final String TASK_PREFIX = "task-";
    public static final String COMMIT_TASKS_PREFIX = "commit-";
    public static final String TASK_COUNT_RECORD_PREFIX = "tasks-fencing-";
    public static final String SESSION_KEY_KEY = "session-key";
    public static final Schema CONNECTOR_CONFIGURATION_V0;
    public static final Schema TASK_CONFIGURATION_V0;
    public static final Schema CONNECTOR_TASKS_COMMIT_V0;
    public static final Schema TARGET_STATE_V0;
    public static final Schema TARGET_STATE_V1;
    public static final Schema TASK_COUNT_RECORD_V0;
    public static final Schema SESSION_KEY_V0;
    public static final String RESTART_PREFIX = "restart-connector-";
    public static final boolean ONLY_FAILED_DEFAULT = false;
    public static final boolean INCLUDE_TASKS_DEFAULT = false;
    public static final String ONLY_FAILED_FIELD_NAME = "only-failed";
    public static final String INCLUDE_TASKS_FIELD_NAME = "include-tasks";
    public static final Schema RESTART_REQUEST_V0;
    public static final String LOGGER_CLUSTER_PREFIX = "logger-cluster-";
    public static final Schema LOGGER_LEVEL_V0;
    static final long READ_WRITE_TOTAL_TIMEOUT_MS = 30000L;
    private final Object lock;
    private final Converter converter;
    private volatile boolean started = false;
    private ConfigBackingStore.UpdateListener updateListener;
    private final Map<String, Object> baseProducerProps;
    private final String topic;
    private final KafkaBasedLog<String, byte[]> configLog;
    final Map<String, Integer> connectorTaskCounts = new HashMap<String, Integer>();
    final Map<String, Map<String, String>> connectorConfigs = new HashMap<String, Map<String, String>>();
    final Map<ConnectorTaskId, Map<String, String>> taskConfigs = new HashMap<ConnectorTaskId, Map<String, String>>();
    private final Supplier<TopicAdmin> topicAdminSupplier;
    private SharedTopicAdmin ownTopicAdmin;
    private final String clientId;
    final Set<String> inconsistent = new HashSet<String>();
    private volatile long offset;
    private volatile SessionKey sessionKey;
    final Map<String, Map<ConnectorTaskId, Map<String, String>>> deferredTaskUpdates = new HashMap<String, Map<ConnectorTaskId, Map<String, String>>>();
    final Map<String, TargetState> connectorTargetStates = new HashMap<String, TargetState>();
    final Map<String, Integer> connectorTaskCountRecords = new HashMap<String, Integer>();
    final Map<String, Integer> connectorTaskConfigGenerations = new HashMap<String, Integer>();
    final Set<String> connectorsPendingFencing = new HashSet<String>();
    private final WorkerConfigTransformer configTransformer;
    private final boolean usesFencableWriter;
    private volatile Producer<String, byte[]> fencableProducer;
    private final Map<String, Object> fencableProducerProps;
    private final Time time;

    public static String TARGET_STATE_KEY(String connectorName) {
        return TARGET_STATE_PREFIX + connectorName;
    }

    public static String CONNECTOR_KEY(String connectorName) {
        return CONNECTOR_PREFIX + connectorName;
    }

    public static String TASK_KEY(ConnectorTaskId taskId) {
        return TASK_PREFIX + taskId.connector() + "-" + taskId.task();
    }

    public static String COMMIT_TASKS_KEY(String connectorName) {
        return COMMIT_TASKS_PREFIX + connectorName;
    }

    public static String TASK_COUNT_RECORD_KEY(String connectorName) {
        return TASK_COUNT_RECORD_PREFIX + connectorName;
    }

    public static String RESTART_KEY(String connectorName) {
        return RESTART_PREFIX + connectorName;
    }

    public static String LOGGER_CLUSTER_KEY(String namespace) {
        return LOGGER_CLUSTER_PREFIX + namespace;
    }

    @Deprecated
    public KafkaConfigBackingStore(Converter converter, DistributedConfig config, WorkerConfigTransformer configTransformer) {
        this(converter, config, configTransformer, null, "connect-distributed-");
    }

    public KafkaConfigBackingStore(Converter converter, DistributedConfig config, WorkerConfigTransformer configTransformer, Supplier<TopicAdmin> adminSupplier, String clientIdBase) {
        this(converter, config, configTransformer, adminSupplier, clientIdBase, Time.SYSTEM);
    }

    KafkaConfigBackingStore(Converter converter, DistributedConfig config, WorkerConfigTransformer configTransformer, Supplier<TopicAdmin> adminSupplier, String clientIdBase, Time time) {
        this.lock = new Object();
        this.converter = converter;
        this.offset = -1L;
        this.topicAdminSupplier = adminSupplier;
        this.clientId = Objects.requireNonNull(clientIdBase) + "configs";
        this.time = time;
        this.baseProducerProps = this.baseProducerProps(config);
        this.baseProducerProps.put("enable.idempotence", "false");
        this.fencableProducerProps = this.fencableProducerProps(config);
        this.usesFencableWriter = config.transactionalLeaderEnabled();
        this.topic = config.getString("config.storage.topic");
        if (this.topic == null || this.topic.trim().length() == 0) {
            throw new ConfigException("Must specify topic for connector configuration.");
        }
        this.configLog = this.setupAndCreateKafkaBasedLog(this.topic, config);
        this.configTransformer = configTransformer;
    }

    @Override
    public void setUpdateListener(ConfigBackingStore.UpdateListener listener) {
        this.updateListener = listener;
    }

    @Override
    public void start() {
        log.info("Starting KafkaConfigBackingStore");
        try {
            this.configLog.start();
        }
        catch (UnsupportedVersionException e) {
            throw new ConnectException("Enabling exactly-once support for source connectors requires a Kafka broker version that allows admin clients to read consumer offsets. Please either disable the worker's exactly-once support for source connectors, or use a newer Kafka broker version.", (Throwable)e);
        }
        int partitionCount = this.configLog.partitionCount();
        if (partitionCount > 1) {
            String msg = String.format("Topic '%s' supplied via the '%s' property is required to have a single partition in order to guarantee consistency of connector configurations, but found %d partitions.", this.topic, "config.storage.topic", partitionCount);
            throw new ConfigException(msg);
        }
        this.started = true;
        log.info("Started KafkaConfigBackingStore");
    }

    @Override
    public void stop() {
        log.info("Closing KafkaConfigBackingStore");
        this.relinquishWritePrivileges();
        Utils.closeQuietly((AutoCloseable)this.ownTopicAdmin, (String)"admin for config topic");
        try {
            this.configLog.stop();
        }
        finally {
            if (this.ownTopicAdmin != null) {
                this.ownTopicAdmin.close();
            }
        }
        log.info("Closed KafkaConfigBackingStore");
    }

    @Override
    public void claimWritePrivileges() {
        if (this.usesFencableWriter && this.fencableProducer == null) {
            try {
                this.fencableProducer = this.createFencableProducer();
                this.fencableProducer.initTransactions();
            }
            catch (Exception e) {
                this.relinquishWritePrivileges();
                throw new ConnectException("Failed to create and initialize fencable producer for config topic", (Throwable)e);
            }
        }
    }

    private Map<String, Object> baseProducerProps(WorkerConfig workerConfig) {
        HashMap<String, Object> producerProps = new HashMap<String, Object>(workerConfig.originals());
        String kafkaClusterId = workerConfig.kafkaClusterId();
        producerProps.put("key.serializer", StringSerializer.class.getName());
        producerProps.put("value.serializer", ByteArraySerializer.class.getName());
        producerProps.put("delivery.timeout.ms", Integer.MAX_VALUE);
        ConnectUtils.addMetricsContextProperties(producerProps, workerConfig, kafkaClusterId);
        return producerProps;
    }

    Map<String, Object> fencableProducerProps(DistributedConfig workerConfig) {
        HashMap<String, Object> result = new HashMap<String, Object>(this.baseProducerProps(workerConfig));
        result.put("client.id", this.clientId + "-leader");
        result.put("acks", "all");
        result.put("max.in.flight.requests.per.connection", 5);
        ConnectUtils.ensureProperty(result, "enable.idempotence", "true", "for the worker's config topic producer when exactly-once source support is enabled or in preparation to be enabled", false);
        ConnectUtils.ensureProperty(result, "transactional.id", workerConfig.transactionalProducerId(), "for the worker's config topic producer when exactly-once source support is enabled or in preparation to be enabled", true);
        return result;
    }

    Producer<String, byte[]> createFencableProducer() {
        return new KafkaProducer(this.fencableProducerProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterConfigState snapshot() {
        Object object = this.lock;
        synchronized (object) {
            return new ClusterConfigState(this.offset, this.sessionKey, new HashMap<String, Integer>(this.connectorTaskCounts), new HashMap<String, Map<String, String>>(this.connectorConfigs), new HashMap<String, TargetState>(this.connectorTargetStates), new HashMap<ConnectorTaskId, Map<String, String>>(this.taskConfigs), new HashMap<String, Integer>(this.connectorTaskCountRecords), new HashMap<String, Integer>(this.connectorTaskConfigGenerations), new HashSet<String>(this.connectorsPendingFencing), new HashSet<String>(this.inconsistent), this.configTransformer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String connector) {
        Object object = this.lock;
        synchronized (object) {
            return this.connectorConfigs.containsKey(connector);
        }
    }

    @Override
    public void putConnectorConfig(String connector, Map<String, String> properties, TargetState targetState) {
        log.debug("Writing connector configuration for connector '{}'", (Object)connector);
        Struct connectConfig = new Struct(CONNECTOR_CONFIGURATION_V0);
        connectConfig.put("properties", properties);
        byte[] serializedConfig = this.converter.fromConnectData(this.topic, CONNECTOR_CONFIGURATION_V0, (Object)connectConfig);
        try {
            Timer timer = this.time.timer(30000L);
            ArrayList<ProducerKeyValue> keyValues = new ArrayList<ProducerKeyValue>();
            if (targetState != null) {
                log.debug("Writing target state {} for connector {}", (Object)targetState, (Object)connector);
                keyValues.add(new ProducerKeyValue(KafkaConfigBackingStore.TARGET_STATE_KEY(connector), this.serializeTargetState(targetState)));
            }
            keyValues.add(new ProducerKeyValue(KafkaConfigBackingStore.CONNECTOR_KEY(connector), serializedConfig));
            this.sendPrivileged(keyValues, timer);
            this.configLog.readToEnd().get(timer.remainingMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write connector configuration to Kafka: ", (Throwable)e);
            throw new ConnectException("Error writing connector configuration to Kafka", (Throwable)e);
        }
    }

    @Override
    public void removeConnectorConfig(String connector) {
        log.debug("Removing connector configuration for connector '{}'", (Object)connector);
        try {
            Timer timer = this.time.timer(30000L);
            List<ProducerKeyValue> keyValues = Arrays.asList(new ProducerKeyValue(KafkaConfigBackingStore.CONNECTOR_KEY(connector), null), new ProducerKeyValue(KafkaConfigBackingStore.TARGET_STATE_KEY(connector), null));
            this.sendPrivileged(keyValues, timer);
            this.configLog.readToEnd().get(timer.remainingMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to remove connector configuration from Kafka: ", (Throwable)e);
            throw new ConnectException("Error removing connector configuration from Kafka", (Throwable)e);
        }
    }

    @Override
    public void removeTaskConfigs(String connector) {
        throw new UnsupportedOperationException("Removal of tasks is not currently supported");
    }

    @Override
    public void putTaskConfigs(String connector, List<Map<String, String>> configs) {
        Timer timer = this.time.timer(30000L);
        try {
            this.configLog.readToEnd().get(timer.remainingMs(), TimeUnit.MILLISECONDS);
            timer.update();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write root configuration to Kafka: ", (Throwable)e);
            throw new ConnectException("Error writing root configuration to Kafka", (Throwable)e);
        }
        int taskCount = configs.size();
        int index = 0;
        ArrayList<ProducerKeyValue> keyValues = new ArrayList<ProducerKeyValue>();
        for (Map<String, String> taskConfig : configs) {
            Struct connectConfig = new Struct(TASK_CONFIGURATION_V0);
            connectConfig.put("properties", taskConfig);
            byte[] serializedConfig = this.converter.fromConnectData(this.topic, TASK_CONFIGURATION_V0, (Object)connectConfig);
            log.debug("Writing configuration for connector '{}' task {}", (Object)connector, (Object)index);
            ConnectorTaskId connectorTaskId = new ConnectorTaskId(connector, index);
            keyValues.add(new ProducerKeyValue(KafkaConfigBackingStore.TASK_KEY(connectorTaskId), serializedConfig));
            ++index;
        }
        try {
            this.sendPrivileged(keyValues, timer);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write task configurations to Kafka", (Throwable)e);
            throw new ConnectException("Error writing task configurations to Kafka", (Throwable)e);
        }
        try {
            if (taskCount > 0) {
                this.configLog.readToEnd().get(timer.remainingMs(), TimeUnit.MILLISECONDS);
                timer.update();
            }
            Struct connectConfig = new Struct(CONNECTOR_TASKS_COMMIT_V0);
            connectConfig.put("tasks", (Object)taskCount);
            byte[] serializedConfig = this.converter.fromConnectData(this.topic, CONNECTOR_TASKS_COMMIT_V0, (Object)connectConfig);
            log.debug("Writing commit for connector '{}' with {} tasks.", (Object)connector, (Object)taskCount);
            this.sendPrivileged(KafkaConfigBackingStore.COMMIT_TASKS_KEY(connector), serializedConfig, timer);
            this.configLog.readToEnd().get(timer.remainingMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write root configuration to Kafka: ", (Throwable)e);
            throw new ConnectException("Error writing root configuration to Kafka", (Throwable)e);
        }
    }

    @Override
    public void refresh(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            this.configLog.readToEnd().get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ConnectException("Error trying to read to end of config log", (Throwable)e);
        }
    }

    @Override
    public void putTargetState(String connector, TargetState state) {
        log.debug("Writing target state {} for connector {}", (Object)state, (Object)connector);
        try {
            this.configLog.sendWithReceipt(KafkaConfigBackingStore.TARGET_STATE_KEY(connector), this.serializeTargetState(state)).get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write target state to Kafka", (Throwable)e);
            throw new ConnectException("Error writing target state to Kafka", (Throwable)e);
        }
    }

    private byte[] serializeTargetState(TargetState state) {
        Struct connectTargetState = new Struct(TARGET_STATE_V1);
        connectTargetState.put("state", (Object)(state == TargetState.STOPPED ? TargetState.PAUSED.name() : state.name()));
        connectTargetState.put("state.v2", (Object)state.name());
        return this.converter.fromConnectData(this.topic, TARGET_STATE_V1, (Object)connectTargetState);
    }

    @Override
    public void putTaskCountRecord(String connector, int taskCount) {
        Struct taskCountRecord = new Struct(TASK_COUNT_RECORD_V0);
        taskCountRecord.put("task-count", (Object)taskCount);
        byte[] serializedTaskCountRecord = this.converter.fromConnectData(this.topic, TASK_COUNT_RECORD_V0, (Object)taskCountRecord);
        log.debug("Writing task count record {} for connector {}", (Object)taskCount, (Object)connector);
        try {
            Timer timer = this.time.timer(30000L);
            this.sendPrivileged(KafkaConfigBackingStore.TASK_COUNT_RECORD_KEY(connector), serializedTaskCountRecord, timer);
            this.configLog.readToEnd().get(timer.remainingMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write task count record with {} tasks for connector {} to Kafka: ", new Object[]{taskCount, connector, e});
            throw new ConnectException("Error writing task count record to Kafka", (Throwable)e);
        }
    }

    @Override
    public void putSessionKey(SessionKey sessionKey) {
        log.debug("Distributing new session key");
        Struct sessionKeyStruct = new Struct(SESSION_KEY_V0);
        sessionKeyStruct.put("key", (Object)Base64.getEncoder().encodeToString(sessionKey.key().getEncoded()));
        sessionKeyStruct.put("algorithm", (Object)sessionKey.key().getAlgorithm());
        sessionKeyStruct.put("creation-timestamp", (Object)sessionKey.creationTimestamp());
        byte[] serializedSessionKey = this.converter.fromConnectData(this.topic, SESSION_KEY_V0, (Object)sessionKeyStruct);
        try {
            Timer timer = this.time.timer(30000L);
            this.sendPrivileged(SESSION_KEY_KEY, serializedSessionKey, timer);
            this.configLog.readToEnd().get(timer.remainingMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write session key to Kafka: ", (Throwable)e);
            throw new ConnectException("Error writing session key to Kafka", (Throwable)e);
        }
    }

    @Override
    public void putRestartRequest(RestartRequest restartRequest) {
        log.debug("Writing {} to Kafka", (Object)restartRequest);
        String key = KafkaConfigBackingStore.RESTART_KEY(restartRequest.connectorName());
        Struct value = new Struct(RESTART_REQUEST_V0);
        value.put(INCLUDE_TASKS_FIELD_NAME, (Object)restartRequest.includeTasks());
        value.put(ONLY_FAILED_FIELD_NAME, (Object)restartRequest.onlyFailed());
        byte[] serializedValue = this.converter.fromConnectData(this.topic, value.schema(), (Object)value);
        try {
            Timer timer = this.time.timer(30000L);
            this.sendPrivileged(key, serializedValue, timer);
            this.configLog.readToEnd().get(timer.remainingMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write {} to Kafka: ", (Object)restartRequest, (Object)e);
            throw new ConnectException("Error writing " + restartRequest + " to Kafka", (Throwable)e);
        }
    }

    @Override
    public void putLoggerLevel(String namespace, String level) {
        log.debug("Writing level {} for logging namespace {} to Kafka", (Object)level, (Object)namespace);
        Struct value = new Struct(LOGGER_LEVEL_V0);
        value.put("level", (Object)level);
        byte[] serializedValue = this.converter.fromConnectData(this.topic, value.schema(), (Object)value);
        try {
            this.configLog.sendWithReceipt(KafkaConfigBackingStore.LOGGER_CLUSTER_KEY(namespace), serializedValue).get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Failed to write logger level to Kafka", (Throwable)e);
            throw new ConnectException("Error writing logger level to Kafka", (Throwable)e);
        }
    }

    KafkaBasedLog<String, byte[]> setupAndCreateKafkaBasedLog(String topic, WorkerConfig config) {
        String clusterId = config.kafkaClusterId();
        Map<String, Object> originals = config.originals();
        Map<String, Object> producerProps = this.baseProducerProps(config);
        producerProps.put("enable.idempotence", "false");
        ConnectUtils.addMetricsContextProperties(producerProps, config, clusterId);
        ConnectUtils.addConfluentMetricsContextProperties(producerProps);
        producerProps.put("client.id", this.clientId);
        HashMap<String, Object> consumerProps = new HashMap<String, Object>(originals);
        consumerProps.put("key.deserializer", StringDeserializer.class.getName());
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("client.id", this.clientId);
        ConnectUtils.addMetricsContextProperties(consumerProps, config, clusterId);
        ConnectUtils.addConfluentMetricsContextProperties(consumerProps);
        if (config.exactlyOnceSourceEnabled()) {
            ConnectUtils.ensureProperty(consumerProps, "isolation.level", IsolationLevel.READ_COMMITTED.name().toLowerCase(Locale.ROOT), "for the worker's config topic consumer when exactly-once source support is enabled", true);
        }
        HashMap<String, Object> adminProps = new HashMap<String, Object>(originals);
        ConnectUtils.addMetricsContextProperties(adminProps, config, clusterId);
        ConnectUtils.addConfluentMetricsContextProperties(adminProps);
        adminProps.put("client.id", this.clientId);
        SharedTopicAdmin adminSupplier = this.topicAdminSupplier != null ? this.topicAdminSupplier : (this.ownTopicAdmin = new SharedTopicAdmin(adminProps));
        Map<String, Object> topicSettings = config instanceof DistributedConfig ? ((DistributedConfig)config).configStorageTopicSettings() : Collections.emptyMap();
        NewTopic topicDescription = TopicAdmin.defineTopic(topic).config(topicSettings).compacted().partitions(1).replicationFactor(config.getShort("config.storage.replication.factor")).build();
        return this.createKafkaBasedLog(topic, producerProps, consumerProps, new ConsumeCallback(), topicDescription, adminSupplier, config, this.time);
    }

    private void sendPrivileged(String key, byte[] value, Timer timer) throws ExecutionException, InterruptedException, TimeoutException {
        this.sendPrivileged(Collections.singletonList(new ProducerKeyValue(key, value)), timer);
    }

    private void sendPrivileged(List<ProducerKeyValue> keyValues, Timer timer) throws ExecutionException, InterruptedException, TimeoutException {
        if (!this.usesFencableWriter) {
            ArrayList producerFutures = new ArrayList();
            keyValues.forEach(keyValue -> producerFutures.add(this.configLog.sendWithReceipt(keyValue.key, keyValue.value)));
            timer.update();
            for (Future future : producerFutures) {
                future.get(timer.remainingMs(), TimeUnit.MILLISECONDS);
                timer.update();
            }
            return;
        }
        if (this.fencableProducer == null) {
            throw new IllegalStateException("Cannot produce to config topic without claiming write privileges first");
        }
        try {
            this.fencableProducer.beginTransaction();
            keyValues.forEach(keyValue -> this.fencableProducer.send(new ProducerRecord(this.topic, (Object)keyValue.key, (Object)keyValue.value)));
            this.fencableProducer.commitTransaction();
            timer.update();
        }
        catch (Exception e) {
            log.warn("Failed to perform fencable send to config topic", (Throwable)e);
            this.relinquishWritePrivileges();
            throw new PrivilegedWriteException("Failed to perform fencable send to config topic", e);
        }
    }

    private void relinquishWritePrivileges() {
        if (this.fencableProducer != null) {
            Utils.closeQuietly(() -> this.fencableProducer.close(Duration.ZERO), (String)"fencable producer for config topic");
            this.fencableProducer = null;
        }
    }

    @Override
    protected String getTopicConfig() {
        return "config.storage.topic";
    }

    @Override
    protected String getTopicPurpose() {
        return "connector configurations";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTargetStateRecord(String connectorName, SchemaAndValue value) {
        boolean removed = false;
        boolean stateChanged = true;
        Object object = this.lock;
        synchronized (object) {
            if (value.value() == null) {
                log.debug("Removed target state for connector {} due to null value in topic.", (Object)connectorName);
                this.connectorTargetStates.remove(connectorName);
                removed = true;
                if (this.connectorConfigs.containsKey(connectorName)) {
                    this.connectorTargetStates.put(connectorName, TargetState.STARTED);
                }
            } else {
                if (!(value.value() instanceof Map)) {
                    log.error("Ignoring target state for connector '{}' because it is in the wrong format: {}", (Object)connectorName, (Object)ConnectUtils.className(value.value()));
                    return;
                }
                Map valueMap = (Map)value.value();
                Object targetState = valueMap.get("state.v2");
                if (targetState != null && !(targetState instanceof String)) {
                    log.error("Invalid data for target state for connector '{}': 'state.v2' field should be a String but is {}", (Object)connectorName, (Object)ConnectUtils.className(targetState));
                    targetState = null;
                }
                if (targetState == null && !((targetState = valueMap.get("state")) instanceof String)) {
                    log.error("Invalid data for target state for connector '{}': 'state' field should be a String but is {}", (Object)connectorName, (Object)ConnectUtils.className(targetState));
                    return;
                }
                try {
                    TargetState state = TargetState.valueOf((String)targetState);
                    log.debug("Setting target state for connector '{}' to {}", (Object)connectorName, targetState);
                    TargetState prevState = this.connectorTargetStates.put(connectorName, state);
                    stateChanged = !state.equals((Object)prevState);
                }
                catch (IllegalArgumentException e) {
                    log.error("Invalid target state for connector '{}': {}", (Object)connectorName, targetState);
                    return;
                }
            }
        }
        if (this.started && !removed && stateChanged && this.connectorConfigs.containsKey(connectorName)) {
            this.updateListener.onConnectorTargetStateChange(connectorName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnectorConfigRecord(String connectorName, SchemaAndValue value) {
        boolean removed = false;
        Object object = this.lock;
        synchronized (object) {
            if (value.value() == null) {
                log.info("Successfully processed removal of connector '{}'", (Object)connectorName);
                this.connectorConfigs.remove(connectorName);
                this.connectorTaskCounts.remove(connectorName);
                this.taskConfigs.keySet().removeIf(taskId -> taskId.connector().equals(connectorName));
                this.deferredTaskUpdates.remove(connectorName);
                removed = true;
            } else {
                if (!(value.value() instanceof Map)) {
                    log.error("Ignoring configuration for connector '{}' because it is in the wrong format: {}", (Object)connectorName, (Object)ConnectUtils.className(value.value()));
                    return;
                }
                Object newConnectorConfig = ((Map)value.value()).get("properties");
                if (!(newConnectorConfig instanceof Map)) {
                    log.error("Invalid data for config for connector '{}': 'properties' field should be a Map but is {}", (Object)connectorName, (Object)ConnectUtils.className(newConnectorConfig));
                    return;
                }
                log.debug("Updating configuration for connector '{}'", (Object)connectorName);
                Map stringsConnectorConfig = (Map)newConnectorConfig;
                this.connectorConfigs.put(connectorName, stringsConnectorConfig);
                if (!this.connectorTargetStates.containsKey(connectorName)) {
                    this.connectorTargetStates.put(connectorName, TargetState.STARTED);
                }
            }
        }
        if (this.started) {
            if (removed) {
                this.updateListener.onConnectorConfigRemove(connectorName);
            } else {
                this.updateListener.onConnectorConfigUpdate(connectorName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTaskConfigRecord(ConnectorTaskId taskId, SchemaAndValue value) {
        Object object = this.lock;
        synchronized (object) {
            if (value.value() == null) {
                log.error("Ignoring task configuration for task {} because it is unexpectedly null", (Object)taskId);
                return;
            }
            if (!(value.value() instanceof Map)) {
                log.error("Ignoring task configuration for task {} because the value is not a Map but is {}", (Object)taskId, (Object)ConnectUtils.className(value.value()));
                return;
            }
            Object newTaskConfig = ((Map)value.value()).get("properties");
            if (!(newTaskConfig instanceof Map)) {
                log.error("Invalid data for config of task {} 'properties' field should be a Map but is {}", (Object)taskId, (Object)ConnectUtils.className(newTaskConfig));
                return;
            }
            Map deferred = this.deferredTaskUpdates.computeIfAbsent(taskId.connector(), k -> new HashMap());
            log.debug("Storing new config for task {}; this will wait for a commit message before the new config will take effect.", (Object)taskId);
            Map stringsTaskConfig = (Map)newTaskConfig;
            deferred.put(taskId, stringsTaskConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTasksCommitRecord(String connectorName, SchemaAndValue value) {
        ArrayList<ConnectorTaskId> updatedTasks = new ArrayList<ConnectorTaskId>();
        Object object = this.lock;
        synchronized (object) {
            if (!(value.value() instanceof Map)) {
                log.error("Ignoring connector tasks configuration commit for connector '{}' because it is in the wrong format: {}", (Object)connectorName, (Object)ConnectUtils.className(value.value()));
                return;
            }
            Map<ConnectorTaskId, Map<String, String>> deferred = this.deferredTaskUpdates.get(connectorName);
            int newTaskCount = KafkaConfigBackingStore.intValue(((Map)value.value()).get("tasks"));
            Set<Integer> taskIdSet = this.taskIds(connectorName, deferred);
            if (!this.completeTaskIdSet(taskIdSet, newTaskCount)) {
                log.debug("We have an incomplete set of task configs for connector '{}' probably due to compaction. So we are not doing anything with the new configuration.", (Object)connectorName);
                this.inconsistent.add(connectorName);
            } else {
                if (deferred != null) {
                    this.taskConfigs.putAll(deferred);
                    updatedTasks.addAll(deferred.keySet());
                    this.connectorTaskConfigGenerations.compute(connectorName, (ignored, generation) -> generation != null ? generation + 1 : 0);
                }
                this.inconsistent.remove(connectorName);
            }
            if (deferred != null) {
                deferred.clear();
            }
            this.connectorTaskCounts.put(connectorName, newTaskCount);
        }
        this.connectorsPendingFencing.add(connectorName);
        if (this.started) {
            this.updateListener.onTaskConfigUpdate(updatedTasks);
        }
    }

    RestartRequest recordToRestartRequest(ConsumerRecord<String, byte[]> record, SchemaAndValue value) {
        boolean includeTasks;
        boolean onlyFailed;
        String connectorName = ((String)record.key()).substring(RESTART_PREFIX.length());
        if (!(value.value() instanceof Map)) {
            log.error("Ignoring restart request because the value is not a Map but is {}", (Object)ConnectUtils.className(value.value()));
            return null;
        }
        Map valueAsMap = (Map)value.value();
        Object failed = valueAsMap.get(ONLY_FAILED_FIELD_NAME);
        if (!(failed instanceof Boolean)) {
            log.warn("Invalid data for restart request '{}' field should be a Boolean but is {}, defaulting to {}", new Object[]{ONLY_FAILED_FIELD_NAME, ConnectUtils.className(failed), false});
            onlyFailed = false;
        } else {
            onlyFailed = (Boolean)failed;
        }
        Object withTasks = valueAsMap.get(INCLUDE_TASKS_FIELD_NAME);
        if (!(withTasks instanceof Boolean)) {
            log.warn("Invalid data for restart request '{}' field should be a Boolean but is {}, defaulting to {}", new Object[]{INCLUDE_TASKS_FIELD_NAME, ConnectUtils.className(withTasks), false});
            includeTasks = false;
        } else {
            includeTasks = (Boolean)withTasks;
        }
        return new RestartRequest(connectorName, onlyFailed, includeTasks);
    }

    private void processTaskCountRecord(String connectorName, SchemaAndValue value) {
        if (!(value.value() instanceof Map)) {
            log.error("Ignoring task count record for connector '{}' because it is in the wrong format: {}", (Object)connectorName, (Object)ConnectUtils.className(value.value()));
            return;
        }
        int taskCount = KafkaConfigBackingStore.intValue(((Map)value.value()).get("task-count"));
        log.debug("Setting task count record for connector '{}' to {}", (Object)connectorName, (Object)taskCount);
        this.connectorTaskCountRecords.put(connectorName, taskCount);
        this.connectorsPendingFencing.remove(connectorName);
    }

    private void processSessionKeyRecord(SchemaAndValue value) {
        if (value.value() == null) {
            log.error("Ignoring session key because it is unexpectedly null");
            return;
        }
        if (!(value.value() instanceof Map)) {
            log.error("Ignoring session key because the value is not a Map but is {}", (Object)ConnectUtils.className(value.value()));
            return;
        }
        Map valueAsMap = (Map)value.value();
        Object sessionKey = valueAsMap.get("key");
        if (!(sessionKey instanceof String)) {
            log.error("Invalid data for session key 'key' field should be a String but is {}", (Object)ConnectUtils.className(sessionKey));
            return;
        }
        byte[] key = Base64.getDecoder().decode((String)sessionKey);
        Object keyAlgorithm = valueAsMap.get("algorithm");
        if (!(keyAlgorithm instanceof String)) {
            log.error("Invalid data for session key 'algorithm' field should be a String but it is {}", (Object)ConnectUtils.className(keyAlgorithm));
            return;
        }
        Object creationTimestamp = valueAsMap.get("creation-timestamp");
        if (!(creationTimestamp instanceof Long)) {
            log.error("Invalid data for session key 'creation-timestamp' field should be a long but it is {}", (Object)ConnectUtils.className(creationTimestamp));
            return;
        }
        this.sessionKey = new SessionKey(new SecretKeySpec(key, (String)keyAlgorithm), (Long)creationTimestamp);
        if (this.started) {
            this.updateListener.onSessionKeyUpdate(this.sessionKey);
        }
    }

    private void processLoggerLevelRecord(String namespace, SchemaAndValue value) {
        if (value.value() == null) {
            log.error("Ignoring logging level for namespace {} because it is unexpectedly null", (Object)namespace);
            return;
        }
        if (!(value.value() instanceof Map)) {
            log.error("Ignoring logging level for namespace {} because the value is not a Map but is {}", (Object)namespace, (Object)ConnectUtils.className(value.value()));
            return;
        }
        Map valueAsMap = (Map)value.value();
        Object level = valueAsMap.get("level");
        if (!(level instanceof String)) {
            log.error("Invalid data for logging level key 'level' field with namespace {}; should be a String but it is {}", (Object)namespace, (Object)ConnectUtils.className(level));
            return;
        }
        if (this.started) {
            this.updateListener.onLoggingLevelUpdate(namespace, (String)level);
        } else {
            log.trace("Ignoring old logging level {} for namespace {} that was writen to the config topic before this worker completed startup", level, (Object)namespace);
        }
    }

    private ConnectorTaskId parseTaskId(String key) {
        String[] parts = key.split("-");
        if (parts.length < 3) {
            return null;
        }
        try {
            int taskNum = Integer.parseInt(parts[parts.length - 1]);
            String connectorName = Utils.join((Object[])Arrays.copyOfRange(parts, 1, parts.length - 1), (String)"-");
            return new ConnectorTaskId(connectorName, taskNum);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Set<Integer> taskIds(String connector, Map<ConnectorTaskId, Map<String, String>> configs) {
        TreeSet<Integer> tasks = new TreeSet<Integer>();
        if (configs == null) {
            return tasks;
        }
        for (ConnectorTaskId taskId : configs.keySet()) {
            assert (taskId.connector().equals(connector));
            tasks.add(taskId.task());
        }
        return tasks;
    }

    private boolean completeTaskIdSet(Set<Integer> idSet, int expectedSize) {
        if (idSet.size() < expectedSize) {
            return false;
        }
        for (int i = 0; i < expectedSize; ++i) {
            if (idSet.contains(i)) continue;
            return false;
        }
        return true;
    }

    private static int intValue(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return (int)((Long)value).longValue();
        }
        throw new ConnectException("Expected integer value to be either Integer or Long");
    }

    static {
        TASK_CONFIGURATION_V0 = CONNECTOR_CONFIGURATION_V0 = SchemaBuilder.struct().field("properties", SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.OPTIONAL_STRING_SCHEMA).build()).build();
        CONNECTOR_TASKS_COMMIT_V0 = SchemaBuilder.struct().field("tasks", Schema.INT32_SCHEMA).build();
        TARGET_STATE_V0 = SchemaBuilder.struct().field("state", Schema.STRING_SCHEMA).build();
        TARGET_STATE_V1 = SchemaBuilder.struct().field("state", Schema.STRING_SCHEMA).field("state.v2", Schema.OPTIONAL_STRING_SCHEMA).build();
        TASK_COUNT_RECORD_V0 = SchemaBuilder.struct().field("task-count", Schema.INT32_SCHEMA).build();
        SESSION_KEY_V0 = SchemaBuilder.struct().field("key", Schema.STRING_SCHEMA).field("algorithm", Schema.STRING_SCHEMA).field("creation-timestamp", Schema.INT64_SCHEMA).build();
        RESTART_REQUEST_V0 = SchemaBuilder.struct().field(INCLUDE_TASKS_FIELD_NAME, Schema.BOOLEAN_SCHEMA).field(ONLY_FAILED_FIELD_NAME, Schema.BOOLEAN_SCHEMA).build();
        LOGGER_LEVEL_V0 = SchemaBuilder.struct().field("level", Schema.STRING_SCHEMA).build();
    }

    private class ConsumeCallback
    implements Callback<ConsumerRecord<String, byte[]>> {
        private ConsumeCallback() {
        }

        @Override
        public void onCompletion(Throwable error, ConsumerRecord<String, byte[]> record) {
            SchemaAndValue value;
            if (error != null) {
                log.error("Unexpected in consumer callback for KafkaConfigBackingStore: ", error);
                return;
            }
            try {
                value = KafkaConfigBackingStore.this.converter.toConnectData(KafkaConfigBackingStore.this.topic, (byte[])record.value());
            }
            catch (DataException e) {
                log.error("Failed to convert config data to Kafka Connect format: ", (Throwable)e);
                return;
            }
            KafkaConfigBackingStore.this.offset = record.offset() + 1L;
            if (((String)record.key()).startsWith(KafkaConfigBackingStore.TARGET_STATE_PREFIX)) {
                String connectorName = ((String)record.key()).substring(KafkaConfigBackingStore.TARGET_STATE_PREFIX.length());
                KafkaConfigBackingStore.this.processTargetStateRecord(connectorName, value);
            } else if (((String)record.key()).startsWith(KafkaConfigBackingStore.CONNECTOR_PREFIX)) {
                String connectorName = ((String)record.key()).substring(KafkaConfigBackingStore.CONNECTOR_PREFIX.length());
                KafkaConfigBackingStore.this.processConnectorConfigRecord(connectorName, value);
            } else if (((String)record.key()).startsWith(KafkaConfigBackingStore.TASK_PREFIX)) {
                ConnectorTaskId taskId = KafkaConfigBackingStore.this.parseTaskId((String)record.key());
                if (taskId == null) {
                    log.error("Ignoring task configuration because {} couldn't be parsed as a task config key", record.key());
                    return;
                }
                KafkaConfigBackingStore.this.processTaskConfigRecord(taskId, value);
            } else if (((String)record.key()).startsWith(KafkaConfigBackingStore.COMMIT_TASKS_PREFIX)) {
                String connectorName = ((String)record.key()).substring(KafkaConfigBackingStore.COMMIT_TASKS_PREFIX.length());
                KafkaConfigBackingStore.this.processTasksCommitRecord(connectorName, value);
            } else if (((String)record.key()).startsWith(KafkaConfigBackingStore.RESTART_PREFIX)) {
                RestartRequest request = KafkaConfigBackingStore.this.recordToRestartRequest(record, value);
                if (request != null && KafkaConfigBackingStore.this.started) {
                    KafkaConfigBackingStore.this.updateListener.onRestartRequest(request);
                }
            } else if (((String)record.key()).startsWith(KafkaConfigBackingStore.TASK_COUNT_RECORD_PREFIX)) {
                String connectorName = ((String)record.key()).substring(KafkaConfigBackingStore.TASK_COUNT_RECORD_PREFIX.length());
                KafkaConfigBackingStore.this.processTaskCountRecord(connectorName, value);
            } else if (((String)record.key()).equals(KafkaConfigBackingStore.SESSION_KEY_KEY)) {
                KafkaConfigBackingStore.this.processSessionKeyRecord(value);
            } else if (((String)record.key()).startsWith(KafkaConfigBackingStore.LOGGER_CLUSTER_PREFIX)) {
                String loggingNamespace = ((String)record.key()).substring(KafkaConfigBackingStore.LOGGER_CLUSTER_PREFIX.length());
                KafkaConfigBackingStore.this.processLoggerLevelRecord(loggingNamespace, value);
            } else {
                log.error("Discarding config update record with invalid key: {}", record.key());
            }
        }
    }

    private static class ProducerKeyValue {
        final String key;
        final byte[] value;

        ProducerKeyValue(String key, byte[] value) {
            this.key = key;
            this.value = value;
        }
    }
}

