/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.WindowCalculationHelper;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MetricsWindow {
    private final long sizeMs;
    private final long startMs;
    private final long endMs;
    private final long index;
    private final long baseTimestamp;
    private static final Long EMPTY_WINDOW_END_MS = 0L;
    private static final Long EMPTY_WINDOW_INDEX = 0L;

    public MetricsWindow(long startMs, long endMs, long index, long baseTimestamp) {
        this.startMs = startMs;
        this.endMs = endMs;
        this.baseTimestamp = baseTimestamp;
        this.sizeMs = endMs - startMs;
        this.index = index;
    }

    public MetricsWindow(long startMs, long endMs, long index) {
        this.startMs = startMs;
        this.endMs = endMs;
        this.baseTimestamp = 0L;
        this.sizeMs = endMs - startMs;
        this.index = index;
    }

    public static MetricsWindow empty(long windowSizeMs) {
        return new MetricsWindow(-windowSizeMs, EMPTY_WINDOW_END_MS, EMPTY_WINDOW_INDEX);
    }

    public long sizeMs() {
        return this.sizeMs;
    }

    public MetricsWindow nextWindow() {
        return WindowCalculationHelper.metricsWindow(this.index + 1L, this.sizeMs, this.baseTimestamp);
    }

    public MetricsWindow previousWindow() {
        return WindowCalculationHelper.metricsWindow(this.index - 1L, this.sizeMs, this.baseTimestamp);
    }

    public long startMs() {
        return this.startMs;
    }

    public long endMsInclusive() {
        return this.endMs - 1L;
    }

    public String toConciseString() {
        return "(index: " + this.index + ", " + this.timeStringRange() + ")";
    }

    public String toString() {
        return "MetricsWindow{sizeMs=" + this.sizeMs + ", startMs=" + this.startMs + ", endMs=" + this.endMs + ", endMsInclusive=" + this.endMsInclusive() + ", index=" + this.index + ", baseTimestamp=" + this.baseTimestamp + "}(" + this.timeStringRange() + ")";
    }

    private String timeStringRange() {
        return KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(this.startMs) + " - " + KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(this.endMsInclusive());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsWindow that = (MetricsWindow)o;
        return this.sizeMs == that.sizeMs && this.startMs == that.startMs && this.endMs == that.endMs && this.index == that.index;
    }

    public int hashCode() {
        return Objects.hash(this.sizeMs, this.startMs, this.endMs, this.index);
    }
}

