/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricsWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class WindowCalculationHelper {
    static long findWindowStartTimestamp(long index, long windowBaseTimeMs, long windowSizeMs) {
        return (index - 1L) * windowSizeMs + windowBaseTimeMs;
    }

    public static long findWindowEndTimestamp(long windowIndex, long windowBaseTimeMs, long windowSizeMs) {
        return windowIndex * windowSizeMs + windowBaseTimeMs - 1L;
    }

    static void populateTimestamps(List<Long> windows, long fromWindowIndex, long toWindowIndex, long windowBaseTimeMs, long windowSizeMs) {
        for (long index = fromWindowIndex; index <= toWindowIndex; ++index) {
            windows.add(WindowCalculationHelper.findWindowEndTimestamp(index, windowBaseTimeMs, windowSizeMs));
        }
    }

    static void populateTimestamps(Collection<Long> windows, Collection<Long> windowIndices, long windowBaseTimeMs, long windowSizeMs) {
        for (Long index : windowIndices) {
            windows.add(WindowCalculationHelper.findWindowEndTimestamp(index, windowBaseTimeMs, windowSizeMs));
        }
    }

    static void populateWindowTimestamps(Map<Long, Float> original, Map<Long, Float> result, long windowBaseTimeMs, long windowSizeMs) {
        original.forEach((key, value) -> result.put(WindowCalculationHelper.findWindowEndTimestamp(key, windowBaseTimeMs, windowSizeMs), (Float)value));
    }

    public static Set<Long> windowIndicesToWindows(Set<Long> windowIndices, long windowBaseTimeMs, long windowSizeMs) {
        TreeSet<Long> result = new TreeSet<Long>(Collections.reverseOrder());
        WindowCalculationHelper.populateTimestamps(result, windowIndices, windowBaseTimeMs, windowSizeMs);
        return result;
    }

    public static Map<Long, Float> windowIndicesToWindows(Map<Long, Float> original, long windowBaseTimeMs, long windowSizeMs) {
        TreeMap<Long, Float> result = new TreeMap<Long, Float>(Collections.reverseOrder());
        WindowCalculationHelper.populateWindowTimestamps(original, result, windowBaseTimeMs, windowSizeMs);
        return result;
    }

    static List<Long> toWindows(SortedSet<Long> windowIndices, long windowBaseTimeMs, long windowSizeMs) {
        ArrayList<Long> windows = new ArrayList<Long>(windowIndices.size());
        WindowCalculationHelper.populateTimestamps(windows, windowIndices, windowBaseTimeMs, windowSizeMs);
        return windows;
    }

    public static MetricsWindow metricsWindow(long windowIndex, long windowSizeMs, long windowBaseTimeMs) {
        long startMs = windowSizeMs * (windowIndex - 1L) + windowBaseTimeMs;
        long endMs = windowSizeMs * windowIndex + windowBaseTimeMs;
        return new MetricsWindow(startMs, endMs, windowIndex, windowBaseTimeMs);
    }

    public static MetricsWindow currentWindow(long nowMs, long windowSizeMs, long windowBaseTimeMs) {
        return WindowCalculationHelper.metricsWindow(WindowCalculationHelper.windowIndex(nowMs, windowBaseTimeMs, windowSizeMs), windowSizeMs, windowBaseTimeMs);
    }

    public static long windowIndex(long timeMs, long windowBaseTimeMs, long windowSizeMs) {
        return (timeMs - windowBaseTimeMs) / windowSizeMs + 1L;
    }
}

