/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol;

import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class KafkaCruiseControlOperationMetricsTracker {
    public static final String OPERATION_NAME_SELF_HEALING = "self-healing";
    public static final String OPERATION_NAME_BROKER_REMOVAL = "broker-removal";
    public static final String OPERATION_NAME_BROKER_ADDITION = "broker-addition";
    public static final String OPERATION_TYPE_CPU = "cpu";
    public static final String OPERATION_TYPE_TRDG = "trdg";
    private static final String METRIC_NAME = "cruise-control-operations";
    private static final String METRIC_OPERATION_TAG = "operation";
    private static final String METRIC_BROKER_ADDITION_TYPE_TAG = "broker-addition-type";
    private final DataBalancerMetricsRegistry registry;
    private final Map<Operation, Integer> operationStates;

    public KafkaCruiseControlOperationMetricsTracker(DataBalancerMetricsRegistry registry) {
        this.registry = registry;
        this.operationStates = new ConcurrentHashMap<Operation, Integer>();
        this.init();
    }

    private void init() {
        Arrays.stream(Operation.values()).forEach(operation -> {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put(METRIC_OPERATION_TAG, operation.getOperationName());
            operation.getOperationType().ifPresent(type -> tags.put(METRIC_BROKER_ADDITION_TYPE_TAG, (String)type));
            this.registry.newGauge(KafkaCruiseControlOperationMetricsTracker.class, METRIC_NAME, () -> this.operationStates.getOrDefault(operation, 0), tags);
        });
    }

    public void beginOperation(Operation operation) {
        this.operationStates.put(operation, 1);
    }

    public void completeOperation(Operation operation) {
        this.operationStates.put(operation, 0);
    }

    public static enum Operation {
        SELF_HEALING("self-healing"),
        BROKER_REMOVAL("broker-removal"),
        BROKER_ADDITION("broker-addition"),
        BROKER_ADDITION_WITH_CPU("broker-addition", "cpu"),
        BROKER_ADDITION_WITH_TRDG("broker-addition", "trdg");

        private final String operationName;
        private final String operationType;

        private Operation(String operationName) {
            this.operationName = operationName;
            this.operationType = null;
        }

        private Operation(String operationName, String operationType) {
            this.operationName = operationName;
            this.operationType = operationType;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public Optional<String> getOperationType() {
            return Optional.ofNullable(this.operationType);
        }
    }
}

