/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalOptimizationResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ProposalStats;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import io.confluent.cruisecontrol.analyzer.history.TopicPartitionMovement;
import java.util.Optional;
import java.util.Stack;
import org.apache.kafka.common.TopicPartition;

public class BalancingActionsLog {
    private final Stack<ReplicaBalancingAction> balancingActions = new Stack();
    private final Stack<TopicPartitionMovement> tpMovements = new Stack();
    private int numProposalsAccepted = 0;
    private int numMovesAccepted = 0;

    public void recordBalancingAction(ReplicaBalancingAction action) {
        this.balancingActions.push(action);
        ++this.numProposalsAccepted;
        if (action.balancingAction() == ActionType.INTER_BROKER_REPLICA_MOVEMENT) {
            ++this.numMovesAccepted;
        }
    }

    public void recordTopicPartitionMovement(TopicPartitionMovement tpMovement) {
        this.tpMovements.push(tpMovement);
    }

    public void revertActions(ClusterModel model) {
        while (!this.balancingActions.empty()) {
            ReplicaBalancingAction action = this.balancingActions.pop();
            TopicPartition tp = action.topicPartition();
            int sourceBroker = action.sourceBrokerId();
            int destinationBroker = action.destinationBrokerId();
            ActionType actionType = action.balancingAction();
            if (actionType == ActionType.LEADERSHIP_MOVEMENT) {
                model.relocateLeadership(tp, destinationBroker, sourceBroker);
                continue;
            }
            if (actionType == ActionType.INTER_BROKER_REPLICA_MOVEMENT) {
                model.relocateReplica(tp, destinationBroker, sourceBroker);
                continue;
            }
            throw new UnsupportedOperationException(String.format("Reverting balancing action of type %s is not supported.", new Object[]{actionType}));
        }
    }

    public void revertTopicPartitionMovements(GoalOptimizationResult.Builder optimizationResultBuilder) {
        while (!this.tpMovements.empty()) {
            TopicPartitionMovement tpMovement = this.tpMovements.pop();
            optimizationResultBuilder.removeTopicPartitionMovement(tpMovement);
        }
    }

    public void revertAcceptedProposals(ProposalStats.Builder proposalStatsBuilder, int brokerId, Optional<String> revertingGoal) {
        proposalStatsBuilder.revertAcceptedProposals(brokerId, this.numProposalsAccepted, this.numMovesAccepted, revertingGoal);
        this.numProposalsAccepted = 0;
        this.numMovesAccepted = 0;
    }

    Stack<ReplicaBalancingAction> balancingActions() {
        return this.balancingActions;
    }

    Stack<TopicPartitionMovement> topicPartitionMovements() {
        return this.tpMovements;
    }

    int numProposalsAccepted() {
        return this.numProposalsAccepted;
    }

    int numMovesAccepted() {
        return this.numMovesAccepted;
    }
}

