/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalOptimizationResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ProposalStats;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.GoalConfigChangeNotifier;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.UpdatableSbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.executor.PartitionProposal;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.ReplicaId;
import com.linkedin.kafka.cruisecontrol.monitor.BrokerStats;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import io.confluent.cruisecontrol.analyzer.history.EntityMovementHistory;
import io.confluent.cruisecontrol.analyzer.history.TopicPartitionMovement;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoalOptimizer {
    private static final String PROPOSAL_COMPUTATION_TIMER_METRIC_NAME = "proposal-computation-timer";
    static final String INCREMENTAL_BALANCING_ENABLED_METRIC_NAME = "incremental-balancing-enabled";
    static final String GOAL_PROPOSAL_GENERATION_RATE_METRIC_NAME = "proposal-generation-rate";
    private static final String GOAL_PROPOSAL_REJECTION_RATE_METRIC_NAME = "proposal-rejection-rate";
    private static final String GOAL_PROPOSAL_ACCEPTANCE_RATE_METRIC_NAME = "proposal-acceptance-rate";
    private static final String GOAL_MOVE_GENERATION_RATE_METRIC_NAME = "move-generation-rate";
    private static final String GOAL_SWAP_GENERATION_RATE_METRIC_NAME = "swap-generation-rate";
    private static final String GOAL_PARTITION_MOVE_GENERATION_RATE_METRIC_NAME = "partition-move-generation-rate";
    private static final Logger LOG = LoggerFactory.getLogger(GoalOptimizer.class);
    private final ConcurrentMap<String, ProposalMetrics> goalProposalMetrics;
    private final BalancingConstraint balancingConstraint;
    private final Timer proposalComputationTimer;
    private final double priorityWeight;
    private final double strictnessWeight;
    private final Time time;
    private final EntityMovementHistory<TopicPartitionMovement> topicPartitionMovementHistory;
    private volatile boolean incrementalBalancingEnabled;

    public GoalOptimizer(KafkaCruiseControlConfig config, final DataBalancerMetricsRegistry metricsRegistry, UpdatableSbcGoalsConfig updatableSbcGoalsConfig, EntityMovementHistory<TopicPartitionMovement> topicPartitionMovementHistory) {
        this.balancingConstraint = new BalancingConstraint(config);
        this.proposalComputationTimer = metricsRegistry.newTimer(GoalOptimizer.class, PROPOSAL_COMPUTATION_TIMER_METRIC_NAME);
        this.priorityWeight = config.getDouble("goal.balancedness.priority.weight");
        this.strictnessWeight = config.getDouble("goal.balancedness.strictness.weight");
        this.time = Time.SYSTEM;
        this.goalProposalMetrics = new ConcurrentHashMap<String, ProposalMetrics>();
        this.incrementalBalancingEnabled = updatableSbcGoalsConfig.config().isIncrementalBalancingEnabled();
        metricsRegistry.newGauge(GoalOptimizer.class, INCREMENTAL_BALANCING_ENABLED_METRIC_NAME, () -> this.incrementalBalancingEnabled);
        this.maybePopulateMetrics(metricsRegistry, updatableSbcGoalsConfig.config());
        updatableSbcGoalsConfig.registerListener(new GoalConfigChangeNotifier.GoalConfigChangeListener("goal-optimizer-metrics-update-listener"){

            @Override
            public void onChange(SbcGoalsConfig newConfig) {
                GoalOptimizer.this.incrementalBalancingEnabled = newConfig.isIncrementalBalancingEnabled();
                GoalOptimizer.this.maybePopulateMetrics(metricsRegistry, newConfig);
            }
        });
        this.topicPartitionMovementHistory = topicPartitionMovementHistory;
    }

    public OptimizerResult optimizations(ClusterModel clusterModel, GoalsConfig goalsConfig, OptimizationOptions optimizationOptions) throws KafkaCruiseControlException {
        List<Goal> goalsByPriority = goalsConfig.goals();
        if (clusterModel == null) {
            throw new IllegalArgumentException("The cluster model cannot be null");
        }
        if (goalsByPriority.isEmpty()) {
            throw new IllegalArgumentException("At least one goal must be provided to get an optimization result.");
        }
        if (!clusterModel.clusterHasEligibleDestinationBrokers()) {
            throw new IllegalArgumentException("All brokers in the cluster are uneligible for replica placement - they are either dead or excluded for replica placement.");
        }
        LOG.info("Starting proposal computation");
        long start = this.time.hiResClockMs();
        LOG.trace("Cluster before optimization is {}", (Object)clusterModel);
        BrokerStats brokerStatsBeforeOptimization = clusterModel.brokerStats(null);
        Map<TopicPartition, List<ReplicaId>> initReplicaDistribution = clusterModel.getReplicaDistribution();
        Map<TopicPartition, ReplicaId> initLeaderDistribution = clusterModel.getLeaderDistribution();
        Map<TopicPartition, List<ReplicaId>> initObserverDistribution = clusterModel.getObserverDistribution();
        boolean isSelfHealing = !clusterModel.selfHealingEligibleReplicas().isEmpty();
        HashSet<Goal> optimizedGoals = new HashSet<Goal>(goalsByPriority.size());
        HashSet<String> skippedGoals = new HashSet<String>();
        HashSet<String> violatedGoalNamesBeforeOptimization = new HashSet<String>();
        HashSet<String> violatedGoalNamesAfterOptimization = new HashSet<String>();
        HashSet<String> goalNamesWithProposals = new HashSet<String>();
        HashMap<String, GoalOptimizationResult.GoalOptimizationResultState> goalOptimizationResultStateByGoalName = new HashMap<String, GoalOptimizationResult.GoalOptimizationResultState>();
        HashMap<String, ProposalStats> proposalStatsByGoal = new HashMap<String, ProposalStats>();
        LinkedHashMap<Goal, ClusterModelStats> statsByGoalPriority = new LinkedHashMap<Goal, ClusterModelStats>(goalsByPriority.size());
        Map<TopicPartition, List<ReplicaId>> preOptimizedReplicaDistribution = null;
        Map<TopicPartition, ReplicaId> preOptimizedLeaderDistribution = null;
        Map<TopicPartition, List<ReplicaId>> preOptimizedObserverDistribution = null;
        boolean wereHardProposalsGenerated = false;
        for (Goal goal : goalsByPriority) {
            preOptimizedReplicaDistribution = preOptimizedReplicaDistribution == null ? initReplicaDistribution : clusterModel.getReplicaDistribution();
            preOptimizedLeaderDistribution = preOptimizedLeaderDistribution == null ? initLeaderDistribution : clusterModel.getLeaderDistribution();
            Map<TopicPartition, List<ReplicaId>> map = preOptimizedObserverDistribution = preOptimizedObserverDistribution == null ? initObserverDistribution : clusterModel.getObserverDistribution();
            if (!goal.isHardGoal() && !goalsConfig.executeOptimizationsOverHardProposals() && wereHardProposalsGenerated) {
                LOG.debug("{} skipped due to generated proposals by the hard goals before the incremental soft goal", (Object)goal.name());
                skippedGoals.add(goal.name());
                continue;
            }
            LOG.debug("Optimizing goal {}", (Object)goal.name());
            GoalOptimizationResult result = goal.optimize(clusterModel, optimizedGoals, optimizationOptions);
            optimizedGoals.add(goal);
            statsByGoalPriority.put(goal, clusterModel.getClusterStats(this.balancingConstraint));
            if (goal.isHardGoal() && result.hasReplicaChange()) {
                wereHardProposalsGenerated = true;
            }
            if (result.hasReplicaChange() || !result.isSuccessful()) {
                violatedGoalNamesBeforeOptimization.add(goal.name());
            }
            if (result.isFailed()) {
                violatedGoalNamesAfterOptimization.add(goal.name());
            }
            goalNamesWithProposals.addAll(result.goalsWithMovements());
            goalOptimizationResultStateByGoalName.put(goal.name(), result.resultState());
            proposalStatsByGoal.put(goal.name(), result.proposalStats());
            this.updateProposalMetrics(goal.name(), result.proposalStats());
            if (LOG.isDebugEnabled()) {
                Set<PartitionProposal> goalProposals = AnalyzerUtils.getDiff(preOptimizedReplicaDistribution, preOptimizedLeaderDistribution, preOptimizedObserverDistribution, clusterModel, goal.canChangeReplicationFactor());
                LOG.debug("[{}/{}] Generated {} proposals for {}{}.", new Object[]{optimizedGoals.size(), goalsByPriority.size(), goalProposals.size(), isSelfHealing ? "self-healing " : "", goal.name()});
                LOG.debug("Broker level stats after optimization: {}", (Object)clusterModel.brokerStats(null));
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Proposals for {}{}.{}%n", new Object[]{isSelfHealing ? "self-healing " : "", goal.name(), goalProposals});
                }
            }
            if (this.topicPartitionMovementHistory == null) continue;
            SortedSet<TopicPartitionMovement> topicPartitionMovements = result.topicPartitionMovements();
            topicPartitionMovements.forEach(this.topicPartitionMovementHistory::record);
        }
        clusterModel.sanityCheck();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Broker level stats after optimization: {}%n", (Object)clusterModel.brokerStats(null));
        }
        Set<PartitionProposal> proposals = AnalyzerUtils.getDiff(initReplicaDistribution, initLeaderDistribution, initObserverDistribution, clusterModel, true);
        OptimizerResult proposal = new OptimizerResult(goalOptimizationResultStateByGoalName, statsByGoalPriority, skippedGoals, violatedGoalNamesBeforeOptimization, violatedGoalNamesAfterOptimization, goalNamesWithProposals, proposals, brokerStatsBeforeOptimization, clusterModel.brokerStats(null), clusterModel.generation(), clusterModel.getClusterStats(this.balancingConstraint), clusterModel.capacityEstimationInfoByBrokerId(), optimizationOptions, KafkaCruiseControlUtils.balancednessCostByGoal(goalsByPriority, this.priorityWeight, this.strictnessWeight), proposalStatsByGoal);
        long proposalComputationTime = this.time.hiResClockMs() - start;
        this.proposalComputationTimer.update(proposalComputationTime, TimeUnit.MILLISECONDS);
        LOG.info("Finished proposal computation in {} ms", (Object)proposalComputationTime);
        this.logSaturatedReplicaMovesForResources(proposals, new HashSet<Resource>(Arrays.asList(Resource.PRODUCE_IN, Resource.CONSUME_OUT)), clusterModel);
        return proposal;
    }

    private void logSaturatedReplicaMovesForResources(Set<PartitionProposal> proposals, Set<Resource> resources, ClusterModel clusterModel) {
        for (Resource resource : resources) {
            double numSaturatedMoves = this.numSaturatedReplicaMoves(proposals, resource, clusterModel);
            if (!(numSaturatedMoves > 0.0)) continue;
            LOG.info("Plan includes {} replica moves which are saturated for {}.", (Object)numSaturatedMoves, (Object)resource);
        }
    }

    private double numSaturatedReplicaMoves(Set<PartitionProposal> partitionProposals, Resource resource, ClusterModel optimizedClusterModel) {
        return partitionProposals.stream().mapToDouble(executionProposal -> optimizedClusterModel.partition(executionProposal.topicPartition()).saturatedReplicaMoveCount(resource)).sum();
    }

    private synchronized void maybePopulateMetrics(DataBalancerMetricsRegistry registry, SbcGoalsConfig currentGoalConfig) {
        this.maybePopulateProposalMetrics(registry, currentGoalConfig.rebalancingGoals().goals());
        this.maybePopulateProposalMetrics(registry, currentGoalConfig.incrementalBalancingGoals().goals());
    }

    private synchronized void maybePopulateProposalMetrics(DataBalancerMetricsRegistry registry, List<Goal> rebalancingGoals) {
        for (Goal goal : rebalancingGoals) {
            if (this.goalProposalMetrics.containsKey(goal.name())) continue;
            HashMap<String, String> metricTags = new HashMap<String, String>();
            metricTags.put("goal", goal.name());
            Meter generatedMeter = registry.newMeter(GoalOptimizer.class, GOAL_PROPOSAL_GENERATION_RATE_METRIC_NAME, "proposals-generated", TimeUnit.SECONDS, metricTags);
            Meter rejectedMeter = registry.newMeter(GoalOptimizer.class, GOAL_PROPOSAL_REJECTION_RATE_METRIC_NAME, "proposals-rejected", TimeUnit.SECONDS, metricTags);
            Meter acceptedMeter = registry.newMeter(GoalOptimizer.class, GOAL_PROPOSAL_ACCEPTANCE_RATE_METRIC_NAME, "proposals-accepted", TimeUnit.SECONDS, metricTags);
            Meter moveTrackMeter = registry.newMeter(GoalOptimizer.class, GOAL_MOVE_GENERATION_RATE_METRIC_NAME, "moves-accepted", TimeUnit.SECONDS, metricTags);
            Meter swapTrackMeter = registry.newMeter(GoalOptimizer.class, GOAL_SWAP_GENERATION_RATE_METRIC_NAME, "swaps-accepted", TimeUnit.SECONDS, metricTags);
            Meter partitionMoveTrackMeter = registry.newMeter(GoalOptimizer.class, GOAL_PARTITION_MOVE_GENERATION_RATE_METRIC_NAME, "partition-moves-accepted", TimeUnit.SECONDS, metricTags);
            this.goalProposalMetrics.put(goal.name(), new ProposalMetrics(generatedMeter, rejectedMeter, acceptedMeter, moveTrackMeter, swapTrackMeter, partitionMoveTrackMeter));
        }
    }

    private void updateProposalMetrics(String goalName, ProposalStats goalProposalStats) {
        ProposalMetrics pm = (ProposalMetrics)this.goalProposalMetrics.get(goalName);
        if (pm != null) {
            pm.updateMetrics(goalProposalStats);
        }
    }

    private static class ProposalMetrics {
        public final Meter proposalGenerationMeter;
        public final Meter proposalRejectionMeter;
        public final Meter proposalAcceptanceMeter;
        public final Meter moveMeter;
        public final Meter swapMeter;
        public final Meter partitionMoveMeter;

        public ProposalMetrics(Meter proposalGenerationMeter, Meter proposalRejectionMeter, Meter proposalAcceptanceMeter, Meter moveMeter, Meter swapMeter, Meter partitionMoveMeter) {
            this.proposalGenerationMeter = proposalGenerationMeter;
            this.proposalRejectionMeter = proposalRejectionMeter;
            this.proposalAcceptanceMeter = proposalAcceptanceMeter;
            this.moveMeter = moveMeter;
            this.swapMeter = swapMeter;
            this.partitionMoveMeter = partitionMoveMeter;
        }

        private void updateMetrics(ProposalStats goalProposalStats) {
            this.proposalGenerationMeter.mark((long)goalProposalStats.proposalsGenerated());
            this.proposalRejectionMeter.mark((long)goalProposalStats.proposalsRejected());
            this.proposalAcceptanceMeter.mark((long)goalProposalStats.proposalsAccepted());
            this.moveMeter.mark((long)goalProposalStats.movesAccepted());
            this.swapMeter.mark((long)goalProposalStats.swapsAccepted());
            this.partitionMoveMeter.mark((long)goalProposalStats.partitionMovesAccepted());
        }
    }
}

