/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.EntityFilter;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.NoOpReplicaFilter;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ResourceDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.CandidateBroker;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.BalancingThresholdsFactory;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholds;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.util.ReplicaByResourceUtilizationComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceDistributionGoal
extends ResourceDistributionAbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDistributionGoal.class);
    private static final long PER_BROKER_SWAP_TIMEOUT_MS = 1000L;
    private final Time time;
    final Map<Integer, List<String>> swapTimeoutsExceededByBroker = new HashMap<Integer, List<String>>();

    public ResourceDistributionGoal() {
        this.time = Time.SYSTEM;
    }

    ResourceDistributionGoal(BalancingConstraint constraint) {
        this(Time.SYSTEM, constraint);
    }

    ResourceDistributionGoal(Time time, BalancingConstraint constraint) {
        super(constraint);
        this.time = time;
    }

    @Override
    protected abstract Resource resource();

    @Override
    protected boolean validatePercentages() {
        return true;
    }

    @Override
    protected ResourceUtilizationRatioThresholds balancingThresholds(ClusterModel clusterModel, OptimizationOptions optimizationOptions, boolean needValidation) {
        return BalancingThresholdsFactory.computeRelativeThresholds(clusterModel, optimizationOptions, this.balancingConstraint, this.resource(), needValidation);
    }

    @Override
    protected ResourceUtilizationRatioThresholds balancingThresholdsForCell(Cell cell, OptimizationOptions optimizationOptions, boolean needValidation) {
        return BalancingThresholdsFactory.computeRelativeThresholdsForCell(cell, optimizationOptions, this.balancingConstraint, this.resource(), needValidation);
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        Replica sourceReplica = clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_SWAP: {
                boolean bothBrokersCurrentlyWithinLimit;
                Replica destinationReplica = destinationBroker.replica(action.destinationTopicPartition());
                double sourceUtilizationDelta = destinationReplica.load().expectedUtilizationFor(this.resource()) - sourceReplica.load().expectedUtilizationFor(this.resource());
                if (sourceUtilizationDelta == 0.0) {
                    return ActionAcceptance.ACCEPT;
                }
                boolean bl = sourceUtilizationDelta > 0.0 ? this.isLoadAboveBalanceLowerLimit(destinationBroker) && this.isLoadUnderBalanceUpperLimit(sourceReplica.broker()) : (bothBrokersCurrentlyWithinLimit = this.isLoadAboveBalanceLowerLimit(sourceReplica.broker()) && this.isLoadUnderBalanceUpperLimit(destinationBroker));
                if (bothBrokersCurrentlyWithinLimit) {
                    return this.isSwapViolatingLimit(sourceReplica, destinationReplica) ? ActionAcceptance.REPLICA_REJECT : ActionAcceptance.ACCEPT;
                }
                return this.isSelfSatisfiedAfterSwap(sourceReplica, destinationReplica) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case LEADERSHIP_MOVEMENT: {
                if (this.isLoadAboveBalanceLowerLimit(sourceReplica.broker()) && this.isLoadUnderBalanceUpperLimit(destinationBroker)) {
                    return this.isLoadUnderBalanceUpperLimitAfterChange(sourceReplica.load(), destinationBroker, ResourceDistributionAbstractGoal.ChangeType.ADD) && this.isLoadAboveBalanceLowerLimitAfterChange(sourceReplica.load(), sourceReplica.broker(), ResourceDistributionAbstractGoal.ChangeType.REMOVE) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
                }
                return this.isAcceptableAfterReplicaMove(sourceReplica, destinationBroker) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.newBrokers().isEmpty() ? clusterModel.eligibleSourceOrDestinationBrokers() : clusterModel.newBrokers();
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        Replica sourceReplica = clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition());
        if (this.fixOfflineReplicasOnly && sourceReplica.broker().replica(action.topicPartition()).isCurrentOffline()) {
            return action.balancingAction() == ActionType.INTER_BROKER_REPLICA_MOVEMENT;
        }
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_SWAP: {
                Replica destinationReplica = destinationBroker.replica(action.destinationTopicPartition());
                double sourceUtilizationDelta = destinationReplica.load().expectedUtilizationFor(this.resource()) - sourceReplica.load().expectedUtilizationFor(this.resource());
                return sourceUtilizationDelta != 0.0 && !this.isSwapViolatingLimit(sourceReplica, destinationReplica);
            }
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case LEADERSHIP_MOVEMENT: {
                return this.isLoadUnderBalanceUpperLimitAfterChange(sourceReplica.load(), destinationBroker, ResourceDistributionAbstractGoal.ChangeType.ADD) && this.isLoadAboveBalanceLowerLimitAfterChange(sourceReplica.load(), sourceReplica.broker(), ResourceDistributionAbstractGoal.ChangeType.REMOVE);
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        HashSet<Integer> brokerIdsAboveBalanceUpperLimit = new HashSet<Integer>();
        HashSet<Integer> brokerIdsUnderBalanceLowerLimit = new HashSet<Integer>();
        for (Broker broker : clusterModel.eligibleDestinationBrokers()) {
            if (!this.isLoadUnderBalanceUpperLimit(broker)) {
                brokerIdsAboveBalanceUpperLimit.add(broker.id());
            }
            if (this.isLoadAboveBalanceLowerLimit(broker)) continue;
            brokerIdsUnderBalanceLowerLimit.add(broker.id());
        }
        if (!brokerIdsAboveBalanceUpperLimit.isEmpty()) {
            LOG.debug("Utilization for broker ids:{} {} above the balance limit for:{} after {}.", new Object[]{brokerIdsAboveBalanceUpperLimit, brokerIdsAboveBalanceUpperLimit.size() > 1 ? "are" : "is", this.resource(), clusterModel.selfHealingEligibleReplicas().isEmpty() ? "rebalance" : "self-healing"});
            this.optimizationResultBuilder.markUnsuccessfulOptimization();
        }
        if (!brokerIdsUnderBalanceLowerLimit.isEmpty()) {
            LOG.debug("Utilization for broker ids:{} {} under the balance limit for:{} after {}.", new Object[]{brokerIdsUnderBalanceLowerLimit, brokerIdsUnderBalanceLowerLimit.size() > 1 ? "are" : "is", this.resource(), clusterModel.selfHealingEligibleReplicas().isEmpty() ? "rebalance" : "self-healing"});
            this.optimizationResultBuilder.markUnsuccessfulOptimization();
        }
        if (!this.swapTimeoutsExceededByBroker.isEmpty()) {
            LOG.info("Attempted to swap replicas in order to satisfy the balance threshold for {} brokers but could not because they timed out. Brokers and their timeout reasons: {}", (Object)this.swapTimeoutsExceededByBroker.size(), this.swapTimeoutsExceededByBroker);
        }
        try {
            GoalUtils.ensureNoOfflineReplicas(clusterModel, this.name());
        }
        catch (OptimizationFailureException ofe) {
            if (this.fixOfflineReplicasOnly) {
                clusterModel.untrackSortedReplicas(this.sortName());
                throw ofe;
            }
            this.fixOfflineReplicasOnly = true;
            LOG.info("Ignoring resource balance limit to move replicas from dead brokers/disks.");
            return;
        }
        GoalUtils.ensureReplicasMoveOffBrokersWithBadDisks(clusterModel, this.name());
        this.finish();
        clusterModel.untrackSortedReplicas(this.sortName());
    }

    @Override
    public void finish() {
        super.finish();
        this.swapTimeoutsExceededByBroker.clear();
    }

    @Override
    protected void doRebalance(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        this.performLeadershipMovement(broker, clusterModel, optimizedGoals, optimizationOptions, Optional.empty());
        this.performReplicaMovement(broker, clusterModel, optimizedGoals, optimizationOptions, Optional.empty());
        this.performReplicaSwap(broker, clusterModel, optimizedGoals, optimizationOptions);
    }

    private void performReplicaSwap(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (this.requireLessLoad) {
            this.requireLessLoad = this.rebalanceBySwappingLoadOut(broker, clusterModel, optimizedGoals, optimizationOptions, this.moveImmigrantsOnly);
        }
        if (this.requireMoreLoad) {
            this.requireMoreLoad = this.rebalanceBySwappingLoadIn(broker, clusterModel, optimizedGoals, optimizationOptions, this.moveImmigrantsOnly);
        }
    }

    private SortedSet<Replica> sortedCandidateReplicas(Broker broker, Set<String> excludedTopics, double loadLimit, boolean isAscending, boolean followersOnly, boolean immigrantsOnly) {
        TreeSet<Replica> candidateReplicas = new TreeSet<Replica>((r1, r2) -> {
            boolean isR1Offline = r1.isCurrentOffline();
            boolean isR2Offline = r2.isCurrentOffline();
            if (isR1Offline && !isR2Offline) {
                return -1;
            }
            if (!isR1Offline && isR2Offline) {
                return 1;
            }
            int result = isAscending ? Double.compare(r1.load().expectedUtilizationFor(this.resource()), r2.load().expectedUtilizationFor(this.resource())) : Double.compare(r2.load().expectedUtilizationFor(this.resource()), r1.load().expectedUtilizationFor(this.resource()));
            return result == 0 ? r1.topicPartition().toString().compareTo(r2.topicPartition().toString()) : result;
        });
        Set<Replica> filteredReplicas = GoalUtils.filterReplicas(broker, followersOnly, false, immigrantsOnly, this.replicaFilter());
        if (isAscending) {
            candidateReplicas.addAll(filteredReplicas.stream().filter(r -> !ResourceDistributionGoal.shouldExclude(r, excludedTopics) && r.load().expectedUtilizationFor(this.resource()) < loadLimit).collect(Collectors.toSet()));
        } else {
            candidateReplicas.addAll(filteredReplicas.stream().filter(r -> !ResourceDistributionGoal.shouldExclude(r, excludedTopics) && r.load().expectedUtilizationFor(this.resource()) > loadLimit).collect(Collectors.toSet()));
        }
        return candidateReplicas;
    }

    private double getMaxReplicaLoad(SortedSet<Replica> sortedReplicas) {
        double maxReplicaLoad = sortedReplicas.first().load().expectedUtilizationFor(this.resource());
        for (Replica replica : sortedReplicas) {
            if (replica.isCurrentOffline()) continue;
            if (!(replica.load().expectedUtilizationFor(this.resource()) > maxReplicaLoad)) break;
            maxReplicaLoad = replica.load().expectedUtilizationFor(this.resource());
            break;
        }
        return maxReplicaLoad;
    }

    boolean rebalanceBySwappingLoadOut(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, boolean moveImmigrantsOnly) {
        long swapStartTimeMs = this.time.hiResClockMs();
        if (!broker.isEligibleSource() || !broker.isEligibleDestination() || optimizationOptions.excludedBrokersForReplicaMove().contains(broker.id())) {
            return true;
        }
        TreeSet<Replica> sourceReplicas = new TreeSet<Replica>(ReplicaByResourceUtilizationComparator.of(this.resource()));
        sourceReplicas.addAll(GoalUtils.filterReplicas(broker, false, false, moveImmigrantsOnly, this.replicaFilter()));
        if (sourceReplicas.isEmpty()) {
            return true;
        }
        double maxSourceReplicaLoad = this.getMaxReplicaLoad(sourceReplicas);
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        Set<Integer> excludedBrokersForLeadership = optimizationOptions.excludedBrokersForLeadership();
        Set<Integer> excludedBrokersForReplicaMove = optimizationOptions.excludedBrokersForReplicaMove();
        boolean swapWithFollowersOnly = excludedBrokersForLeadership.contains(broker.id());
        PriorityQueue<CandidateBroker> candidateBrokerPQ = new PriorityQueue<CandidateBroker>();
        for (Broker candidate : clusterModel.brokersUnderThreshold(clusterModel.eligibleSourceAndDestinationBrokers(), this.resource(), this.thresholds.clusterThresholds().balanceUpperThreshold()).stream().filter(b -> !b.replicas().isEmpty()).collect(Collectors.toSet())) {
            SortedSet<Replica> replicasToSwapWith = this.sortedCandidateReplicas(candidate, excludedTopics, maxSourceReplicaLoad, true, swapWithFollowersOnly, moveImmigrantsOnly);
            CandidateBroker candidateBroker = new CandidateBroker(candidate, this.resource(), replicasToSwapWith, true, excludedBrokersForLeadership, excludedBrokersForReplicaMove);
            candidateBrokerPQ.add(candidateBroker);
        }
        while (true) {
            if (this.remainingPerBrokerSwapTimeMs(swapStartTimeMs) <= 0L) {
                String timeoutReason = String.format("Swap load out timeout for broker %d.", broker.id());
                LOG.debug(timeoutReason);
                this.addSwapTimeoutForBroker(broker.id(), timeoutReason);
                return true;
            }
            CandidateBroker cb = (CandidateBroker)candidateBrokerPQ.poll();
            if (cb == null) break;
            SortedSet<Replica> candidateReplicasToSwapWith = cb.replicas();
            Replica swappedInReplica = null;
            Replica swappedOutReplica = null;
            for (Replica sourceReplica : sourceReplicas) {
                if (ResourceDistributionGoal.shouldExclude(sourceReplica, excludedTopics)) continue;
                Replica swappedIn = this.maybeApplySwapAction(clusterModel, sourceReplica, cb, optimizedGoals, Optional.empty());
                if (swappedIn != null) {
                    if (this.isLoadUnderBalanceUpperLimit(broker)) {
                        LOG.debug("Successfully balanced {} for broker {} by swapping REPLICA out.", (Object)this.resource(), (Object)broker.id());
                        return false;
                    }
                    swappedInReplica = swappedIn;
                    swappedOutReplica = sourceReplica;
                    break;
                }
                if (this.remainingPerBrokerSwapTimeMs(swapStartTimeMs) > 0L) continue;
                String timeoutReason = String.format("Swap load out timeout for source replica %s.", sourceReplica);
                LOG.debug(timeoutReason);
                this.addSwapTimeoutForBroker(broker.id(), timeoutReason);
                return true;
            }
            this.swapUpdate(swappedInReplica, swappedOutReplica, sourceReplicas, candidateReplicasToSwapWith, candidateBrokerPQ, cb);
        }
        return true;
    }

    protected EntityFilter<Replica> replicaFilter() {
        return new NoOpReplicaFilter();
    }

    long remainingPerBrokerSwapTimeMs(long swapStartTimeMs) {
        return 1000L - (this.time.hiResClockMs() - swapStartTimeMs);
    }

    private void swapUpdate(Replica swappedInReplica, Replica swappedOutReplica, SortedSet<Replica> sourceReplicas, SortedSet<Replica> candidateReplicasToSwapWith, PriorityQueue<CandidateBroker> candidateBrokerPQ, CandidateBroker cb) {
        if (swappedInReplica != null) {
            sourceReplicas.remove(swappedOutReplica);
            sourceReplicas.add(swappedInReplica);
            candidateReplicasToSwapWith.remove(swappedInReplica);
            candidateReplicasToSwapWith.add(swappedOutReplica);
            candidateBrokerPQ.add(cb);
        }
    }

    boolean rebalanceBySwappingLoadIn(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions, boolean moveImmigrantsOnly) {
        long swapStartTimeMs = this.time.hiResClockMs();
        if (!broker.isEligibleSource() || !broker.isEligibleDestination() || optimizationOptions.excludedBrokersForReplicaMove().contains(broker.id())) {
            return true;
        }
        TreeSet<Replica> sourceReplicas = new TreeSet<Replica>(ReplicaByResourceUtilizationComparator.of(this.resource()));
        sourceReplicas.addAll(GoalUtils.filterReplicas(broker, false, false, moveImmigrantsOnly));
        if (sourceReplicas.isEmpty()) {
            return true;
        }
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        Set<Integer> excludedBrokersForLeadership = optimizationOptions.excludedBrokersForLeadership();
        Set<Integer> excludedBrokersForReplicaMove = optimizationOptions.excludedBrokersForReplicaMove();
        boolean swapWithFollowersOnly = excludedBrokersForLeadership.contains(broker.id());
        PriorityQueue<CandidateBroker> candidateBrokerPQ = new PriorityQueue<CandidateBroker>();
        for (Broker candidate : clusterModel.brokersOverThreshold(clusterModel.eligibleSourceAndDestinationBrokers(), this.resource(), this.thresholds.clusterThresholds().balanceLowerThreshold())) {
            double minSourceReplicaLoad = ((Replica)sourceReplicas.first()).load().expectedUtilizationFor(this.resource());
            SortedSet<Replica> replicasToSwapWith = this.sortedCandidateReplicas(candidate, excludedTopics, minSourceReplicaLoad, false, swapWithFollowersOnly, moveImmigrantsOnly);
            CandidateBroker candidateBroker = new CandidateBroker(candidate, this.resource(), replicasToSwapWith, false, excludedBrokersForLeadership, excludedBrokersForReplicaMove);
            candidateBrokerPQ.add(candidateBroker);
        }
        while (true) {
            if (this.remainingPerBrokerSwapTimeMs(swapStartTimeMs) <= 0L) {
                String timeoutReason = String.format("Swap load in timeout for broker %d.", broker.id());
                LOG.debug(timeoutReason);
                this.addSwapTimeoutForBroker(broker.id(), timeoutReason);
                return true;
            }
            CandidateBroker cb = (CandidateBroker)candidateBrokerPQ.poll();
            if (cb == null) break;
            SortedSet<Replica> candidateReplicasToSwapWith = cb.replicas();
            Replica swappedInReplica = null;
            Replica swappedOutReplica = null;
            for (Replica sourceReplica : sourceReplicas) {
                if (ResourceDistributionGoal.shouldExclude(sourceReplica, excludedTopics)) continue;
                double sourceReplicaUtilization = sourceReplica.load().expectedUtilizationFor(this.resource());
                if (sourceReplicaUtilization == 0.0) break;
                Replica swappedIn = this.maybeApplySwapAction(clusterModel, sourceReplica, cb, optimizedGoals, Optional.empty());
                if (swappedIn != null) {
                    if (this.isLoadAboveBalanceLowerLimit(broker)) {
                        LOG.debug("Successfully balanced {} for broker {} by swapping REPLICA in.", (Object)this.resource(), (Object)broker.id());
                        return false;
                    }
                    swappedInReplica = swappedIn;
                    swappedOutReplica = sourceReplica;
                    break;
                }
                if (this.remainingPerBrokerSwapTimeMs(swapStartTimeMs) > 0L) continue;
                String timeoutReason = String.format("Swap load in timeout for source replica %s.", sourceReplica);
                LOG.debug(timeoutReason);
                this.addSwapTimeoutForBroker(broker.id(), timeoutReason);
                return true;
            }
            this.swapUpdate(swappedInReplica, swappedOutReplica, sourceReplicas, candidateReplicasToSwapWith, candidateBrokerPQ, cb);
        }
        return true;
    }

    @Override
    protected boolean isRebalanceByMovingLoadOutCompleted(Broker broker) {
        return this.isLoadUnderBalanceUpperLimit(broker);
    }

    @Override
    protected boolean isRebalanceByMovingLoadInCompleted(Broker broker) {
        return this.isLoadAboveBalanceLowerLimit(broker);
    }

    private boolean isAcceptableAfterReplicaMove(Replica sourceReplica, Broker destinationBroker) {
        double sourceUtilizationDelta = -sourceReplica.load().expectedUtilizationFor(this.resource());
        double destinationBrokerUtilization = destinationBroker.load().expectedUtilizationFor(this.resource());
        return this.isGettingMoreBalanced(sourceReplica, sourceUtilizationDelta, destinationBrokerUtilization);
    }

    private boolean isSelfSatisfiedAfterSwap(Replica sourceReplica, Replica destinationReplica) {
        double sourceUtilizationDelta = destinationReplica.load().expectedUtilizationFor(this.resource()) - sourceReplica.load().expectedUtilizationFor(this.resource());
        double destinationBrokerUtilization = destinationReplica.broker().load().expectedUtilizationFor(this.resource());
        return this.isGettingMoreBalanced(sourceReplica, sourceUtilizationDelta, destinationBrokerUtilization);
    }

    private boolean isGettingMoreBalanced(Replica sourceReplica, double sourceUtilizationDelta, double destinationBrokerUtilization) {
        double sourceBrokerUtilization = sourceReplica.broker().load().expectedUtilizationFor(this.resource());
        double prevDiff = sourceBrokerUtilization - destinationBrokerUtilization;
        double nextDiff = prevDiff + 2.0 * sourceUtilizationDelta;
        return Math.abs(nextDiff) < Math.abs(prevDiff);
    }

    private boolean isSwapViolatingLimit(Replica sourceReplica, Replica destinationReplica) {
        double sourceUtilizationDelta = destinationReplica.load().expectedUtilizationFor(this.resource()) - sourceReplica.load().expectedUtilizationFor(this.resource());
        boolean swapViolatingBrokerLimit = this.isSwapViolatingContainerLimit(sourceUtilizationDelta, sourceReplica, destinationReplica, r -> r.broker().load(), r -> r.broker().capacity().totalCapacityFor(this.resource()));
        if (!swapViolatingBrokerLimit || !this.resource().isHostResource()) {
            return swapViolatingBrokerLimit;
        }
        return this.isSwapViolatingContainerLimit(sourceUtilizationDelta, sourceReplica, destinationReplica, r -> r.broker().host().load(), r -> r.broker().host().capacity().totalCapacityFor(this.resource()));
    }

    private boolean isSwapViolatingContainerLimit(double sourceUtilizationDelta, Replica sourceReplica, Replica destinationReplica, Function<Replica, Load> loadFunction, Function<Replica, Double> capacityFunction) {
        double destinationContainerBalanceLowerLimit;
        double sourceContainerBalanceLowerLimit;
        boolean isContainerUnderUpperLimit;
        double sourceContainerUtilization = loadFunction.apply(sourceReplica).expectedUtilizationFor(this.resource());
        double destinationContainerUtilization = loadFunction.apply(destinationReplica).expectedUtilizationFor(this.resource());
        if (sourceUtilizationDelta > 0.0) {
            double sourceContainerBalanceUpperLimit = capacityFunction.apply(sourceReplica) * this.thresholds.clusterThresholds().balanceUpperThreshold();
            isContainerUnderUpperLimit = sourceContainerUtilization + sourceUtilizationDelta <= sourceContainerBalanceUpperLimit;
        } else {
            double destinationContainerBalanceUpperLimit = capacityFunction.apply(destinationReplica) * this.thresholds.clusterThresholds().balanceUpperThreshold();
            boolean bl = isContainerUnderUpperLimit = destinationContainerUtilization - sourceUtilizationDelta <= destinationContainerBalanceUpperLimit;
        }
        if (!isContainerUnderUpperLimit) {
            return true;
        }
        boolean isContainerAboveLowerLimit = sourceUtilizationDelta < 0.0 ? sourceContainerUtilization + sourceUtilizationDelta >= (sourceContainerBalanceLowerLimit = capacityFunction.apply(sourceReplica) * this.thresholds.clusterThresholds().balanceLowerThreshold()) : destinationContainerUtilization - sourceUtilizationDelta >= (destinationContainerBalanceLowerLimit = capacityFunction.apply(destinationReplica) * this.thresholds.clusterThresholds().balanceLowerThreshold());
        return !isContainerAboveLowerLimit;
    }

    private void addSwapTimeoutForBroker(int brokerId, String timeoutReason) {
        this.swapTimeoutsExceededByBroker.computeIfAbsent(brokerId, k -> new ArrayList()).add(timeoutReason);
    }
}

